/* sendpack.c - sendpack, putw, putch, putwsum putlsum, putchar */

#include "define.h"
extern int mecbfd;
union	fourbyte {
	long	l;
	short	s[2];
	char	c[4];
};
extern	char RDY;
char 	soh =  '/';

/*------------------------------------------------------------------------------
 * sendpack - send a packet to the MC 68000
 *------------------------------------------------------------------------------
 */

long	sum, cksum;

sendpack(addr, length, buf)
	long	addr;			/* starting address		*/
	long	length;			/* length of data in bytes	*/
	char	*buf;			/* data output buffer		*/
{
	int	i, j;

	DEBUG(8,"Sending packet to address 0x%x",addr);
        DEBUG(8,"  of length 0x%x\r\n", length);
	sum = 0;
	write(mecbfd,&soh,1);
	DEBUG(8,"sent start of header\r\n",NULL);
	putlsum(addr);
	DEBUG(8,"sent address\r\n",NULL);
	putlsum(length);
	DEBUG(8,"sent length\r\n",NULL);
/*	for ( i=0 ; i<length ; i++ )  */
/*		putch(buf[i]);  in case need slowdown for debugging */
	for (i=0; i<length; i++)
	  sum += buf[i];
	write(mecbfd,buf,length); /* less expensive way than loop of putch's*/

	DEBUG(8,"sent packet\r\n",NULL);
	cksum = ~sum;
	write(mecbfd,&cksum,sizeof(cksum));
	DEBUG(8,"sent check sum\r\n",NULL);
        
}

/*------------------------------------------------------------------------------
 * putch - put a character on the high speed line
 *------------------------------------------------------------------------------
 */
putch(ch)
	char	ch;
{
	sum += ch;
	write(mecbfd,&ch,sizeof(ch));
/*	usleep(2000);*/  /*temp slowdown for debugging */
}

/*------------------------------------------------------------------------------
 * putlsum - write a fourbyte to the high speed line (4 bytes)
 *------------------------------------------------------------------------------
putlsum(x)
long	x;
{
	union	fourbyte y;

	y.l = x;
	putch(y.c[3] & 0xff);
	putch(y.c[2] & 0xff);
	putch(y.c[1] & 0xff);
	putch(y.c[0] & 0xff);
	return;
}
 */

putlsum(x)
long	x;
{
	int	i,j,k,l;

	   
	i = ((x & 0xff000000) >> 24);
	j = ((x & 0xff0000) >> 16);
	k = ((x & 0xff00) >> 8);
	l = ( x & 0xff); 
	putch((char) i);
	putch((char) j);
	putch((char) k);
	putch((char) l); 
	return;
}
