.globl _main
|	these are for the pit	
	PGCR = 0x10001	|port general control register 
	PSRR = 0x10003	|port service request register 
	PADDR = 0x10005	|port a data direction register 
	PACR = 0x1000d	|port a control register 
	PADR = 0x10011	|port a data register 
	EBIT = 4	|line 4 goes to enable input of decoder

|	these are for the console UART--

UARTDATA  = 0x10042			| Port 1 Uart Data
UARTSTAT  = 0x10040			| Port 1 Uart Status
RXFULL    = 0x00			| Mask for Receiver Full Bit
TXEMPTY   = 0x01			| Mask for Transmitter Empty Bit
FRAMERR   = 4				| Frame Error is bit 4
STACKADDR = 0xffc

|  	these are for the command protocol--

SOH	  = 0x2f			| '/'
ACK	  = 0x79			| 'y'
NAK	  = 0x6e			| 'n'
BRESET    = 0x41			| 'A'
RESETALL  = 0x7f			| wildcard line#

| Protocol:
|  Reset server just reads chars from console line until it sees a SOH char,
|   then sends back ACK
|  Reset server then reads next char, checks it for the only command
|   now valid, that is, board-reset, char BRESET.  If it sees any other
|   char, it sends back NAK and cycles back to start of protocol.
|  Reset server then reads next char, which is the line# to reset, or
|   RESETALL to request all mecbs reset.  If this byte is received as
|   neither 0-15 nor RESETALL, a NAK is sent back and the protocol
|   is restarted.  Otherwise the appropriate action is taken and
|   ACK is sent back.  The protocol is then restarted.

|  Note that even if two processes send commands to the board and their
|   chars intermix, the wrong board will not be reset, because none of
|   the command chars match a valid line# or RESETALL.

|general--
DBUGaddr = 0x7000
TUTOR     = 228				| Trap code for return to monitor
|Register a4 is reserved for debugging

.text
_main:	movl 	#0x1000,sp	| init stack
	movl	#DBUGaddr, a4   |debug setup
 	movb	#-1, a4@-
	bsr	initpit		|init pi/t  (temp--should do only on demand)
	bsr 	resetall	|reset all boards to start (temp)
	bsr	serve
	bra 	_main

serve:	bsr rawgetc		|from console line
	cmpb #SOH,d0		|look for start of transmission
	bne serve
	moveb #ACK,d0
	bsr rawputc		| ack the correct SOH
	bsr rawgetc
	cmpb #BRESET,d0		|wants reset?
	bne serve1		|no, go on
	bsr resetcmd		|yes, do it
	bra serve

serve1:	moveb #NAK,d0		|all we know how to do so far
	bsr rawputc
	bra serve

|reset command: accepts input byte/line # or RESETALL for reset all lines
| returns ACK or NAK as appropriate, also on console line

resetcmd:
	bsr rawgetc		|3rd char gives line#
	cmpb #RESETALL,d0	|wildcard reset?
	bne resetcmd1		| no, go on
	bsr resetall		| yes, do it
	bra rescmddone

resetcmd1:
	cmpb #16,d0		| reasonable line #?
	bhis resetfail		| no, fail
	bsr breset		| line # in d0, as wanted by breset

rescmddone:
	moveb #ACK,d0
	bsr rawputc		|report back success
	rts
	
resetfail: moveb #NAK,d0
	bsr rawputc
	rts

resetall:
	movl	d2,sp@-
	clrb	d2			|reset all boards
lp2:
	movb 	d2,d0
	bsr	breset
	addb	#1,d2
	bsr 	wait
	cmpb	#16,d2
	bne lp2
	movl	sp@+,d2
	rts

wait:	movl 	d5,sp@-
	movw	#60000,d5		|so can see it happen
wait1:	dbra	d5,wait1
	movl	sp@+,d5
	rts

initpit:
	movb	#0,PGCR			|set mode 0, shut down first
	clrb	PSRR
	movb	#0xff,PADDR		|set port A to all output
	movb	#168,PACR		|set submode 1x
	movb 	#0x22,PGCR		|turn on port A, sense of handshakes
	rts

clear:	clrb	d0			|reset all boards
lpi1:	bsr	breset
	addb	#1,d0
	cmpb	#16,d0
	bne	lpi1
	rts

|reset one board
|accepts  d0/ board # to reset
breset:	bset 	#EBIT,d0		|decoder output stays disabled
	movb	d0,PADR			|set board address, let stabilize
	bclr 	#EBIT,PADR		|enable decoder output
	bsr wait			|big signal to board
	bset #EBIT,PADR			|disable decoder output
	rts
| routines borrowed from fast.s--
|----------------------------------------------------------------------------
|  rawputc  --  put a character on the line
|----------------------------------------------------------------------------

rawputc:
	btst	#TXEMPTY, UARTSTAT
	beq	rawputc
	movb	d0, UARTDATA
debug1:
	btst	#TXEMPTY, UARTSTAT
	beq	debug1
	rts

|---------------------------------------------------------------------------
|  rawgetc  --  get a character from the line
|---------------------------------------------------------------------------

rawgetc:
	clrl	d0
check1:
	btst	#RXFULL, UARTSTAT
	beq	check1
	btst	#FRAMERR, UARTSTAT	| Check for BREAK
	bne	monitor			| Pop to monitor if so
	movb	UARTDATA, d0
	rts

|----------------------------------------------------------------------------
|  monitor  -- return control to the firmware monitor (NO re-initialization)
|----------------------------------------------------------------------------

monitor:
	movb	#5, a4@-
notyet:
	btst	#TXEMPTY, UARTSTAT
	beq	notyet
	movl	#TUTOR, d7	| trap code assigned by Motorola's monitor
	trap	#14
