#include "define.h"
#include <a.out.h>
#include <stdio.h>
/*------------------------------------------------------------------------------
 * Procargs  --  parse and check command line, setup global A structure
 *------------------------------------------------------------------------------
 */

procargs(argc, argv)
	int	argc;
	char	*argv[];
{
  int	arg;
  int	unswitched;
  char *p,*rindex();

  A.userprog[0]   = '\0';
  A.fastloader	= FASTLOADER;
  A.bootloader	= BOOTLOADER;
  A.loadaddr	= PROGSTART;
  A.boardnum	= BOARDDEFAULT;
  A.boardesc	= CMD_ESC;
	
  A.xdev = get_xdev(argv);	/* if argv[0] starts with 'M', set xdev=1 */
  if (A.xdev)
    A.Baud	= 9600;		/* default speed, Mtip systems */
  else
    A.Baud	= 2400;		/* default speed, mtip systems*/


  if (argc==1)
    {
      printf("usage: %s [-b board#] [-f download-file]\n",argv[0]);
      printf("specify board by #: -b 1, etc.; defaults to scan.\n");
      printf("download-file is direct output of ld ...\n");
      printf("more flags: [-x debuglevel] [-e escchar]\n");
      printf("for info on commands, type ~? once program is running\n");
      printf("now scanning for free board...\n");
      return;			/* go on, scanning for free board */
    }

  for ( arg=1 ; arg<argc ; arg++ ) {
    if ( argv[arg][0] == '-' ) {
      switch ( argv[arg][1] ) {
      case 'b':
	if ( ++arg >= argc )
	  usagexit(argv[--arg]);
	A.boardnum = atoi(argv[arg]);
	if (A.boardnum==0 &&
	    strcmp(argv[arg],"0")!=0)
	  usagexit(argv[arg]);
	break;
      case 'e':
	if ( ++arg >= argc )
	  usagexit(argv[--arg]);
	if(sscanf(argv[arg],"%c",&A.boardesc)!=1)
	  usagexit(argv[arg]);
	break;
      case 'f':
	if ( ++arg >= argc )
	  usagexit(argv[--arg]);
	if(setloadfile(argv[arg])<0)
	  usagexit(argv[arg]);
	break;
      case 'x':
	if ( ++arg >= argc )
	  usagexit(argv[--arg]);
	Debug = atoi(argv[arg]);
	break;
      case 's':
	if ( ++arg >= argc )
	  usagexit(argv[--arg]);
	A.Baud = atoi(argv[arg]);
	break;
      case 'l':
	if (++arg >= argc)
	  usagexit(argv[--arg]);
	strcpy (glomline,argv[arg]);
	break;
      default:
	usagexit(argv[arg]);
	break;
      }
    } 
  }
}
usagexit(s)
char *s;
{
  fprintf(stderr, "error in arg %s\n",s);
  exit(1);
}


setloadfile(fn)
char *fn;
{
  FILE *fp;
  struct exec hdr;

  if ((fp = fopen(fn,"r"))==(FILE *)NULL)
    {
      fprintf(stderr,"Can't find file %s!!!\n",fn);
      return -1;
    }
  else 
    {
      gethdr(fp,&hdr,fn);	/* fill hdr */
      A.loadaddr = hdr.a_entry; /* get startaddr */
      if (A.loadaddr < 0x8000 & !A.xdev)
	if (A.loadaddr+hdr.a_text+hdr.a_data+hdr.a_bss>=0x8000)
	  printf("Warning: Program too big for 32K MECB!\n");
      if (A.loadaddr != PROGSTART) /* non-default case */
	printf("Code starts at 0x%x\n",A.loadaddr);
      fclose(fp); /* reopen later */
      strcpy(A.userprog,fn);	/* save name */
      return 0;
    }
}

/* if program names starts with "M", xdev=1 (second series of boards),
   else xdev = 0 (orig. series of boards) */
int get_xdev(argv)
char **argv;
{
  char *p,*rindex();

  p = rindex(argv[0],'/');	/* find last / if any, in program name */
  if (p==NULL)
    p = argv[0];		/* no /, look at first char */
  else
    p++;			/* look at one past last / */
  if (*p=='M')			/* if 'M', set xdev = 1 */
    return 1;
  else
    return 0;
}
