
/* monitor.c - getmon, restore */

#include <stdio.h>
#include <errno.h>
#include <sgtty.h>
#include <ctype.h>
#include "define.h"
#include <signal.h>
#include <setjmp.h>

int readuntil();
struct	sgttyb	oldtty, newtty;
extern int mecbfd;
/*------------------------------------------------------------------------------
 * getmon  --  set linemode options and wait for monitor prompt.
 *             executed directly after monitor 'L' command.
 *------------------------------------------------------------------------------
 */

getmon()
{
        char buf[BUFSIZ];

	ttyset = TRUE;

/* break hardly ever helps, so let's do without this delay--eoneil 3/11/89*/
/*	DEBUG(5,"break.. ",NULL);        */
/*	ioctl(mecbfd, TIOCSBRK, NULL);        */
/*	sleep(BREAK_DELAY);        */
/*	ioctl(mecbfd, TIOCCBRK, NULL);        */
/*	    DEBUG(5,"looking for BREAK_ACK\r\n",NULL);  */
/*	    readuntil(BREAK_ACK, 30);        */

	if (sendmon("\r", NOWAIT)<0)
	  {
	    DEBUG(1,"getmon: First write to mecb line failed\r\n",NULL);
	    return -1;
	  }
	DEBUG(1,"Looking for TUTOR prompt... \r\n",NULL);
	if (readuntil(prompt, 10)<0)
	  {
	    DEBUG(1,"...timed out\r\n",NULL);
	    return -1;
	  }
	DEBUG(1,"...got it\r\n",NULL);
	return 0;
}

/*------------------------------------------------------------------------------
 * sendmon  --  send a message to the monitor
 *------------------------------------------------------------------------------
 */
sendmon(msg, wait)
char *msg; Bool wait;
{
	char *ptr, tmpstr[2];

	DEBUG(6,"sendmon sending %s\r\n",msg);
	while (*msg!=EOS) {
		write(mecbfd, msg, 1);
                if ( wait ) {
                        tmpstr[0] = *msg;
                        tmpstr[1] = EOS;
                        if(readuntil(tmpstr, 10)<0)
                           {
                              DEBUG(6,"sendmon failed with %s left to send\r\n",msg);
			  return -1;
                             }
                }
		msg++;
	}
	return 0;
}


/*-----------------------------------------------------------------------------
 * readuntil - read mecb line until pattern found or time expires.
 * returns >= 0 on success, <0 on failure.
 *-----------------------------------------------------------------------------
 */
static char buf[BUFSIZ];

readuntil(pattern, time)
char *pattern; int time;
{
  int i = 0;
  int retval;

 /* test for empty string pattern */
  if ( pattern == NULL || *pattern == EOS ) return 0;

  while (1)
    {
      if ((retval = TOgetc(mecbfd,time)) <0)
	{
	  DEBUG(2,"readuntil timing out\r\n",NULL);
	  DEBUG(2,"--expected pattern = %s\r\n",pattern);
	  buf[i] = EOS;		/* tie off string */
	  DEBUG(2,"--got so far: %s\r\n",buf);
	  return -1;
	}
      else buf[i++] = retval&0x7f; /* new char for buf */
      switch (endsearch(buf,i,pattern))	/* search for pattern in buf */
	{
	case 0: i = 0;		/* no match at all--start over in buf */
	  break;
	case 1: break;		/* partial match, go on */
	case 2: return 0;	/* matched pattern */
	}
    }
}

static jmp_buf save_frame;

alarmhand()
{
  longjmp(save_frame,1);	/* make setjmp return true */
}

/* 4.2BSD does not provide aborted syscalls on signals */
/* the old trick of just getting alarm signal no longer works-- */
/* the read is RESTARTED on alarm, not aborted like it used to be */
/* TOgetc returns char from mecb OR -2 for time-out */

TOgetc(mecbfd,nsec)
int mecbfd;
int nsec;			/* timeout period */
{
  char buf[1];
  int retval;

  signal(SIGALRM,alarmhand);	/* arm alarm with routine above */
  alarm(nsec);
  if (setjmp(save_frame))
      retval = -2;		/* got signal */
  else				/* made it in time */
    {
      retval = read(mecbfd,buf,1); /* try to read */
      if (retval == 1) retval = buf[0];	/* success */
    }
  alarm(0);
  return retval;
}

/*-----------------------------------------------------------------------------
 *  startmon  --  start execution at a specified address
 *-----------------------------------------------------------------------------
 */
startmon(address)
int	address;
{
	int	i;
	char	buf[32];

	DEBUG(9,"startmon: addr = %x\r\n",address);
	sprintf(buf, "GD %08x\r", address);
	for (i=0; i<strlen(buf); i++)
	    if ( islower(buf[i]) ) buf[i] = toupper(buf[i]);
	if (sendmon(buf, WAIT)<0)
	  {
	    DEBUG(1,"startmon: failed on GD command\r\n",NULL);
	    return -1;
	  }
	/* TUTOR responds with a message about the starting address */
	sprintf(buf, "PHYSICAL ADDRESS=%08x", address);
	for (i=0; i<strlen(buf); i++)
	    if ( islower(buf[i]) ) buf[i] = toupper(buf[i]);
	if (readuntil(buf,10)<0)
	  fprintf(stderr,"Warning: expected TUTOR PHYS ADDR message imperfectly received\r\n");
	DEBUG(9,"\r\nMonitor started.\r\n",NULL);
	return 0;
}

/*------------------------------------------------------------------------------
 *  autostart  --  implement startup options (a future option not yet used.)
 *------------------------------------------------------------------------------
autostart()
{
	if ( A.autostart ) {
		startmon(A.loadaddr);
		fprintf(logfp, "\n(Start at 0x%x)\n", A.loadaddr);
	}
}
 */


/* search for t in s, return 1 for all of t in s, 0 for the first part */
/*  of t at the end of s, -1 for no part of t at end of s */
endsearch(s,slen,t)
char s[];			/* slen in length */
int slen;
char t[];			/* null-terminated */
{
  int i,j;

  j = 0;
  for (i=0; i < slen;i++)
    {
      if (s[i] == t[j])
	j++;			/* matched char--advance in pattern */
      else
	{
	  i -= j;		/* unmatched--i back by j, will be inc'd */
	  j = 0;		/*  and start over in t */
	}
      if (t[j] == '\0')
	return 2;		/* success--pattern all matched */
    }
  /* here when all of s scanned-- */
  if (j>0)
    return 1;			/* partial match at end of s */
  else return 0;		/* no match at all at end of s */
}

setword_mecb(addr,contents)
unsigned addr,contents;
{
  char cmd[80];			/* MS 2000 0600 for ex. */
  int i;

  sprintf(cmd,"MS %x %04x\r",addr,contents); /* TUTOR cmd */
  for (i=0; i<strlen(cmd); i++)
    if(islower(cmd[i])) cmd[i] = toupper(cmd[i]); /* in case 0abc */
  return sendmon(cmd,WAIT); /* have TUTOR store it */
}

setlong_mecb(addr,contents)
unsigned addr,contents;
{
  char cmd[80];			/* MS 2000 00000600 for ex. */
  int i;

  sprintf(cmd,"MS %x %08x\r",addr,contents); /* TUTOR cmd */
  for (i=0; i<strlen(cmd); i++)
    if (islower(cmd[i])) cmd[i] = toupper(cmd[i]); /* in case 0abc */
  return sendmon(cmd,WAIT); /* have TUTOR store it */
}

