/* loadprog.c - loadprog */
#include <stdio.h>
#include <a.out.h>
#include "define.h"
#define	STACKADDR 0xffc
#define	PKSTART "s"
char RDY = '\\';

FILE	*userfp, *fopen();
struct	exec	userhdr;
/*------------------------------------------------------------------------------
 * loadprog - load user program over high speed line
 *------------------------------------------------------------------------------
 */

loadprog(loadaddr, fastlength,mecbfd)
int	loadaddr;
int	fastlength;
int	mecbfd;
{
	int	bytes;
	int	length,packet;
	char	buf[PACKSIZE];
        int	resp;



	if ( (userfp = fopen(A.userprog,   "r")) == NULL) {
		fprintf(stderr,"Error -- opening %s user file\r\n",A.userprog);
		return(-1);
	}
	if (gethdr(userfp, &userhdr, A.userprog) < 0) {
		fprintf(stderr,"Error -- getting exe header %s\r\n",A.userprog);
		return (-1);
	}
	bytes = userhdr.a_text + userhdr.a_data;
	if (A.xdev==0) {			/* mecb needs tweaking-- */
	  if (startmon( MAXADDR-fastlength)<0)
	    return -1;
	  DEBUG(8,"Starting fastloader at 0x%x\r\n",(MAXADDR-fastlength));
	  if (readuntil(PKSTART,10)<0)
	    {
	      DEBUG(1,"fastloader failed to respond to start\r\n",NULL);
	      return -1;
	    }
	}
	packet = 0;
	while ( bytes > 0 ) {
		length = (bytes>PACKSIZE ? PACKSIZE : bytes);
		fread(buf, 1 , length, userfp);
		do {
		  sendpack(loadaddr,length,buf);
		  DEBUG(8,"in loadprog. About to read\r\n",NULL);
		  while ((resp = TOgetc(mecbfd,10)) == *PKSTART); /*skip extra starts */
		  if (resp < 0)
		    fprintf(stderr,"\r\n Read time out, on packet %d, retrying...\r\n",packet);
		  else if ( resp == NAK )
		    fprintf(stderr,"\r\nNAK, on packet %d, retrying...\r\n",packet);
		  else if (resp == ACK )
		    {
		      DEBUG(8,"\r\nACK received \r\n",NULL);
		    }
		  else
		   fprintf(stderr,"Received unexpected char from board: %c\r\n",(char)resp);
		} while ( resp != ACK );
		DEBUG(1,".",NULL); /* show progress */
		fflush(stderr);
		loadaddr += length;
		bytes -= length;
		packet++;
	}
	sendpack ( loadaddr, 0, buf );
	if ((resp = TOgetc(mecbfd,4)) < 0)
	  fprintf(stderr,"loadprog: problem at end of transmission: got %d\n",resp);

	fclose(userfp);
	fprintf(stderr,"Done loading user program\r\n");
	return (1);
}
