/* loadfast.c - loadfast */

#include <a.out.h>
#include "define.h"
#define	LENADDR	0x2000
extern char *prompt;
FILE	*fastfp, *fopen();
struct	exec	fasthdr;
/*------------------------------------------------------------------------------
 *  loadfast --  send fast loader to boot loader in reverse order
 *------------------------------------------------------------------------------
 */
loadfast(mecbfd)
int	mecbfd;
{

	int	length,i;
	char	*stack, *stackptr;
	char	buf[128];
	char    nullbuf[1];

	if ( (fastfp = fopen(A.fastloader, "r")) == NULL) {
		fprintf(stderr,"Cannot open file: %s\r\n", A.fastloader);
		return(-1);
	}
	gethdr(fastfp, &fasthdr, A.fastloader);
	DEBUG(4,"Loadfast():\r\n",NULL);
	length = fasthdr.a_text + fasthdr.a_data;	
	DEBUG(8,"length of fastloader is 0x%x\r\n",length);
	stack = (char *) malloc(length);	
	stackptr = &stack[length-1];
	while ( stackptr >= stack ) 	/* copy fast loader into memory	*/
		*stackptr-- = (char) fgetc(fastfp);

	usleep(50000);		/* make sure TUTOR ready */
	DEBUG(6,"calling setword()..\r\n",NULL);
	if (setword_mecb(LENADDR,length)<0)/* length of fast loader	*/
	  {
	    DEBUG(1,"Failed on setword of fast loader length\r\n",NULL);
	    return -1;
	  }
	sleep(1);
	DEBUG(6,"calling startmon()..\r\n",NULL);
	if (startmon(BOOTSTART)<0)
	  return -1;
        sleep(1);			/* Wait for monitor to get ready*/
	DEBUG(6,"Sending...\r\n",NULL);
	while ( ++stackptr < &stack[length] ) {
		write(mecbfd, stackptr, 1);
		DEBUG(8,".",NULL);
	}
	nullbuf[0] = '\0';
	for (i=0;i<20;i++)
	  write(mecbfd,nullbuf,1);   /* pad with nulls */
	DEBUG(6,"\r\nsent.  Waiting for prompt..\r\n",NULL);
	if (readuntil(prompt,20) < 0)
	  fprintf(stderr,"No response from fastloader\n");
	DEBUG(4,"Loadfast(): Have sent %s.\r\n",FASTLOADER);
	return(length);
}
