/* loadboot.c - loadboot, getline */

#include <a.out.h>
#include "define.h"
#define	MORE	1
#define NOMORE	0
FILE	*bootfp, *fopen();
extern char *prompt;
/*------------------------------------------------------------------------------
 * loadboot  -- load bootstrap loader via TUTOR Monitor
 *		input state: after monitor prompt
 * 		output state: same
 *------------------------------------------------------------------------------
 */
loadboot()
{
	char buf[128];



	if ( (bootfp = fopen(A.bootloader, "r")) == NULL) {
		fprintf(stderr,"Error -- opening %s boot loader ",A.bootloader);
		return(-1);
	}	
 	DEBUG(7,"Sending 'LO1'..\r\n ",NULL); 
	sendmon("LO1\r\n",WAIT);
	DEBUG(7," sent\r\n",NULL); 
	while ( getline(bootfp, buf) == MORE) {
 		DEBUG(7,", sending.. ",NULL); 
		sendmon(buf, WAIT);
 		DEBUG(7,"sent.\r\n",NULL); 
	} 
	DEBUG(6,"Have sent %s.\r\n",BOOTLOADER);
	readuntil(prompt, 10);
	DEBUG(7,"\r\nReceived TUTOR's prompt.\r\n",NULL);
	fclose(bootfp);
	return(1);
}

static getline(bootfp, buf)
FILE	*bootfp;
char	*buf;
{
	while( (*buf = (char)fgetc(bootfp)) != (char)EOF) {
		if (*buf++ == '\n') {
			*--buf = '\r';
			*++buf = EOS;
/* 			DEBUG(7,"Getline has found EOLN",NULL); */
			return(MORE);
		}
	}
/* 	DEBUG(7,"Getline has found EOF\n",NULL); */
	return(NOMORE);
}
