/* getmecb.c  -  procedure that automatically selects an MECB	*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include "define.h"
#define	MAXSTR	30
char	devname[MAXSTR];
char	convert[MAXSTR];
char	*loginid;
char	*mecbdevs[] = {
#include "mecbdevs.h"
		"/dev/MECB"};
#define	NDEVS	sizeof(mecbdevs)/sizeof(char *)
char *Mecbdevs[] = {
#include "Mecbdevs.h"
                "/dev/MECB.X"};
#define NXDEVS  sizeof(Mecbdevs)/sizeof(char *)

/*
 * ----------------------------------------------------------------------
 * setline - will configure a tty to communicate with a MECB. Special
 *	     routine included to handel the reset board.
 * ----------------------------------------------------------------------
 */

setline(mecbfd,xdev,mecbnum,speed)
int	*mecbfd;
int     xdev;                   /* 0 for orig. series, 1 for .X boards */
int	*mecbnum;		/* updateable if -1=wild */
int speed ;

{
  int i,mfd;
  char **devs;

  devs = mecbdevs;		/* orig series's array of names */
  if (xdev)
    devs = Mecbdevs;		/* X series's array of names */

  /* if glomline is non-trivial, use it as line to target machine */
  if (glomline[0] != '\0')
   {
    if ( ( mfd = open(glomline, O_RDWR,0666)) < 0)
	{
	  fprintf (stderr,"line %s is not currently available\n",glomline);
	  return (-1);
	}
   }
  else if (*mecbnum>=0)		/* non-wild, just use it */
    {
      if ( ( mfd = open(devs[*mecbnum], O_RDWR|O_NDELAY,0666)) < 0)
	{
	  fprintf (stderr,"board %d is not currently available\n",*mecbnum);
	  *mecbnum = -1;
	  return (-1);
	}
    }
  else				/* wild, try user boards in order-- */
    for (i=(xdev?0:1);i<NDEVS;i++) /* xdev user boards start at 0, orig at 1*/
      if ( ( mfd = open(devs[i], O_RDWR|O_NDELAY,0666)) > 0)
	{
	  *mecbnum = i;			/* return now-known bd # to caller */
	  break;			/* success--continue below */
	}

  if (mfd < 0)
    {
      fprintf(stderr,"Sorry, no board currently available\n");
      return (-1);
    }
  *mecbfd = mfd;		/* return fd to caller */

  /* Now lock the mecb line so noone else can use it */
  if (ioctl(mfd, TIOCEXCL,0) < 0) 
    fprintf(stderr," Cannot gain exclusive use of line, continuing\n");

  if (ioctl(mfd, TIOCGETP, &lttymode) < 0) {
    fprintf(stderr,"Error getting lttymode setup \n");
    return (-1);
  }
  lttymode.sg_flags |= RAW;
  lttymode.sg_flags &= ~ECHO;
  switch(speed)
    {
    case 1200: lttymode.sg_ospeed = lttymode.sg_ispeed = B1200;
      break;
    case 2400: lttymode.sg_ospeed = lttymode.sg_ispeed = B2400;
      break;
    case 9600: lttymode.sg_ospeed = lttymode.sg_ispeed = B9600;
      break;
      default  : lttymode.sg_ospeed = lttymode.sg_ispeed = B1200;
      break;
    }
  if (ioctl(mfd, TIOCSETP, &lttymode) < 0) {
    fprintf(stderr,"Error setting lttymode setup \n");
    return (-1);
  }
  
  if (ioctl(mfd, TIOCGETC, &t) < 0) {
    fprintf(stderr,"Error getting t \n");
    return (-1);
  }
  t.t_startc = '\0';
  t.t_stopc = '\0';
  if (ioctl(mfd, TIOCSETC, &t) < 0) {
    fprintf(stderr,"Error setting t \n");
    return (-1);
  }
  if (glomline[0] ==0 &&ioctl(mfd, TIOCSDTR, 0) < 0)
    {
      fprintf(stderr,"Can't raise DTR ");
      return(-1);
    }
  return(1);
}


