#include "/usr/local/xinu68/include/stdio.h"
#define PACKSIZE  0x400
#define SOH 0x2f
#define ACK 'y'
#define NAK 'n'

static int ldev = CONSOLE;

loadfile()
{
  while (getpack(ldev))	/* 0 len returned means eot */
    ;
}

int getpack(ldev)
int ldev;			/* CONSOLE or whatever */
{    
  char Buf[PACKSIZE];	/* temp place for packet */
  int BaseAddr,PackLen;		/* from packet header */
  int CheckSum,PktCkSum;	/* for checksum comparison */
  char ch;

  while (1) {			/* loop until get a packet */
    do {
      putc(ldev,'s');		/* put out 's' until see SOH back */
      ch = getc(ldev);
    } while (ch != SOH);
    CheckSum = 0;
    BaseAddr = getlong_cs(ldev,&CheckSum); /* get # and add to cksum */
    PackLen = getlong_cs(ldev,&CheckSum);
    if (PackLen > PACKSIZE) {
      putc(ldev,NAK);
      continue;			/* getpack loop */
    }
    if (PackLen>0)
      getbuf(Buf,PackLen,&CheckSum); /* and adjust CheckSum */
    PktCkSum = getlong(ldev);
    if (PktCkSum&CheckSum) {
      putc(ldev,NAK);
      continue;			/* with getpack loop */
    }
      
    bcopy(Buf,BaseAddr,PackLen); /* copy accepted packet to place */
    putc(ldev,ACK);
    return PackLen;
  }
}

getbuf(ldev,buf,len,cksumptr)
int ldev;
char *buf;
int len;
int *cksumptr;
{
  int i;
  unsigned char ch;

  for (i=0;i<len;i++) {
    ch = getc(ldev);
    *buf++ = ch;		/* put char in buf */
    *cksumptr += ch;		/* add to checksum */
  }
}

int getlong(ldev)
int ldev;
{
  int byte0,byte1,byte2,byte3;

  byte0 = kgetc(ldev);
  byte1 = kgetc(ldev);
  byte2 = kgetc(ldev);
  byte3 = kgetc(ldev);
  return byte0<<24|byte1<<16|byte2<<8|byte3;
}

int getlong_cs(ldev,cksumptr)
int ldev;
int *cksumptr;
{
  int byte0,byte1,byte2,byte3;

  byte0 = kgetc(ldev);
  *cksumptr += byte0;
  byte1 = kgetc(ldev);
  *cksumptr += byte1;
  byte2 = kgetc(ldev);
  *cksumptr += byte2;
  byte3 = kgetc(ldev);
  *cksumptr += byte3;
  return byte0<<24|byte1<<16|byte2<<8|byte3;
}
