/*----------------------------------------------------------------------*/
/*									*/
/*	download	+++ load programs into MC 68000 +++		*/
/*									*/
/* This program takes MC68000 a.out format files and downloads them	*/
/* into a Motorola Educational Computer Board (MEX68KECB)		*/
/*									*/
/* Usage:								*/
/*	download [filename] [-t tty] [-b filename] [-v] [-s]		*/
/*									*/
/* Author:								*/
/*      D. Burns                                                        */
/*	Princeton University/EECS Deptartment				*/
/*	July, 1983							*/
/*                                                                      */
/* Modified by:								*/
/*      rickm	                                                        */
/*	UMass-Boston/Math Deptartment					*/
/*	July, 1985							*/
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <a.out.h>
#include <sgtty.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <syscall.h>
#include "define.h"

char	*prompt = "> ";			/* prompt for tutor, readuntil  */
int	ttyset	=	FALSE;
int	fastlength;
extern int mecbfd;

download(mecbfd)
int mecbfd;
{
	char	buf[BUFSIZ];

	if (A.userprog[0] == '\0')
	  {
	    printf("ownload your .68 loadfile: ");
	    if (scanf("%s",buf)!=1) /* get 1 token */
	      {
		printf("Error in scanning filename!\n");
		return -1;
	      }
	    else
	      {
		if (setloadfile(buf)<0)
		  return -1;
	      }
	  }
	else
	  printf("ownloading %s\n",A.userprog); /* d/D was already echoed */

      if (A.xdev==0) {		/* mecb needs bootstraps, 7300 has them */
	DEBUG(4,"Calling getmon()\r\n ",NULL);           /* from floppy */
	getmon();
	DEBUG(1,"Calling loadboot()\r\n",NULL);
	if (loadboot() < 0) 
		return(-1);
	DEBUG(1,"Calling loadfast()\r\n",NULL);
        if ((fastlength = loadfast(mecbfd)) < 0)
		return(-1);
      } else {
 	DEBUG(7,"Sending 'lo'..\r\n ",NULL); 
	sendmon("lo\r\n",WAIT);
	DEBUG(7," sent\r\n",NULL); 
      }
	DEBUG(1,"Calling loadprog()\r\n",NULL);
	if ((loadprog(A.loadaddr,fastlength,mecbfd)) < 0) 
		return(-1);
        fprintf(stderr,"Done.\r\n");
}
