#include <stdio.h>
#include <sys/ioctl.h>

#ifdef DBUG
#define DEBUG(l, f, s)	if (Debug >= l) fprintf(stderr, f, s);
#else  DBUG
#define DEBUG(l, f, s)	;
#endif DBUG
#define	BREAK_ACK	"BREAK"	/* String sent by TUTOR to ack break	*/
#define	BREAK_DELAY	1	/* Seconds to sleep while BREAK'ing	*/

#define	BOOTLOADER	"/usr/local/xinu68/bin/boot.srec"
#define	FASTLOADER	"/usr/local/xinu68/bin/fastloader.68"
#define LOGFILE		".logfile"
#define BOARDDEFAULT	-1
#define STDIN		0
#define STDOUT		1
#define TRUE		1
#define FALSE		0
#define	WAIT		TRUE
#define	NOWAIT		FALSE
#define SOH		'/'
#define ACK		'y'
#define NAK		'n'
#define ESC		'\033'
#define PACKSIZE	0x0400
#define DISABLE		0x2700
#define EOS		'\0'
#define MAXADDR		0x8000
#define BOOTSTART	0x1000
#define PROGSTART	0x1000
#define CMD_ESC  '~'
typedef	int	Bool;

struct options {
	char	*fastloader;
	char	*bootloader;
	char	userprog[80];
	char	*logfile;
	char	boardesc;
	int	Baud;
	int	loadaddr;
	int     xdev;    /* 0 for orig. series of boards, 1 for .X boards */
	int	boardnum;
};
char	*prompt;
char	*errormes;	/* Global usagexit message */
int	mecbfd;		/* Mecb file descriptor */
int	pid;		/* Process id, for fork and lockfile */
static	int	idle = 0;
int	ttyset;
int	Debug;
char glomline[100];		/* if non-trivial, line to glom onto */
FILE	*logfp;
struct 	options	A;
struct	sgttyb	lttymode;	/* for mecb line */
struct	tchars	t;
extern	char	*mecbdevs[];



