#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include "define.h"

/* package to handle commanding tty, i.e., stdin */
/* mostly run in cbreak mode, with excursions to raw and original modes */
/*  using routines set_raw_ctty and set_orig_ctty, back with */
/*  set_cbreak_tty, tho also can call save_ctty, then set_orig_ctty, */
/*  then restore_ctty, if not sure what to go back to (non-top-level) */

/* prevent direct access: program must use set_raw_ctty, etc.-- */
static struct  sgttyb  kttymode;	/* orig mode */
static struct  sgttyb  cbreak_cttymode; /* orig, made cbreak */
static struct  sgttyb  raw_cttymode;	/* orig, made raw */
static int have_modes= 0;	/* set to 1 if ioctl succeeds */

init_ctty()
{
  /*
   * set up local terminal in cbreak mode, other settings as on entry
   */

  /* Fill in sgtty structure kttymode with terminal settings on entry */
  if (!isatty(0))
    return 0;			/* not a tty--presume batch mode */

  if (ioctl(STDIN, TIOCGETP, &kttymode) < 0 ) {
    perror("Cannot get terminal modes");
    return 0;			/* try batch mode */
  }

  if (ioctl(STDIN,TIOCGETP,&cbreak_cttymode) < 0) {
    fprintf(stderr,"Error - Getting ctty terminal modes \r\n");
    return 0;
  }
  have_modes = 1;		/* success, can put back later */
  cbreak_cttymode.sg_flags |= CBREAK;
  cbreak_cttymode.sg_flags &= ~ECHO;
  cbreak_cttymode.sg_flags &= ~CRMOD;
  if(ioctl(STDIN, TIOCSETP, &cbreak_cttymode) < 0) {
    fprintf(stderr,"Cannot set modes on your ctty line\r\n");
    have_modes = 0;		/* don't try again */
    return 0;
  }
  ioctl(STDIN, TIOCGETP, &raw_cttymode); /* for perm raw copy */
  raw_cttymode.sg_flags &= ~CBREAK;
  raw_cttymode.sg_flags |= RAW;	/* now ready for set_raw_ctty */
  return 1;			/* cks out as real ctty */
}

/* save ctty status in caller's provided struct sgttyb */

save_ctty(cttymodep)
struct sgttyb *cttymodep; /* caller provide storage for struct--its copy */
{
  if (have_modes)
    ioctl(STDIN, TIOCGETP, cttymodep);
}

/* restore back from caller's struct sgttyb, filled by save_ctty */
restore_ctty(cttymodep)
struct sgttyb *cttymodep;
{
  if (have_modes)
    ioctl(STDIN, TIOCSETP, cttymodep);
}

/* set ctty to original, modified to cbreak mode */
set_cbreak_ctty()
{
  if (have_modes)
    ioctl(STDIN,TIOCSETP,&cbreak_cttymode);
}

/* set ctty to origina, modified to raw mode */
set_raw_ctty()
{
  if (have_modes)
    ioctl(STDIN,TIOCSETP,&raw_cttymode);
}

/* back to what we started with */
set_orig_ctty()
{
  if (have_modes)
    ioctl(STDIN,TIOCSETP,&kttymode);
}
