/* note line# kludge--remove when fix hardware reset server--eoneil 11/8/88*/
#include <stdio.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <setjmp.h>
/* temp-- */
char server[] = "/dev/MECB.0";
struct sigvec alarmvec,oldvec;
int serverfd;

#define SOH '/'
#define BRESET 'A'
#define ACK 'y'
#define NAK 'n'
#define RESETALL '\177'

main(argc,argv)
int argc;
char *argv[];
{
  char *linespec;
  int line;
  int alarmhand();

  if (argc == 2)
    linespec = argv[1];
  else
    {
      printf("Line to reset (0-15), or * for all: ");
      linespec = (char *)malloc(80);
      scanf("%s",linespec);
    }
  if (linespec[0]=='*')
    line = RESETALL;
  else 
    {
      line = atoi(linespec);
      if (line<0||line>15)
	{
	  fprintf(stderr,"Invalid line, try again\n");
	  exit(1);
	}
    }
  serverfd = open(server,O_RDWR,0);
  if (serverfd <0)
    {
      fprintf(stderr,"Failed to open %s\n",server);
      exit(1);
    }
  if (ioctl(serverfd, TIOCEXCL,0) < 0) 
    fprintf(stderr,"Cannot gain exclusive use of reset server--continuing\n");
  setupline(&serverfd);		
  if (line==2) line = 12;   /* kludge */
  if (line==5) line = 13;   /* avoiding bad reset lines */
  if (line==7) line = 8;
  if (resetboard(serverfd,line)<0)
    fprintf(stderr,"Failed to reset board\n");
}

static jmp_buf save_frame;

alarmhand()
{
  longjmp(save_frame,1);	/* make setjmp return true */
}

/* 4.2BSD does not provide aborted syscalls on signals */
/* the old trick of just getting alarm signal no longer works-- */
/* the read is RESTARTED on alarm, not aborted like it used to be */

TOgetc(serverfd,nsec)
int serverfd;
int nsec;			/* timeout period */
{
  int pid,stat;
  char buf[1];
  int retval;

  signal(SIGALRM,alarmhand);   /* parent ignores alarm */
  alarm(nsec);
  if (setjmp(save_frame))
    retval = -2;		/* got signal */
  else				/* made it in time */
    {
      retval = read(serverfd,buf,1); /* try to read */
      if (retval == 1) retval = buf[0];	/* success */
    }
  alarm(0);
  return retval;
}

serputc(ch)
char ch;
{
  char buf[1];

  buf[0] = ch;
  if (write(serverfd,buf,1) != 1)
    return -1;
  else return 0;
}

resetboard(serverfd,line)
int serverfd;
int line;			/* 0-15 or RESETALL */
{
  int ans,timeoutsecs,i;

  if (serputc(SOH) < 0) 
    {				/* assume if one works, rest will-- */
      fprintf(stderr,"Serputc of SOH failed\n");
      return -1;
    }
  for(i=0;i<5&& (ans = TOgetc(serverfd,3)) != ACK; i++)
    { fprintf(stderr,"Non-ACK to SOH: %c=0x%x\n",ans,ans);
    serputc(SOH);    /* maybe finish partial command...*/
    }
  if (ans != ACK)
    {
      fprintf(stderr,"No ACK of SOH in 5 tries--reset server hung!!\n");
      return -1;
    }
  serputc(BRESET);
  serputc(line);
  timeoutsecs = (line==RESETALL?20:3); /* give wildcard reset longer */
  if ((ans = TOgetc(serverfd,timeoutsecs)) != ACK)
    {
      if (ans < 0)
	fprintf(stderr,"Reset server timed out after %d secs\n",timeoutsecs);
      else
	fprintf(stderr,"Did not receive expected ACK, got %c=0x%x\n",ans,ans);
      return -1;   /* fail */
    }
  else return 0;		/* success */
}
struct	sgttyb	lttymode;
struct	tchars	t;

setupline(mecbfd)
int *mecbfd;
{	
  if (ioctl(*mecbfd, TIOCGETP, &lttymode) < 0) {
    fprintf(stderr,"Error getting lttymode setup \n");
    return (-1);
  }
  lttymode.sg_flags |= RAW;
  lttymode.sg_flags &= ~ECHO;
  lttymode.sg_ospeed = lttymode.sg_ispeed = B1200;
  if (ioctl(*mecbfd, TIOCSETP, &lttymode) < 0) {
    fprintf(stderr,"Error setting lttymode setup \n");
    return (-1);
  }

  if (ioctl(*mecbfd, TIOCGETC, &t) < 0) {
    fprintf(stderr,"Error getting t \n");
    return (-1);
  }
  t.t_startc = '\0';
  t.t_stopc = '\0';
  if (ioctl(*mecbfd, TIOCSETC, &t) < 0) {
    fprintf(stderr,"Error setting t \n");
    return (-1);
  }
  if (ioctl(*mecbfd, TIOCSDTR, 0) < 0)
    {
      fprintf(stderr,"Can't raise DTR ");
      return(-1);
    }
}
