| boot.s  -  bootstrap loader

| boot  --  loads the fast loader into the high portion of memory;
|           when executed, register d0 contains the size of the fast loader
|	    in bytes

LENGTH	  = 0x2000			| Address where length is hidden
UARTDATA  = 0x10042			| Port 1 Uart Data
UARTSTAT  = 0x10040			| Port 1 Uart Status
FRAMERR   = 0x4				| Framing Error bit (BREAK detect)
MAXADDR	  = 0x8000			| Highest memory location

RXFULL    = 0				| Receiver Full Bit

	.data
	.text
	.globl	_boot
_boot:
	clrl	d0
	movw	LENGTH, d0
	movl	#MAXADDR, a0
getchar:
	btst	#RXFULL, UARTSTAT	| Wait until a character is sent
	beq	getchar
	btst	#FRAMERR, UARTSTAT	| Check for BREAK
	bne	monitor			|    return to monitor if so
	movb	UARTDATA, a0@-		| Move character into high memory
	subql	#1, d0			| Decrement count of incoming chs
	bne	getchar			| If more characters, go get them

monitor:
	movb	#228,d7			| Return to monitor
	trap	#14
