/*	$NetBSD: oss_2_0_d.h,v 1.3 2021/12/18 23:45:21 riastradh Exp $	*/

/*
 * OSS_2_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef OSS_2_0_D_H
#define OSS_2_0_D_H

#define mmIH_VMID_0_LUT                                                         0xf50
#define mmIH_VMID_1_LUT                                                         0xf51
#define mmIH_VMID_2_LUT                                                         0xf52
#define mmIH_VMID_3_LUT                                                         0xf53
#define mmIH_VMID_4_LUT                                                         0xf54
#define mmIH_VMID_5_LUT                                                         0xf55
#define mmIH_VMID_6_LUT                                                         0xf56
#define mmIH_VMID_7_LUT                                                         0xf57
#define mmIH_VMID_8_LUT                                                         0xf58
#define mmIH_VMID_9_LUT                                                         0xf59
#define mmIH_VMID_10_LUT                                                        0xf5a
#define mmIH_VMID_11_LUT                                                        0xf5b
#define mmIH_VMID_12_LUT                                                        0xf5c
#define mmIH_VMID_13_LUT                                                        0xf5d
#define mmIH_VMID_14_LUT                                                        0xf5e
#define mmIH_VMID_15_LUT                                                        0xf5f
#define mmIH_RB_CNTL                                                            0xf80
#define mmIH_RB_BASE                                                            0xf81
#define mmIH_RB_RPTR                                                            0xf82
#define mmIH_RB_WPTR                                                            0xf83
#define mmIH_RB_WPTR_ADDR_HI                                                    0xf84
#define mmIH_RB_WPTR_ADDR_LO                                                    0xf85
#define mmIH_CNTL                                                               0xf86
#define mmIH_LEVEL_STATUS                                                       0xf87
#define mmIH_STATUS                                                             0xf88
#define mmIH_PERFMON_CNTL                                                       0xf89
#define mmIH_PERFCOUNTER0_RESULT                                                0xf8a
#define mmIH_PERFCOUNTER1_RESULT                                                0xf8b
#define mmIH_ADVFAULT_CNTL                                                      0xf8c
#define mmSEM_MCIF_CONFIG                                                       0xf90
#define mmSDMA_CONFIG                                                           0xf91
#define mmSDMA1_CONFIG                                                          0xf92
#define mmUVD_CONFIG                                                            0xf93
#define mmVCE_CONFIG                                                            0xf94
#define mmACP_CONFIG                                                            0xf95
#define mmCPG_CONFIG                                                            0xf96
#define mmCPC1_CONFIG                                                           0xf97
#define mmCPC2_CONFIG                                                           0xf98
#define mmSEM_STATUS                                                            0xf99
#define mmSEM_EDC_CONFIG                                                        0xf9a
#define mmSEM_MAILBOX_CLIENTCONFIG                                              0xf9b
#define mmSEM_MAILBOX                                                           0xf9c
#define mmSEM_MAILBOX_CONTROL                                                   0xf9d
#define mmSEM_CHICKEN_BITS                                                      0xf9e
#define mmSRBM_CNTL                                                             0x390
#define mmSRBM_GFX_CNTL                                                         0x391
#define mmSRBM_STATUS2                                                          0x393
#define mmSRBM_STATUS                                                           0x394
#define mmSRBM_CAM_INDEX                                                        0x396
#define mmSRBM_CAM_DATA                                                         0x397
#define mmSRBM_SOFT_RESET                                                       0x398
#define mmSRBM_DEBUG_CNTL                                                       0x399
#define mmSRBM_DEBUG_DATA                                                       0x39a
#define mmSRBM_CHIP_REVISION                                                    0x39b
#define mmCC_SYS_RB_REDUNDANCY                                                  0x39f
#define mmCC_SYS_RB_BACKEND_DISABLE                                             0x3a0
#define mmGC_USER_SYS_RB_BACKEND_DISABLE                                        0x3a1
#define mmSRBM_MC_CLKEN_CNTL                                                    0x3b3
#define mmSRBM_SYS_CLKEN_CNTL                                                   0x3b4
#define mmSRBM_VCE_CLKEN_CNTL                                                   0x3b5
#define mmSRBM_UVD_CLKEN_CNTL                                                   0x3b6
#define mmSRBM_SDMA_CLKEN_CNTL                                                  0x3b7
#define mmSRBM_SAM_CLKEN_CNTL                                                   0x3b8
#define mmSRBM_DEBUG                                                            0x3a4
#define mmSRBM_DEBUG_SNAPSHOT                                                   0x3a5
#define mmSRBM_READ_ERROR                                                       0x3a6
#define mmSRBM_INT_CNTL                                                         0x3a8
#define mmSRBM_INT_STATUS                                                       0x3a9
#define mmSRBM_INT_ACK                                                          0x3aa
#define mmSRBM_PERFMON_CNTL                                                     0x700
#define mmSRBM_PERFCOUNTER0_SELECT                                              0x701
#define mmSRBM_PERFCOUNTER1_SELECT                                              0x702
#define mmSRBM_PERFCOUNTER0_LO                                                  0x703
#define mmSRBM_PERFCOUNTER0_HI                                                  0x704
#define mmSRBM_PERFCOUNTER1_LO                                                  0x705
#define mmSRBM_PERFCOUNTER1_HI                                                  0x706
#define mmCC_DRM_ID_STRAPS                                                      0x1559
#define mmCGTT_DRM_CLK_CTRL0                                                    0x1579
#define ixDH_TEST                                                               0x0
#define ixKHFS0                                                                 0x4
#define ixKHFS1                                                                 0x8
#define ixKHFS2                                                                 0xc
#define ixKHFS3                                                                 0x10
#define ixKSESSION0                                                             0x14
#define ixKSESSION1                                                             0x18
#define ixKSESSION2                                                             0x1c
#define ixKSESSION3                                                             0x20
#define ixKSIG0                                                                 0x24
#define ixKSIG1                                                                 0x28
#define ixKSIG2                                                                 0x2c
#define ixKSIG3                                                                 0x30
#define ixEXP0                                                                  0x34
#define ixEXP1                                                                  0x38
#define ixEXP2                                                                  0x3c
#define ixEXP3                                                                  0x40
#define ixEXP4                                                                  0x44
#define ixEXP5                                                                  0x48
#define ixEXP6                                                                  0x4c
#define ixEXP7                                                                  0x50
#define ixLX0                                                                   0x54
#define ixLX1                                                                   0x58
#define ixLX2                                                                   0x5c
#define ixLX3                                                                   0x60
#define ixCLIENT2_K0                                                            0x1b4
#define ixCLIENT2_K1                                                            0x1b8
#define ixCLIENT2_K2                                                            0x1bc
#define ixCLIENT2_K3                                                            0x1c0
#define ixCLIENT2_CK0                                                           0x1c4
#define ixCLIENT2_CK1                                                           0x1c8
#define ixCLIENT2_CK2                                                           0x1cc
#define ixCLIENT2_CK3                                                           0x1d0
#define ixCLIENT2_CD0                                                           0x1d4
#define ixCLIENT2_CD1                                                           0x1d8
#define ixCLIENT2_CD2                                                           0x1dc
#define ixCLIENT2_CD3                                                           0x1e0
#define ixCLIENT2_BM                                                            0x1e4
#define ixCLIENT2_OFFSET                                                        0x1e8
#define ixCLIENT2_STATUS                                                        0x1ec
#define ixCLIENT0_K0                                                            0x1f0
#define ixCLIENT0_K1                                                            0x1f4
#define ixCLIENT0_K2                                                            0x1f8
#define ixCLIENT0_K3                                                            0x1fc
#define ixCLIENT0_CK0                                                           0x200
#define ixCLIENT0_CK1                                                           0x204
#define ixCLIENT0_CK2                                                           0x208
#define ixCLIENT0_CK3                                                           0x20c
#define ixCLIENT0_CD0                                                           0x210
#define ixCLIENT0_CD1                                                           0x214
#define ixCLIENT0_CD2                                                           0x218
#define ixCLIENT0_CD3                                                           0x21c
#define ixCLIENT0_BM                                                            0x220
#define ixCLIENT0_OFFSET                                                        0x224
#define ixCLIENT0_STATUS                                                        0x228
#define ixCLIENT1_K0                                                            0x22c
#define ixCLIENT1_K1                                                            0x230
#define ixCLIENT1_K2                                                            0x234
#define ixCLIENT1_K3                                                            0x238
#define ixCLIENT1_CK0                                                           0x23c
#define ixCLIENT1_CK1                                                           0x240
#define ixCLIENT1_CK2                                                           0x244
#define ixCLIENT1_CK3                                                           0x248
#define ixCLIENT1_CD0                                                           0x24c
#define ixCLIENT1_CD1                                                           0x250
#define ixCLIENT1_CD2                                                           0x254
#define ixCLIENT1_CD3                                                           0x258
#define ixCLIENT1_BM                                                            0x25c
#define ixCLIENT1_OFFSET                                                        0x260
#define ixCLIENT1_PORT_STATUS                                                   0x264
#define ixKEFUSE0                                                               0x268
#define ixKEFUSE1                                                               0x26c
#define ixKEFUSE2                                                               0x270
#define ixKEFUSE3                                                               0x274
#define ixHFS_SEED0                                                             0x278
#define ixHFS_SEED1                                                             0x27c
#define ixHFS_SEED2                                                             0x280
#define ixHFS_SEED3                                                             0x284
#define ixRINGOSC_MASK                                                          0x288
#define ixCLIENT0_OFFSET_HI                                                     0x290
#define ixCLIENT1_OFFSET_HI                                                     0x294
#define ixCLIENT2_OFFSET_HI                                                     0x298
#define ixSPU_PORT_STATUS                                                       0x29c
#define ixCLIENT3_OFFSET_HI                                                     0x2a0
#define ixCLIENT3_K0                                                            0x2a4
#define ixCLIENT3_K1                                                            0x2a8
#define ixCLIENT3_K2                                                            0x2ac
#define ixCLIENT3_K3                                                            0x2b0
#define ixCLIENT3_CK0                                                           0x2b4
#define ixCLIENT3_CK1                                                           0x2b8
#define ixCLIENT3_CK2                                                           0x2bc
#define ixCLIENT3_CK3                                                           0x2c0
#define ixCLIENT3_CD0                                                           0x2c4
#define ixCLIENT3_CD1                                                           0x2c8
#define ixCLIENT3_CD2                                                           0x2cc
#define ixCLIENT3_CD3                                                           0x2d0
#define ixCLIENT3_BM                                                            0x2d4
#define ixCLIENT3_OFFSET                                                        0x2d8
#define ixCLIENT3_STATUS                                                        0x2dc
#define mmDC_TEST_DEBUG_INDEX                                                   0x157c
#define mmDC_TEST_DEBUG_DATA                                                    0x157d
#define mmXDMA_SLV_CNTL                                                         0x460
#define mmXDMA_SLV_MEM_CLIENT_CONFIG                                            0x461
#define mmXDMA_SLV_SLS_PITCH                                                    0x462
#define mmXDMA_SLV_READ_URGENT_CNTL                                             0x463
#define mmXDMA_SLV_WRITE_URGENT_CNTL                                            0x464
#define mmXDMA_SLV_WB_RATE_CNTL                                                 0x465
#define mmXDMA_SLV_READ_LATENCY_MINMAX                                          0x466
#define mmXDMA_SLV_READ_LATENCY_AVE                                             0x467
#define mmXDMA_SLV_PCIE_NACK_STATUS                                             0x468
#define mmXDMA_SLV_MEM_NACK_STATUS                                              0x469
#define mmXDMA_SLV_RDRET_BUF_STATUS                                             0x46a
#define mmXDMA_SLV_READ_LATENCY_TIMER                                           0x46b
#define mmXDMA_SLV_FLIP_PENDING                                                 0x46c
#define mmSDMA0_UCODE_ADDR                                                      0x3400
#define mmSDMA0_UCODE_DATA                                                      0x3401
#define mmSDMA0_POWER_CNTL                                                      0x3402
#define mmSDMA0_CLK_CTRL                                                        0x3403
#define mmSDMA0_CNTL                                                            0x3404
#define mmSDMA0_CHICKEN_BITS                                                    0x3405
#define mmSDMA0_TILING_CONFIG                                                   0x3406
#define mmSDMA0_HASH                                                            0x3407
#define mmSDMA0_SEM_INCOMPLETE_TIMER_CNTL                                       0x3408
#define mmSDMA0_SEM_WAIT_FAIL_TIMER_CNTL                                        0x3409
#define mmSDMA0_RB_RPTR_FETCH                                                   0x340a
#define mmSDMA0_IB_OFFSET_FETCH                                                 0x340b
#define mmSDMA0_PROGRAM                                                         0x340c
#define mmSDMA0_STATUS_REG                                                      0x340d
#define mmSDMA0_STATUS1_REG                                                     0x340e
#define mmSDMA0_PERFMON_CNTL                                                    0x340f
#define mmSDMA0_PERFCOUNTER0_RESULT                                             0x3410
#define mmSDMA0_PERFCOUNTER1_RESULT                                             0x3411
#define mmSDMA0_F32_CNTL                                                        0x3412
#define mmSDMA0_FREEZE                                                          0x3413
#define mmSDMA0_PHASE0_QUANTUM                                                  0x3414
#define mmSDMA0_PHASE1_QUANTUM                                                  0x3415
#define mmSDMA_POWER_GATING                                                     0x3416
#define mmSDMA_PGFSM_CONFIG                                                     0x3417
#define mmSDMA_PGFSM_WRITE                                                      0x3418
#define mmSDMA_PGFSM_READ                                                       0x3419
#define mmSDMA0_EDC_CONFIG                                                      0x341a
#define mmSDMA0_GFX_RB_CNTL                                                     0x3480
#define mmSDMA0_GFX_RB_BASE                                                     0x3481
#define mmSDMA0_GFX_RB_BASE_HI                                                  0x3482
#define mmSDMA0_GFX_RB_RPTR                                                     0x3483
#define mmSDMA0_GFX_RB_WPTR                                                     0x3484
#define mmSDMA0_GFX_RB_WPTR_POLL_CNTL                                           0x3485
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_HI                                        0x3486
#define mmSDMA0_GFX_RB_WPTR_POLL_ADDR_LO                                        0x3487
#define mmSDMA0_GFX_RB_RPTR_ADDR_HI                                             0x3488
#define mmSDMA0_GFX_RB_RPTR_ADDR_LO                                             0x3489
#define mmSDMA0_GFX_IB_CNTL                                                     0x348a
#define mmSDMA0_GFX_IB_RPTR                                                     0x348b
#define mmSDMA0_GFX_IB_OFFSET                                                   0x348c
#define mmSDMA0_GFX_IB_BASE_LO                                                  0x348d
#define mmSDMA0_GFX_IB_BASE_HI                                                  0x348e
#define mmSDMA0_GFX_IB_SIZE                                                     0x348f
#define mmSDMA0_GFX_SKIP_CNTL                                                   0x3490
#define mmSDMA0_GFX_CONTEXT_STATUS                                              0x3491
#define mmSDMA0_GFX_CONTEXT_CNTL                                                0x3493
#define mmSDMA0_GFX_VIRTUAL_ADDR                                                0x34a7
#define mmSDMA0_GFX_APE1_CNTL                                                   0x34a8
#define mmSDMA0_GFX_WATERMARK                                                   0x34aa
#define mmSDMA0_RLC0_RB_CNTL                                                    0x3500
#define mmSDMA0_RLC0_RB_BASE                                                    0x3501
#define mmSDMA0_RLC0_RB_BASE_HI                                                 0x3502
#define mmSDMA0_RLC0_RB_RPTR                                                    0x3503
#define mmSDMA0_RLC0_RB_WPTR                                                    0x3504
#define mmSDMA0_RLC0_RB_WPTR_POLL_CNTL                                          0x3505
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI                                       0x3506
#define mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO                                       0x3507
#define mmSDMA0_RLC0_RB_RPTR_ADDR_HI                                            0x3508
#define mmSDMA0_RLC0_RB_RPTR_ADDR_LO                                            0x3509
#define mmSDMA0_RLC0_IB_CNTL                                                    0x350a
#define mmSDMA0_RLC0_IB_RPTR                                                    0x350b
#define mmSDMA0_RLC0_IB_OFFSET                                                  0x350c
#define mmSDMA0_RLC0_IB_BASE_LO                                                 0x350d
#define mmSDMA0_RLC0_IB_BASE_HI                                                 0x350e
#define mmSDMA0_RLC0_IB_SIZE                                                    0x350f
#define mmSDMA0_RLC0_SKIP_CNTL                                                  0x3510
#define mmSDMA0_RLC0_CONTEXT_STATUS                                             0x3511
#define mmSDMA0_RLC0_DOORBELL                                                   0x3512
#define mmSDMA0_RLC0_VIRTUAL_ADDR                                               0x3527
#define mmSDMA0_RLC0_APE1_CNTL                                                  0x3528
#define mmSDMA0_RLC0_DOORBELL_LOG                                               0x3529
#define mmSDMA0_RLC0_WATERMARK                                                  0x352a
#define mmSDMA0_RLC1_RB_CNTL                                                    0x3580
#define mmSDMA0_RLC1_RB_BASE                                                    0x3581
#define mmSDMA0_RLC1_RB_BASE_HI                                                 0x3582
#define mmSDMA0_RLC1_RB_RPTR                                                    0x3583
#define mmSDMA0_RLC1_RB_WPTR                                                    0x3584
#define mmSDMA0_RLC1_RB_WPTR_POLL_CNTL                                          0x3585
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI                                       0x3586
#define mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO                                       0x3587
#define mmSDMA0_RLC1_RB_RPTR_ADDR_HI                                            0x3588
#define mmSDMA0_RLC1_RB_RPTR_ADDR_LO                                            0x3589
#define mmSDMA0_RLC1_IB_CNTL                                                    0x358a
#define mmSDMA0_RLC1_IB_RPTR                                                    0x358b
#define mmSDMA0_RLC1_IB_OFFSET                                                  0x358c
#define mmSDMA0_RLC1_IB_BASE_LO                                                 0x358d
#define mmSDMA0_RLC1_IB_BASE_HI                                                 0x358e
#define mmSDMA0_RLC1_IB_SIZE                                                    0x358f
#define mmSDMA0_RLC1_SKIP_CNTL                                                  0x3590
#define mmSDMA0_RLC1_CONTEXT_STATUS                                             0x3591
#define mmSDMA0_RLC1_DOORBELL                                                   0x3592
#define mmSDMA0_RLC1_VIRTUAL_ADDR                                               0x35a7
#define mmSDMA0_RLC1_APE1_CNTL                                                  0x35a8
#define mmSDMA0_RLC1_DOORBELL_LOG                                               0x35a9
#define mmSDMA0_RLC1_WATERMARK                                                  0x35aa
#define mmSDMA1_UCODE_ADDR                                                      0x3600
#define mmSDMA1_UCODE_DATA                                                      0x3601
#define mmSDMA1_POWER_CNTL                                                      0x3602
#define mmSDMA1_CLK_CTRL                                                        0x3603
#define mmSDMA1_CNTL                                                            0x3604
#define mmSDMA1_CHICKEN_BITS                                                    0x3605
#define mmSDMA1_TILING_CONFIG                                                   0x3606
#define mmSDMA1_HASH                                                            0x3607
#define mmSDMA1_SEM_INCOMPLETE_TIMER_CNTL                                       0x3608
#define mmSDMA1_SEM_WAIT_FAIL_TIMER_CNTL                                        0x3609
#define mmSDMA1_RB_RPTR_FETCH                                                   0x360a
#define mmSDMA1_IB_OFFSET_FETCH                                                 0x360b
#define mmSDMA1_PROGRAM                                                         0x360c
#define mmSDMA1_STATUS_REG                                                      0x360d
#define mmSDMA1_STATUS1_REG                                                     0x360e
#define mmSDMA1_PERFMON_CNTL                                                    0x360f
#define mmSDMA1_PERFCOUNTER0_RESULT                                             0x3610
#define mmSDMA1_PERFCOUNTER1_RESULT                                             0x3611
#define mmSDMA1_F32_CNTL                                                        0x3612
#define mmSDMA1_FREEZE                                                          0x3613
#define mmSDMA1_PHASE0_QUANTUM                                                  0x3614
#define mmSDMA1_PHASE1_QUANTUM                                                  0x3615
#define mmSDMA1_EDC_CONFIG                                                      0x361a
#define mmSDMA1_GFX_RB_CNTL                                                     0x3680
#define mmSDMA1_GFX_RB_BASE                                                     0x3681
#define mmSDMA1_GFX_RB_BASE_HI                                                  0x3682
#define mmSDMA1_GFX_RB_RPTR                                                     0x3683
#define mmSDMA1_GFX_RB_WPTR                                                     0x3684
#define mmSDMA1_GFX_RB_WPTR_POLL_CNTL                                           0x3685
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_HI                                        0x3686
#define mmSDMA1_GFX_RB_WPTR_POLL_ADDR_LO                                        0x3687
#define mmSDMA1_GFX_RB_RPTR_ADDR_HI                                             0x3688
#define mmSDMA1_GFX_RB_RPTR_ADDR_LO                                             0x3689
#define mmSDMA1_GFX_IB_CNTL                                                     0x368a
#define mmSDMA1_GFX_IB_RPTR                                                     0x368b
#define mmSDMA1_GFX_IB_OFFSET                                                   0x368c
#define mmSDMA1_GFX_IB_BASE_LO                                                  0x368d
#define mmSDMA1_GFX_IB_BASE_HI                                                  0x368e
#define mmSDMA1_GFX_IB_SIZE                                                     0x368f
#define mmSDMA1_GFX_SKIP_CNTL                                                   0x3690
#define mmSDMA1_GFX_CONTEXT_STATUS                                              0x3691
#define mmSDMA1_GFX_CONTEXT_CNTL                                                0x3693
#define mmSDMA1_GFX_VIRTUAL_ADDR                                                0x36a7
#define mmSDMA1_GFX_APE1_CNTL                                                   0x36a8
#define mmSDMA1_GFX_WATERMARK                                                   0x36aa
#define mmSDMA1_RLC0_RB_CNTL                                                    0x3700
#define mmSDMA1_RLC0_RB_BASE                                                    0x3701
#define mmSDMA1_RLC0_RB_BASE_HI                                                 0x3702
#define mmSDMA1_RLC0_RB_RPTR                                                    0x3703
#define mmSDMA1_RLC0_RB_WPTR                                                    0x3704
#define mmSDMA1_RLC0_RB_WPTR_POLL_CNTL                                          0x3705
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI                                       0x3706
#define mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO                                       0x3707
#define mmSDMA1_RLC0_RB_RPTR_ADDR_HI                                            0x3708
#define mmSDMA1_RLC0_RB_RPTR_ADDR_LO                                            0x3709
#define mmSDMA1_RLC0_IB_CNTL                                                    0x370a
#define mmSDMA1_RLC0_IB_RPTR                                                    0x370b
#define mmSDMA1_RLC0_IB_OFFSET                                                  0x370c
#define mmSDMA1_RLC0_IB_BASE_LO                                                 0x370d
#define mmSDMA1_RLC0_IB_BASE_HI                                                 0x370e
#define mmSDMA1_RLC0_IB_SIZE                                                    0x370f
#define mmSDMA1_RLC0_SKIP_CNTL                                                  0x3710
#define mmSDMA1_RLC0_CONTEXT_STATUS                                             0x3711
#define mmSDMA1_RLC0_DOORBELL                                                   0x3712
#define mmSDMA1_RLC0_VIRTUAL_ADDR                                               0x3727
#define mmSDMA1_RLC0_APE1_CNTL                                                  0x3728
#define mmSDMA1_RLC0_DOORBELL_LOG                                               0x3729
#define mmSDMA1_RLC0_WATERMARK                                                  0x372a
#define mmSDMA1_RLC1_RB_CNTL                                                    0x3780
#define mmSDMA1_RLC1_RB_BASE                                                    0x3781
#define mmSDMA1_RLC1_RB_BASE_HI                                                 0x3782
#define mmSDMA1_RLC1_RB_RPTR                                                    0x3783
#define mmSDMA1_RLC1_RB_WPTR                                                    0x3784
#define mmSDMA1_RLC1_RB_WPTR_POLL_CNTL                                          0x3785
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI                                       0x3786
#define mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO                                       0x3787
#define mmSDMA1_RLC1_RB_RPTR_ADDR_HI                                            0x3788
#define mmSDMA1_RLC1_RB_RPTR_ADDR_LO                                            0x3789
#define mmSDMA1_RLC1_IB_CNTL                                                    0x378a
#define mmSDMA1_RLC1_IB_RPTR                                                    0x378b
#define mmSDMA1_RLC1_IB_OFFSET                                                  0x378c
#define mmSDMA1_RLC1_IB_BASE_LO                                                 0x378d
#define mmSDMA1_RLC1_IB_BASE_HI                                                 0x378e
#define mmSDMA1_RLC1_IB_SIZE                                                    0x378f
#define mmSDMA1_RLC1_SKIP_CNTL                                                  0x3790
#define mmSDMA1_RLC1_CONTEXT_STATUS                                             0x3791
#define mmSDMA1_RLC1_DOORBELL                                                   0x3792
#define mmSDMA1_RLC1_VIRTUAL_ADDR                                               0x37a7
#define mmSDMA1_RLC1_APE1_CNTL                                                  0x37a8
#define mmSDMA1_RLC1_DOORBELL_LOG                                               0x37a9
#define mmSDMA1_RLC1_WATERMARK                                                  0x37aa
#define mmXDMA_SLV_CHANNEL_CNTL                                                 0x470
#define mmSDMA_CHANNEL0_XDMA_SLV_CHANNEL_CNTL                                   0x470
#define mmSDMA_CHANNEL1_XDMA_SLV_CHANNEL_CNTL                                   0x478
#define mmSDMA_CHANNEL2_XDMA_SLV_CHANNEL_CNTL                                   0x480
#define mmSDMA_CHANNEL3_XDMA_SLV_CHANNEL_CNTL                                   0x488
#define mmSDMA_CHANNEL4_XDMA_SLV_CHANNEL_CNTL                                   0x490
#define mmSDMA_CHANNEL5_XDMA_SLV_CHANNEL_CNTL                                   0x498
#define mmXDMA_SLV_REMOTE_GPU_ADDRESS                                           0x471
#define mmSDMA_CHANNEL0_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x471
#define mmSDMA_CHANNEL1_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x479
#define mmSDMA_CHANNEL2_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x481
#define mmSDMA_CHANNEL3_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x489
#define mmSDMA_CHANNEL4_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x491
#define mmSDMA_CHANNEL5_XDMA_SLV_REMOTE_GPU_ADDRESS                             0x499
#define mmXDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                                      0x472
#define mmSDMA_CHANNEL0_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x472
#define mmSDMA_CHANNEL1_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x47a
#define mmSDMA_CHANNEL2_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x482
#define mmSDMA_CHANNEL3_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x48a
#define mmSDMA_CHANNEL4_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x492
#define mmSDMA_CHANNEL5_XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH                        0x49a
#define mmXDMA_MSTR_PIPE_CNTL                                                   0x400
#define mmMDMA_PIPE0_XDMA_MSTR_PIPE_CNTL                                        0x400
#define mmMDMA_PIPE1_XDMA_MSTR_PIPE_CNTL                                        0x410
#define mmMDMA_PIPE2_XDMA_MSTR_PIPE_CNTL                                        0x420
#define mmMDMA_PIPE3_XDMA_MSTR_PIPE_CNTL                                        0x430
#define mmMDMA_PIPE4_XDMA_MSTR_PIPE_CNTL                                        0x440
#define mmMDMA_PIPE5_XDMA_MSTR_PIPE_CNTL                                        0x450
#define mmXDMA_MSTR_READ_COMMAND                                                0x401
#define mmMDMA_PIPE0_XDMA_MSTR_READ_COMMAND                                     0x401
#define mmMDMA_PIPE1_XDMA_MSTR_READ_COMMAND                                     0x411
#define mmMDMA_PIPE2_XDMA_MSTR_READ_COMMAND                                     0x421
#define mmMDMA_PIPE3_XDMA_MSTR_READ_COMMAND                                     0x431
#define mmMDMA_PIPE4_XDMA_MSTR_READ_COMMAND                                     0x441
#define mmMDMA_PIPE5_XDMA_MSTR_READ_COMMAND                                     0x451
#define mmXDMA_MSTR_CHANNEL_DIM                                                 0x402
#define mmMDMA_PIPE0_XDMA_MSTR_CHANNEL_DIM                                      0x402
#define mmMDMA_PIPE1_XDMA_MSTR_CHANNEL_DIM                                      0x412
#define mmMDMA_PIPE2_XDMA_MSTR_CHANNEL_DIM                                      0x422
#define mmMDMA_PIPE3_XDMA_MSTR_CHANNEL_DIM                                      0x432
#define mmMDMA_PIPE4_XDMA_MSTR_CHANNEL_DIM                                      0x442
#define mmMDMA_PIPE5_XDMA_MSTR_CHANNEL_DIM                                      0x452
#define mmXDMA_MSTR_HEIGHT                                                      0x403
#define mmMDMA_PIPE0_XDMA_MSTR_HEIGHT                                           0x403
#define mmMDMA_PIPE1_XDMA_MSTR_HEIGHT                                           0x413
#define mmMDMA_PIPE2_XDMA_MSTR_HEIGHT                                           0x423
#define mmMDMA_PIPE3_XDMA_MSTR_HEIGHT                                           0x433
#define mmMDMA_PIPE4_XDMA_MSTR_HEIGHT                                           0x443
#define mmMDMA_PIPE5_XDMA_MSTR_HEIGHT                                           0x453
#define mmXDMA_MSTR_REMOTE_SURFACE_BASE                                         0x404
#define mmMDMA_PIPE0_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x404
#define mmMDMA_PIPE1_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x414
#define mmMDMA_PIPE2_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x424
#define mmMDMA_PIPE3_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x434
#define mmMDMA_PIPE4_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x444
#define mmMDMA_PIPE5_XDMA_MSTR_REMOTE_SURFACE_BASE                              0x454
#define mmXDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                                    0x405
#define mmMDMA_PIPE0_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x405
#define mmMDMA_PIPE1_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x415
#define mmMDMA_PIPE2_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x425
#define mmMDMA_PIPE3_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x435
#define mmMDMA_PIPE4_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x445
#define mmMDMA_PIPE5_XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH                         0x455
#define mmXDMA_MSTR_REMOTE_GPU_ADDRESS                                          0x406
#define mmMDMA_PIPE0_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x406
#define mmMDMA_PIPE1_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x416
#define mmMDMA_PIPE2_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x426
#define mmMDMA_PIPE3_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x436
#define mmMDMA_PIPE4_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x446
#define mmMDMA_PIPE5_XDMA_MSTR_REMOTE_GPU_ADDRESS                               0x456
#define mmXDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                                     0x407
#define mmMDMA_PIPE0_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x407
#define mmMDMA_PIPE1_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x417
#define mmMDMA_PIPE2_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x427
#define mmMDMA_PIPE3_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x437
#define mmMDMA_PIPE4_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x447
#define mmMDMA_PIPE5_XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH                          0x457
#define mmXDMA_MSTR_CACHE_BASE_ADDR                                             0x408
#define mmMDMA_PIPE0_XDMA_MSTR_CACHE_BASE_ADDR                                  0x408
#define mmMDMA_PIPE1_XDMA_MSTR_CACHE_BASE_ADDR                                  0x418
#define mmMDMA_PIPE2_XDMA_MSTR_CACHE_BASE_ADDR                                  0x428
#define mmMDMA_PIPE3_XDMA_MSTR_CACHE_BASE_ADDR                                  0x438
#define mmMDMA_PIPE4_XDMA_MSTR_CACHE_BASE_ADDR                                  0x448
#define mmMDMA_PIPE5_XDMA_MSTR_CACHE_BASE_ADDR                                  0x458
#define mmXDMA_MSTR_CACHE_BASE_ADDR_HIGH                                        0x409
#define mmMDMA_PIPE0_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x409
#define mmMDMA_PIPE1_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x419
#define mmMDMA_PIPE2_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x429
#define mmMDMA_PIPE3_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x439
#define mmMDMA_PIPE4_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x449
#define mmMDMA_PIPE5_XDMA_MSTR_CACHE_BASE_ADDR_HIGH                             0x459
#define mmXDMA_MSTR_CACHE_PITCH                                                 0x40a
#define mmMDMA_PIPE0_XDMA_MSTR_CACHE_PITCH                                      0x40a
#define mmMDMA_PIPE1_XDMA_MSTR_CACHE_PITCH                                      0x41a
#define mmMDMA_PIPE2_XDMA_MSTR_CACHE_PITCH                                      0x42a
#define mmMDMA_PIPE3_XDMA_MSTR_CACHE_PITCH                                      0x43a
#define mmMDMA_PIPE4_XDMA_MSTR_CACHE_PITCH                                      0x44a
#define mmMDMA_PIPE5_XDMA_MSTR_CACHE_PITCH                                      0x45a
#define mmXDMA_MSTR_CHANNEL_START                                               0x40b
#define mmMDMA_PIPE0_XDMA_MSTR_CHANNEL_START                                    0x40b
#define mmMDMA_PIPE1_XDMA_MSTR_CHANNEL_START                                    0x41b
#define mmMDMA_PIPE2_XDMA_MSTR_CHANNEL_START                                    0x42b
#define mmMDMA_PIPE3_XDMA_MSTR_CHANNEL_START                                    0x43b
#define mmMDMA_PIPE4_XDMA_MSTR_CHANNEL_START                                    0x44b
#define mmMDMA_PIPE5_XDMA_MSTR_CHANNEL_START                                    0x45b
#define mmXDMA_MSTR_MEM_OVERFLOW_CNTL                                           0x40c
#define mmMDMA_PIPE0_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x40c
#define mmMDMA_PIPE1_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x41c
#define mmMDMA_PIPE2_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x42c
#define mmMDMA_PIPE3_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x43c
#define mmMDMA_PIPE4_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x44c
#define mmMDMA_PIPE5_XDMA_MSTR_MEM_OVERFLOW_CNTL                                0x45c
#define mmXDMA_MSTR_MEM_UNDERFLOW_CNTL                                          0x40d
#define mmMDMA_PIPE0_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x40d
#define mmMDMA_PIPE1_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x41d
#define mmMDMA_PIPE2_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x42d
#define mmMDMA_PIPE3_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x43d
#define mmMDMA_PIPE4_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x44d
#define mmMDMA_PIPE5_XDMA_MSTR_MEM_UNDERFLOW_CNTL                               0x45d
#define mmXDMA_MSTR_PERFMEAS_STATUS                                             0x40e
#define mmMDMA_PIPE0_XDMA_MSTR_PERFMEAS_STATUS                                  0x40e
#define mmMDMA_PIPE1_XDMA_MSTR_PERFMEAS_STATUS                                  0x41e
#define mmMDMA_PIPE2_XDMA_MSTR_PERFMEAS_STATUS                                  0x42e
#define mmMDMA_PIPE3_XDMA_MSTR_PERFMEAS_STATUS                                  0x43e
#define mmMDMA_PIPE4_XDMA_MSTR_PERFMEAS_STATUS                                  0x44e
#define mmMDMA_PIPE5_XDMA_MSTR_PERFMEAS_STATUS                                  0x45e
#define mmXDMA_MSTR_PERFMEAS_CNTL                                               0x40f
#define mmMDMA_PIPE0_XDMA_MSTR_PERFMEAS_CNTL                                    0x40f
#define mmMDMA_PIPE1_XDMA_MSTR_PERFMEAS_CNTL                                    0x41f
#define mmMDMA_PIPE2_XDMA_MSTR_PERFMEAS_CNTL                                    0x42f
#define mmMDMA_PIPE3_XDMA_MSTR_PERFMEAS_CNTL                                    0x43f
#define mmMDMA_PIPE4_XDMA_MSTR_PERFMEAS_CNTL                                    0x44f
#define mmMDMA_PIPE5_XDMA_MSTR_PERFMEAS_CNTL                                    0x45f
#define mmXDMA_MSTR_CNTL                                                        0x3ec
#define mmXDMA_MSTR_STATUS                                                      0x3ed
#define mmXDMA_MSTR_MEM_CLIENT_CONFIG                                           0x3ee
#define mmXDMA_MSTR_LOCAL_SURFACE_BASE_ADDR                                     0x3ef
#define mmXDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_HIGH                                0x3f0
#define mmXDMA_MSTR_LOCAL_SURFACE_PITCH                                         0x3f1
#define mmXDMA_MSTR_CMD_URGENT_CNTL                                             0x3f2
#define mmXDMA_MSTR_MEM_URGENT_CNTL                                             0x3f3
#define mmXDMA_MSTR_MEM_UNDERFLOW_CONFIG                                        0x3f4
#define mmXDMA_MSTR_PCIE_NACK_STATUS                                            0x3f5
#define mmXDMA_MSTR_MEM_NACK_STATUS                                             0x3f6
#define mmXDMA_MSTR_VSYNC_GSL_CHECK                                             0x3f7
#define mmHDP_HOST_PATH_CNTL                                                    0xb00
#define mmHDP_NONSURFACE_BASE                                                   0xb01
#define mmHDP_NONSURFACE_INFO                                                   0xb02
#define mmHDP_NONSURFACE_SIZE                                                   0xb03
#define mmHDP_NONSURF_FLAGS                                                     0xbc9
#define mmHDP_NONSURF_FLAGS_CLR                                                 0xbca
#define mmHDP_SW_SEMAPHORE                                                      0xbcb
#define mmHDP_DEBUG0                                                            0xbcc
#define mmHDP_DEBUG1                                                            0xbcd
#define mmHDP_LAST_SURFACE_HIT                                                  0xbce
#define mmHDP_TILING_CONFIG                                                     0xbcf
#define mmHDP_SC_MULTI_CHIP_CNTL                                                0xbd0
#define mmHDP_OUTSTANDING_REQ                                                   0xbd1
#define mmHDP_ADDR_CONFIG                                                       0xbd2
#define mmHDP_MISC_CNTL                                                         0xbd3
#define mmHDP_MEM_POWER_LS                                                      0xbd4
#define mmHDP_NONSURFACE_PREFETCH                                               0xbd5
#define mmHDP_MEMIO_CNTL                                                        0xbf6
#define mmHDP_MEMIO_ADDR                                                        0xbf7
#define mmHDP_MEMIO_STATUS                                                      0xbf8
#define mmHDP_MEMIO_WR_DATA                                                     0xbf9
#define mmHDP_MEMIO_RD_DATA                                                     0xbfa
#define mmHDP_XDP_DIRECT2HDP_FIRST                                              0xc00
#define mmHDP_XDP_D2H_FLUSH                                                     0xc01
#define mmHDP_XDP_D2H_BAR_UPDATE                                                0xc02
#define mmHDP_XDP_D2H_RSVD_3                                                    0xc03
#define mmHDP_XDP_D2H_RSVD_4                                                    0xc04
#define mmHDP_XDP_D2H_RSVD_5                                                    0xc05
#define mmHDP_XDP_D2H_RSVD_6                                                    0xc06
#define mmHDP_XDP_D2H_RSVD_7                                                    0xc07
#define mmHDP_XDP_D2H_RSVD_8                                                    0xc08
#define mmHDP_XDP_D2H_RSVD_9                                                    0xc09
#define mmHDP_XDP_D2H_RSVD_10                                                   0xc0a
#define mmHDP_XDP_D2H_RSVD_11                                                   0xc0b
#define mmHDP_XDP_D2H_RSVD_12                                                   0xc0c
#define mmHDP_XDP_D2H_RSVD_13                                                   0xc0d
#define mmHDP_XDP_D2H_RSVD_14                                                   0xc0e
#define mmHDP_XDP_D2H_RSVD_15                                                   0xc0f
#define mmHDP_XDP_D2H_RSVD_16                                                   0xc10
#define mmHDP_XDP_D2H_RSVD_17                                                   0xc11
#define mmHDP_XDP_D2H_RSVD_18                                                   0xc12
#define mmHDP_XDP_D2H_RSVD_19                                                   0xc13
#define mmHDP_XDP_D2H_RSVD_20                                                   0xc14
#define mmHDP_XDP_D2H_RSVD_21                                                   0xc15
#define mmHDP_XDP_D2H_RSVD_22                                                   0xc16
#define mmHDP_XDP_D2H_RSVD_23                                                   0xc17
#define mmHDP_XDP_D2H_RSVD_24                                                   0xc18
#define mmHDP_XDP_D2H_RSVD_25                                                   0xc19
#define mmHDP_XDP_D2H_RSVD_26                                                   0xc1a
#define mmHDP_XDP_D2H_RSVD_27                                                   0xc1b
#define mmHDP_XDP_D2H_RSVD_28                                                   0xc1c
#define mmHDP_XDP_D2H_RSVD_29                                                   0xc1d
#define mmHDP_XDP_D2H_RSVD_30                                                   0xc1e
#define mmHDP_XDP_D2H_RSVD_31                                                   0xc1f
#define mmHDP_XDP_D2H_RSVD_32                                                   0xc20
#define mmHDP_XDP_D2H_RSVD_33                                                   0xc21
#define mmHDP_XDP_D2H_RSVD_34                                                   0xc22
#define mmHDP_XDP_DIRECT2HDP_LAST                                               0xc23
#define mmHDP_XDP_P2P_BAR_CFG                                                   0xc24
#define mmHDP_XDP_P2P_MBX_OFFSET                                                0xc25
#define mmHDP_XDP_P2P_MBX_ADDR0                                                 0xc26
#define mmHDP_XDP_P2P_MBX_ADDR1                                                 0xc27
#define mmHDP_XDP_P2P_MBX_ADDR2                                                 0xc28
#define mmHDP_XDP_P2P_MBX_ADDR3                                                 0xc29
#define mmHDP_XDP_P2P_MBX_ADDR4                                                 0xc2a
#define mmHDP_XDP_P2P_MBX_ADDR5                                                 0xc2b
#define mmHDP_XDP_P2P_MBX_ADDR6                                                 0xc2c
#define mmHDP_XDP_HDP_MBX_MC_CFG                                                0xc2d
#define mmHDP_XDP_HDP_MC_CFG                                                    0xc2e
#define mmHDP_XDP_HST_CFG                                                       0xc2f
#define mmHDP_XDP_SID_CFG                                                       0xc30
#define mmHDP_XDP_HDP_IPH_CFG                                                   0xc31
#define mmHDP_XDP_SRBM_CFG                                                      0xc32
#define mmHDP_XDP_CGTT_BLK_CTRL                                                 0xc33
#define mmHDP_XDP_P2P_BAR0                                                      0xc34
#define mmHDP_XDP_P2P_BAR1                                                      0xc35
#define mmHDP_XDP_P2P_BAR2                                                      0xc36
#define mmHDP_XDP_P2P_BAR3                                                      0xc37
#define mmHDP_XDP_P2P_BAR4                                                      0xc38
#define mmHDP_XDP_P2P_BAR5                                                      0xc39
#define mmHDP_XDP_P2P_BAR6                                                      0xc3a
#define mmHDP_XDP_P2P_BAR7                                                      0xc3b
#define mmHDP_XDP_FLUSH_ARMED_STS                                               0xc3c
#define mmHDP_XDP_FLUSH_CNTR0_STS                                               0xc3d
#define mmHDP_XDP_BUSY_STS                                                      0xc3e
#define mmHDP_XDP_STICKY                                                        0xc3f
#define mmHDP_XDP_CHKN                                                          0xc40
#define mmHDP_XDP_DBG_ADDR                                                      0xc41
#define mmHDP_XDP_DBG_DATA                                                      0xc42
#define mmHDP_XDP_DBG_MASK                                                      0xc43
#define mmHDP_XDP_BARS_ADDR_39_36                                               0xc44

#endif /* OSS_2_0_D_H */
