#!/usr/bin/lua

local lm = require("libm")

local fmtf = "%-24s%+2.13f"
local fmti = "%-24s%d"

local function test(s, x)
   print(string.format(fmtf, s, x))
end

local function testb(s, x)
   print(string.format(fmti, s, x and 1 or 0))
end

test("M_E", lm.M_E);
test("M_LOG2E", lm.M_LOG2E)
test("M_LOG10E", lm.M_LOG10E)
test("M_LN2", lm.M_LN2)
test("M_LN10", lm.M_LN10)
test("M_PI", lm.M_PI)
test("M_PI_2", lm.M_PI_2)
test("M_PI_4", lm.M_PI_4)
test("M_1_PI", lm.M_1_PI)
test("M_2_PI", lm.M_2_PI)
test("M_2_SQRTPI", lm.M_2_SQRTPI)
test("M_SQRT2", lm.M_SQRT2)
test("M_SQRT1_2", lm.M_SQRT1_2)

test("cos(M_PI_2)", lm.cos(lm.M_PI_2))
test("acos(cos(M_PI_2))", lm.acos(lm.cos(lm.M_PI_2)))
test("cosh(M_SQRT1_2)", lm.cosh(lm.M_SQRT1_2))
test("acosh(cosh(M_SQRT1_2))", lm.acosh(lm.cosh(lm.M_SQRT1_2)))
test("sin(M_PI_2)", lm.sin(lm.M_PI_2))
test("asin(sin(M_PI_2))", lm.asin(lm.sin(lm.M_PI_2)))
test("sinh(M_PI_2)", lm.sinh(lm.M_PI_2))
test("asinh(sinh(M_PI_2))", lm.asinh(lm.sinh(lm.M_PI_2)))
test("tan(M_SQRT2)", lm.tan(lm.M_SQRT2))
test("atan(tan(M_SQRT2))", lm.atan(lm.tan(lm.M_SQRT2)))
test("tanh(M_SQRT2)", lm.tanh(lm.M_SQRT2))
test("atanh(tanh(M_SQRT2))", lm.atanh(lm.tanh(lm.M_SQRT2)))
test("atan2(M_SQRT2, M_SQRT2)", lm.atan2(lm.M_SQRT2, lm.M_SQRT2))
test("cbrt(8.0)", lm.cbrt(8.0))
test("ceil(M_PI)", lm.ceil(lm.M_PI))
test("ceil(M_E)", lm.ceil(lm.M_E))
test("copysign(-2.0, 10.0)", lm.copysign(-2.0, 10.0))
test("copysign(2.0, -10.0)", lm.copysign(2.0, -10.0))
test("erf(M_SQRT1_2)", lm.erf(lm.M_SQRT1_2))
test("erfc(M_SQRT1_2)", lm.erfc(lm.M_SQRT1_2))
test("exp(M_PI_4)", lm.exp(lm.M_PI_4))
test("exp2(3.0)", lm.exp2(3.0))
test("expm1(M_PI_4)", lm.expm1(lm.M_PI_4))
test("fabs(-M_SQRT2)", lm.fabs(-lm.M_SQRT2))
test("fabs(M_SQRT2)", lm.fabs(lm.M_SQRT2))
test("fdim(M_PI, M_PI_2)", lm.fdim(lm.M_PI, lm.M_PI_2))
test("fdim(M_PI, -M_PI_2)", lm.fdim(lm.M_PI, -lm.M_PI_2))
testb("finite(1.0 / 0.0)", lm.finite(1.0 / 0.0))
test("floor(M_PI)", lm.floor(lm.M_PI))
test("floor(M_E)", lm.floor(lm.M_E))
test("fma(M_PI, M_E, M_SQRT2)", lm.fma(lm.M_PI, lm.M_E, lm.M_SQRT2))
test("fmax(M_PI, M_E)", lm.fmax(lm.M_PI, lm.M_E))
test("fmin(M_PI, M_E)", lm.fmin(lm.M_PI, lm.M_E))
test("fmod(100.5, 10.0)", lm.fmod(100.5, 10.0))
test("gamma(5.0)", lm.gamma(5.0))
test("hypot(3.0, 4.0)", lm.hypot(3.0, 4.0))
print(string.format(fmti, "ilogb(10.0)", lm.ilogb(10.0)))
testb("isinf(1.0 / 0.0)", lm.isinf(1.0 / 0.0))
testb("isnan(log(-1.0))", lm.isnan(lm.log(-1.0)))
test("j0(M_PI)", lm.j0(lm.M_PI))
test("j1(M_PI)", lm.j1(lm.M_PI))
test("jn(3, M_PI)", lm.jn(3, lm.M_PI))
test("lgamma(M_PI)", lm.lgamma(lm.M_PI))
test("log(M_E)", lm.log(lm.M_E))
test("log10(100.0)", lm.log10(100.0))
test("log1p(M_PI)", lm.log1p(lm.M_PI))
test("nan(\"\")", lm.nan(""))
-- XXX vax test("nextafter(1.0e-14, 1.0)", lm.nextafter(1.0e-14, 1.0))
test("pow(M_SQRT2, 2.0)", lm.pow(lm.M_SQRT2, 2.0))
test("remainder(M_PI, M_E)", lm.remainder(lm.M_PI, lm.M_E))
test("rint(M_PI)", lm.rint(lm.M_PI))
test("rint(M_E)", lm.rint(lm.M_E))
print(string.format(fmtf, "scalbn(1.0, 2)", lm.scalbn(1.0, 2)))
test("sin(M_PI_4)", lm.sin(lm.M_PI_4))
test("sinh(M_PI_4)", lm.sinh(lm.M_PI_4))
test("sqrt(9.0)", lm.sqrt(9.0))
test("tan(M_PI_4)", lm.tan(lm.M_PI_4))
test("tanh(M_PI_4)", lm.tanh(lm.M_PI_4))
test("trunc(M_PI)", lm.trunc(lm.M_PI))
test("trunc(M_E)", lm.trunc(lm.M_E))
test("y0(M_PI)", lm.y0(lm.M_PI))
test("y1(M_PI)", lm.y1(lm.M_PI))
test("yn(3, M_PI)", lm.yn(3, lm.M_PI))
