/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
** sqrt in 64 bit precision always
*/

	.align 4
.globl _sqrtpf
_sqrtpf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	fnstcw -12(%ebp) 	   /* store current control word */
	fnstcw -16(%ebp)		   /* store again */
	andw  $0xf0ff, -12(%ebp)	   /* enable 32 bit precision */
	fldcw -12(%ebp)

	flds 8(%ebp)
	fsqrt

	fldcw -16(%ebp)		   /* restore original control word */

	leave
	ret
