/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
** This file started life as a C program but has been massively hacked.
**
** The coefficients are from Hart, et.al. via Berkeley
**
*/

.data
	.align 4
p0:
	.double 0d-6.30767364049771680000e+05
	.align 4
p1:
	.double 0d-8.99127202203950870000e+04
	.align 4
p2:
	.double 0d-2.89421135598956380000e+03
	.align 4
p3:
	.double 0d-2.63056321339749710000e+01
	.align 4
q0:
	.double 0d-6.30767364049771680000e+05
	.align 4
q1:
	.double 0d1.52151737879001900000e+04
	.align 4
q2:
	.double 0d-1.73678953558233700000e+02

.text
	.align 4
.LC0:
	.double 0d2.10000000000000000000e+01
	.align 4
.LC1:
	.double 0d5.00000000000000000000e-01

	.align 4
.globl _sinh

_sinh:
	pushl %ebp
	movl %esp,%ebp
	subl $72,%esp
	fldl 8(%ebp)
	fstpl -8(%ebp)
	movl $1,%edx
	fldl -8(%ebp)
	ftst
	fstp %st(0)
	fnstsw %ax
	sahf
	jae .L2
	fldl -8(%ebp)
	fchs
	fstpl -8(%ebp)
	movl $-1,%edx
.L2:
	fldl .LC0
	fldl -8(%ebp)
	fcompp
	fnstsw %ax
	sahf
	jbe .L3
	fldl -8(%ebp)
	fldl2e
	fmulp
	fstl %st(1)
	frndint
	fstl %st(2)
	fsubrp
	f2xm1
	fld1
	faddp
	fscale
	fldl .LC1
	fmulp
	testl %edx,%edx
	jg .L7
	fchs
.L7:
	leave
	ret
.L3:
	fldl .LC1
	fldl -8(%ebp)
	fcompp
	fnstsw %ax
	sahf
	jbe .L6
	fldl 8(%ebp)
	fldl2e
	fmulp
	fstl %st(1)
	frndint
	fstl %st(2)
	fsubrp
	f2xm1
	fld1
	faddp
	fscale
	fst %st(1)
	fld1
	fdivp
	fsubrp
	fldl .LC1
	fmulp
	leave
	ret
.L6:
	fldl -8(%ebp)
	fmull -8(%ebp)
	fstl -16(%ebp)
	fmull p3
	faddl p2
	fmull -16(%ebp)
	faddl p1
	fmull -16(%ebp)
	faddl p0
	fmull -8(%ebp)
	fstpl -72(%ebp)
	fldl -16(%ebp)
	faddl q2
	fmull -16(%ebp)
	faddl q1
	fmull -16(%ebp)
	faddl q0
	fstpl -56(%ebp)
	fldl -72(%ebp)
	fdivl -56(%ebp)
	pushl %edx
	fildl (%esp)
	addl $4,%esp
	fstpl -64(%ebp)
	fmull -64(%ebp)
	leal -76(%ebp),%esp
	leave
	ret
