/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

#include <stdio.h>

extern short _getsw();

ieee_retrospective(f)
FILE *f;
{
	short status;

	if (f == (FILE *)NULL)
		f = stderr;

	status = _getsw();

	if (status & 0xdf) {
		fprintf(f,"\n");
		fprintf(f,"Warning: the following IEEE floating-point");
		fprintf(f," arithmetic exceptions\n");
		fprintf(f,"occurred in this program and were never cleared:\n");
		if (status & 0x0001) fprintf(f,"Invalid Operation;\n");
		if (status & 0x0002) fprintf(f,"Denormal;\n");
		if (status & 0x0004) fprintf(f,"Division by Zero;\n");
		if (status & 0x0008) fprintf(f,"Overflow;\n");
		if (status & 0x0010) fprintf(f,"Underflow;\n");
		fprintf(f,"\n");
	}
}
