/*
** This file is covered by the GNU General Public Licence
** 
** This file should be installed somewhere in your standard include
** search path and given the name fpumath.h.
*/

/*
** This is a good way of flagging whether 
** you are using the alternate stuff
*/
#ifndef	__FPUMATH_H
#define	__FPUMATH_H

#define __FPU__


#if defined(__GNUC__) || defined(__STDC__)

extern double j0(double), j1(double), jn(int,double), y0(double), y1(double);
extern double yn(int,double);
extern double erf(double), erfc(double), erfcx(double);
extern double exp(double), log(double), log10(double), pow(double,double);
extern double sqrt(double);
extern double expm1(double), log1p(double), exp10(double);
extern double exp2(double), log2(double);
extern double floor(double), ceil(double), fabs(double);
extern double lgamma(double), gamma(double);
extern double sinh(double), cosh(double), tanh(double);
extern double asinh(double), acosh(double), atanh(double);
extern double sin(double), cos(double), tan(double), asin(double);
extern double acos(double), atan(double), atan2(double,double);
extern double hypot(double,double);
extern double sqrtp(double);

#else

extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double erf(), erfc(), erfcx();
extern double exp(), log(), log10(), pow(), sqrt();
extern double expm1(), log1p(), exp10();
extern double exp2(), log2();
extern double floor(), ceil(), fabs();
extern double lgamma(), gamma();
extern double sinh(), cosh(), tanh();
extern double asinh(), acosh(), atanh();
extern double sin(), cos(), tan(), asin();
extern double acos(), atan(), atan2(), hypot();
extern double sqrtp();

#endif

/*
** IEEE functions
*/

#if defined(__GNUC__) || defined(__STDC__)

extern double rint(double), drem(double,double), scalb(double,int);
extern double logb(double), copysign(double,double);
extern double infinity(void), nextafter(double,double);
extern int isnan(double), iszero(double), isinf(double), isnormal(double);
extern int issubnormal(double);
extern int signbit(double), finite(double);
extern double max_normal(void), min_normal(void), min_subnormal(void);
extern double max_subnormal(void);
extern double quiet_nan(long int),signaling_nan(long int);

#else

extern double rint(), drem(), scalb(), logb(), copysign();
extern double infinity(), nextafter();
extern int isnan(), iszero(), isinf(), isnormal(), issubnormal();
extern int signbit(), finite();
extern double max_normal(), min_normal(), min_subnormal(), max_subnormal();
extern double quiet_nan(),signaling_nan();

#endif

/*
** Float versions
*/
#if defined(__GNUC__) || defined(__STDC__)

extern float j0f(float), j1f(float), jnf(int,float), y0f(float);
extern float y1f(float), ynf(int,float);
extern float erff(float), erfcf(float), erfcxf(float), sqrtf(float);
extern float expf(float), logf(float), log10f(float), powf(float, float);
extern float expm1f(float), log1pf(float), exp10f(float);
extern float exp2f(float), log2f(float);
extern float floorf(float), ceilf(float), fabsf(float);
extern float lgammaf(float), gammaf(float);
extern float sinhf(float), coshf(float), tanhf(float);
extern float asinhf(float), acoshf(float), atanhf(float);
extern float sinf(float), cosf(float), tanf(float), asinf(float);
extern float acosf(float), atanf(float), atan2f(float, float);
extern float hypotf(float, float);
extern float sqrtpf(float);

extern float rintf(float), dremf(float), scalbf(float, int);
extern float logbf(float), copysignf(float, float);
extern float infinityf(void), nextafterf(float, float);
extern int isnanf(float), iszerof(float), isinff(float);
extern int isnormalf(float), issubnormalf(float);
extern int signbitf(float), finitef(float);
extern float max_normalf(void), min_normalf(void);
extern float min_subnormalf(void), max_subnormalf(void);
extern float quiet_nanf(long int), signaling_nanf(long int);

#endif

/*
** Extensions
*/

#if defined(__GNUC__) || defined(__STDC__)

extern int setinternal(void), setcont(int);

#else

extern int setinternal(), setcont();

#endif

/*
** The argument of ieee_retrospective is a FILE * 
** but we don't want to include stdio.h.
*/

extern void ieee_retrospective();

/*
** Useful defines for setcont
*/

#define MASK_ALL0 0x107f	/* single precision */
#define MASK_ALL 0x127f		/* double precision */
#define MASK_ALL1 0x137f 	/* extra precision */

#define __infinity infinity

#define M_E	2.7182818284590452354
#define M_LOG2E	1.4426950408889634074
#define M_LOG10E	0.43429448190325182765
#define M_LN2	0.69314718055994530942
#define M_LN10	2.30258509299404568402
#define M_PI	3.14159265358979323846
#define M_PI_2	1.57079632679489661923
#define M_PI_4	0.78539816339744830962
#define M_1_PI	0.31830988618379067154
#define M_2_PI	0.63661977236758134308
#define M_2_SQRTPI	1.12837916709551257390
#define M_SQRT2	1.41421356237309504880
#define M_SQRT1_2	0.70710678118654752440

#ifndef IEEE
#define MAXFLOAT	((float)3.40282346638528860e+38)
#define	MINFLOAT	((float)1.40129846432481707e-45)
#else
#define	MAXFLOAT	(max_normalf())
#define	MINFLOAT	(min_subnormalf())
#endif

#ifndef IEEE
#define	MAXDOUBLE	1.79769313486231570e+308  /* wrong in math.h */
#define	MINDOUBLE	4.94065645841246544e-324
#else
#define	MAXDOUBLE	(max_normal())
#define	MINDOUBLE	(min_subnormal())
#endif

#define ULP		1.1102230246251565e-16
#define ULPF		5.9604644775390625e-08

#define	HUGE_VAL	MAXFLOAT

#ifdef IEEE
#define HUGE	(__infinity())
#else
#define HUGE 	MAXDOUBLE
#endif

#endif
