/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.Lpi:
	.double 3.14159265358979323846

	.align 4
.Lmpi:
	.double -3.14159265358979323846

	.align 4
.Lhalfpi: 
	.double 1.57079632679489661923

	.align 4
.Lmhalfpi:
	.double -1.57079632679489661923

	.align 4
.globl _atan2
_atan2:
	pushl %ebp
	movl %esp,%ebp

	fldl 16(%ebp)
	ftst
	fnstsw %ax
	sahf 
	fldl 8(%ebp)
	jz .Lgotzero
	jc .Lgotneg

	fdivp
	fld1
	fpatan

	leave
	ret

.Lgotneg:
	ftst
	fnstsw %ax
	sahf 
	jc .Lneg1

	fdivp
	fld1
	fpatan
	fldl .Lmpi
	fsubrp

	leave
	ret

.Lneg1:
	fdivp
	fld1
	fpatan
	fldl .Lpi
	fsubrp

	leave
	ret

.Lgotzero:
	ftst
	fnstsw %ax
	sahf
	ffree %st(0)
	ffree %st(1)
	jz .Lzero
	jc .Lneg

	fldl .Lhalfpi

	leave
	ret

.Lzero:
	fldz

	leave
	ret

.Lneg:
	fldl .Lmhalfpi

	leave
	ret

