
//
//	convsh2ml		A sound converter
//
//		Ver. 1.1
//
//	v1.0 1991/3/18
//	v1.1 1991/4/11	does not use SNDConvertSound
//
//	HiroshiMomose
//		Zoology, UCD, Davis, CA 95616   hmomose@ucdavis.edu
//
//	To compile, type : cc -O -g -o convsh2ml convsh2ml.c -lsys_s
//

#define title ("convsh2ml.c - converts a 44.1 kHz stereo 16 bit linear .snd file to 22kHz mono")
#define pname	"convsh2ml"

#import <sound/sound.h>
#import <stdio.h>

#define MONO	1
#define STEREO	2

check_error(int err)
{
    if (err) {
	fprintf(stderr, "Error(%s): %s\n",pname, SNDSoundError(err));
	exit(1);
    }
    return err;
}

main (int argc, char *argv[])
{

	int			i, size, width, temp, nsamples;
	int			datasize, dataformat, samplingrate, channelcount, info;
	char		channel = 'L';
	short int	ldata1, rdata1, ldata2, rdata2;
	int			tempdata;
	char		*p;
	short int	*ip;
	SNDSoundStruct	*infile;	// input sound file
	SNDSoundStruct header = {
		SND_MAGIC, 0, 0, SND_FORMAT_LINEAR_16, (int)SND_RATE_LOW, 2, "" };
	FILE		*outfile;		// for output, we don't.


	// ========== Check command line flag
	if ( argc == 4 )
		channel = toupper( argv[1][0] );
	if ( ( channel != 'L') && ( channel != 'R' ) ) {
		fprintf( stderr, "Error(%s): wrong channel %c (must be L or R)\n", pname, channel );
		exit( -1 );
	}	
	if( argc < 4 ) {
		fprintf( stderr, "%s\n\n", title );
		fprintf( stderr, "Usage : %s channel infile outfile\n\n\t", pname );
		fprintf( stderr, "channel must be either L or R (case does not matter)\n\t" );
		fprintf( stderr, "infile must be a 44kHz 16bit linear stereo .snd file\n\t" );
		fprintf( stderr, "outfile will be a 16bit linear monaural .snd file\n\t" );
		fprintf( stderr, "Doesn't check if outfile already exists. So be careful.\n\n" );
		fprintf( stderr, "Sample operation : %s L stereo.snd mono.snd\n", pname );
		exit( -1 );
	}    

	// ========== Open input file
	check_error( SNDReadSoundfile( argv[2], &infile ));

	// ========== open output file
	if (( outfile = fopen ( argv[3], "wb" )) == 0 ) {
		fprintf( stderr, "Error(%s): Can't open input file : %s\n", pname, argv[1] );
		exit( -1 );
	}

	// ========== Read input file header
	check_error( SNDGetDataPointer( infile, &p, &size, &width ));
	dataformat		= infile->dataFormat;
	channelcount	= infile->channelCount;
	dataformat		= infile->dataFormat;
	datasize		= infile->dataSize;
	samplingrate	= infile->samplingRate;
	channelcount	= infile->channelCount;
	nsamples		= SNDSampleCount( infile );		// no. of data samples

	datasize /= 2;		// Size of the sound data will be half

	// ========== Check file format
	if( channelcount != STEREO ) {
		fprintf( stderr, "Error(%s): Input file %s is not stereo\n", pname, argv[1] );
		exit( -1 );
	}	
	if( dataformat != SND_FORMAT_LINEAR_16 ) {
		fprintf( stderr, "Error(%s): Input file %s is not 16bit linear\n", pname, argv[1] );
		exit( -1 );
	}	

	// ========== Write output file header	
	temp = SND_MAGIC;			fwrite( &temp, 4, 1, outfile );
	temp = 28;					fwrite( &temp, 4, 1, outfile );	// start point of sound data
	temp = datasize;			fwrite( &temp, 4, 1, outfile );	// no. of bytes in sound data
	temp = dataformat;			fwrite( &temp, 4, 1, outfile );
	temp = (int)SND_RATE_LOW;	fwrite( &temp, 4, 1, outfile );
	temp = MONO;				fwrite( &temp, 4, 1, outfile );	// channel count
	temp = 0x00000000;  		fwrite( &temp, 4, 1, outfile );	// info. string

	// ========== Write output sound data	

	ip = (short int *)p;
	
	nsamples /= 2;				// since we are reading 2 samples in each loop
	if ( channel == 'L' ) {
		while ( nsamples-- > 0 ) {
			ldata1 = ( *(ip++) );
			rdata1 = ( *(ip++) );
			ldata2 = ( *(ip++) );
			rdata2 = ( *(ip++) );
			tempdata = ((int) ( ldata1 + ldata2 ) ) / 2;
			ldata2 = (short int)tempdata;
			fwrite ( &ldata2, 2, 1, outfile );
		}
	} else {
		while ( nsamples-- > 0 ) {
			ldata1 = ( *(ip++) );
			rdata1 = ( *(ip++) );
			ldata2 = ( *(ip++) );
			rdata2 = ( *(ip++) );
			tempdata = ((int) ( rdata1 + rdata2 ) ) / 2;
			rdata2 = (short int)tempdata;
			fwrite ( &rdata2, 2, 1, outfile );
		}
	}
	SNDFree( infile );
	fclose( outfile );
	exit( 0 );
}


