//
//	convh2l	-	A sound converter
//
//	convh2l takes a snd file as input and writes a 22kHz
//	stereo 16 bit linear soundfile
//
//		Ver. 1.0
//
//	v1.0 1991/3/18
//
//	HiroshiMomose
//		Zoology, UCD, Davis, CA 95616   hmomose@ucdavis.edu
//
//	To compile, type : cc -O -g -o convh2l convh2l.c -lsys_s
//
//	This program is mostly based on converttest.c
//	found in /Nextdeveloper/Examples/Sound

#define pname  "convh2l"
#define title ("convh2l.c - converts a .snd file to 22kHz stereo 16 bit linear")

#import <sound/sound.h>
#import <stdio.h>

check_error(int err)
{
    if (err) {
	fprintf(stderr, "Error : %s\n",SNDSoundError(err));
	exit(1);
    }
    return err;
}

main (int argc, char *argv[])
{
    SNDSoundStruct *s1, *s2;
    SNDSoundStruct header = {
	SND_MAGIC, 0, 0, SND_FORMAT_LINEAR_16, (int)SND_RATE_LOW, 2, "" };

    if( argc != 3 ) {
		fprintf( stderr, "%s\n\n", title );
		fprintf( stderr, "Usage : %s infile outfile\n\n\t", pname );
		fprintf( stderr, "infile must be a .snd file\n\t" );
		fprintf( stderr, "outfile will be a 22kHz 16bit linear stereo .snd file\n\t" );
		fprintf( stderr, "Doesn't check if outfile already exists. So be careful.\n\n" );
		fprintf( stderr, "Sample operation : %s in.snd out.snd\n", pname );
		exit( -1 );
	}    
    check_error(SNDReadSoundfile(argv[1],&s1));
    s2 = &header;
    check_error(SNDConvertSound(s1,&s2));
    check_error(SNDWriteSoundfile(argv[2],s2));
    exit(0);
}


