#ifndef NOICP
/* Includes */
 
#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckuusr.h"
#include "ckcxla.h"
#include "ckcnet.h"			/* Network symbols */
 
#ifdef datageneral
#define fgets(stringbuf,max,fd) dg_fgets(stringbuf,max,fd)
#endif /* datageneral */

/* External Kermit Variables, see ckmain.c for description. */
 
extern int size, rpsiz, urpsiz, local, rmailf, stdinf, sndsrc, xitsta,
  server, displa, binary, parity, escape, xargc, flow,
  turn, duplex, nfils, ckxech, pktlog, seslog, tralog, stdouf,
  turnch, dfloc, keep, maxrps, warn, quiet, cnflg, tlevel, pflag,
  mdmtyp, zincnt, fblksiz, frecl, frecfm, atcapr, atdiso, verwho;
 
extern long vernum, speed;
extern char *versio, *protv, *ckxv, *ckzv, *fnsv, *connv, *dftty, *cmdv;
extern char *dialv, *loginv, *for_def[], *whil_def[], *xif_def[];
extern char *ckxsys, *ckzsys, *cmarg, *cmarg2, **xargv, **cmlist;
extern char *DIRCMD, *PWDCMD, *DELCMD, *WHOCMD, optbuf[], ttname[], filnam[];
extern CHAR sstate;
extern CHAR *zinptr;

#ifndef NOMSEND				/* Multiple SEND */
extern char *msfiles[];
#endif /* NOMSEND */
extern char fspec[];			/* Most recent filespec */

#ifndef NOCSETS
extern int tcharset, fcharset, nfilc;
extern struct csinfo fcsinfo[], tcsinfo[];
extern struct keytab fcstab[];
#endif /* NOCSETS */

char *homdir;			/* Pointer to home directory string */
int rcflag = 0;			/* Flag for alternate init file name */

#ifndef NOXMIT
/* Variables for TRANSMIT command */

int xmitx = 1;			/* Whether to echo during TRANSMIT */
int xmitf = 0;			/* Character to fill empty lines */
int xmitl = 0;			/* 1 = Send linefeeds too */
int xmitp = LF;			/* Host line prompt */
#endif /* NOXMIT */

/* Declarations from cmd package */
 
extern char cmdbuf[], atmbuf[]; /* Command buffers */
#ifndef NOSPL
extern char savbuf[]; /* Command buffers */
#endif /* NOSPL */

/* Declarations from ck?fio.c module */
 
extern char *SPACMD;			/* Space command, home directory. */
extern int backgrd, bgset;		/* Kermit executing in background */
#ifdef OS2
extern char *zfindfile();
#endif /* OS2 */
 
/* Variables and symbols local to this module */
 
extern char line[];			/* Character buffer for anything */
char *lp;				/* Pointer to line buffer */
#ifndef NOSPL
extern char inpbuf[];			/* Buffer for INPUT and REINPUT */
char *inpbp = inpbuf;			/* And pointer to same */
extern char vnambuf[];			/* Buffer for variable names */
extern char *vnp;			/* Pointer to same */
extern char lblbuf[];			/* Buffer for labels */
#endif /* NOSPL */

char psave[80] = { NUL };		/* For saving & restoring prompt */

#ifdef DEBUG
extern char debfil[];			/* Debugging log file name */
#endif /* DEBUG */
extern char pktfil[];			/* Packet log file name */
extern char sesfil[];			/* Session log file name */
#ifdef TLOG
extern char trafil[];			/* Transaction log file name */
#endif /* TLOG */
extern char tmpbuf[];			/* Temporary buffer */
char *tp;				/* Temporary pointer */
 
extern int action, cflg;		/* Command-line connect cmd given */

extern int fblksiz, frecl, frecfm, forg, fcctrl; /* VMS file things */

int repars,				/* Reparse needed */
    techo = 0,				/* Take echo */
    terror = 0;				/* Take error action, 1 = quit */

extern int en_cwd, en_del, en_dir, en_fin, /* Flags for ENABLE/DISABLE */
   en_get, en_hos, en_sen, en_set, en_spa, en_typ, en_who, en_bye;

extern int success;			/* Command success/failure flag */

#ifndef NOSPL
int					/* SET INPUT parameters. */
  indef = 5,				/* 5 seconds default timeout */
  intime = 0,				/* 0 = proceed */
  incase = 0,				/* 0 = ignore */
  inecho = 1;				/* 1 = echo on */
 
int maclvl = -1;			/* Macro to execute */
extern char *macx[];			/* Index of current macro */
extern char *mrval[];			/* Macro return value */
int mecho = 0;				/* Macro echo */
int merror = 0;				/* Macro error action */
extern char *macp[];			/* Pointer to macro */
char varnam[6];				/* For variable names */
extern int macargc[];			/* ARGC from macro invocation */

extern char *m_arg[MACLEVEL][NARGS];	/* Stack of macro arguments */
extern char *g_var[];			/* Global variables %a, %b, etc */
 
extern char **a_ptr[];			/* Array pointers */
extern int a_dim[];			/* Array dimensions */

extern struct cmdptr cmdstk[];		/* The command stack itself */
extern int cmdlvl;			/* Current position in command stack */
#endif /* NOSPL */

static int x, y, z = 0;			/* Local workers */
static char *s;

#define xsystem(s) zsyscmd(s)

/* Top-Level Interactive Command Keyword Table */
 
struct keytab cmdtab[] = {
    "!",	   XXSHE, 0,		/* shell escape */
    "#",    	   XXCOM, CM_INV,	/* comment */
#ifndef NOSPL
    ":",           XXLBL, CM_INV,	/* label */
#endif /* NOSPL */
    "@",           XXSHE, CM_INV,	/* DCL escape */
#ifndef NOSPL
    "asg",         XXASS, CM_INV,       /* invisible synonym for assign */
    "ask",         XXASK, 0,		/* ask */
    "askq",        XXASKQ,0,            /* ask quietly */
    "assign",      XXASS, 0,            /* assign */
#endif /* NOSPL */
    "bug",         XXBUG, 0,		/* bug report instructions */
    "bye",         XXBYE, 0,		/* bye to remote server */
    "c",           XXCON, CM_INV|CM_ABR, /* invisible synonym for connect */
#ifndef NOFRILLS
    "cat",         XXTYP, CM_INV,	/* display a local file */
#endif /* NOFRILLS */
    "cd",          XXCWD, 0,		/* change directory */
#ifndef NOFRILLS
    "clear",       XXCLE, 0,		/* clear input buffer */
#endif /* NOFRILLS */
    "close",	   XXCLO, 0,		/* close a log file */
    "comment",     XXCOM, 0,		/* comment */
    "connect",     XXCON, 0,		/* connect to remote system */
    "cwd",	   XXCWD, CM_INV,	/* invisisble synonym for cd */
#ifndef NOSPL
    "dcl",         XXDCL, CM_INV,	/* declare an array */
    "declare",     XXDCL, 0,		/* declare an array */
    "decrement",   XXDEC, 0,		/* decrement a numeric variable */
    "define",      XXDEF, 0,		/* define a macro */
#endif /* NOSPL */
#ifndef NOFRILLS
    "delete",      XXDEL, 0,		/* delete a file */
#endif /* NOFRILLS */
#ifndef NODIAL
    "dial",	   XXDIAL,0,		/* dial a phone number */
#endif /* NODIAL */
    "directory",   XXDIR, 0,		/* directory of files */
    "disable",     XXDIS, 0,		/* disable server function */
#ifndef NOSPL
    "do",          XXDO,  0,		/* execute a macro */
#endif /* NOSPL */
    "echo",        XXECH, 0,		/* echo argument */
#ifndef NOSPL
    "else",        XXELS, CM_INV,	/* ELSE part of IF statement */
#endif /* NOSPL */
    "enable",      XXENA, 0,		/* enable a server function */
#ifndef NOSPL
    "end",         XXEND, 0,		/* END command file or macro */
#endif /* NOSPL */
#ifndef NOFRILLS
#ifdef COMMENT
/* The ERROR command is badly broken.  Uncomment it when it's fixed! */
    "error",       XXERR, 0,		/* Send an Error packet */
#endif /* COMMENT */
#endif /* NOFRILLS */
    "exit",	   XXEXI, 0,		/* exit the program */
    "finish",      XXFIN, 0,		/* FINISH */
#ifndef NOSPL
    "for",         XXFOR, 0,		/* FOR loop */
#endif /* NOSPL */
    "get",         XXGET, 0,		/* GET */
#ifndef NOSPL
    "goto",        XXGOTO,0,		/* goto label in take file or macro */
#endif /* NOSPL */
    "hangup",      XXHAN, 0,		/* hangup dialed phone connection */
    "help",	   XXHLP, 0,		/* display help text */
#ifndef NOSPL
    "i",           XXINP, CM_INV|CM_ABR, /* invisible synonym for INPUT */
    "if",          XXIF,  0,		/* if (condition) command */
    "in",          XXINP, CM_INV|CM_ABR, /* invisible synonym for INPUT */
    "increment",   XXINC, 0,		/* increment a numeric variable */
    "input",       XXINP, 0,		/* input string from comm line */
#endif /* NOSPL */
    "l",           XXLOG, CM_INV|CM_ABR,/* invisible synonym for log */
    "log",  	   XXLOG, 0,		/* open a log file */
#ifndef NOFRILLS
    "ls",          XXDIR, CM_INV,	/* invisible synonym for directory */
    "mail",        XXMAI, 0,		/* mail file to user */
    "man",         XXHLP, CM_INV,       /* Synonym for help */
#endif /* NOFRILLS */
#ifndef NOMSEND
    "msend",       XXMSE, 0,		/* Multiple SEND */
#endif /* NOMSEND */
#ifndef NOFRILLS
    "mv",          XXREN, CM_INV,	/* rename a local file */
#endif /* NOFRILLS */
#ifndef NOSPL
    "open",        XXOPE, 0,		/* open file for reading or writing */
    "output",      XXOUT, 0,		/* output string to comm line */
#endif /* NOSPL */
#ifdef SUNX25
    "pad",         XXPAD, 0,            /* PAD commands */
#endif /* SUNX25 */
#ifndef NOSPL
    "pause",       XXPAU, 0,		/* sleep for specified interval */
    "pop",         XXEND, CM_INV,	/* allow POP as synonym for END */
#endif /* NOSPL */
    "push",        XXSHE, 0,		/* PUSH command (like RUN, !) */
    "pwd",         XXPWD, 0,            /* print working directory */
    "quit",	   XXQUI, 0,		/* quit from program = exit */
    "r",           XXREC, CM_INV,	/* invisible synonym for receive */
#ifndef NOSPL
    "read",        XXREA, 0,            /* read */
#endif /* NOSPL */
    "receive",	   XXREC, 0,		/* receive files */
#ifndef NODIAL
    "redial",      XXRED, 0,		/* redial */
#endif /* NODIAL */
#ifndef NOSPL
    "reinput",     XXREI, 0,            /* reinput */
#endif /* NOSPL */
    "remote",	   XXREM, 0,		/* send generic command to server */
#ifndef NOFRILLS
    "rename",      XXREN, 0,		/* rename a local file */
    "replay",      XXTYP, CM_INV,	/* replay (for now, just type) */
#endif /* NOFRILLS */
#ifndef NOSPL
    "return",      XXRET, 0,		/* return from function */
#endif /* NOSPL */
#ifndef NOFRILLS
    "rm",          XXDEL, CM_INV,	/* invisible synonym for delete */
#endif /* NOFRILLS */
    "run",         XXSHE, 0,		/* run a program or command */
    "s",           XXSEN, CM_INV|CM_ABR, /* invisible synonym for send */
#ifndef NOSCRIPT
    "script",	   XXLOGI,0,		/* execute a uucp-style script */
#endif
    "send",	   XXSEN, 0,		/* send files */
    "server",	   XXSER, 0,		/* be a server */
    "set",	   XXSET, 0,		/* set parameters */
    "show", 	   XXSHO, 0,		/* show parameters */
#ifndef NOFRILLS
    "sleep",       XXPAU, CM_INV,	/* sleep for specified interval */
#endif /* NOFRILLS */
    "space",       XXSPA, 0,		/* show available disk space */
    "spawn",       XXSHE, CM_INV,	/* synonym for PUSH, RUN */
    "statistics",  XXSTA, 0,		/* display file transfer stats */
#ifndef NOSPL
    "stop",        XXSTO, 0,		/* stop all take files */
#endif /* NOSPL */
    "suspend",     XXSUS, 0,		/* Suspend */
    "take",	   XXTAK, 0,		/* take commands from file */
#ifndef NOFRILLS
    "test",        XXTES, CM_INV,	/* (for testing) */
#endif /* NOFRILLS */
#ifndef NOCSETS
    "translate",   XXXLA, 0,		/* translate local file char sets */
#endif
#ifndef NOXMIT
    "transmit",    XXTRA, 0,		/* raw upload file */
#endif /* NOXMIT */
#ifndef NOFRILLS
    "type",        XXTYP, 0,		/* display a local file */
#endif /* NOFRILLS */
    "version",     XXVER, 0,		/* version number display */
#ifndef NOSPL
    "wait",        XXWAI, 0,		/* wait (like pause) */
    "while",       XXWHI, 0,		/* while */
#endif /* NOSPL */
#ifndef NOFRILLS
    "who",         XXWHO, 0,		/* who */
    "write",       XXWRI, 0,		/* write */
#endif /* NOFRILLS */
#ifndef NOSPL
    "xif",         XXIFX, 0,		/* Extended IF */
#endif /* NOSPL */
#ifndef NOCSETS
    "xlate",       XXXLA, CM_INV,	/* translate local file char sets */
#endif
#ifndef NOXMIT
    "xmit",        XXTRA, CM_INV,	/* raw upload file */
#endif /* NOXMIT */
    "z",           XXSUS, CM_INV	/* Suspend */
#ifndef NOSPL
   ,"_getargs",    XXGTA, CM_INV,       /* used internally by FOR, etc */
    "_putargs",    XXPTA, CM_INV        /* used internally by FOR, etc */
#endif /* NOSPL */
};
int ncmd = (sizeof(cmdtab) / sizeof(struct keytab));

char toktab[] = {
    '!',				/* Shell escape */
    '#',				/* Comment */
    ';',				/* Comment */
#ifndef NOSPL
    ':',				/* Label */
#endif /* NOSPL */
    '@',				/* DCL escape */
    '\0'				/* End of this string */
};

/* Parameter keyword table */
 
struct keytab prmtab[] = {
    "attributes",       XYATTR,  0,
    "background",       XYBACK,  0,
    "baud",	        XYSPEE,  CM_INV,
    "block-check",  	XYCHKT,  0,
#ifdef DYNAMIC
    "buffers",          XYBUF,   0,
#endif /* DYNAMIC */
    "carrier",          XYCARR,  0,
#ifndef NOSPL
    "case",             XYCASE,  0,
#endif /* NOSPL */
    "command",          XYCMD,   0,
#ifndef NOSPL
    "count",            XYCOUN,  0,
#endif /* NOSPL */
    "debug",            XYDEBU,  CM_INV,
#ifdef VMS
    "default",          XYDFLT,  0,
#else
    "default",          XYDFLT,  CM_INV,
#endif /* VMS */
    "delay",	    	XYDELA,  0,
#ifndef NODIAL
    "dial",             XYDIAL,  0,
#endif /* NODIAL */
    "duplex",	    	XYDUPL,  0,
    "escape-character", XYESC,   0,
    "file", 	  	XYFILE,  0,
    "flow-control", 	XYFLOW,  0,
    "handshake",    	XYHAND,  0,
#ifdef NETCONN
    "host",             XYHOST,  0,
#endif /* NETCONN */
    "incomplete",   	XYIFD,   0,
#ifndef NOSPL
    "input",            XYINPU,  0,
#endif /* NOSPL */
    "l",                XYLINE,  CM_INV|CM_ABR,
#ifndef NOCSETS
    "language",         XYLANG,  0,
#endif /* NOCSETS */
    "line",             XYLINE,  0,
#ifndef NOSPL
    "macro",            XYMACR,  0,
#endif /* NOSPL */
#ifndef NODIAL
    "modem-dialer",	XYMODM,	 0,
#endif
#ifdef NETCONN
    "network",          XYNET,   CM_INV,
#endif /* NETCONN */
#ifdef COMMENT
    "packet-length",    XYLEN,   CM_INV, /* moved to send/receive */
#endif
#ifdef SUNX25
    "pad",              XYPAD,   0,
#endif /* SUNX25 */
    "parity",	    	XYPARI,  0,
    "port",             XYLINE,  CM_INV,
    "prompt",	    	XYPROM,  0,
    "receive",          XYRECV,  0,
    "retry",            XYRETR,  0,
    "send",             XYSEND,  0,
    "server",           XYSERV,  0,
#ifdef UNIX
    "session-log",      XYSESS,  0,
#endif /* UNIX */
    "speed",	        XYSPEE,  0,
#ifdef UNIX
    "suspend",          XYSUSP,  0,
#endif /* UNIX */
    "take",             XYTAKE,  0,
    "terminal",         XYTERM,  0,
#ifndef NOCSETS
    "transfer",         XYXFER,  0,
#endif /* NOCSETS */
#ifndef NOXMIT
    "transmit",         XYXMIT,  0,
#endif /* NOXMIT */
    "unknown-char-set", XYUNCS,  0,
    "window-size",      XYWIND,  0,
#ifdef UNIX
    "wildcard-expansion", XYWILD, 0,
#endif /* UNIX */
#ifdef SUNX25
    "x.25",             XYX25,   0,
#endif /* SUNX25 */
#ifndef NOCSETS
    "xfer",             XYXFER,  CM_INV,
#endif /* NOCSETS */
#ifndef NOXMIT
    "xmit",             XYXMIT,  CM_INV
#endif /* NOXMIT */
};
int nprm = (sizeof(prmtab) / sizeof(struct keytab)); /* How many parameters */
 
/* Table of networks */
#ifdef NETCONN
struct keytab netcmd[] = {
/*  "decnet",        NET_DEC,  0, */
    "tcp/ip",        NET_TCPB, 0
/*  "stream-tcp-ip", NET_TCPA, 0  */
#ifdef SUNX25
    ,"x.25",         NET_SX25, 0
#endif /* SUNX25 */
};
int nnets = (sizeof(netcmd) / sizeof(struct keytab)); /* How many networks */
#endif /* NETCONN */

/* Remote Command Table */
 
struct keytab remcmd[] = {
    "cd",        XZCWD, 0,
    "cwd",       XZCWD, CM_INV,
    "delete",    XZDEL, 0,
    "directory", XZDIR, 0,
    "help",      XZHLP, 0,
    "host",      XZHOS, 0,
#ifndef NOFRILLS
    "print",     XZPRI, 0,
#endif /* NOFRILLS */
    "set",       XZSET, 0,
    "space",	 XZSPA, 0
#ifndef NOFRILLS
,   "type", 	 XZTYP, 0,
    "who",  	 XZWHO, 0
#endif /* NOFRILLS */
};
int nrmt = (sizeof(remcmd) / sizeof(struct keytab));
 
struct keytab logtab[] = {
    "debugging",    LOGD, 0,
    "packets",	    LOGP, 0,
    "session",      LOGS, 0,
    "transactions", LOGT, 0
};
int nlog = (sizeof(logtab) / sizeof(struct keytab));
 
struct keytab writab[] = {
#ifndef NOSPL
    "append-file",     LOGW, CM_INV,
#endif /* NOSPL */
    "debug-log",       LOGD, 0,
#ifndef NOSPL
    "file",            LOGW, 0,
#endif /* NOSPL */
    "packet-log",      LOGP, 0,
    "screen",          LOGX, 0,
    "session-log",     LOGS, 0,
    "sys$output",      LOGX, CM_INV,
    "transaction-log", LOGT, 0
};
int nwri = (sizeof(writab) / sizeof(struct keytab));

struct keytab clstab[] = {
#ifndef NOSPL
    "append-file",     LOGW, CM_INV,
#endif /* NOSPL */
    "debug-log",       LOGD, 0,
    "packet-log",      LOGP, 0,
#ifndef NOSPL
    "read-file",       LOGR, 0,
#endif /* NOSPL */
    "session-log",     LOGS, 0,
    "transaction-log", LOGT, 0,
#ifndef NOSPL
    "write-file",      LOGW, 0
#endif /* NOSPL */
};
int ncls = (sizeof(clstab) / sizeof(struct keytab));

/* SHOW command arguments */
 
struct keytab shotab[] = {
#ifndef NOSPL
    "arguments", SHARG, 0,
    "arrays", SHARR, 0,
#endif /* NOSPL */
    "attributes", SHATT, 0,
    "communications", SHCOM, 0,
#ifndef NOSPL
    "count", SHCOU, 0,
#endif /* NOSPL */
#ifdef VMS
    "default", SHDFLT, 0,
#else
    "default", SHDFLT, CM_INV,
#endif /* VMS */
#ifndef NODIAL
    "dial", SHDIA, 0,
#endif /* NODIAL */
    "escape", SHESC, 0,
    "file", SHFIL, 0,
#ifndef NOSPL
    "functions", SHFUN, 0,
    "globals", SHVAR, 0,
#endif /* NOSPL */
    "key", SHKEY, CM_INV,
#ifndef NOCSETS
    "languages", SHLNG, 0,
#endif /* NOCSETS */
#ifndef NOSPL
    "macros", SHMAC, 0,
#endif /* NOSPL */
    "modem", SHMOD, 0,
#ifdef NETCONN
    "network", SHNET, 0,
#ifdef SUNX25
    "pad", SHPAD, 0,
#endif /* SUNX25 */
#endif /* NETCONN */
    "parameters", SHPAR, CM_INV,
    "protocol", SHPRO, 0,
#ifndef NOSPL
    "scripts", SHSCR, 0,
#endif /* NOSPL */
    "server", SHSER, 0,
    "status", SHSTA, 0,
    "terminal", SHTER, 0,
#ifndef NOXMIT
    "transmit", SHXMI, 0,
#endif /* NOXMIT */
#ifndef NOSPL
    "variables", SHBUI, 0,
#endif /* NOSPL */
    "versions", SHVER, 0,
    "xmit", SHXMI, CM_INV
};
int nsho = (sizeof(shotab) / sizeof(struct keytab));

#ifdef SUNX25
struct keytab padtab[] = {              /* PAD commands */
    "clear",      XYPADL, 0,
    "interrupt",  XYPADI, 0,
    "reset",      XYPADR, 0,
    "status",     XYPADS, 0
};
int npadc = (sizeof(padtab) / sizeof(struct keytab));
#endif /* SUNX25 */

struct keytab enatab[] = {		/* ENABLE commands */
    "all",        EN_ALL,  0,
    "bye",        EN_BYE,  0,
    "cd",         EN_CWD,  0,
    "cwd",        EN_CWD,  CM_INV,
    "delete",     EN_DEL,  0,
    "directory",  EN_DIR,  0,
    "finish",     EN_FIN,  0,
    "get",        EN_GET,  0,
    "host",       EN_HOS,  0,
    "send",       EN_SEN,  0,
    "set",        EN_SET,  0,
    "space",      EN_SPA,  0,
    "type",       EN_TYP,  0,
    "who",        EN_WHO,  0
};
int nena = (sizeof(enatab) / sizeof(struct keytab));

#ifndef NOSPL
struct mtab mactab[MAC_MAX] = {		/* Preinitialized macro table */
    NULL, NULL, 0
};
int nmac = 0;

struct keytab mackey[MAC_MAX];		/* Macro names as command keywords */
#endif /* NOSPL */

/* Forward declarations of functions */

_PROTOTYP (int doask,   ( int  ) );
_PROTOTYP (int dodef,   ( int  ) );
_PROTOTYP (int dodel,   ( void ) );
_PROTOTYP (int dodial,  ( int  ) );
_PROTOTYP (int dodir,   ( void ) );
_PROTOTYP (int doelse,  ( void ) );
_PROTOTYP (int dofor,   ( void ) );
_PROTOTYP (int dogta,   ( int  ) );
_PROTOTYP (int doincr,  ( int  ) );
_PROTOTYP (int dopaus,  ( int  ) );
_PROTOTYP (int dorenam, ( void ) );

/*  D O C M D  --  Do a command  */
 
/*
 Returns:
   -2: user typed an illegal command
   -1: reparse needed
    0: parse was successful (even tho command may have failed).
*/ 
int
docmd(cx) int cx; {

    debug(F101,"docmd entry, cx","",cx);

/* Massive switch command broken up into smaller ones */

    switch (cx) {
      case -4:			/* EOF */
#ifdef OSK
	if (!quiet && pflag)  printf("\n");
#else
	if (!quiet && pflag)  printf("\r\n");
#endif /* OSK */
	  doexit(GOOD_EXIT,xitsta);
      case -3:				/* Null command */
	return(0);
      case -9:				/* Like -2, but errmsg already done */
      case -6:				/* Special */
      case -2:				/* Error, maybe */
      case -1:				/* Reparse needed */
	return(cx);
      default:
	break;
    }
 
/* And later, even the smaller ones were removed, so now we just have ifs. */

#ifndef NOSPL
/* Copy macro args from/to two levels up, used internally by _floop et al. */
    if (cx == XXGTA || cx == XXPTA) {	/* _GETARGS, _PUTARGS */
	int x;
	debug(F101,"docmd XXGTA","",XXGTA);
	debug(F101,"docmd cx","",cx);
	debug(F101,"docmd XXGTA maclvl","",maclvl);
	x = dogta(cx);
	debug(F101,"docmd dogta returns","",x);
	debug(F101,"docmd dogta maclvl","",maclvl);
	return(x);
    }
#endif /* NOSPL */

#ifndef NOSPL
/* ASK, ASKQ, READ */
    if (cx == XXASK || cx == XXASKQ || cx == XXREA) {
	return(doask(cx));
    }
#endif /* NOSPL */

    if (cx == XXBUG) {			/* BUG */
	if ((x = cmcfm()) < 0) return(x);
	return(dobug());
    }

    if (cx == XXBYE) {			/* BYE */
	if ((x = cmcfm()) < 0) return(x);
	sstate = setgen('L',"","","");
	if (local) ttflui();		/* If local, flush tty input buffer */
	return(0);
    } 

#ifndef NOFRILLS
    if (cx == XXCLE) {			/* CLEAR */
	if ((x = cmcfm()) < 0) return(x);
	y = ttflui();			/* Flush input buffer */
#ifndef NOSPL
	for (x = 0; x < INPBUFSIZ; x++)	/* and our local copy too */
	  inpbuf[x] = 0;
	inpbp = inpbuf;
#endif /* NOSPL */
	success = (y == 0);		/* Set SUCCESS/FAILURE */
	return(success);
    }
#endif /* NOFRILLS */

    if (cx == XXCOM) {			/* COMMENT */
	if ((x = cmtxt("Text of comment line","",&s,NULL)) < 0)
	  return(x);
	/* Don't change SUCCESS flag for this one */
	return(0);
    } 

    if (cx == XXCON) {			/* CONNECT */
	if ((x = cmcfm()) < 0)
	  return(x);
	return(success = doconect());
    }

    if (cx == XXCWD) {			/* CWD */
	return(success = docd());
    }

    if (cx == XXCLO) {			/* CLOSE */
	x = cmkey(clstab,ncls,"Which log or file to close","",xxstring);
	if (x == -3) {
	    printf("?You must tell which file or log\n");
	    return(-9);
	}
	if (x < 0) return(x);
	if ((y = cmcfm()) < 0) return(y);
	y = doclslog(x);
	success = (y == 1);
	return(success);
    }

#ifndef NOSPL
    if (cx == XXDEC || cx == XXINC) {	/* DECREMENT, INCREMENT */
	return(doincr(cx));
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXDEF || cx == XXASS) {	/* DEFINE, ASSIGN */
	return(dodef(cx));
    }
#endif /* NOSPL */

#ifndef NOSPL    
    if (cx == XXDCL) {			/* DECLARE an array */
	if ((y = cmfld("Array name","",&s,NULL)) < 0) {
	    if (y == -3) {
		printf("?Array name required\n");
		return(-9);
	    } else return(y);
	}
	if ((y = arraynam(s,&x,&z)) < 0) return(y);
	if ((y = cmcfm()) < 0) return(y);
	if (dclarray(x,z) < 0) {
	    printf("?Declare failed\n");
	    return(success = 0);
	}
	return(success = 1);
    }
#endif /* NOSPL */


#ifndef NODIAL
    if (cx == XXRED || cx == XXDIAL) {	/* DIAL or REDIAL */
	return(dodial(cx));
    }
#endif /* NODIAL */
 
#ifndef NOFRILLS
    if (cx == XXDEL) {			/* DELETE */
	return(dodel());
    }
#endif /* NOFRILLS */

    if (cx == XXDIR) {			/* DIRECTORY */
	return(dodir());
    }
 
#ifndef NOSPL
    if (cx == XXELS) {			/* ELSE */
	return(doelse());
    }
#endif /* NOSPL */

    if (cx == XXENA || cx == XXDIS) {	/* ENABLE, DISABLE */
	s = (cx == XXENA) ?
	  "Server function to enable" :
	    "Server function to disable";

	if ((x = cmkey(enatab,nena,s,"",xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of server function required\n");
		return(-9);
	    } else return(x);
	}
	if ((y = cmcfm()) < 0) return(y);
	return(doenable(cx,x));
    }

#ifndef NOSPL
    if (cx == XXEND) {			/* END, POP (same thing) */
	if (cmdlvl == 0) {		/* At top level, nothing happens... */
	    if ((x = cmcfm()) < 0)
	      return(x);
	    return(success = 1);
	}
	popclvl();
	return(success = 1);
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXRET) {			/* RETURN */
	if (cmdlvl == 0) {		/* At top level, nothing happens... */
	    if ((x = cmcfm()) < 0)
	      return(x);
	    return(success = 1);
	} else if (cmdstk[cmdlvl].src == CMD_TF) { /* In TAKE file, like POP */
	    if ((x = cmcfm()) < 0)
	      return(x);
	    popclvl();			/* pop command level */
	    return(success = 1);	/* always succeeds */
	} else if (cmdstk[cmdlvl].src == CMD_MD) { /* Within macro */  
	    if ((x = cmtxt("optional return value","",&s,NULL)) < 0)
	      return(x);
	    return(doreturn(s));
	} else return(-2);
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXDO) {			/* DO (a macro) */
	if (nmac == 0) {
	    printf("\n?No macros defined\n");
	    return(-2);
	}
	for (y = 0; y < nmac; y++) {	/* copy the macro table */
	    mackey[y].kwd = mactab[y].kwd; /* into a regular keyword table */
	    mackey[y].kwval = y;	/* with value = pointer to macro tbl */
	    mackey[y].flgs = mactab[y].flgs;
	}
	/* parse name as keyword */
	if ((x = cmkey(mackey,nmac,"macro","",xxstring)) < 0) {
	    if (x == -3) {
		printf("?Macro name required\n");
		return(-9);
	    } else return(x);
	}
	if ((y = cmtxt("optional arguments","",&s,xxstring)) < 0)
	  return(y);			/* get args */
	return(success = dodo(x,s));
    }
#endif /* NOSPL */

    if (cx == XXECH) {			/* ECHO */
	if ((x = cmtxt("Material to be echoed","",&s,xxstring)) < 0)
	  return(x);
	printf("%s\n",s);
	return(1);			/* Always succeeds */
    }

#ifndef NOSPL
    if (cx == XXOPE) {			/* OPEN */
	return(doopen());
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXOUT) {			/* OUTPUT */
	if ((x = cmtxt("Text to be output","",&s,xxstring)) < 0)
	  return(x);
	if (*s == '{') {
	    x = strlen(s);
	    if (s[x-1] == '}') {
		s[x-1] = NUL;
		s++;
	    }
	}
	return(success = dooutput(s));
    }
#endif /* NOSPL */

#ifdef SUNX25
    if (cx == XXPAD) {			/* PAD commands */
	x = cmkey(padtab,npadc,"PAD command","",xxstring);
	if (x == -3) {
	    printf("?You must specify a PAD command to execute\n");
	    return(-2);
	}
	if (x < 0) return(x);
    
	switch (x) {
	  case XYPADL: 
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else {
		x25clear();
		initpad();
	    }
	    break;
	  case XYPADS:
	    if (x25stat() < 0)
	      printf("Not connected\r\n");
	    else {
		extern int linkid, lcn;
		conol("Connected thru ");
		conol(ttname);
		printf(", Link id %d, Logical channel number %d\r\n",
		       linkid,lcn);
	    }
	    break;
	  case XYPADR:
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else
	      x25reset(0,0);
	    break;
	  case XYPADI:
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else 
	      x25intr(0);
	}
	return(0);
}
#endif /* SUNX25 */

#ifndef NOSPL
    if (cx == XXPAU || cx == XXWAI) {	/* PAUSE, WAIT */
	return(dopaus(cx));
    }
#endif /* NOSPL */

    if (cx == XXPWD) {			/* PWD */
	if ((x = cmcfm()) < 0) return(x);
	xsystem(PWDCMD);
	return(success = 1);		/* blind faith */
    }

    if (cx == XXQUI || cx == XXEXI) {	/* EXIT, QUIT */
	if ((y = cmnum("exit status code","",10,&x,xxstring)) < 0) {
	    if (y == -3)
	      x = xitsta;
	    else return(y);
	}
	if ((y = cmcfm()) < 0) return(y);
#ifdef VMS
	doexit(GOOD_EXIT,x);
#else
	doexit(x,-1);
#endif /* VMS */
    }

#ifndef NOFRILLS
    if (cx == XXERR) {			/* ERROR */
	if ((x = cmcfm()) < 0) return(x);
	ttflui();
	sstate = 'a';
	return(0);
    }
#endif /* NOFRILLS */

    if (cx == XXFIN) {			/* FINISH */
	if ((x = cmcfm()) < 0) return(x);
	sstate = setgen('F',"","","");
	if (local) ttflui();		/* If local, flush tty input buffer */
	return(0);
    }

#ifndef NOSPL
    if (cx == XXFOR) {			/* FOR loop */
	return(dofor());
    }
#endif /* NOSPL */

    if (cx == XXGET) {			/* GET */
	x = cmtxt("Name of remote file(s), or carriage return","",&cmarg,
		  xxstring);
	if ((x == -2) || (x == -1)) return(x);
	return(doget());
    }

    if (cx == XXHLP) {			/* HELP */
#ifdef NOHELP
	return(dohlp(XXHLP));        
#else
	x = cmkey2(cmdtab,ncmd,"C-Kermit command","help",toktab,xxstring);
	if (x == -5) {
	    y = chktok(toktab);
	    debug(F101,"top-level cmkey token","",y);
	    ungword();
	    switch (y) {
	      case '!': x = XXSHE; break;
	      case '#': x = XXCOM; break;
	      case ';': x = XXCOM; break;
#ifndef NOSPL
	      case ':': x = XXLBL; break;
#endif /* NOSPL */
	      case '&': x = XXECH; break;
	      default:
		printf("\n?Invalid - %s\n",cmdbuf);
		x = -2;
	    }
	}
	return(dohlp(x));
#endif /* NOHELP */
    }
 
    if (cx == XXHAN) {			/* HANGUP */
	if ((x = cmcfm()) < 0) return(x);
	success = (tthang() > -1);
	return(success);
    }

#ifndef NOSPL
    if (cx == XXGOTO) {			/* GOTO */
/* Note, here we don't set SUCCESS/FAILURE flag */
	if ((y = cmfld("label","",&s,xxstring)) < 0) {
	    if (y == -3) {
		printf("?Label name required\n");
		return(-9);
	    } else return(y);
	}
	strcpy(lblbuf,s);
	if ((x = cmcfm()) < 0) return(x);
	s = lblbuf;
	return(dogoto(s));
    }
#endif /* NOSPL */

#ifndef NOSPL
/* IF, Extended IF, WHILE */
    if (cx == XXIF || cx == XXIFX || cx == XXWHI) {
	return(doif(cx));
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXINP || cx == XXREI) {	/* INPUT and REINPUT */
	y = cmnum("seconds to wait for input","1",10,&x,xxstring);
	if (y < 0) {
	    return(y);
	}
	if (x <= 0) x = 1;
	if ((y = cmtxt("Material to be input","",&s,xxstring)) < 0)
	  return(y);
	if (*s == '\0') {
	    printf("?Text required\n");
	    return(-9);
	}
	if (*s == '{') {
	    y = strlen(s);
	    if (s[y-1] == '}') {
		s[y-1] = NUL;
		s++;
	    }
	}
	if (cx == XXINP) {		/* INPUT */
	    debug(F110,"calling doinput",s,0);
	    success = doinput(x,s);	/* Go try to input the search string */
	} else {			/* REINPUT */
	    debug(F110,"xxrei line",s,0);
	    success = doreinp(x,s);
	}
	if (intime && !success) {	/* TIMEOUT-ACTION = QUIT? */
	    popclvl();			/* If so, pop command level. */
	    if (pflag && cmdlvl == 0) {
		if (cx == XXINP) printf("Input timed out\n");
		if (cx == XXREI) printf("Reinput failed\n");
	    }
	}
	return(success);		/* Return do(re)input's return code */
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXLBL) {			/* LABEL */
	if ((x = cmfld("label","",&s,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Label name required\n");
		return(-9);
	    } else return(x);
	}
	if ((x = cmcfm()) < 0) return(x);
	return(0);
    }
#endif /* NOSPL */

    if (cx == XXLOG) {			/* LOG */
	x = cmkey(logtab,nlog,"What to log","",xxstring);
	if (x == -3) {
	    printf("?Type of log required\n");
	    return(-9);
	}
	if (x < 0) return(x);
	x = dolog(x);
	if (x < 0)
	  return(x);
	else
	  return(success = x);
    }
 
#ifndef NOSCRIPT
    if (cx == XXLOGI) {			/* UUCP-style script */
	if ((x = cmtxt("expect-send expect-send ...","",&s,xxstring)) < 0)
	  return(x);
#ifdef VMS
	conres();			/* For Ctrl-C to work... */
#endif /* VMS */
	return(success = dologin(s));	/* Return 1=completed, 0=failed */
    }
#endif /* NOSCRIPT */
 
    if (cx == XXREC) {			/* RECEIVE */
	cmarg2 = "";
	x = cmofi("Name under which to store the file, or CR","",&cmarg2,
		  xxstring);
	if ((x == -1) || (x == -2)) return(x);
	debug(F111,"cmofi cmarg2",cmarg2,x);
	if ((x = cmcfm()) < 0) return(x);
	sstate = 'v';
	if (local) displa = 1;
	return(0);
    }
 
    if (cx == XXREM) {			/* REMOTE */
	x = cmkey(remcmd,nrmt,"Remote Kermit server command","",xxstring);
	if (x == -3) {
	    printf("?You must specify a command for the remote server\n");
	    return(-9);
	}
	return(dormt(x));
    }

#ifndef NOFRILLS
    if (cx == XXREN) {			/* RENAME */
	return(dorenam());
    }
#endif /* NOFRILLS */

    if (cx == XXSEN || cx == XXMAI) {	/* SEND, MAIL */
	cmarg = cmarg2 = "";
	if ((x = cmifi("File(s) to send","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?A file specification is required\n");
		return(-9);
	    } else return(x);
	}
	nfils = -1;			/* Files come from internal list. */
	strcpy(line,s);			/* Save copy of string just parsed. */
	strncpy(fspec,s,FSPECL);	/* and here for \v(filespec) */
	if (cx == XXSEN) {		/* SEND command */
	    debug(F101,"Send: wild","",y);
	    if (y == 0) {
		if ((x = cmtxt("Name to send it with","",&cmarg2,
			       xxstring)) < 0)
		  return(x);
	    } else {
		if ((x = cmcfm()) < 0) return(x);
	    }
	    cmarg = line;		/* File to send */
	    debug(F110,"Sending:",cmarg,0);
	    if (*cmarg2 != '\0') debug(F110," as:",cmarg2,0);
	} else {			/* MAIL */
#ifndef NOFRILLS
	    if (!atdiso || !atcapr) {	/* Disposition attribute off? */
		printf("?Disposition Attribute is Off\n");
		return(-2);
	    }
	    debug(F101,"Mail: wild","",y);
	    *optbuf = NUL;		/* Wipe out any old options */
	    if ((x = cmtxt("Address to mail to","",&s,xxstring)) < 0)
	      return(x);
	    if (strlen(s) == 0) { printf("?Address required\n"); return(-9); }
	    strcpy(optbuf,s);
	    if (strlen(optbuf) > 94) { /* Ensure legal size */
		printf("?Option string too long\n");
		return(-2);
	    }
	    cmarg = line;		/* File to send */
	    debug(F110,"Mailing:",cmarg,0);
	    debug(F110,"To:",optbuf,0);
	    rmailf = 1;			/* MAIL modifier flag for SEND */
#else
	    printf("?Sorry, no frills\n");
	    return(-2);
#endif /* NOFRILLS */
	}
	sstate = 's';			/* Set start state to SEND */
	if (local) {			/* If in local mode, */
	    displa = 1;			/* turn on file transfer display */
	    ttflui();			/* and flush tty input buffer. */
	}
	return(0);
    }
 
#ifndef NOMSEND
    if (cx == XXMSE) {			/* MSEND command */
	nfils = 0;			/* Like getting a list of */
	lp = line;			/* files on the command line */
	while (1) {
	    char *p;
	    if ((x = cmifi("List of files to send, or carriage return","",
			   &s,&y,xxstring)) < 0) {
		if (x == -3) {
		    if (nfils <= 0) {
			printf("?A file specification is required\n");
			return(-9);
		    } else break;
		}
		return(x);
	    }
	    msfiles[nfils++] = lp;	/* Got one, count it, point to it, */
	    p = lp;			/* remember pointer, */
	    while (*lp++ = *s++) ;	/* and copy it into buffer */
	    if (nfils == 1) *fspec = NUL; /* Take care of \v(filespec) */
	    if ((strlen(fspec) + strlen(p) + 1) < FSPECL) {
		strcat(fspec,p);
		strcat(fspec," ");
	    }
	}
	cmlist = msfiles;		/* Point cmlist to pointer array */
	cmarg2 = "";			/* No internal expansion list (yet) */
	sndsrc = nfils;			/* Filenames come from cmlist */
	sstate = 's';			/* Set start state to SEND */
	if (local) {			/* If in local mode, */
	    displa = 1;			/* turn on file transfer display */
	    ttflui();			/* and flush tty input buffer. */
	}
	return(0);
    }
#endif /* NOMSEND */

    if (cx == XXSER) {			/* SERVER */
	if ((x = cmcfm()) < 0) return(x);
	sstate = 'x';
	if (local) displa = 1;
#ifdef AMIGA
	reqoff();			/* No DOS requestors while server */
#endif /* AMIGA */
    return(0);
    }

    if (cx == XXSET) {			/* SET command */
	x = cmkey(prmtab,nprm,"Parameter","",xxstring);
	if (x == -3) {
	    printf("?You must specify a parameter to set\n");
	    return(-9);
	}
	if (x < 0) return(x);
	/* have to set success separately for each item in doprm()... */
	/* actually not really, could have just had doprm return 0 or 1 */
	/* and set success here... */
	y = doprm(x,0);
	if (y == -3) {
	    printf("?More fields required\n");
	    return(-9);
	} else return(y);
    }

    if (cx == XXSHE) {			/* SHELL (system) command */
	if (cmtxt("System command to execute","",&s,xxstring) < 0)
	  return(-1);
	conres();			/* Make console normal  */
	x = zshcmd(s);
	concb(escape);
	return(success = x);
    }

    if (cx == XXSHO) {			/* SHOW */
	x = cmkey(shotab,nsho,"","parameters",xxstring);
	if (x < 0) return(x);
	return(success = doshow(x));
    }
 
    if (cx == XXSPA) {			/* SPACE */
#ifdef datageneral
	/* The DG can take an argument after its "space" command. */
	if ((x = cmtxt("Confirm, or local directory name","",&s,xxstring)) < 0)
	  return(x);
	if (*s == NUL) xsystem(SPACMD);
	else {
	    char *cp;
	    cp = alloc(strlen(s) + 7);      /* For "space *s" */
	    strcpy(cp,"space "), strcat(cp,s);
	    xsystem(cp);
	    if (cp) free(cp);
	}
#else
	if ((x = cmcfm()) < 0) return(x);
#ifdef OS2
	concooked();
	xsystem(SPACMD);
	conraw();
#else
	xsystem(SPACMD);
#endif /* OS2 */
#endif /* datageneral */
	return(success = 1);		/* pretend it worked */
    }
 
    if (cx == XXSTA) {			/* STATISTICS */
	if ((x = cmcfm()) < 0) return(x);
	return(success = dostat());
    }

#ifndef NOSPL
    if (cx == XXSTO) {			/* STOP */
	if ((x = cmcfm()) < 0) return(x);
	dostop();	
	success = 1;			/* always succeeds */
	return(0);
    }
#endif /* NOSPL */

    if (cx == XXSUS) {			/* SUSPEND */
	if ((y = cmcfm()) < 0) return(y);
	stptrap(0);
	return(0);
    }

    if (cx == XXTAK) {			/* TAKE */
	if (tlevel > MAXTAKE-1) {
	    printf("?Take files nested too deeply\n");
	    return(-2);
	}
	if ((y = cmifi("C-Kermit command file","",&s,&x,xxstring)) < 0) { 
	    if (y == -3) {
		printf("?A file name is required\n");
		return(-9);
	    } else return(y);
	}
	if (x != 0) {
	    printf("?Wildcards not allowed in command file name\n");
	    return(-2);
	}
	strcpy(line,s);
	if ((y = cmcfm()) < 0) return(y);
	return(success = dotake(line));
    }
 
#ifndef NOXMIT
    if (cx == XXTRA) {			/* TRANSMIT */
	if ((x = cmifi("File to transmit","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?Only a single file may be transmitted\n");
	    return(-2);
	}
	strcpy(line,s);			/* Save copy of string just parsed. */
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */
	debug(F111,"calling transmit",line,xmitp);
	return(success = transmit(line,xmitp)); /* Do the command */
    }
#endif /* NOXMIT */

#ifndef NOFRILLS
    if (cx == XXTYP) {			/* TYPE */
	if ((x = cmifi("File to type","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?A single file please\n");
	    return(-2);
	}
	strcpy(line,s);			/* Save copy of string just parsed. */
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */
	debug(F110,"calling dotype",line,0);
	return(success = dotype(line));	/* Do the TYPE command */
    }
#endif /* NOFRILLS */

#ifndef NOFRILLS
    if (cx == XXTES) {			/* TEST */
	/* Fill this in with whatever is being tested... */
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */

#ifndef NOSPL
#ifdef COMMENT
	{ int d, i, j;			/* Dump all arrays */
	  char c, **p;
	  for (i = 0; i < 27; i++) {
	      p = a_ptr[i];
	      d = a_dim[i];
	      c = (i == 0) ? 64 : i + 96;
	      if (d && p) {
		  fprintf(stderr,"&%c[%d]\n",c,d);
		  for (j = 0; j <= d; j++) {
		      if (p[j]) {
			  fprintf(stderr,"  &%c[%2d] = [%s]\n",c,j,p[j]);
		      }
		  }	  
	      }
	  }
      }
#else /* Not COMMENT */
	printf("cmdlvl = %d, tlevel = %d, maclvl = %d\n",cmdlvl,tlevel,maclvl);
	if (maclvl < 0) {
	    printf("%s\n",
	     "Call me from inside a macro and I'll dump the argument stack");
	    return(0);
	}
	printf("Macro level: %d, ARGC = %d\n     ",maclvl,macargc[maclvl]);
	for (y = 0; y < 10; y++) printf("%7d",y);
	for (x = 0; x <= maclvl; x++) {
	    printf("\n%2d:  ",x);
	    for (y = 0; y < 10; y++) {
		s = m_arg[x][y];
		printf("%7s",s ? s : "(none)");
	    }
	}
	printf("\n");
#endif /* COMMENT */
#endif /* NOSPL */
	return(0);
    }
#endif /* NOFRILLS */

#ifndef NOCSETS
    if (cx == XXXLA) {	   /* TRANSLATE <ifn> from-cs to-cs <ofn> */
	int incs, outcs;
	if ((x = cmifi("File to translate","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?A single file please\n");
	    return(-2);
	}
	strcpy(line,s);			/* Save copy of string just parsed. */

	if ((incs = cmkey(fcstab,nfilc,"from character-set","",xxstring)) < 0)
	  return(incs);
	if ((outcs = cmkey(fcstab,nfilc,"to character-set","",xxstring)) < 0)
	  return(outcs);

	if ((x = cmofi("output file",CTTNAM,&s,xxstring)) < 0) return(x);
	strncpy(tmpbuf,s,50);
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */
	return(success = xlate(line,tmpbuf,incs,outcs)); /* Execute it */
    }
#endif /* NOCSETS */

    if (cx == XXVER) {			/* VERSION */
	if ((y = cmcfm()) < 0) return(y);
	printf("%s,%s\n Numeric: %ld",versio,ckxsys,vernum);
	if (verwho) printf("-%d\n",verwho); else printf("\n");
	return(success = 1);
    }

#ifndef NOFRILLS
    if (cx == XXWHO) {			/* WHO */
	if ((y = cmtxt("user name","",&s,xxstring)) < 0) return(y);
	sprintf(line,"%s%s",WHOCMD,s);
	xsystem(line);
	return(success = 1);
    }
#endif /* NOFRILLS */

#ifndef NOFRILLS
    if (cx == XXWRI) {			/* WRITE */
	if ((x = cmkey(writab,nwri,"to file or log","",xxstring)) < 0) {
	    printf("?Write to what?\n");
	    return(x);
	}
	if ((y = cmtxt("text","",&s,xxstring)) < 0) return(y);
	switch (x) {
	  case LOGD: y = ZDFILE; break;
	  case LOGP: y = ZPFILE; break;
	  case LOGS: y = ZSFILE; break;
	  case LOGT: y = ZTFILE; break;
#ifndef NOSPL
	  case LOGW: y = ZWFILE; break;
#endif /* NOSPL */
	  case LOGX:
	    printf("%s",s);
#ifndef NOSPL
	    if (cmdlvl == 0) printf("\n");
#else
	    if (tlevel == 0) printf("\n");
#endif /* NOSPL */
	    return(success = 1);
	  default: return(-2);
	}
	if ((x = zsout(y,s)) < 0)
	  printf("?File or log not open\n");
	return(success = (x == 0) ? 1 : 0);
    }
#endif /* NOFRILLS */

    debug(F101,"docmd unk arg","",cx);
    return(-2);				/* None of the above. */
} /* end of docmnd() */

#endif /* NOICP */
