
/* WARNING -- This C source program generated by Wart preprocessor. */
/* Do not edit this file; edit the Wart-format source file instead, */
/* and then run it through Wart to produce a new C source file.     */

/* Wart Version Info: */
char *wartv = "Wart Version 2A(007) Aug 1990";

char *protv = "C-Kermit Protocol Module 5A(040), 22 Mar 91"; /* -*-C-*- */

/* C K C P R O  -- C-Kermit Protocol Module, in Wart preprocessor notation. */
/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1991, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained. 
*/
#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
/*
 Note -- This file may also be preprocessed by the Unix Lex program, but 
 you must indent the above #include statements before using Lex, and then
 restore them to the left margin in the resulting C program before compilation.
 Also, the invocation of the "wart()" function below must be replaced by an
 invocation  of the "yylex()" function.  It might also be necessary to remove
 comments in the %%...%% section.
*/

/* State definitions for Wart (or Lex) */
#define ipkt 1
#define rfile 2
#define rattr 3
#define rdata 4
#define ssinit 5
#define ssfile 6
#define ssattr 7
#define ssdata 8
#define sseof 9
#define sseot 10
#define serve 11
#define generic 12
#define get 13
#define rgen 14

/* External C-Kermit variable declarations */
  extern char *versio, *srvtxt, *cmarg, *cmarg2, **cmlist;
  extern char filnam[], ttname[];
  extern CHAR sstate, *rpar(), encbuf[], *srvptr, *data;
  extern int timint, pkttim, nfils, hcflg, xflg, flow, mdmtyp, network;
  extern int cxseen, czseen, server, local, displa, bctu, bctr, quiet;
  extern int tsecs, parity, backgrd, nakstate, atcapu, wslotn, winlo;
  extern int wslots, success, xitsta, rprintf, discard, cdtimo, keep;
  extern long speed;
  extern char *DIRCMD, *DIRCM2, *DELCMD, *TYPCMD, *SPACMD, *SPACM2, *WHOCMD;
  extern CHAR *rdatap;
  extern struct zattr iattr;
#ifdef DYNAMIC
  extern CHAR *srvcmd;
#else
  extern CHAR srvcmd[];
#endif /* DYNAMIC */

#ifndef NOSPL
  extern int cmdlvl;
#else
  extern int tlevel;
#endif /* NOSPL */

#ifdef NOMSEND
  extern int sndsrc;
#endif /* NOMSEND */

/* Flags for the ENABLE and DISABLE commands */
extern int
  en_cwd, en_del, en_dir, en_fin, en_get, en_bye,
  en_hos, en_sen, en_spa, en_set, en_typ, en_who;

/* Global variables declared here */

  int what = W_NOTHING;			/* What we're doing */

/* Local variables */

  static char vstate = 0;  		/* Saved State   */
  static char vcmd = 0;    		/* Saved Command */

  static int x;				/* General-purpose integer */
  static char *s;			/* General-purpose string pointer */

/* Macros - Note, BEGIN is predefined by Wart (and Lex) as "state = ", */
/* BEGIN is NOT a GOTO! */
#define TINIT  if (tinit() < 0) return(-9)
#define SERVE  TINIT; nakstate = 1; what = W_NOTHING; BEGIN serve
#define RESUME if (server) { SERVE; } else { sleep(2); return(0); }
#define QUIT x=quiet; quiet=1; clsif(); clsof(1); tsecs=gtimer(); quiet=x; \
 return(1)


#define BEGIN state =

int state = 0;

int
wart()
{
    int c,actno;
    extern char tbl[];
    while (1) {
	c = input();
	if ((actno = tbl[c + state*128]) != -1)
	    switch(actno) {
case 1:
    { TINIT;				/* Do Send command */
    if (sinit()) BEGIN ssinit;
       else RESUME; }
    break;
case 2:
    { TINIT; nakstate = 1; BEGIN get; }
    break;
case 3:
    { TINIT; vstate = get;  vcmd = 0;   sipkt('I'); BEGIN ipkt; }
    break;
case 4:
    { TINIT; vstate = rgen; vcmd = 'C'; sipkt('I'); BEGIN ipkt; }
    break;
case 5:
    { TINIT; vstate = rgen; vcmd = 'G'; sipkt('I'); BEGIN ipkt; }
    break;
case 6:
    { sleep(1); SERVE; }
    break;
case 7:
    { if (!data) TINIT;			/* "ABEND" -- Tell other side. */
    errpkt((CHAR *)"User cancelled");
    success = 0;
    return(0); }
    break;
case 8:
    {			/* Receive Send-Init packet. */
    if (state == serve && !en_sen) {	/* Not allowed if in server mode */
	errpkt((CHAR *)"SEND disabled"); /* and SEND is disabled. */
	SERVE;
    } else {				/* OK to go ahead. */
	nakstate = 1;			/* Can send NAKs from here. */
	rinit(rdatap);			/* Set parameters */
	bctu = bctr;			/* Switch to agreed-upon block check */
	timint = pkttim;		/* Switch to per-packet timer */
	chktimo();			/* Check & adjust timeout */
	resetc();			/* Reset counters */
	rtimer();			/* Reset timer */
	what = W_RECV;			/* Remember we're receiving */
	BEGIN rfile;			/* Go into receive-file state */
    }
}
    break;
case 9:
    {				/* Get ack for I-packet */
    spar(rdatap);			/* Set parameters */
#ifdef COMMENT
    getsbuf(winlo = 0);			/* Set window-low back to zero */
#else
    winlo = 0;
#endif
    if (vcmd) {				/* If sending a generic command */
	scmd(vcmd,(CHAR *)cmarg);	/* Do that */
	vcmd = 0;			/* and then un-remember it. */
    } else if (vstate == get) srinit();	/* If sending GET command, do that */
    winlo = 0;				/* Again! */
    nakstate = 1;			/* Can send NAKs from here. */
    BEGIN vstate;			/* Switch to desired state */
}
    break;
case 10:
    {				/* Ignore Error reply to I packet */
#ifdef COMMENT
    getsbuf(winlo = 0);			/* Set window-low back to zero */
#else
    winlo = 0;
#endif
    if (vcmd) {				/* in case other Kermit doesn't */
	scmd(vcmd,(CHAR *)cmarg);	/* understand I-packets. */
	vcmd = 0;			/* Otherwise act as above... */
    } else if (vstate == get) srinit();
    winlo = 0;				/* Back to packet 0 again. */
    freerpkt(winlo);			/* Discard the Error packet. */
    nakstate = 1;			/* Can send NAKs from here. */
    BEGIN vstate;
}
    break;
case 11:
    {		/* Resend of previous I-pkt ACK, same seq number! */
    srinit();
}
    break;
case 12:
    {				/* Get I-packet */
    spar(rdatap);			/* Set parameters from it */
    ack1(rpar());			/* Respond with our own parameters */
    pktinit();				/* Reinitialize packet numbers */
}
    break;
case 13:
    {				/* Get Receive-Init (GET) */
    debug(F100,"<serve>R","",0);
    if (!en_get) {			/* Only if not disabled!  */
	errpkt((CHAR *)"GET disabled");
	SERVE;
    } else {				/* OK to go ahead. */
	srvptr = srvcmd;		/* Point to server command buffer */
	decode(rdatap,putsrv);		/* Decode the GET command into it */
	/* Accept multiple filespecs */
        cmarg2 = "";			/* Don't use cmarg2 */
	cmarg = "";			/* Don't use cmarg */
#ifndef NOMSEND				/* New way. */
	nfils = fnparse((char *)srvcmd); /* Use cmlist instead */
#else
	nfils = 0 - zxpand(srvcmd);
#endif /* NOMSEND */
	nakstate = 0;			/* Now I'm the sender! */
	if (sinit()) {			/* Send Send-Init */
	    timint = pkttim;		/* Switch to per-packet timer */
	    BEGIN ssinit;		/* If successful, switch state */
	} else { SERVE; }		/* Else back to server command wait */
    }
}
    break;
case 14:
    {				/* Generic server command */
    srvptr = srvcmd;			/* Point to command buffer */
    decode(rdatap,putsrv);		/* Decode packet data into it */
    putsrv('\0');			/* Insert a couple nulls */
    putsrv('\0');			/* for termination */
    if (srvcmd[0]) {
	sstate = srvcmd[0];		/* Set requested start state */
	nakstate = 0;			/* Now I'm the sender. */
	what = W_REMO;			/* Doing a REMOTE command. */
	timint = pkttim;		/* Switch to per-packet timer */
	BEGIN generic;			/* Switch to generic command state */
    } else {
	errpkt((CHAR *)"Badly formed server command"); /* report error */
	SERVE;				/* & go back to server command wait */
    }
}
    break;
case 15:
    {				/* Receive Host command */
    if (!en_hos) {
	errpkt((CHAR *)"REMOTE HOST disabled");
	SERVE;
    } else {
	srvptr = srvcmd;		/* Point to command buffer */
	decode(rdatap,putsrv);		/* Decode command packet into it */
	putsrv('\0');			/* Null-terminate */
	nakstate = 0;			/* Now sending, not receiving */
	if (syscmd((char *)srvcmd,"")) { /* Try to execute the command */
	    what = W_REMO;		/* Doing a REMOTE command. */
	    timint = pkttim;		/* Switch to per-packet timer */
	    BEGIN ssinit;		/* If OK, send back its output */
	} else {			/* Otherwise */
	    errpkt((CHAR *)"Can't do system command"); /* report error */
	    SERVE;			/* & go back to server command wait */
	}
    }
}
    break;
case 16:
    {				/* User typed Ctrl-C... */
    if (!en_fin) {
	errpkt((CHAR *)"QUIT disabled");
	SERVE;
    } else {
	success = 0; QUIT;
    }
}
    break;
case 17:
    {				/* Any other command in this state */
    errpkt((CHAR *)"Unimplemented server function"); /* we don't know about */
    SERVE;				/* back to server command wait */
}
    break;
case 18:
    {				/* Got REMOTE CWD command */
    if (!en_cwd) {
	errpkt((CHAR *)"REMOTE CD disabled");
	SERVE;
    } else {
	if (!cwd((char *)(srvcmd+1))) errpkt((CHAR *)"Can't change directory");
	SERVE;				/* Back to server command wait */
    }
}
    break;
case 19:
    {				/* REMOTE DIRECTORY command */
    char *n2;
    if (!en_dir) {			/* If DIR is disabled, */
	errpkt((CHAR *)"REMOTE DIRECTORY disabled"); /* refuse. */
	SERVE;
    } else {				/* DIR is enabled. */
	if (!en_cwd) {			/* But if CWD is disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */
		errpkt((CHAR *)"Access denied");
		SERVE;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {			/* It's OK to go ahead. */
	    n2 = (*(srvcmd+2)) ? DIRCMD : DIRCM2;
	    if (syscmd(n2,(char *)(srvcmd+2)))  /* If it can be done */
	      BEGIN ssinit;			/* send the results back */
	    else {				/* otherwise */
		errpkt((CHAR *)"Can't list directory"); /* report failure, */
		SERVE;			/* return to server command wait */
	    }
	}
    }
}
    break;
case 20:
    {				/* REMOTE DELETE (Erase) command */
    char *n2;
    if (!en_del) {
	errpkt((CHAR *)"REMOTE DELETE disabled");    
	SERVE;
    } else {
	if (!en_cwd) {			/* But if CWD is disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */
		errpkt((CHAR *)"Access denied");
		SERVE;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {			/* It's OK to go ahead. */
	    if (syscmd(DELCMD,(char *)(srvcmd+2))) /* Try to do it */
	      BEGIN ssinit;			/* If OK send results back */
	    else {				/* otherwise */
		errpkt((CHAR *)"Can't remove file"); /* report failure */
		SERVE;			/* & return to server command wait */
	    }
	}
    }
}
    break;
case 21:
    {				/* FINISH */
    if (!en_fin) {
	errpkt((CHAR *)"FINISH disabled");    
	SERVE;
    } else {
	ack();				/* Acknowledge */
	screen(SCR_TC,0,0l,"");		/* Display */
	return(0);			/* Done */
    }
}
    break;
case 22:
    {				/* BYE (LOGOUT) */
    if (!en_bye) {
	errpkt((CHAR *)"BYE disabled");    
	SERVE;
    } else {
	ack();				/* Acknowledge */
	ttres();			/* Reset the terminal */
	screen(SCR_TC,0,0l,"");		/* Display */
	doclean();			/* Clean up files, etc */
	return(zkself());		/* Try to log self out */
    }
}
    break;
case 23:
    {				/* REMOTE HELP */
    if (sndhlp()) BEGIN ssinit;		/* Try to send it */
    else {				/* If not ok, */
	errpkt((CHAR *)"Can't send help"); /* send error message instead */
	SERVE;				/* and return to server command wait */
    }
}
    break;
case 24:
    {				/* REMOTE SET */
    if (!en_set) {
	errpkt((CHAR *)"REMOTE SET disabled");
	SERVE;
    } else {
	if (remset((char *)(srvcmd+1)))	/* Try to do what they ask */
	  ack();			/* If OK, then acknowledge */
	else				/* Otherwise */
	  errpkt((CHAR *)"Unknown REMOTE SET parameter"); /* give error msg */
	SERVE;				/* Return to server command wait */
    }
}
    break;
case 25:
    {				/* REMOTE TYPE */
    char *n2;
    if (!en_typ) {
	errpkt((CHAR *)"REMOTE TYPE disabled");
	SERVE;
    } else {
	if (!en_cwd) {			/* But if CWD is disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */
		errpkt((CHAR *)"Access denied");
		SERVE;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {			/* It's OK to go ahead. */
	    if (syscmd(TYPCMD,(char *)(srvcmd+2))) /* Try */
	      BEGIN ssinit;			/* OK */
	    else {				/* not OK */
		errpkt((CHAR *)"Can't type file"); /* give error message */
		SERVE;			/* wait for next server command */
	    }
	}
    }
}
    break;
case 26:
    {				/* REMOTE SPACE */
    if (!en_spa) {
	errpkt((CHAR *)"REMOTE SPACE disabled");
	SERVE;
    } else {
	x = *(srvcmd+1);		/* Get area to check */
	x = ((x == '\0') || (x == SP));
	if (!x && !en_cwd) {		/* If CWD disabled and they gave */
	    errpkt((CHAR *)"Access denied"); /* a non-default area, */
	    SERVE;			/* refuse. */
	} else {
	    x = (x ? syscmd(SPACMD,"") : syscmd(SPACM2,(char *)(srvcmd+2)));
	    if (x) {				/* If we got the info */
		BEGIN ssinit;			/* send it */
	    } else {				/* otherwise */
		errpkt((CHAR *)"Can't check space"); /* send error message */
		SERVE;			/* and await next server command */
	    }
	}
    }
}
    break;
case 27:
    {				/* REMOTE WHO */
    if (!en_who) {
	errpkt((CHAR *)"REMOTE WHO disabled");
	SERVE;
    } else {
	if (syscmd(WHOCMD,(char *)(srvcmd+2))) /* The now-familiar scenario. */
	  BEGIN ssinit;
	else {
	    errpkt((CHAR *)"Can't do who command");
	    SERVE;
	}
    }
}
    break;
case 28:
    {
    if (!en_fin) {			/* Ctrl-C typed */
	errpkt((CHAR *)"QUIT disabled");
	SERVE;
    } else {
	success = 0; QUIT;
    }
}
    break;
case 29:
    {				/* Anything else in this state... */
    errpkt((CHAR *)"Unimplemented REMOTE command"); /* Complain */
    SERVE;				/* and return to server command wait */
}
    break;
case 30:
    {				/* Short-Form reply */
    decode(rdatap,puttrm);		/* in ACK Data field */
    RESUME;
}
    break;
case 31:
    {				/* File header */
    xflg = 0;				/* Not screen data */
    if (!rcvfil(filnam)) {		/* Figure out local filename */
	errpkt((CHAR *)"Can't transform filename"); /* Trouble */
	RESUME;
    } else {				/* OK to receive */
	encstr((CHAR *)filnam);		/* Encode the name */
	ack1((CHAR *)(encbuf+7));	/* Send it back in ACK */
	initattr(&iattr);		/* Clear file attribute structure */
	window(wslotn);			/* allocate negotiated window slots */
	BEGIN rattr;			/* Now expect Attribute packets */
    }
}
    break;
case 32:
    {				/* X-packet instead of file header */
    xflg = 1;				/* Screen data */
    ack();				/* Acknowledge the X-packet */
    initattr(&iattr);			/* Initialize attribute structure */
    window(wslotn);			/* allocate negotiated window slots */
    what = W_REMO;			/* we're doing a REMOTE command */
    BEGIN rattr;			/* Expect Attribute packets */
}
    break;
case 33:
    {				/* Attribute packet */
    if (discard) {			/* If SET FILE COLLISION DISCARD */
	ack1((CHAR *)"N");		/* refuse it */
    } else if (gattr(rdatap,&iattr) == 0) /* Read into attribute structure */
      ack();				/* If OK, acknowledge */
    else				/* Otherwise */
      ack1((CHAR *)iattr.reply.val);	/* refuse to accept the file */
}
    break;
case 34:
    {				/* First data packet */
    if (discard) {			/* if we're discarding the file */
	ack1((CHAR *)"X");		/* just ack the data like this. */
	BEGIN rdata;			/* and wait for more data packets. */
    } else {				/* Not discarding. */
	if (xflg)			/* If screen data */
	  x = opent(&iattr);		/* "open" the screen */
	else				/* otherwise */
	  x = opena(filnam,&iattr);	/* open the file, with attributes */
	if (x) {			/* If file was opened ok */
	    if (decode(rdatap,putfil) < 0) { /* decode first data packet */
		errpkt((CHAR *)"Error writing data");
		RESUME;
	    }
	    ack();			/* acknowledge it */
	    BEGIN rdata;		/* and switch to receive-data state */
	} else {			/* otherwise */
	    errpkt((CHAR *)"Can't open file");	/* send error message */
	    RESUME;			/* and quit. */
	}
    }
}
    break;
case 35:
    {				/* EOT, no more files */
    ack();				/* Acknowledge */
    tsecs = gtimer();			/* Get timing for statistics */
    reot();				/* Do EOT things */
    RESUME;				/* and quit */
}
    break;
case 36:
    {				/* Data packet */
    if (cxseen || discard)		/* If file interrupt */
      ack1((CHAR *)"X");		/* put "X" in ACK */
    else if (czseen)			/* If file-group interrupt */
      ack1((CHAR *)"Z");		/* put "Z" in ACK */
    else if (decode(rdatap,putfil) < 0) { /* Normal case, decode to file */
	errpkt((CHAR *)"Error writing data"); /* If failure, */
	clsof(!keep);			/*   Close & keep/discard the file */
	RESUME;				/* Send ACK only after data */
    } else ack();			/* written to file OK. */
}
    break;
case 37:
    {				/* EOF immediately after A-Packet. */
    if (xflg)				/* Zero-length file. If screen data */
      x = opent(&iattr);		/* "open" the screen */
    else				/* otherwise */
      x = opena(filnam,&iattr);		/* open the file, with attributes. */
    if (reof(filnam, &iattr) < 0) {	/* Now close & dispose of the file */
	errpkt((CHAR *)"Can't close file"); /* If problem, send error msg */
	RESUME;				/* and quit */
    } else {				/* otherwise */
	ack();				/* acknowledge the EOF packet */
	success = 1;
	BEGIN rfile;			/* and await another file */
    }
}
    break;
case 38:
    {				/* End Of File (EOF) Packet */
/*  wslots = 1;	*/			/* Window size back to 1 */
    if (discard) {			/* If discarding, there's no file */
	discard = 0;			/* to close, just reset the discard */
	ack();				/* flag, ack, and proceed normally. */
	success = 1;			/* Count this as a success. */
	BEGIN rfile;
    } else if (reof(filnam, &iattr) < 0) { /* Close & dispose of the file */
	errpkt((CHAR *)"Can't close file"); /* If problem, send error msg */
	RESUME;				/* and quit */
    } else {				/* otherwise */
	ack();				/* acknowledge the EOF packet */
	success = 1;
	BEGIN rfile;			/* and await another file */
    }
}
    break;
case 39:
    {				/* ACK for Send-Init */
    spar(rdatap);			/* set parameters from it */
    bctu = bctr;			/* switch to agreed-upon block check */
    what = W_SEND;			/* Remember we're sending */
    x = sfile(xflg);			/* Send X or F header packet */
    if (x) {				/* If the packet was sent OK */
	resetc();			/* reset per-transaction counters */
	rtimer();			/* reset timers */
	chktimo();			/* Check & adjust timeout */
	BEGIN ssfile;			/* and switch to receive-file state */
    } else {				/* otherwise send error msg & quit */
	s = xflg ? "Can't execute command" : "Can't open file";
	errpkt((CHAR *)s);
	RESUME;
    }
}
    break;
case 40:
    {				/* R packet was retransmitted. */
    xsinit();				/* Resend packet 0 */
}
    break;
case 41:
    {				/* Same deal if G packet comes again */
    xsinit();
}
    break;
case 42:
    {				/* Same deal if C packet comes again */
    xsinit();
}
    break;
case 43:
    {				/* ACK for F packet */
    srvptr = srvcmd;			/* Point to string buffer */
    decode(rdatap,putsrv);		/* Decode data field, if any */
    putsrv('\0');			/* Terminate with null */
    if (*srvcmd)			/* If remote name was recorded */
      tlog(F110," stored as",(char *) srvcmd,0L); /* Log in transaction log. */
    if (atcapu) {			/* If attributes are to be used */
	if (sattr(xflg) < 0) {		/* set and send them */
	    errpkt((CHAR *)"Can't send attributes"); /* if problem, say so */
	    RESUME;			     /* and quit */
	} else BEGIN ssattr;		/* if ok, switch to attribute state */
    } else {
	window(wslotn);
	if (sdata() < 0) {		/* No attributes, send data */
	    clsif();			/* If not ok, close input file, */
	    window(wslots = 1);		/* put window size back to 1, */
	    seof((CHAR *)"");		/* send EOF packet, */
	    BEGIN sseof;		/* and switch to EOF state. */
	} else BEGIN ssdata;		/* All ok, switch to send-data state */
    }
}
    break;
case 44:
    {				/* Got ACK to A packet */
    if (rsattr(rdatap) < 0) {		/* Was the file refused? */
	clsif();			/* yes, close it */
	sxeof((CHAR *)"D");		/* send EOF with "discard" code */
	BEGIN sseof;			/* switch to send-EOF state */
    } else {
	window(wslotn);			/* Allocate negotiated window. */
	if (sdata() < 0) {		/* File accepted, send data */
	    clsif();			/* If problem, close input file */
	    window(wslots = 1);		/* Window size back to 1... */
	    seof((CHAR *)"");		/* send EOF packet */
	    BEGIN sseof;		/* and switch to send-EOF state. */
	} else {			/* All ok, enter send-data state. */
	    BEGIN ssdata;
	}
    }
}
    break;
case 45:
    {				/* Got ACK to Data packet */
    canned(rdatap);			/* Check if file transfer cancelled */
    if (sdata() < 0) {			/* Try to send next data */
	clsif();			/* If no more data, close file */
	window(wslots = 1);		/* Window size back to 1... */
	if (cxseen || czseen)		/* If interrupted */
	  seof((CHAR *)"D");		/* send special EOF packet */
	else seof((CHAR *)"");		/* Otherwise regular EOF packet */
	BEGIN sseof;			/* And enter send-eof state */
    }
}
    break;
case 46:
    {				/* Got ACK to EOF */
    success = (cxseen == 0 && czseen == 0); /* Set this for IF command */
    cxseen = 0;				/* This goes back to zero. */
    if (gnfile() > 0) {			/* Any more files to send? */
	if (sfile(xflg))		/* Yes, try to send next file header */
	  BEGIN ssfile;			/* if ok, enter send-file state */
	else {				/* otherwise */
	    errpkt((CHAR *)"Can't open file");	/* send error message */
	    RESUME;			/* and quit */
	}
    } else {				/* No next file */
	tsecs = gtimer();		/* get statistics timers */
	seot();				/* send EOT packet */
	BEGIN sseot;			/* enter send-eot state */
    }
}
    break;
case 47:
    {				/* Got ACK to EOT */
    RESUME;				/* All done, just quit */
}
    break;
case 48:
    {					/* Got Error packet, in any state */
    ermsg((char *)rdatap);		/* Issue message. */
    success = 0;			/* For IF SUCCESS/FAIL. */
    debug(F101,"ckcpro.w sstate at E pkt","",sstate);
    x = quiet; quiet = 1;		/* Close files silently, */
    clsif(); clsof(1);			/* discarding any output file. */
    tsecs = gtimer();			/* Get timers */
    quiet = x;				/* restore quiet state */
    if (backgrd && !server) fatal("Protocol error");
    xitsta |= what;			/* Save this for doexit(). */
    RESUME;
}
    break;
case 49:
    { QUIT; }
    break;
case 50:
    {					/* Anything not accounted for above */
    errpkt((CHAR *)"Unexpected packet type"); /* Give error message */
    xitsta |= what;			/* Save this for doexit(). */
    RESUME;				/* and quit */
}
    break;

	    }
    }
}

char tbl[] = {
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 10, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50,  9, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 35, 50, 50, 48, 31, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 32, 50, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 33, 50, 50, 34, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 37, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 36, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 38, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 42, 50, 48, 50, 41, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 40, 50, 50, 50, 50, 50, 50, 39, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 43, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 44, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 45, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 46, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 47, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
-1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
17, 17, 17, 15, 17, 17, 17, 14, 17, 12, 17, 17, 17, 17, 17, 17, 
17, 17, 13,  8, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
17,  7, 17,  4, 17, 17, 17,  5, 17, 17, 17, 17, 17, 17, 17, 17, 
17, 16,  3,  1, 17, 17,  2, 17,  6, 17, 17, 17, 17, 17, 17, 17, 
-1, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 
29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 
29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 
29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 
29, 29, 29, 18, 19, 20, 21, 29, 23, 29, 29, 29, 22, 29, 29, 29, 
29, 29, 29, 24, 25, 26, 29, 27, 29, 29, 29, 29, 29, 29, 29, 29, 
29,  7, 29,  4, 29, 29, 29,  5, 29, 29, 29, 29, 29, 29, 29, 29, 
29, 28,  3,  1, 29, 29,  2, 29,  6, 29, 29, 29, 29, 29, 29, 29, 
-1, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50,  8, 50, 50, 50, 50, 50, 11, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
 0, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50, 50, 50, 48, 31, 50, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 50, 50,  8, 50, 50, 50, 50, 32, 30, 50, 50, 50, 50, 50, 50, 
50,  7, 50,  4, 50, 50, 50,  5, 50, 50, 50, 50, 50, 50, 50, 50, 
50, 49,  3,  1, 50, 50,  2, 50,  6, 50, 50, 50, 50, 50, 50, 50, 
};


/*  P R O T O  --  Protocol entry function  */

VOID
proto() {

    int x;
    long lx;

/* Set up the communication line for file transfer. */

    if (local && (speed < 0L) && (network == 0)) {
	screen(SCR_EM,0,0l,"Sorry, you must 'set speed' first");
	return;
    }
    x = -1;
    if (ttopen(ttname,&x,mdmtyp,cdtimo) < 0) {
	debug(F111,"failed: proto ttopen local",ttname,local);
	screen(SCR_EM,0,0l,"Can't open line");
	return;
    }
    if (x > -1) local = x;
    debug(F111,"proto ttopen local",ttname,local);

    lx = (local && !network) ? speed : -1;
    if (ttpkt(lx,flow,parity) < 0) {	/* Put line in packet mode, */
	screen(SCR_EM,0,0l,"Can't condition line");
	return;
    }
    if (!local) connoi();		/* No console interrupts if remote */

    if (sstate == 'x') {		/* If entering server mode, */
	server = 1;			/* set flag, */
	debug(F101,"server backgrd","",backgrd);
	debug(F101,"server quiet","",quiet);
	if (!quiet && !backgrd) {
    	    debug(F100,"SHOULD NOT SEE THIS IF IN BACKGROUND!","",0);
	    if (!local)			/* and issue appropriate message. */
	    	conol(srvtxt);
	    else {
	    	conol("Entering server mode on ");
		conoll(ttname);
		conoll("Type Ctrl-C to quit.");
	    }
	}
    } else server = 0;
#ifdef VMS
    if (!quiet && !backgrd)    /* So message doesn't overwrite prompt */
      conoll("");
    if (local) conres();       /* So Ctrl-C will work */
#endif /* VMS */
    if (sstate == 'v' && !local && !quiet && !backgrd &&
#ifndef NOSPL
	cmdlvl == 0
#else
	tlevel < 0
#endif /* NOSPL */
	)
      conoll("Escape back to your local Kermit and give a SEND command...");
    if (sstate == 's' && !local && !quiet && !backgrd &&
#ifndef NOSPL
	cmdlvl == 0
#else
	tlevel < 0
#endif /* NOSPL */
	)
      conoll("Escape back to your local Kermit and give a RECEIVE command...");
    sleep(1);
/*
 The 'wart()' function is generated by the wart program.  It gets a
 character from the input() routine and then based on that character and
 the current state, selects the appropriate action, according to the state
 table above, which is transformed by the wart program into a big case
 statement.  The function is active for one transaction.
*/
    wart();				/* Enter the state table switcher. */
    
    if (server) {			/* Back from packet protocol. */
	server = 0;
    	if (!quiet && !backgrd)		/* Give appropriate message */
	    conoll("C-Kermit server done");
    }
/*
  Note: the following is necessary in case we have just done a remote-mode
  file transfer, in which case the controlling terminal modes have been
  changed by ttpkt().  In particular, special characters like Ctrl-C and
  Ctrl-\ might have been turned off (see ttpkt).  So this call to ttres() is
  essential.
*/
    if (!local) ttres();		/* Reset the terminal */
    screen(SCR_TC,0,0l,"");		/* Transaction complete */
}
