/*
 * Winfo
 * by Paul S. Kleppner
 *
 * This program may be freely distributed, but not sold.
 * It is provided without warranty of any kind, expressed or
 * implied, as to its fitness for any particular use.
 */

/*
 * WinInfo class.  This is the controlling object of the application.
 */

#import <objc/Object.h>
#import <appkit/graphics.h>


// The winfo struct holds information about a particular window.

struct winfo {
  int num;				// window number (server's value, not appkit's)
  NXRect place;			// location of window on screen
  int hasAlpha;			// YES if has alpha value
  int colors;			// number of color componentsa
  int depth;			// depth of eachc olor
  int level;			// level on screen
  int context;			// DisplayPostscript context
  BOOL origOnScreen;	// YES if window was originally on screen
  BOOL onScreenNow;		// YES if window is on screen now
  BOOL isMe;			// YES if this is one of Winfo's own windows
};

@interface WinInfo:Object
{
  BOOL activeFlag;		// YES if active (i.e. start button is pressed)
  BOOL outlineMode;		// YES if outline mode (== !show window contents)a
  BOOL offScreenMode;	// YES if off-screen windows should be shown

  id myFont;			// display font
  int numWins;			// number of existing windows
  int *windowList;		// array of all DPS window numbers
  int numOnScreen;		// number of existing windows on screen
  int *onScreenList;	// array of on-screen DPS window numbers
  struct winfo *wpList;	// array of info about each window

  BOOL highlightAlpha;	// YES if windows w/alpha should be highlighted
  BOOL highlightColor;	// YES if windows w/color should be highlihgted
  BOOL highlightDepth;	// YES if windows w/depth > 1 should be highlighted

  id displayWin;		// id of full-size window in which display is created
  int selectedContext;	// context number for currently selected window

  id reportPanel;				// id of report panel
  id timeDelay;					// time delay field

					// selected window fields in report panel
  id repBox;					// box surrounding all fields
  id repContext;				// context
  id repSize;					// size
  id repAlpha;					// alpha
  id repDepth;					// depth
  id repColors;					// color
  id repBackingStore;			// backing store

					// all windows in contenxt fields in report panel
  id repOnScreen;				// on-screen
  id repOffScreen;				// off-screen
  id repTotalScreen;			// total
  id repTotalBackingStore;		// total amount of backing store

					// other controls in report panel
  id highlightOpt;				// highlighting check boxes
  id showOutlinesButton;		// show outlines or contents check box
  id showOffScreenButton;		// show off screen windows check box

}


- startStop:sender;
- start:sender;
- stop:sender;
- changeHighlight:sender;
- getHighlightValues:sender;
- showAllWindows;
- showOutlineWindow:(struct winfo *)wp markBorder:(BOOL)mark;
- (struct winfo *) mapPointToWindow:(NXPoint *)p;
- clearReport;
- showReportFor:(struct winfo *)wp;
- (int) sizeBackingStore:(struct winfo *)wp;
- (int) trueWinNumberFor:win;
- showOutlines:sender;
- showOffScreen:sender;
- clearOffScreen;
- moveOnScreen:(BOOL)how forContext:(int)context;
- (struct winfo *) findWinfoByNumber:(int)wnum;
- buildWindowList;
- buildOnScreenList;
@end
