/*
 * Winfo
 * by Paul S. Kleppner
 *
 * This program may be freely distributed, but not sold.
 * It is provided without warranty of any kind, expressed or
 * implied, as to its fitness for any particular use.
 */

/*
 * WView.  This is the content view for the display window
 * on which everything is drawn.  Its only purpose is
 * to take mouse-down events and pass them to hte proxy.
 */

#import "WView.h"

@implementation WView

// Construct, specifying a given client.
+ newForClient:client
{
  self = [super new];
  myClient = client;

  return self;
}

// Pass mouse-down events to the client.
- mouseDown:(NXEvent *)event
{
  [myClient mouseDownProxy:event];
  return self;
}

// Take first mouse hits.
- (BOOL) acceptsFirstMouse
{
  return YES;
}
@end
