/* Document.h
 * Purpose:   Initializes, loads, archives and frees a single
 *	document.  The template for the document is located in
 *	Document.nib, which is loaded by this class each time
 *	a new document is created.  The windows are tiled using
 *	the newLocation() function.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: R. Dunbar Poor
 * Created: 28/April/1991
 *
 */
#import <objc/Object.h>

#define DOCUMENT_TYPE	"updoc"

@interface Document:Object
{
  id	docWindow;	/* the window containing the document */
  id	statusField;	/* a text field */
  id	docContents;	/* textField (representing the contents of the doc) */
  char	*name;		/* the name of the document */
}

- init;
- initFromFile:(const char *)filename;
- loadFromFile:(const char *)filename;
- free;

- (const char *)message;
/*
 * return the message contained in this document's text field
 */

- activateDocument:sender;
- deactivateDocument:sender;
/*
 * These are the methods that are called when the document is
 * unhidden or hidden respectively.
 */

- hideDocument:sender;
/*
 * remove this document from the screen (but don't delete it)
 */

- setDocEdited:(BOOL)edited;
- (BOOL)isDocEdited;

- setDocumentName:(const char *)newName;

- save:sender;
- saveAs:sender;
- saveTo:sender;
- revert:sender;
- close:sender;

- dirty:sender;
- checkForEdited:sender;

- windowDidBecomeMain:sender;
- windowDidResignMain:sender;
- windowWillClose:sender;

@end
