/* DocController.h
 * Purpose:  This is the main controlling class for this application.
 *	DocController loads the Info and Help nib files on demand.
 *	DocController also handles the multiple documents that can
 *	be open at any time using the Document class -- including
 *	keeping a count, tracking the current active document, 
 *	managing the open and save panels, etc.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: R. Dunbar Poor
 * Created: 28/April/1991
 *
 */
#import <objc/Object.h>
#import <objc/List.h>

@interface DocController:Object
{
  id	helpPanel;		/* the help panel */
  id	infoPanel;		/* the info panel */
  id	activeDocument;
  /*
   * the following are for debugging (and demonstration) only
   */
  int	documentCount;		/* # of documents */
  id	activeDocumentField;	/* indicator of the current document */
  id	documentCountField;	/* indicator of documentCount */
  /*
   * the following are outlets to menu cells that we want to enable
   * and disable on occasion.
   */
  id	saveMenu;
  id	saveAsMenu;
  id	saveToMenu;
  id	saveAllMenu;
  id	revertMenu;
  id	closeMenu;
}

- init;
- free;

- showInfo:sender;
- showHelp:sender;

- activeDocument;
- setActiveDocument:aDocument;
/*
 * return (or set) the document to which save, saveAs, revert, etc 
 * messages will be sent.
 */

- unsetActiveDocument:aDocument;
/*
 * if aDocument is the activeDocument, resign it from that role.
 */

- open:sender;
- new:sender;
- save:sender;
- saveAs:sender;
- saveTo:sender;
- saveAll:sender;
- revert:sender;
- close:sender;

- performForDocuments:(SEL)aSelector with:anObject;
/*
 * Send [self aSelector :aDocument :anObject] for each Document in the
 * application.
 */

- (int)appOpenFile:(const char *)path type:(const char *)type;
- (BOOL)appAcceptsAnotherFile:sender;
- appDidInit:sender;
- appWillTerminate:sender;

@end
