/* ImageReader.m
 *
 * This file defines the image reading function that lets the user open 
 * a file and display it on the screen.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to
 * its fitness for any particular use.
 */

#import <appkit/OpenPanel.h>	
#import "ImageReader.h"
#import "TiffDocView.h"

@implementation ImageReader

- readImage:sender
{
    id			op;
    const char		*imageFile;
    const char *const	tiffType[2] = {"tiff", NULL};

    /* 
     Run the App's OpenPanel and get the name of the image file to load.
     We filter for TIFF files for simplicity, but without the filter, this
     would work for eps files as well.    See README.
     */
    op = [OpenPanel new];
    [op runModalForDirectory:"~" file: NULL types:tiffType];
    
    /* Only try to read an image if one has been specified */
    if (imageFile = [op filename])
    {
    	[imageView readImageFile: imageFile];
    }
    
    return self;
}


@end
