
/*ImageReader.h
 *   
 * This header file defines the ImageReader class, which reads a TIFF file,
 * allocates an NXImage to manage it, and displays it.
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */


#import <objc/Object.h>

/* 
 * The ImageReader needs one outlet, which it uses to send image data
 * to a TiffDocView (the DocView in the ScrollView of the application's
 * main window), and ultimately to an NXImage.
 */

@interface ImageReader:Object
{
    id	imageView;
}

/* The readImage action opens a TIFF file and sends it to an NXImage object. */

- readImage:sender;

@end
