/*  
 * 
 * BananaSplit.m	-- How to resize an NXSplitView
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by Henry Krempel -- NeXT Developer Support
 *
 */
#import "BananaSplit.h"

@implementation BananaSplit

// Application Delegate Method -- set up the contents of the SplitView

-appDidInit:sender
{
    [doubleView addSubview: topView];
    [doubleView addSubview: bottomView];
    [doubleView display];
    return self;
}

// NXSplitView Delegate methods

// Constrain the divider

- splitView:sender 
    getMinY:(NXCoord *)minY // in the split view's flipped coordinates
    maxY:(NXCoord *)maxY
    ofSubviewAt:(int)offset     // offset = 0 is the first divider
{
    *minY = 100.0;      // approx. 1 in. from top
    *maxY -= 100.0;     // ditto from bottom
    if ( *maxY < 100.0 ) *maxY = 100.0;
    return self;
}

// Use automatic adjuster when the window resizes.  
// If the top view gets too small,  fix it.

- splitView:sender 
    resizeSubviews:(const NXSize *)oldSize
{
    NXRect lower, upper;
    float delta;
    
    [[sender window] disableDisplay];
    [sender adjustSubviews];
    
    [topView getFrame:&upper];
    [bottomView getFrame:&lower];
    if (upper.size.height < 100) {
        delta = 100.0 - upper.size.height;
        upper.size.height=100;
        lower.size.height-=delta;
        [topView setFrame:&upper];
        [bottomView setFrame:&lower];
        }
        
    [[sender window] reenableDisplay];
    [[sender window] display];

    return self;
}

// Window Delegate method -- constrain window resizing

- windowWillResize:sender toSize:(NXSize *)frameSize
{
    if ( frameSize->height < 280 ) frameSize->height=280;
    if ( frameSize->width < 150 ) frameSize->width=150;
    return self;
}

@end
