@Part(CKUNIX,root="kuser")
@string(-ckversion="5A(163)")
@define(exx=example,above 2,below 1)
@define(d4=description,leftmargin +4,indent -4,group,blanklines hinge)
@define(d8=description,leftmargin +8,indent -8,group,blanklines hinge)
@define(d128=description,leftmargin +12,indent -8,group,blanklines hinge)
@define(d62=description,leftmargin +6,indent -2,group,blanklines hinge)
@define(d84=description,leftmargin +8,indent -4,group,blanklines hinge)
@Chapter<C-Kermit>
@index<C-Kermit>@index<UNIX Kermit>

@case(device,file="********@*
This document is formatted as an ordinary, plain text ASCII disk file.
Typeset copies are available in the Kermit User Guide from Columbia
University.  Changes should be made to CKUKER.MSS.@*********")

@Begin<Description,spread 0.2>
@i(Program:)@\Frank da Cruz (Columbia University), contributions by many
others.

@i(Language:)@\C

@i(Documentation:)@\Christine Gianone, Frank da Cruz (Columbia University).

@i(Version:)@\@value(-ckversion)

@i(Date: )@\October 1990
@end<Description>

@subheading<UNIX Kermit Capabilities At A Glance:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfer text files:@\Yes
Transfer binary files:@\Yes
International text:@\Yes
Wildcard send:@\Yes
File transfer interruption:@\Yes
Filename collision actions:@\Yes
Can time out:@\Yes
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Automatic parity detection:@\Yes
Dynamic packet length:@\Yes
CONNECT mode:@\Yes
Terminal emulation:@\Depends on implementation
Communication settings:@\Yes
Transmit BREAK:@\Yes (most versions)
Support for dialout modems:@\Yes
TCP/IP support:@\Yes (BSD UNIX versions)
X.25 support:@\Yes (SUN versions with SunLink)
IBM mainframe communication:@\Yes
Transaction logging:@\Yes
Session logging:@\Yes
Debug logging:@\Yes
Packet logging:@\Yes
Act as server:@\Yes
Talk to server:@\Yes
Advanced server functions:@\Yes
Security for server:@\Yes
Local file management:@\Yes
Command/Init files:@\Yes
Long packets:@\Yes
Sliding Windows:@\Yes
File attributes packets:@\Yes
Command macros:@\Yes
Script programming language:@\Yes
Raw file transmit and capture:@\Yes
@end<format>
@newpage()
@section(Acknowledgements)

Thanks to the dozens of people who have been involved in C-Kermit development
over the years, especially Bill Catchings and Jeff Damens (formerly of
Columbia University), Chris Maio (still of Columbia University), and Herm
Fischer of Encino, CA, for their roles in its initial development.  And
special thanks to those who put so much work into features or testing of
version 5A:
@begin(format, above 1, below 1, leftmargin +4)
Kristoffer Eriksson (Peridot Konsult AB, @uoum()rebro, Sweden)
Bo Kullmar (Sveriges Riksbank (Central Bank of Sweden), Stockholm)
Tor Lillqvist (Helsinki University, Finland)
Warren H@. Tucker (Tridom Corporation, Mountain Park, Georgia, USA)
Peter Mauzey (AT&T Bell Laboratories, Middletown, New Jersey, USA)
Terry Kennedy (St Peters College, Jersey City, NJ, USA)
Chuck Hedrick (Rutgers University, New Brunswick, NJ, USA)
Joe R@. Doupnik (Utah State University, USA)
Ken Yap (University of Rochester, New York, USA)
Marcello Frutig (Catholic University, Rio de Janeiro, Brazil)
Paul Placeway (BBN, Cambridge, Massachusetts, USA)
Chris Adie (Edinburgh University, Scotland, UK)
Chris Armstrong (Brookhaven National Laboratory, New York, USA)
Mark Buda (Digital Equipment Corporation, New Hampshire, USA)
William Bader (Software Consulting Services, Nazareth, PA, USA)
Steve Walton (California State University Northridge, USA)
@end(format)

Kristoffer, Bo, Warren, and Peter comprised the "modem committee", which
worked long and hard to rationalize C-Kermit's treatment of modem signals in
the many and varied Unix environments.  Kristoffer and Bo also contributed
much code to the Unix-specific support modules.  Kristoffer deserves a special
Archaeology Achievement Award for a detailed study and unraveling of many
years' accretions of incomprehensible "magic" in the infamous @q<ckutio.c>
module (a collection of supposedly simple functions that give the emphatic lie
to all claims that Unix is a "portable operating system").

Ken got the TCP/IP support started by supplying the sockets code for the
Berkeley UNIX version.  Marcello supplied the SunLink X.25 code.  Paul, as
always in recent years, is responsible for the Macintosh end, the two Chris's
for the OS/2 version, Terry, William, Mark for the VAX/VMS version, and Steve
for the Amiga version.

Chuck found and fixed many bugs and contributed many valuable insights, as well
as writing the Unix "man page" for C-Kermit 5A.

And thanks to the indefatigable and omniscient Joe Doupnik (author of MS-DOS
Kermit), who worked closely with the authors on the design of the sliding
window algorithms, the script programming language, and the international
character set support during the joint development effort for MS-DOS Kermit
3.0 and C-Kermit 5A (and in his spare time, Joe lent a hand with the AT&T 7300
Unix PC version of C-Kermit).  And finally, thanks to the dozens (hundreds) of
others who tested C-Kermit on dozens (hundreds) of hardware and software
platforms and contributed bug reports, fixes, new features, and suggestions:
Jay Rouman,
Andy Fyfe,
David MacKenzie,
John Chmielewski,
Frank Prindle,
Dean Long,
David A Rasmussen,
Ted Medin,
Farrell Woods,
John Dunlap,
Larry Rosenman,
Roger Wallace,
Jack Bryans,
Drew Burton,
Daniel Senderowicz,
Rich Auletta,
Tye McQueen,
Evan R Moore,
Christian Hemsing,
Jeff Altman,
Irwin Sobel,
Mike Beede,
Charlie Epstein,
Bob Devonshire,
Jim Barbour,
Berthold K.P. Horn,
Allister J. Gorman,
Dave Bruce,
Rick Troth,
Caleb Strockbine,
Charles S. Fuller,
Andy Y.A. Kuo,
Peter Jones,
Lars Kellogg-Stedman,
Patrick Wolfe,
Dennis Pleticha,
John Kesich,
Erik Olsen,
Mark Zinzow,
Tom Wade,
Wally Strzelec,
Lawrence R. Rogers,
Nick Sayer,
Piet W Plomp,
Manfred Prange,
Gary J Rosenblum,
Ethan A Lish,
Bert Laverman,
John Nall,
Didier Marion,
Nate Williams,
Bob Perkins,
Brad Robillard,
Fred van Kempen,
J Roberts,
David Dyck,
G Brendan Reilly,
Matt Sutter,
Sergey Kartashoff,
Michael Yaroslavtsev,
and Konstantin Vinogradov.

@index(C-Kermit)@index(Unix Kermit)
@section(Introduction)

C-Kermit is a communication software program written in C that provides a full
implementation of the Kermit file transfer protocol, plus terminal connection,
modem dialing, file management, and a powerful script programming language.
An important goal of C-Kermit is transportability to different computers and
operating systems.  To date, C-Kermit (one release or another) has been
adapted to UNIX (most versions), VAX/VMS, Data General AOS/VS, IBM OS/2, the
Apple Macintosh, the Commodore Amiga, the Atari ST, Apollo Aegis, OS-9,
Microsoft Windows, NCR 9800/VE, and others.

C-Kermit offers you several methods of interaction.  On UNIX, VAX/VMS, and
other timesharing systems, you have access to Kermit's interactive command
parser, and you can also invoke Kermit with command line options.  On
workstations like the Macintosh, and to some degree the PS/2 with OS/2, there
is a mouse-and-window interface with pull-down menus, radio buttons, and so
forth; these are (or will be) described in separate documents.

Interactive operation gives you full access to all of C-Kermit's features.
Command-line invocation gives you access to a small but useful subset.
Command-line operation is described in Section @ref(-cmdlin).

@section(Interactive Operation)

C-Kermit's interactive command prompt is "@q(C-Kermit>)".  In response to this
prompt, you can type any valid interactive C-Kermit command.  C-Kermit executes
the command and then prompts you for another command.  The process continues
until you instruct the program to terminate.

Commands begin with a keyword, normally an English verb, such as "send".  You
may omit trailing characters from any keyword, as long as you specify
sufficient characters to distinguish it from any other keyword valid in that
field.  Certain commonly-@|used keywords (such as "send", "receive", "connect")
also have special non-@|unique abbreviations ("s" for "send", "r" for
"receive", "c" for "connect").

Command keywords can be entered in either upper or lower case, or any
combination.  This manual shows command keywords in uppercase for clarity.

Certain characters have special functions while you are typing interactive
commands:
@Begin(Description,leftmargin +8,indent -4)
@q(?)@\Question mark, typed at any point in a command, will produce a
message explaining what is possible or expected at that point.  Depending on
the context, the message may be a brief phrase, a menu of keywords, or a list
of files.  Use "?" liberally to feel your way through Kermit's commands.

@q(ESC)@\(The Escape or Altmode key) -- Request completion of the current
keyword or filename, or insertion of a default value.  The result will be a
beep if the requested operation fails.

@q(TAB)@\(The horizontal Tab key) -- Same as ESC.

@q(DEL)@\(The Delete or Rubout key) -- Delete the previous character from the
command.  You may also use BS (Backspace, Control-H) for this function.

@q(^W)@\(Control-W) -- Erase the rightmost word from the command line.

@q(^U)@\(Control-U) -- Erase the entire command.

@q(^R)@\(Control-R) -- Redisplay the current command.

@q(^C)@\(Control-C) -- Interrupt a command.

@q(SP)@\(Space) -- Delimits fields (keywords, filenames, numbers) within
a command.

@q(CR)@\(Carriage Return) -- Enters the command for execution.  LF (Linefeed)
or FF (formfeed) may also be used for this purpose.

@q(\)@\(Backslash) -- Enter any of the above characters into the command
literally.  To enter a backslash, type two backslashes in a row (@q[\\]).
A backslash at the end of a command line causes the next line to be treated
as a continuation line; this is useful for readability in command files.
Backslash is also used to introduce special characters, variable names, 
and functions.  These are explained in Section @ref(-bkslash).

@q(^Z)@\(Control-Z) -- On systems (like Berkeley Unix, Ultrix) with job
control, Control-Z is supposed to suspend Kermit, i.e. put it into the
@index<Background> @i<background> in such a way that it can be brought back
into the foreground (e.g. with an '@q<fg>' shell command) with all its
settings intact.
@End(Description)
You may type the editing characters (@q[DEL], @q[^W], etc) repeatedly, to
delete all the way back to the prompt.  No action will be performed until the
command is entered by typing carriage return, linefeed, or formfeed.  If you
make any mistakes, you will receive an informative error message and a new
prompt -- make liberal use of `@q[?]' and ESC to feel your way through the
commands.  One important command is "help" -- you should use it the first time
you run C-Kermit.

Comments may be entered as entire commands, or may appear at the end of any
command.  Comments are introduced by semicolon (@q[;]) or pound sign (@q[#]).

Interactive C-Kermit accepts commands from files as well as from the keyboard.
When you start C-Kermit, the program looks for a special file, the @i<Kermit
Initialization File> in your home or current directory (first it looks in the
home directory, then in the current one) and executes any commands it finds
there.  These commands must be in interactive format, not command-@|line
format.  The name of the initialization file is @q<.kermrc> in UNIX and
@q<CKERMIT.INI> in other operating systems.

Here is a brief list of C-Kermit interactive commands:
@begin(format,spread 0)
@tabclear()@tabset(1.5inches,2.0inches,2.5inches)
@>@q<;>@\  Introduce a full-line or trailing comment (also @q<#>).
@>@q<!>@\  Execute a system command or enter system command interpreter.
@>@q<@@>@\  Same as @q<!>.
@>ASK@\  Prompt the user, store user's reply in a variable.
@>ASKQ@\  Like ASK, but, but doesn't echo (useful for passwords).
@>ASSIGN@\  Assign an evaluated string to a variable or macro.
@>BUG@\  Instructions for reporting bugs.
@>BYE@\  Terminate and log out a remote Kermit server.
@>CD@\  Change Working Directory (also, CWD).
@>CLEAR@\  Clear communication device input buffer.
@>CLOSE@\  Close a log or other local file.
@>COMMENT@\  Introduce a full-line comment.
@>CONNECT@\  Establish a terminal connection to a remote computer.
@>DECLARE@\  Declare an array.
@>DECREMENT@\  Subtract one (or other number) from a variable.
@>DEFINE@\  Define a variable or macro.
@>DELETE@\  Delete a file or files.
@>DIAL@\  Dial a telephone number.
@>DIRECTORY@\  Display a directory listing.
@>DISABLE@\  Disallow access to selected features during server operation.
@>DO@\  Execute a macro.
@>ECHO@\  Display text on the screen.
@>ELSE@\  ELSE-part of an IF command.
@>ENABLE@\  Allow access to selected features during server operation.
@>END@\  A command file or macro.
@>EXIT@\  Exit from the program, closing all open files and devices.
@>FINISH@\  Instruct a remote Kermit server to exit, but not log out.
@>FOR@\  Execute commands repeatedly in a counted loop.
@>GET@\  Get files from a remote Kermit server.
@>GOTO@\  Go to a labeled command in a command file or macro.
@>HANGUP@\  Hang up the phone or network connection.
@>HELP@\  Display a help message for a given command.
@>IF@\  Conditionally execute the following command.
@>INCREMENT@\  Add one (or other number) to a variable.
@>INPUT@\  Match characters from another computer against a given text.
@>LOG@\  Open a log file -- debugging, packet, session, transaction.
@>MAIL@\  Send a file as electronic mail to a specified address.
@>MSEND@\  Multiple SEND -- send a list of files.
@>OPEN@\  Open a local file for reading or writing.
@>OUTPUT@\  Send text to another computer.
@>PAD@\  (X.25 version only) Give X.25 PAD commands.
@>PAUSE@\  Do nothing for a given number of seconds.
@>PUSH@\  Invoke host system interactive command interpreter.
@>PWD@\  Display current working device/directory.
@>QUIT@\  Same as EXIT.
@>READ@\  Read a line from a local file.
@>RECEIVE@\  Passively wait for files to arrive.
@>REINPUT@\  Reexamine text previously received from another computer.
@>REMOTE@\  Issue file management commands to a remote Kermit server.
@>RENAME@\  Change the name of a file.
@>RETURN@\  Return from a user-defined function.
@>RUN@\  Run a program or system command.
@>SCRIPT@\  Execute a UUCP-style login script.
@>SEND@\  Send files.
@>SERVER@\  Begin server operation.
@>SET@\  Set various parameters.
@>SHOW@\  Display values of SET parameters.
@>SPACE@\  Display current disk space usage.
@>STATISTICS@\  Display statistics about most recent transaction.
@>STOP@\  Stop executing macro or command file and return to the prompt.
@>SUSPEND@\  Put the Kermit program in the backgound.
@>TAKE@\  Execute commands from a file.
@>TRANLATE@\  Translate a file's character set.
@>TRANSMIT@\  Upload a file with no error checking.
@>TYPE@\  Display a file on the screen.
@>VERSION@\  Display the program version number on the screen.
@>WAIT@\  Wait for the specified modem signals.
@>WHILE@\  Execute commands repeatedly while a condition is true.
@>WRITE@\  Write text to a local file.
@>XIF@\  Extended IF command.
@end(format)

On most computers, C-Kermit can be started simply by typing the word "kermit"
(followed by carriage return).  If no command-line options are included,
Kermit will automatically enter interactive prompting mode.  Let's begin by
looking at a few of C-Kermit's basic interactive commands.  Most important
of all when your are just beginning are the commands to exit from the program
and to get help about it.

@subheading(The EXIT and QUIT Commands)

These two commands are identical.  Both of them do the following:

@begin(itemize,spread 0)
Hangs up the modem, if the communications line supports data terminal ready.

Relinquish access to any communication line assigned via SET LINE, or any
network connection obtained via SET HOST.

Relinquish any uucp and multiuser locks on the communications line (Unix only).

Closes all open logs or other files.

Attempts to insure that the terminal is returned to normal.
@end(itemize)
After exit from C-Kermit, your default directory will be the same as when
you started the program.  The EXIT command is issued implicitly whenever
C-Kermit halts normally, e.g. after a command line invocation, or after certain
kinds of interruptions.

C-Kermit returns an exit status of zero, except when an error is
encountered, where the exit status is set to a nonzero number, depending on
the operating system.  In UNIX, the exit status is the sum of 1 (if any SEND
commands failed), 2 (if any RECEIVE or GET commands failed), and 4 (if any
REMOTE commands failed).

With background operation (e.g., `@q(&)' at end of invoking command line)
driven by scripted interactive commands (redirected standard input and/or take
files), any failed interactive command (such as failed dial or script attempt)
causes the fatal error exit.

@subheading(The HELP Command)

Syntax: HELP [ { @i<command>, { SET, REMOTE } @i<parameter> } ]

Brief help messages or menus are always available at interactive command
level by typing a question mark at any point.  A slightly more verbose form
of help is available through the HELP command.  The HELP command with
no arguments prints a brief summary of how to enter commands and how to
get further help.  HELP may be followed by one of the top-level C-Kermit
command keywords, such as SEND, to request information about a command.
Commands such as SET and REMOTE have a further level of help.  Thus you
may type HELP, HELP SET, or HELP SET PARITY; each will provide a
successively more detailed level of help.

@subheading(The TAKE Command)

Syntax: @q<TAKE >@i<fn1>

The TAKE command instructs C-Kermit to execute commands from the named
file.  The file may contain any interactive C-Kermit commands, including
TAKE; command files may be nested to any reasonable depth, but it may
not contain text to be sent to a remote system during the CONNECT command;
Use scripts for that (see sections @ref<-macros> and @ref<-scrcmd>).

Echoing of commands from TAKE files and handling of errors during TAKE file
execution are controlled by the SET TAKE command.

Comments may be included in take-command files.  Whole-line comments may begin
with the word COMMENT.  Both trailing and whole-line comments can be
introduced using semicolon or pound sign, for example:
@begin(example)
COMMENT - Commands to dial out out using a Hayes modem...
set modem hayes        ; Specify the kind of modem
set line /dev/ttyh8    ; Select a terminal device
set speed 19200        ; Set the speed
dial 7654321           ; Dial the number
@end(example)

TAKE-command files are in exactly the same syntax as interactive commands.  If
you want to include special characters like question mark or backslash that
you would have to quote with backslash when typing interactive commands, you
must quote these characters the same way in command files.  Long lines may be
continued by ending them with a single backslash or a dash:
@begin(example)
set\
modem\
hayes
set-
line /dev-
/ttyh8
@end(example)
Continued lines cannot have trailing comments.  If you put a trailing comment
after the dash, then Kermit will not treat the line as continued.  If you put
a dash at the end of a trailing comment, then Kermit will treat the next line
as a continuation of the comment.

An implicit TAKE command is executed upon your C-Kermit initialization file
(@q<.kermrc> in UNIX, @q<CKERMIT.INI> elsewhere) when C-Kermit starts up, upon
either interactive or command-line invocation.  The initialization file may
contain SET or other commands you want to be in effect at all times.  For
instance, you might want override the default action when incoming files have
the same names as existing files -- in that case, put a command like:
@example(set file collision overwrite)

Under Unix, you may also use the shell's redirection mechanism to cause
C-Kermit to execute commands from a file:
@example(kermit < cmdfile)
or you can even pipe commands in from another process:
@example(command | kermit)

@section(Establishing the Connection)

In order to talk about a connection between two computers, we a way to
distinguish between them.  The @i<local> computer is the one that you are
using most directly -- a PC or workstation on your desk, or a timesharing
computer that you are using from a terminal.  Kermit lets you make a
connection from the local computer to a @i<remote> computer, for example by
dialing it up with a modem.  The Kermit program on your local computer is said
to be in "local mode" and the Kermit program on the remote computer is in
"remote mode".

C-Kermit can be used in either @i<remote> or @i<local> mode.  If you are using
C-Kermit in remote mode, you can skip ahead to Section @ref(-filxfer), File
Transfer.

If you are using C-Kermit in local mode, you must have one of three kinds
of connections to the remote computer:
@begin(enumerate)
A hardwired asynchronous serial connection, either directly to the other
computer, or through some kind of terminal server or switching device.

A dialup connection, which you establish by dialing with a modem.

A network connection.
@end(enumerate)
To prepare C-Kermit for these connections, several preliminary steps are
necessary using the SET command, which is described in Section
@ref(-setshow), below:
@begin(enumerate)
Direct connection: SET LINE @i<device-name>, SET SPEED @i<bits-per-second>.

Dialup connection, which you establish by dialing with a modem: SET MODEM
@i<modem-type>, SET LINE @i<device-name>, SET SPEED @i<bits-per-second>, DIAL
@i<phone-number>.

Network connection: SET HOST @i<network-host-name>.
@end(enumerate)
In addition, you must establish whatever other communication related settings
are appropriate for the connection, including PARITY, DUPLEX, FLOW, and
HANDSHAKE.  Having done all this, you can use the CONNECT command to
begin a terminal session with the remote computer, and once connected, you can
initiate file transfers.

@subheading(The CONNECT Command)

The CONNECT command (C is a special abbreviation for CONNECT) links your
terminal to another computer as if it were a local terminal to that computer,
through the device specified in the most recent SET LINE or SET HOST command,
or through the default device if your system is a PC or workstation.  All
characters you type at your keyboard are sent out the communication line (and
if you have SET DUPLEX HALF, also displayed on your screen), and all
characters arriving at the communication port are displayed on the screen.
Current settings of speed, parity, duplex, and flow-@|control are honored, and
the data connection is 7 bits wide unless you have given the command SET
TERMINAL BYTESIZE 8.  If you have issued a LOG SESSION command, everything
you see on your screen will also be recorded to your session log.  This
provides a way to "capture" files from remote systems that don't have Kermit
programs available.

To get back to your own system, you must type the "escape character", which is
Control-@|Backslash (@q[^\]) unless you have changed it with the SET ESCAPE
command, followed by a single-@|character command, such as C for "close
connection".  Single-@|character commands may be entered in upper or lower
case.  They include:
@begin(description,leftmargin +8,indent -6,spread 0.4)
@q<C>@\Return to C-Kermit.  If you gave an interactive CONNECT command,
return to the C-Kermit prompt.  If you gave a -c or -n option on the command
line, close the connection and return to the system prompt.

@q<B>@\Send a BREAK signal.

@q<0>@\(zero) send a null.

@q<S>@\Give a status report about the connection.

@q<H>@\Hangup the phone.

@q<!>@\Escape to the system command processor "under" Kermit.  Exit or logout
to return to your CONNECT session.

@q<Z>@\Suspend Kermit (UNIX only).

@q<\nnn>@\A character in backslash-code form.

@q[^\]@\Send Control-Backslash itself (whatever you have defined the
escape character to be, typed twice in a row sends one copy of it).
@end(description)
Uppercase and control equivalents for (most of) these letters are also
accepted.  A space typed after the escape character is ignored.  Any other
character will produce a beep.

The connect command simply displays incoming characters on the screen.  It is
assumed any screen control sequences sent by the host will be handled by the
firmware or emulation software in your terminal or PC@foot(Several C-Kermit
implementations include terminal emulators, notably Macintosh and OS/2).

It is sometimes useful to see exactly what characters the host is
transmitting, rather than having your terminal or emulator interpret them for
you.  If you give the command SET DEBUG SESSION, then during CONNECT, C-Kermit
will display control characters using "uparrow" notation, for example @q<^A>
for Control-A, @q<^B> for Control-B, etc, @q<^[> for ESC.  8-bit characters
are preceded by a tilde (@q<~>) character.

@subheading(The DIAL Command)

Syntax: @q(DIAL )@i(telephone-number)

@index<Modem>@index<Dialout Modem>@index<Autodialer>

The DIAL command controls dialout modems; you should have already issued a SET
MODEM command to identify the type of modem to be used for dialing, and then
SET LINE and SET SPEED commands to identify the terminal device to which the
modem is connected.  In the DIAL command, you supply the phone number and the
Kermit program feeds it to the modem in the appropriate format and then
interprets dialer return codes and modem signals to inform you whether the
call was completed.  These actions are based upon built-in knowledge of the
control sequences and responses of each make and model of modem that C-Kermit
knows about.

The telephone-@|number may contain imbedded modem-@|dialer commands
appropriate to the selected modem type, such as comma for Hayes pause, or
`@q(&)' for Ventel dialtone-@|wait and `@q(%)' for Ventel pause (consult your
modem manual for details).

At the time of this writing, support is included for the following modems:
@begin(itemize,spread 0)
AT&T 7300 Internal Modem

AT&T 2212C, 2224B, 2224CEO, and 2296A switched network modems in AT&T mode

AT&T Digital Terminal Data Module (DTDM)

Cermetek Info-Mate 212A

Concord Condor CDS 220

Courier HST

DEC DF03-AC

DEC DF100 Series

DEC DF200 Series

General DataComm 212A/ED

Hayes Smartmodem and compatibles

IBM/Siemens/Rolm 9751 CBX

Microcom AX-9624

Penril

Racal Vadic

US Robotics 212A

Ventel
@end(itemize)
Support for new modems is added to the program from time to time; you
can check the current list by typing SET MODEM ?.

There are also two "generic" modem types -- DIRECT (i.e. no modem at all,
so that no attempt is made to deal with modem signals), and UNKNOWN (which
tells C-Kermit to attempt to honor modem signals, but leaves the dialing
mechanism unspecified).  NONE is a synonym for DIRECT.

The device used for dialing out is the one selected in the most recent SET
LINE command (or on a workstation, the default line if no SET LINE command
was given).  On Unix systems, 
the DIAL command attempts to lock the terminal device's
path and to establish a call on an
exclusive basis.  If it is desired to dial a call and then return to the shell
(such as to do Kermit activities depending on standard in/out redirection), it
is necessary to place the dialed call under one device name (say,
"@q</dev/cua0>") and then escape to the shell @i<within Kermit> on a linked
device which is separate from the dialed line (say, "@q</dev/cul0>").  This is
the same technique used by uucp (to allow locks to be placed separately for
dialing and conversing).

Because modem dialers have strict requirements to override the carrier-@|detect
signal most Unix implementations expect, the sequence for dialing is more rigid
than most other C-Kermit procedures.  Example:
@begin(example)
@ux<kermit>
C-Kermit>@ux<set modem hayes>      ; SET MODEM first!
C-Kermit>@ux<set line /dev/acu2>   ; Then SET LINE,
C-Kermit>@ux<set speed 2400>       ; SET SPEED,
C-Kermit>@ux<dial 9,5551212>       ; and DIAL.
Connected!                         ; If DIAL completes OK,
C-Kermit>@ux<connect>              ; you can CONNECT.
@i(logon, do things)
@ux<^\c>
C-Kermit> ...
C-Kermit>@ux<quit>
@end(example)
This disconnects modem, and unlocks line.

In general, C-Kermit requires that the modem provide the "carrier detect" (CD)
signal when a call is in progress, and remove that signal when the call
completes or the line drops.  If a modem switch setting is available to force
CD, it should normally not be in that setting.  C-Kermit also requires (on most
systems) that the modem track the computer's "data terminal ready" (DTR)
signal.  If a switch setting is available to simulate DTR asserted within the
modem, then it should normally not be in that setting.  Otherwise the modem
will be unable to hang up at the end of a call or when interrupts are received
by Kermit.

For Hayes 1200 @index<Hayes Modem> dialers, two important switch settings are
#1 and #6.  Switch #1 should be normally be UP so that the modem can act
according to your computer's DTR signal.  But if your computer, or particular
implementation of Kermit, cannot control DTR, then switch 1 should be DOWN.
Switch #6 should normally be UP so carrier-@|detect functions properly (but
put it DOWN if you have trouble with the UP position).  Switches #2 (English
versus digit result codes) and #4 (Hayes echoes modem commands) may be in
either position.  Hayes 2400 modems have equivalent "software" switches.

If you want to interrupt a DIAL command in progress (for instance, because
you just realize that you gave it the wrong number), type a Control-C
get back to command level.  If you are a UNIX user and your "interrupt
character" is defined as something besides Ctrl-C, use that instead.

PROBLEMS: The DIAL command hangs up the phone (see HANGUP) prior to dialing.
Because of the problems described for HANGUP, certain UNIX configurations are
unable to use DIAL when it does this.  To work around this problem, give the
command SET DIAL HANGUP OFF before giving the DIAL command.  If DIAL still
doesn't work right, start over again but this time give the command SET
CARRIER OFF prior to SET LINE.

@subheading(The HANGUP Command)

The HANGUP command attempts to hang up the modem on a local-mode dialout
connection established by SET LINE, or to hang up the network connection
established by SET HOST, in order to break the connection.  On terminal
devices, Kermit accomplishes the hangup by momentarily turning off the Data
Terminal Ready (DTR) RS-232 signal.

The means used to drop DTR and bring it back up again are highly dependent on
the computer, the version of UNIX, the communication device, the device
driver, the modem being used, and even the cable that connects the modem to
the communication device.  Therefore you might find that this command fails to
operate as it should.

If the HANGUP command fails to hang up a phone connection, then maybe your
modem is configured to ignore DTR.  You should make sure your modem is
configured to pay attention to the computer's DTR signal.  Another possibility
is that your cable is giving the modem a constant DTR signal, looped back from
its own DSR signal; in that case, replace your cable with a regular
straight-through modem cable.

If the HANGUP command does indeed hang up the phone connection, but then
you can't communicate with the modem any more to establish a new connection,
your version of UNIX has dropped the DTR signal, but failed to bring it back
up again properly.  To work around this problem, give the SET LINE command
(with no device name) to close the current device, and then another SET LINE
command specifying the original device to open it again.

@section(File Transfer)
@label(-filxfer)

Kermit programs can transfer files correctly and completely, using the Kermit
file transfer protocol.  A Kermit program must be running on both computers.
Here is the normal procedure:
@begin(enumerate)
Run Kermit on your local computer.

Make the appropriate communication settings (such as modem type, line, speed,
parity, etc).

Establish a connection to the remote computer (DIAL if necessary).

CONNECT to the remote computer.

Log in to the remote computer if necessary.

Start Kermit on the remote computer and tell it to send (or receive) a
file (or files).

"Escape back" to the local computer.

Tell the local computer to receive (or send) a file (or files).
@end(enumerate)

When transferring files, C-Kermit converts between upper and lower case
filenames and between LF and CRLF line terminators automatically, unless told
to do otherwise.  When binary files must be transferred, the program should be
instructed not to perform LF/CRLF conversion (@q[-i] on the command line or
SET FILE TYPE BINARY interactively; see below).

If C-Kermit is in local mode, the screen is continously updated to
show the progress of the file transer.  A dot is printed for every four data
packets, other packets are shown by type:
@begin(description,leftmargin +6, indent -2, spread 0)
I@\Exchange Parameter Information

R@\Receive Initiation

S@\Send Initiatiation

A@\Attribute Packet

F@\File Header

G@\Generic Server Command

C@\Remote Host Command

N@\Negative Acknowledgement (NAK)

E@\Fatal Error

T@\Indicates a timeout occurred

Q@\Indicates a damaged, undesired, or illegal packet was received

@q<%>@\Indicates a packet was retransmitted
@end(description)
You may type the following interruption commands during file transfer:
@begin(description,leftmargin +6,indent -2,spread 0)
F@\Interrupt the current File, and go on to the next (if any).

X@\Interrupt the entire Batch of files, terminate the operation.

R@\Resend the current packet.

E@\Error: terminate the current operation immediately and return to prompt.

A@\Display a status report for the current operation.
@end(description)

@i(EMERGENCY EXIT:)@index<Emergency Exit>
When running C-Kermit in remote mode, if you have started a protocol operation
(sending or receiving a file, server command wait, etc), you can type two
Control-C's directly to the Unix Kermit program ("connect" first if
necessary):
@display<Control-C Control-C>
This will cause the program to display,
@display<@q[^C^C...]>
and return you to the C-Kermit prompt.

Before initiating a file transfer, you should be sure that all communication
and protocol-related settings are correct.  Version 5A of Kermit attempts to
make things easier for you in this area in several ways, for example by
recognizing file attributes (text or binary, character set, etc) from the
other Kermit if it sends them.  @index<Parity>If your parity is set to NONE,
C-Kermit automatically recognizes parity bits on received packets, and adjusts
its parity accordingly.  But it's better to set these C-Kermit parameters
directly yourself to avoid any confusion that might result from these
automatic adjustments.

@subheading<The SEND Command>

Syntax:  @q<SEND >@i(fn) [ @i<rfn1> ]

Send the file or files denoted by @i(fn) to the other Kermit, which should be
running as a server, or which should be given the RECEIVE command.  The
SEND command may be abbreviated to S, even though S is not a unique
abbreviation for a top-level C-Kermit command.  Each file is sent under its
own name (as described above, or as specified by the 'set file names'
command).  If the second form of the SEND command is used, i.e@. with
@i(fn1) denoting a single file, @i(rfn1) may be specified as a name to
send it under.  For example:
@example[send sows.ear silk.purse]
sends the file @q[sows.ear] but tells the other Kermit that its name is
@q[silk.purse].

@subheading<The MSEND Command>

Syntax:  @q<MSEND >@i(fn) [ @i<fn> [ @i<fn> [ ... ] ] ]

The MSEND command also sends one or more files, but unlike the SEND command,
it allows you to give a list of files to send, and it does @i<not> allow you
to specify an alternate name.  The MSEND file specifications are separated by
spaces.

@index<Wildcard>@index<Metacharacter>
Both the SEND and MSEND commands allow you to use wildcard (meta) characters
to specify groups of files.  Exactly which wildcard characters are available
depend on the host operating system and other factors.  In VAX/VMS, they are
`@q[*]' and `@q[%]'.  In UNIX they are `@q[~]', `@q[*]', and `@q[?]'.  If
`@q[?]'  is to be included, it must be prefixed by `@q[\]' to override its
normal function of providing help.  The `@q[*]' character matches any string,
and `@q[?]' (UNIX) or `@q[%]' (VMS) matches any single character.

When @i(fn) contains `@q[*]' or `@q[?]' characters, there is a limit
to the number of files that can be matched, which varies from system to
system.  If you get the message "Too many files match" then you'll have to
make a more judicious selection.  For example, if @i(fn) was of the form:
@example(usr/longname/anotherlongname/*)
then C-Kermit's string space will fill up rapidly -- try using CD to change
your directory to the path in question and reissuing the command.

Wildcards do not descend through a directory tree.  Only files in the current
or specified directory are sent.

In UNIX versions of C-Kermit only, `@q[~]' is treated as a meta character
if it is the first character in the file specification. If it is followed
immediately by a slash, a space, or end of line, then your login directory
name is substituted.  If it is followed immediately by a username, then that
user's login directory name is substituted.  (In VAX/VMS, you can use logical
names in the file specification for the same purpose.)

@b<Wildcard Notation for UNIX>

Normally, C-Kermit expands wildcard characters itself by searching through the
disk and matching names against the pattern you specify.  But Kermit's
pattern-matching abilities are limited to the metacharacters listed above.
UNIX shells like csh and ksh, on the other hand, offer notations for file
groups, like `@q([bcdfhjlns]og)' or `@q(*.{txt,doc})' that Kermit cannot
handle on its own.  Kermit lets you get at these capabilities with the
command:

@q<SET WILDCARD-EXPANSION { KERMIT, SHELL }>

The default is KERMIT, meaning Kermit itself expands wildcards in SEND and
MSEND, as well as what it receives while in server mode from GET commands.
The SHELL option means Kermit calls upon the user's preferred shell (via the
SHELL environment variable, or failing that, the user's login shell via
getpwuid) to expand them.

Advantages of the SHELL method include more flexibility in file selection,
consistency with the user's shell, and ability to handle a larger number of
files.  But there are drawbacks.  It's noticably slower.  Characters in
filenames that are special to the shell (like |, &, `, etc) must be quoted
with \ (this is not necessary when Kermit expands).  And the same Kermit
command (SEND, MSEND, or GET sent to a server) may behave differently
depending on what your login shell is.  For example, @qq<{aaa,bbb}> is expanded
by the csh, but taken literally by sh and ksh; @qq<[a-z]> is expanded by csh
and ksh, but taken literally by sh.

The expansion is done by passing "echo " concatenated with the user's filespec
to the shell.  This assumes that echo is a built-in shell command, or if it's
not, then the echo program is in the user's path (risky).  "echo" is used
rather than "ls -d" because ls says "xxx not found" if xxx does not exist
(unfortunately, the csh version of "echo" says "echo: no match" if you give it
a string containing metacharacters and no files match, wherease sh and ksh
simply echo the string back at you).  It doesn't matter much, because C-Kermit
checks each word that is returned for its existence as a file (but of course,
you could have a file called "echo:", "no", or "match"...).  And then what
happens if your have a file called "@q<-n>"?  ("@q<echo> @q<-n>" is a command.
Refer to a file called "@q<-n>" in the current directory as "@q<./-n>").

@b<Text vs Binary Files>

@index<Binary Files>@index<Attributes>
When C-Kermit sends each file, it also sends certain information about the
file in an "attribute packet", provided the other Kermit agrees to accept
attribute packets.  This information includes the size, type (text
or binary, determined from the "-i" command-line option or the "set file type"
command), creation date, and a code to let the other Kermit know that the file
is being sent from a Unix system.  The other Kermit may accept or refuse the
file based upon these attributes, for example, if it doesn't have enough disk
space to store a file of the specified size.

The file type attribute allows C-Kermit, when sending a file, to tell the
receiving whether it should be in text or binary mode.  Therefore, if the
receiving Kermit has this feature, it is not necessay to give it a SET FILE
TYPE command to "match modes" with C-Kermit.

@i<Note> -- C-Kermit sends only from the current or specified directory.  It
does not traverse directory trees.  If the source directory contains
subdirectories, they will be skipped.  By the same token, C-Kermit does not
create directories when receiving files.  If you have a need to do this, you
can pipe tar through C-Kermit, as shown in the example in section
@ref(-cmdlin), or under AT&T System III/V Unix you can use cpio, or BACKUP
under VAX/VMS, etc.

@i<Another Note> -- The SEND command skips over "invisible" files
that match the file specification; Unix systems usually treat files whose names
start with a dot (like @q(.login), @q(.cshrc), and @q(.kermrc)) as invisible.
If you want to send these, include the dot in your filespec, as in:
@example(send .*)

@subheading<The RECEIVE Command>

Syntax:  @q<RECEIVE> [@i<fn1>]

Passively wait for files to arrive from the other Kermit, which must be given
the SEND command -- the RECEIVE command does not work in conjunction with a
server (use GET for that).  If @i(fn1) is specified, store the first incoming
file under that name.  The RECEIVE command may be abbreviated to R.

@index(Binary Files)@index<Attributes>
Incoming file data is normally decoded and stored according to whether
C-Kermit is in text or binary mode.  But if the other Kermit sends the
file-type attribute, this will override C-Kermit's file-type setting on a
per-file basis.  Therefore, it is possible for another Kermit program to send
C-Kermit a mixture of text and binary files, so long as the type of each file
is indicated in the Attribute packet.  For text files, C-Kermit will perform
character-set translation if a known transfer character set is indicated in the
Attribute packet (see section on International Characters).

C-Kermit also attempts to store the incoming file with the creation date
that is specified in the Attribute packet.  C-Kermit does not attempt to
verify disk space against the announced size of the incoming file.

You can control C-Kermit's use of these attributes using the SET ATTRIBUTE
command.

@subheading(The STATISTICS Command)

The STATISTICS command displays information about the most recent Kermit file
transfer or other protocol transaction, including file and communication line
input and output, timing and efficiency, as well as what encoding options were
in effect (such as 8th-bit prefixing, repeat-@|count compression, packet
lengths, window size).

@subheading(Non-Protocol Data Transfers)

It is also possible to transfer files with other computers that do not have a
Kermit program available.  To send a file to such a computer, use the TRANSMIT
command:

Syntax: @q<TRANSMIT> @i<fn1> [@i<c>]

This command sends the named file without error checking, obeying current
settings for file type (text or binary), parity, and duplex.

In text mode, send the file a line at a time, using the character @i<c> as a
line turnaround character.  That is, send a line from the file, wait until the
character @i<c> comes in response, then send the next line, and so on.
Linefeed (10) is the default turnaround character.  If zero (0) is specified
for the turnaround character, then send the whole file without waiting for any
response.  Each line is terminated by a carriage return, just as you would
type it at a terminal.  Linefeeds are stripped unless you have given the
command SET TRANSMIT LINEFEED ON.  The computer to which
you are transmitting the file should be prepared to receive it, for instance
into a text editor.

In binary mode, send all the characters of the file with no modification and
no line turnaround handshake.  Use binary mode only if you know that the
computer or device to which you are transmitting the file can receive
arbitrary patterns of characters at full speed.

The TRANSMIT command can be interrupted by typing Ctrl-C.  Also see SET
TRANSMIT.

The opposite of TRANSMIT is LOG SESSION, which lets you capture files or
screen data from remote computers during CONNECT, also without error checking.

@section(Being and Using a Kermit Server)
@label(-server)

The SERVER command places C-Kermit in "server mode" on the currently selected
communication device or network connection.  All further commands must arrive
as valid Kermit packets from the Kermit on the other end of the line.  If you
are running C-Kermit on the remote computer, then you should escape back to
your local computer after you give C-Kermit the SERVER command, and then issue
all further commands to the C-Kermit server from your local Kermit's command
prompt.  It is also possible to work the other way: your local computer is the
Kermit server and the remote computer issues the commands -- this can only
work if the remote Kermit is driven by a TAKE command file (which should end
with the command FINISH).

The C-Kermit server can respond to the following commands from the client:
@begin(format,spread 0,above 1,below 1,leftmargin +2)
@tabclear()@tabset(2.25inches)
@ux<Client Command>@\@ux<Server Response>
  GET@\  Sends files
  SEND@\  Receives files
  MAIL@\  Sends incoming files as e-mail to specified address
  BYE@\  Attempts to log itself out
  FINISH@\  Exits to level from which it was invoked
  REMOTE CD@\  Changes working directory (also, remote cd)
  REMOTE DIRECTORY@\  Sends directory lising
  REMOTE DELETE@\  Removes files
  REMOTE HELP@\  Lists these capabilities
  REMOTE HOST@\  Executes a Unix shell command
  REMOTE PRINT@\  Receives a file and prints it
  REMOTE SET@\  Changes its settings
  REMOTE SPACE@\  Reports about its disk usage
  REMOTE TYPE@\  Sends files to your screen
  REMOTE WHO@\  Shows who's logged in
@end(format)

If the Kermit server is directed at an external line (i.e. it is in "local
mode") then the console may be used for other work if you SET FILE DISPLAY OFF
and run it in the background; normally the program expects the console to be
used to observe file transfers and enter status queries or to interrupt
commands.  The way to get C-Kermit into background@index<Background> operation
from interactive command level varies from system to system (e.g. on Berkeley
Unix you would halt the program with @q(^Z) and then use the C-Shell 'bg'
command to continue it in the background).  The more common method is to
invoke the program with the desired command line arguments, including
"@q(-q)", and with a terminating "@q(&)".

The C-Kermit server will accept a list of files in GET commands sent by
the client, similar to the list you can give to the MSEND command, e.g.:
@begin<example>
MS-Kermit>@ux[get ~joe/new.txt /etc/termcap ../*.c]
@end<example>
The file specifications are separated by spaces.

When the Unix Kermit server is given a REMOTE HOST command, it executes it
using the shell invoked upon login, e.g. the Bourne shell, the Korn Shell, or
the Berkeley C-Shell (or whatever the user has set her SHELL environment
variable to be).

The server can issue periodic NAK packets.  You can control the rate at which
this happens via SET SERVER TIMEOUT.  Specifiying a value of zero instructs
C-Kermit not to do this at all.  A nonzero value, n, makes a NAK appear every
n seconds during server command wait.  This is useful if the client Kermit is
not capable of timeouts, and a packet that it sends to the server is lost.
The default server timeout is zero.

SECURITY.  Before putting C-Kermit into server mode, you can give it commands
to restrict the types of access it allows to clients.  The command is DISABLE.
You can turn these accesses back on using the ENABLE command.  Here are the
items that can be controlled in this way, with the effect of DISABLE noted.
CAUTION: If you leave HOST enabled, the client can get around some of these
restrictions with REMOTE HOST commands.
@begin(description,spread 0)
BYE@\Ignore BYE commands from the client, stay in server mode.

CD@\Don't let the client change directories, or send files to, or get files
from, or delete or type files in, any but the current directory, nor inquire
about space in any but the current directory.

DELETE@\Don't let the client delete any files.

DIRECTORY@\Don't let the client request a directory listing.

FINISH@\Ignore FINISH commands from the client, stay in server mode.

GET@\Don't let the client GET files.

HOST@\Ignore REMOTE HOST commands from the client.

SEND@\Don't accept files that the client tries to send.

SET@\Refuse REMOTE SET commands from the client.

SPACE@\Refuse REMOTE SPACE commands from the client.

TYPE@\Refuse REMOTE TYPE commands from the client.

WHO@\Refuse REMOTE WHO commands from the client.

ALL@\All of the above.
@end(description)

@subheading(Using a Kermit Server)

C-Kermit may itself request services from a remote Kermit server.
To send a file to a Kermit server, use the SEND command, just as you would to
send a file to a Kermit program that has been given the RECEIVE command.  But
you cannot use the RECEIVE command to get a file from a Kermit server, because
the RECEIVE command just waits passively for a file to arrive, but the server
has not been told which file to send.  For this, you need the GET command:

Syntax:@q<  GET >@i<rfn>
@begin(example)
    @i<or>: GET
            @i(rfn)
            @i(fn1)
@end(example)

The GET command requests a remote Kermit server to send the named file or
files, it must be used in place of RECEIVE.
Since a remote file specification (or list) might contain spaces,
which normally delimit fields of a C-Kermit command, an alternate form of the
command is provided to allow the inbound file to be given a new name: type GET
alone on a line, and you will be prompted separately for the remote and local
file specifications, for example:
@Begin(Example)
C-Kermit>@ux(get)
 Remote file specification: @ux(profile exec)
 Local name to store it under: @ux(profile.exec)
@End(Example)
If a `@q[?]' is to be included in the remote file specification, you must
prefix it with `@q[\]' to suppress its normal function of providing help.

If you have started a multiline GET command, you may escape from its
lower-@|level prompts by typing a carriage return in response to the prompt,
e.g.
@Begin(Example)
C-Kermit>@ux(get)
 Remote file specification: @ux(foo)
 Local name to store it under: @i<(Type a carriage return here)>
(cancelled)
C-Kermit>
@End(Example)

After the GET command has been entered, the file transfer proceeds exactly
as if you had given a SEND command to the other Kermit and a RECEIVE
command to this one.

In addition to SEND and GET, the following commands may also be sent from
C-Kermit to a Kermit server.  If the server does not support a command that
you send to it, it will respond with a message like "Unknown server command"
or "Unimplemented REMOTE command".
@begin(d84)
REMOTE CD [@i(directory)]@\Request the server to change its default directory
(and/or device) to the one you specify.  If none is specified, the server
is requested to return to its primary default directory (normally the login
directory).

REMOTE DELETE @i<rfn>@\The server is requested to delete the specified file or
files.

REMOTE DIRECTORY [@i(rfn)]@\The server is requested to send a directory
listing of the specifed files.  If no files are specified, then the server
should send a listing of all the files in the current directory.

REMOTE HELP@\The server is requested to send to your screen a list of the
commands that you may issue to it from your local Kermit.

REMOTE HOST @i(command)@\The server is requested to ask its host operating
system to execute the given command.

REMOTE PRINT @i(file) [@i(options)]@\The file is sent to the server, which is
requested via Attribute packet to print it on its printer using the specified
print options.

REMOTE SET @i<parameter> @i<value>@\The server is requested to set the given
parameter to the specified value.  Use question mark to find out what
parameters and values are available.  The meanings of these parameters and
values are explained in the section on the SET command, below.  Perhaps the
most useful one is REMOTE SET FILE TYPE { TEXT, BINARY }.

REMOTE SPACE [@i(dir)]@\The server is requested to report on available disk
space in the specified device and/or directory, or in the current area if none
specified.

REMOTE TYPE [@i(rfn)]@\The server is requested to send the specified file for
display on your screen.

REMOTE WHO [@i(user)]@\The server is requested to send a list of the users who
are logged in on its computer.  If a username is given, information about that
user is requested.

BYE @i(and) FINISH:@\When connected to a remote Kermit server, these commands
cause the remote server to terminate; FINISH returns it to Kermit or system
command level (depending on the implementation or how the program was invoked);
BYE also requests it to log itself out.
@end(d84)

@section(International Character Sets)

Text files may be written in languages other than English, and in most cases
that means that they contain non-ASCII characters such as accented letters,
special punctuation marks, etc.  Many different character sets have been
devised to represent different languages.  These character sets are sometimes
specific to a particular computer manufacturer, and sometimes they conform to
one standard or another.  The Kermit file transfer protocol permits Kermit
programs to exchange files written in different character sets by translating
between each computer's local file character set and a standard set that is
used "on the wire".  Here are the relevant commands:
@begin(d84)
SET FILE TYPE TEXT@\Character set translation is not done at all unless the
file type is text.

SET TRANSFER CHARACTER-SET @i<name>@\Tell C-Kermit which character set is to be
used on the wire, i.e. within the Kermit packets.  The choices are TRANSPARENT
(no translation, this is the default), ASCII (translate to/from US ASCII),
LATIN1 (ISO 8859-1 Latin Alphabet 1), and CYRILLIC (ISO 8859-5 Latin/Cyrillic
Alphabet).

SET FILE CHARACTER-SET @i<name>@\Tell C-Kermit which character set is used in
the local file, ASCII, or any of a dozen or so 7-bit national replacement
character sets (NRCs) such as ITALIAN, NORWEGIAN, etc, or an 8-bit character
set like LATIN1, DEC-MCS, ALT-CYRILLIC, KOI-CYRILLIC, or LATIN-CYRILLIC.

SET LANGUAGE @i<name>@\Enable certain language-specific translations,
especially for ICELANDIC, GERMAN, RUSSIAN, and the Scandinavian languages.
@end(d84)
These commands are described in more detail later.

When sending a file, C-Kermit translates the file from the specified file
character set into the specified transfer character set, and the code for the
selected transfer character set is included in the file attribute packet, if
use of attribute packets has been negotiated and a SET ATTR [CHARACTER-SET]
OFF command has not been given.

When receiving, C-Kermit translates from the specified transfer character set
to the specified file character set or, if a transfer character set is named
in the incoming attribute packet it is used instead.  If the file character
set is ASCII and special characters are being received, then they are
translated by stripping diacritical marks and aiming for the closest possible
1-to-1 translation on a per-character basis.  But if a SET LANGUAGE command
has been given, special translations can be done.  For example if LANGUAGE has
been set to GERMAN and the local file character set is ASCII, and a file
arrives with a transfer character set of LATIN1, then C-Kermit will translate
German umlaut-vowels into the corresponding vowels followed by the letter e,
and German double-s into two s's.  Similar translations take effect for other
languages.

If unwanted effects appear because of Kermit's translation, you can disable
this feature with SET ATTRIBUTE CHARACTER-SET OFF.

@section(Logging Things)

Kermit's actions during terminal connection and file transfer can be
logged in several ways, using the LOG command:

Syntax: @q<LOG {DEBUGGING, PACKETS, SESSION, TRANSACTIONS} >[ @i(fn1) ]

C-Kermit's progress may be logged in various ways.  The LOG command
opens a log, the CLOSE command closes it.  In addition, all open logs
are closed by the EXIT and QUIT commands.  A name may be specified for
a log file; if the name is omitted, the file is created with a default
name as shown below.

@begin(d4)
LOG DEBUGGING@\This produces a voluminous log of the internal workings of
C-Kermit, of use to Kermit developers or maintainers in tracking down suspected
bugs in the C-Kermit program.  Use of this feature slows down the
Kermit protocol and fills up your disk.  Default name: @q(debug.log).

LOG PACKETS@\This produces a record of all the packets that go in and out of
the communication port.  This log is of use to Kermit maintainers who are
tracking down protocol problems in either C-Kermit or any Kermit that
C-Kermit is connected to.  Default name:  @q(packet.log).

LOG SESSION@\This log will contain a copy of everything you see on your screen
during the CONNECT command, except for local messages or interaction with
local escape commands.  Default name:  @q(session.log).

LOG TRANSACTIONS@\The transaction log is a record of all the files that were
sent or received while transaction logging was in effect.  It includes time
stamps and statistics, filename transformations, and records of any
errors that may have occurred.  The transaction log allows you to have
long unattended file transfer sessions without fear of missing some
vital screen message.  Default name:  @q(transact.log).
@end(d4)
The CLOSE command closes the named log, e.g. CLOSE DEBUG, CLOSE SESSION.

@i<Note:>  Debug and Transaction logs are a compile-time option; C-Kermit may
be compiled without these logs, in which case it will run faster, it will
take up less space on the disk, but the commands relating to them will not
be present.

@section(Local File Management)

C-Kermit allows the following local file management functions from its
interactive command level:
@begin(description,leftmargin +4,indent -4)
CD [@i<directory-name>]@\
Changes Kermit's working device and/or directory to the one given, or to the
user's default directory and/or device if the name is omitted.  This command
affects only the Kermit process and any processes it may subsequently create.
You may use CWD and SET DEFAULT as synonyms for CD.

DELETE @i<fn>@\Deletes (removes, erases) file @i<fn>, which may be the name of
a single file or a wildcard specification containing @q<*> and/or @q<?>
characters.  You may use RM as a synonym for DELETE.

DIRECTORY [@i(fn)]@\Displays a listing of the files whose names match @i(fn),
which may be the name of a single file or a wildcard specification containing
@q<*> and/or @q<?> characters.  If no @i<fn> is given, C-Kermit lists all
files in the current device and/or directory.  The format of and information
provided in the listing depends on the operating system.  You may use LS as a
synonym for DIRECTORY.

PWD@\(Print Working Directory) Display the current working (default) file
device and/or directory.  You may use SHOW DEFAULT as a synonym for PWD.

RENAME @i<fn1> @i<fn2>@\Changes the name of file @i<fn1> to @i<fn2>.  You may
use MV as a synonym for RENAME.

SPACE@\Displays information about disk space and/or quota in the current
directory and device.

TYPE @i<fn>@\Display the named file on the screen.  May be interrupted with
Ctrl-C, and on most systems the display can be stopped and resumed with
Ctrl-S and Ctrl-Q, respectively.  You may use CAT as a synonym for TYPE.

{ @q(@@), @q(!), RUN, PUSH }@\@begin(multiple)
The @i<command> is executed by your computer's operating system command
interpreter (UNIX shell, VMS DCL, etc).  If no command is specified, then an
interactive session is started; exiting from this session, e.g. by typing
Control-D or 'exit' to a UNIX shell, or LOGOUT to VMS DCL, will return you to
C-Kermit command level.  Use the `@q(!)' command to provide file management or
other functions not explicitly provided by C-Kermit commands.  @q<!>, @q<@@>,
RUN, and PUSH are all synonyms for the same command.

@comment{
If you include the "@q(>)" character before the command, then the command's
output will not be displayed on your screen, but rather it will be sent out
the communication device selected in the most recent SET LINE or SET HOST
command.
}
@end(multiple)
@end(description)

@section(The SET and SHOW Commands)
@label(-setshow)

Since Kermit is designed to allow diverse computers to communicate, it is
often necessary to issue special instructions to allow Kermit to adapt
to peculiarities of the other computer or the communication path.  These
instructions are accomplished by the SET command.  The following parameters
may be SET:
@begin(format,spread 0)
@tabclear()@tabset(1.5inches,2.0inches,2.5inches)
@>ATTRIBUTES@\  Turn Attribute packet processing on or off.
@>BACKGROUND@\  Force foreground or background mode.
@>BLOCK-CHECK@\  Level of packet error detection.
@>BUFFERS@\  Send and receive packet buffer sizes.
@>CARRIER@\  Treatment of carrier on terminal connections.
@>CASE@\  Controls treatment of alphabetic case.
@>COMMAND@\  Character set size for commands.
@>COUNT@\  For counted loops.
@>DEBUG@\  Log or display debugging information.
@>DEFAULT@\  Default directory.
@>DELAY@\  How long to wait before sending first packet.
@>DIAL@\  Parameters for DIAL command.
@>DUPLEX@\  Specify which side echoes during CONNECT.
@>ESCAPE@\  Prefix for "escape commands" during CONNECT.
@>FILE@\  Set various file parameters.
@>FLOW-CONTROL@\  Communication line full-duplex flow control.
@>HANDSHAKE@\  Communication line half-duplex turnaround character.
@>HOST@\  Specify network host name.
@>INCOMPLETE@\  Disposition for incompletely received files.
@>INPUT@\  Control behavior of INPUT command.
@>LANGUAGE@\  Enable language-specific character-set translations.
@>LINE@\  Communication line device name.
@>MACRO@\  Control aspects of macro execution.
@>MODEM-DIALER@\  Type of modem-dialer on communication line.
@>PAD@\  (X.25 systems only) X.3 PAD parameters.
@>PARITY@\  Communication line character parity.
@>PROMPT@\  The C-Kermit program's interactive command prompt.
@>RECEIVE@\  Parameters for inbound packets.
@>RETRY@\  Packet retransmission limit.
@>SEND@\  Parameters for outbound packets.
@>SERVER@\  Parameters for server operation.
@>SESSION-LOG@\  (UNIX only) Session log file type, text or binary.
@>SPEED@\  Communication line speed.
@>TAKE@\  Control aspects of TAKE file execution.
@>TERMINAL@\  Terminal parameters.
@>TRANSFER@\  File transfer parameters.
@>TRANSMIT@\  Control aspects of TRANSMIT command execution.
@>UNKNOWN@\  Specify handling of unknown character sets.
@>WINDOW@\  File transfer packet window size.
@>WILDCARD@\  (UNIX only) Kermit vs shell wildcard expansion.
@>X.25@\  (X.25 systems only) X.25 call parameters
@end(format)

The SHOW command may be used to display current settings.
Here is a  summary of settings available in C-Kermit, listed alphabetically.
@begin(d4)
@index<Attributes>
SET ATTRIBUTES@\ Tells C-Kermit whether to exchange
file attribute (A) packets@index<Attribute Packets>, or whether to include
specified attributes within the A packets it sends, or whether to pay
attention to specific attributes in A packets it receives.  When the use of
A packets has been negotiated, C-Kermit enables and uses the ones listed below.
When sending files, C-Kermit responds to an Attribute refusal from the other
computer by not sending the specified file.  For example, if C-Kermit
announces in the A packet that the file is 100K long, the other Kermit could
refuse the file because of insufficient disk space, and then C-Kermit would
not send it.
@begin(d4)
SET ATTRIBUTE CHARACTER-SET { ON, OFF }@\Turn the character-set attribute ON or
OFF.  If ON, C-Kermit includes a code for the transfer character set in the A
packet when sending a file, and when receiving a file, C-Kermit will translate
from the character set (if any) specified in the incoming A packet into the
current file character set (see SET FILE), if the transfer character set is
known to C-Kermit (see SET UNKNOWN).

SET ATTRIBUTE DATE { ON, OFF }@\If ON, C-Kermit includes the file's creation
date in the A packet when sending a file, and stores incoming files with the
creation dates (if any) given in the incoming A packets.  Beware: on some
computers, incremental backups might skip over files with creation dates older
than the most recent backup.

SET ATTRIBUTE DISPOSITION { ON, OFF }@\The MAIL and REMOTE PRINT commands work
by setting "dispositions" of Mail and Print in the A packet when sending a
file.  SET ATTR DISP OFF will cause C-Kermit to ignore this and store such
files on disk rather than mailing or printing them.

SET ATTRIBUTE LENGTH { ON, OFF }@\When sending files, C-Kermit puts their
length in the A packet, so the receiving system has an opportunity to check
and/or allocate disk space in advance, and to refuse the file if there is not
enough disk space.  If you believe that files are being unjustly refused on
the basis of length, you can SET ATTR LENGTH OFF.  When receiving files,
C-Kermit presently ignores the length announced in the A packet.

SET ATTRIBUTE OS-SPECIFIC { ON, OFF }@\Certain versions of Kermit convey
operating-system specific file information in the A packet, which is primarily
useful when transferring files between like systems, such as VMS to VMS.  If
you find this feature is interfering with successful file transfer, SET ATTR
OS OFF.

SET ATTRIBUTE SYSTEM-ID { ON, OFF }@\The A packet also includes a code
identifying the file's operating system of origin, so that the receiver of the
file can decide whether to pay attention to the OS-SPECIFIC attribute.  Use
SET ATTR SYS OFF to disable this feature.

SET ATTRIBUTES ALL { ON, OFF }@\You can turn all the above off using SET ATTR
ALL OFF, and back on using SET ATTR ALL ON.  You can also leave out the word
ALL: SET ATTR OFF, SET ATTR ON.
@end(d4)

SET BACKGROUND { OFF, ON }@\Use SET BACKGROUND off to make your prompts and
messages appear in case they have disappeared because Kermit thinks it is
running in the background (for example, if you are running it through an
output filter, as in "kermit | vt100").  You can accomplish the same effect
using the @q<-z> option on the command line.

SET BLOCK-CHECK {1, 2, 3}@\ Determines the level of per-packet error detection.
"1" is a single-@|character 6-bit checksum, folded to include the values of
all bits from each character.  "2" is a 2-character, 12-bit checksum.  "3" is
a 3-character, 16-bit cyclic redundancy check (CRC).  The higher the block
check, the better the error detection and correction and the higher the
resulting overhead.  Type 1 is most commonly used; it is supported by all
Kermit implementations, and it has proven adequate in most circumstances.
Types 2 or 3 should be used when transferring 8-bit data or when using long
packets.

SET BUFFERS @i<n1> @i<n2>@\Allows you to change the total buffer space used
for sending packets (@i<n1>) and receiving packets (@i<n2>), if Kermit has
been configured to allow dynamic buffer allocation.  The bigger you make them,
the longer your packets can be, and the more window slots you can use.  To see
the default values for your version of Kermit, type SHOW PROTOCOL.

SET CARRIER {AUTO, ON [@i<n>], OFF}@\Specifies C-Kermit's treatment of the
Carrier (CD, DCD, or RLSD) RS-232 signal on terminal device connections
obtained via SET LINE:
@begin(d4)
SET CARRIER ON@\Means to require carrier at all times;
SET LINE will not return until carrier appears (handy for setting Kermit up to
wait for a call to come in), and a fatal error will occur if carrier
disappears during CONNECT or file transfer.  A nice side effect is that when
you log out from the remote computer, you will be put back at C-Kermit prompt
level automatically if the remote system drops carrier properly.  If you want
to set a time limit on how long SET LINE will wait for carrier, you can
include an optional number after SET CARRIER ON to specify the number of
seconds to wait before timing out and returning to the prompt, for example SET
CARRIER ON 30.

SET CARRIER OFF means to ignore carrier at all times.  Useful for direct,
nonmodem connections, or misbehaving modem connections.  Should only be used
when necessary, because it takes away the ability of Kermit to automatically
detect a broken phone connection.

SET CARRIER AUTO means to require carrier during CONNECT but not at other
times.  AUTO is the default.  SET CARRIER ON does not affect the DIAL command.
@end(d4)

SET CASE { ON, OFF }@\Tells C-Kermit whether to pay attention to or ignore
alphabetic case in string matching operations, including INPUT and IF.
Default is OFF, i.e. ignore case.

SET COMMAND BYTESIZE { 7, 8 }@\Normally, C-Kermit's command processor strips
off the 8th bit of any character you type, in case your data connection has
parity.  If there is no parity and you want to use an 8-bit international
character set in your commands (for example, in the ECHO command, or in
filenames), use SET COMMAND BYTESIZE 8.

SET COUNT @i<n>@\For use with counted loops.  See the section on script
language programming.

SET DEFAULT @i<directory>@\Change default directory.  Equivalent to CD.

SET DIAL HANGUP { ON, OFF }@\Normally, the DIAL command will attempt to hang up
the phone before dialing a new call.  This is done by momentarily dropping the
Data Terminal Ready (DTR) signal on the currently selected terminal device.
Unfortunately, the method for doing this is ill-defined in some versions of
UNIX, and in some cases DTR goes down and stays down, which can prevent all
further communication between the computer and the modem.  If you find that
the DIAL command does not work for you at all, try giving the command SET DIAL
HANGUP OFF before giving the DIAL command.  This will prevent DIAL from
hanging up the phone before dialing the new call.

SET DEBUG { ON, OFF, SESSION }@\SET DEBUG ON is equivalent to LOG DEBUG.  SET
DEBUG SESSION means to display incoming control and 8-bit characters on the
screen using special notation (see CONNECT).  SET DEBUG OFF turns off all
debugging.

SET DELAY @i(n)@\How many seconds to wait before sending the first packet
after a SEND command.  Used in remote mode to give you time to escape back to
your local Kermit and issue a RECEIVE command before the first Kermit packet
appears.  Normally 5 seconds.

SET DUPLEX {FULL, HALF}@\For use during CONNECT.  Specifies which side is doing
the echoing; FULL means the other side, HALF means C-Kermit must echo
your keystrokes itself.  Normally FULL.  Use half when communicating with IBM
mainframes over linemode connections, and on similar half-duplex or local-echo
connections.

SET ESCAPE-CHARACTER @i(cc)@\For use during CONNECT to get C-Kermit's
attention.  The escape character acts as a prefix to an escape command, for
instance to close the connection and return to C-Kermit or Unix command level.
The normal escape character is Control-Backslash (ASCII 28).  See CONNECT.

SET FILE @i<parameter> @i<value>@\
Establish file-related parameters:
@begin(d4)
SET FILE BYTESIZE { 7, 8 }@\Normally 8.  If 7, strip the 8th bit from
file data during file transfer.

SET FILE CHARACTER-SET @i<name>@\tells the encoding of the local file, ASCII by
default.  The names DUTCH, GERMAN, FRENCH, etc, refer to 7-bit ASCII-based
national replacement character (NRC) sets.  ALT-CYRILLIC, LATIN-CYRILLIC,
and KOI-CYRILLIC refer to sets used in the Soviet Union and other countries
that use the Cyrillic alphabet.  Latin-1 is the 8-bit ISO 8859
Latin Alphabet 1.  Type SET FILE CHAR ? for a complete list.  When receiving
files, C-Kermit translates from the transfer character set specified in the
most recent SET TRANSFER CHARACTER-SET command or else the one announced in
the Attribute packet (if any) into the file character set.  When sending
files, C-Kermit translates from the current file character set into the
current transfer character set.

SET FILE COLLISION @i<action>@\Tells what to do when a file arrives that has
the same name as an existing file.  The actions are:
@begin(d4)

BACKUP@\(default) Rename the old file to a new, unique name and store the
incoming file under the name it arrived with.  The "new unique" name is simply
a new generation on VAX/VMS.  In UNIX, a "generation number" appended to the
filename, separated by a tilde, as in @q<oofa.txt~8>@foot{The
new name for the arriving file is of the form @q(foo~)@i(n), where foo is the
name they share and @i(n) is a "generation number"; if @i(foo) exists, then
the new file will be called @q(foo~1).  If @q(foo) and @q(foo~1) exist, the
new file will be @q(foo~2), and so on.  If the new name would be longer than
the maximum length for a filename, then characters are deleted from the
end first, for instance, @q(thelongestname) on a system with a limit of 14
characters would become @q(thelongestn~1).}  WARNING: UNIX C-Kermit presently
offers no method of automatically limiting the number of "generations" that
can be created, so if too many of them pile up, you'll have to delete the ones
you don't need by hand.

OVERWRITE@\Overwrite (replace) the existing file.  The existing file is gone,
destroyed.  Even if the file transfer fails or the incoming file is refused.
Use with caution.

APPEND@\Append the incoming file to the end of the existing file.  This option
is useful for adding information to a log file, but it should be used with
caution to avoid, for example, joining two files of different types (like text
and binary).

DISCARD@\Refuse and/or discard the incoming file.  This option is handy for
resuming multi-file transmissions that were broken.  Only those files that
were not successfully transferred before will be accepted.

RENAME@\Give the incoming file a unique name, like the BACKUP option, except
that the incoming file gets the new name, rather than the existing file.

UPDATE@\Accept the incoming file only if it is newer than the existing file.
This feature depends on the creation date field in the attribute packet.
@end(d4)

SET FILE DISPLAY { ON, OFF }@\Normally ON; when in local mode, display progress
of file transfers on the screen (stdout), and watch the keyboard for
interruptions.  If OFF (-q on command line) none of this is done, and the file
transfer may proceed in the background oblivious to any other work
concurrently done at the keyboard.

SET FILE NAMES {CONVERTED, LITERAL}@\Normally CONVERTED, which means that
outbound filenames have device, directory, and/or path specifications
stripped, lowercase letters raised to upper, tildes and extra periods changed
to X's, and an X inserted in front of any name that starts with period.  In
VMS, the generation number is also stripped.  For UNIX only, incoming
filenames have uppercase letters lowered.  LITERAL means that none of these
conversions are done; therefore, any directory path appearing in a received
file specification must exist and be write-accessible.  When literal naming is
being used, the sender should not use path names in the file specification
unless the same path exists on the target system and is writable.

SET FILE RECORD-LENGTH @i<n>@\Tells the record length for fixed-format files,
or the maximum record length for variable-format files, on systems like
VAX/VMS where record-length is a meaningful concept.

@begin<multiple>
SET FILE TYPE {BINARY, TEXT} [{7, 8}]@\The file type is normally text, which
means that conversion is done between the local computer's record format and
Kermit's standard transfer format, for example between Unix newline characters
and Kermit's carriage-@|return/@|linefeed sequences.  BINARY means to transmit
file contents without conversion.  Binary (`@q(-i)' in command line notation)
is necessary for binary files, and desirable in all file transfers between
like systems to cut down on overhead.

The optional trailing parameter tells the bytesize for file transfer.  It is
8 by default.  If you specify 7, the high order bit will be stripped from each
byte of sent and received files.  This is useful for transferring text files
that may have extraneous high order bits set in their disk representation (e.g.
WordPerfect or similar word processor files).
@end<multiple>

SET FILE WARNING { ON, OFF }@\SET FILE WARNING is an old command, somewhat
misnamed.  SET FILE COLLISION (above) should be used instead.  SET FILE
WARNING ON is equivalent to SET FILE COLLISION
RENAME and SET FILE WARNING OFF is equivalent to SET FILE COLLISION OVERWRITE.
@end(d4)

SET FLOW-CONTROL {NONE, XON/XOFF}@\Normally XON/XOFF for full duplex flow
control.  Should be set to NONE if the other system cannot do Xon/Xoff flow
control, or if you have issued a SET HANDSHAKE command.  If set to XON/XOFF,
then HANDSHAKE should be set to NONE.  This setting applies during both
terminal connection and file transfer.  @i<Warning:> This command may have no
effect on certain Unix systems, where Kermit puts the communication line into
"rawmode" and rawmode precludes flow control.

SET HANDSHAKE {XON, XOFF, CR, LF, BELL, ESC, NONE}@\Normally NONE.  Otherwise,
half-duplex communication line turnaround handshaking is done during file
transfer, which means C-Kermit will not reply to a packet until it has
received the indicated handshake character or has timed out waiting for it;
the handshake setting applies only during file transfer.  If you SET HANDSHAKE
to other than NONE, then FLOW should be set to NONE.

SET HOST @i<name>@\For communicating over a network rather than a terminal
device.  Presently supported only for Berkeley-based or other UNIX
implementations using the socket interface to a TCP/IP network, and for
SunLink X.25.  For TCP/IP networks, the @i<name> is the hostname or IP host
number of a host on the network, optionally followed by a colon and an IP
service number.  By default, C-Kermit connects to the telnet (virtual terminal
server) socket on TCP/IP connections.  For X.25 networks, the @i<name> is the
X.121 address.

SET INCOMPLETE {DISCARD, KEEP}@\Disposition for incompletely received files.
If an incoming file is interrupted or an error occurs during transfer,
the part that was received so far is normally discarded.  If you SET
INCOMPLETE KEEP then partial files will be kept.

SET INPUT {CASE, ECHO, TIMEOUT-ACTION}@\Controls the behavior of the INPUT
command.  See the section on script programming.

SET LANGUAGE {ICELANDIC, GERMAN, NORWEGIAN, RUSSIAN, ...}@\For use with
international text file transfer.  If you tell Kermit what language a text
file is written in, then Kermit might be able to apply certain transliteration
tricks when translating between the file character set and the transfer
character set.  See the section on international character sets.

SET LINE [@i<terminal-device-name>]@\
@begin<multiple>
The device name for the communication line to be used for file transfer and
terminal connection, e.g. @q(/dev/ttyi3) on a Unix system or @q<TXA0:> on a
VAX/VMS computer.  If you specify a device name,
Kermit will be in @i<local mode>, and you should remember to issue any other
necessary SET commands, such as SET SPEED (on Unix, at least, the SET SPEED
command is not strictly necessary -- Kermit will use the line's current speed,
but you should use SET SPEED anyway, so that you be sure that speed you desire
is actually being used).

If you omit the device name, Kermit will revert to its default mode of
operation.  If you specify the default device name (@q(/dev/tty) in Unix,
@q<TT:> in VMS), Kermit will enter remote mode (useful when logged in through
the "back port" of a system normally used as a local-mode workstation).

Whenever you give a SET LINE command, C-Kermit closes any currently open
communication device before attempting to open the new one.  Therefore SET
LINE is also useful for closing and hanging up a dialed connection.

When Unix Kermit enters local mode, it attempts to synchronize with other
programs (like uucp) that use external communication lines so as to prevent
two programs using the same line at once; before attempting to lock the
specified line, it will close and unlock any external line that was previously
in use.  If your system does not allow you to have write access to the uucp
lock directory, then you will receive a message like "Sorry, access to lock
denied."  In this case, you must ask your system administrator to ensure that
uucp lockfiles are set up correctly and Kermit is installed correctly.  If
Kermit were to use the external line without proper coordination with uucp
(and even other copies of Kermit), then two or more users could find
themselves using the same line at the same time, which would prevent all
useful communication.

If you SET LINE to a communication port that has a modem attached, and you
have SET CARRIER ON, then the SET LINE command will not return until carrier
appears on the device.  This is useful for setting up a Kermit program that
other people can dial in to.  You can control the amount of time Kermit will
wait for carrier using SET CARRIER ON @i<n>, where n is the number of seconds
to wait for a connection before timing out.  You can also interrupt a blocked
SET LINE command by typing Ctrl-C.
@end<multiple>

SET MACRO { ECHO, ERROR } { ON, OFF }@\Tells whether the individual commands
that comprise a macro should be echoed on the screen during macro execution
(normally they are not), and whether an error during macro execution should
terminate the macro immediately (normally it does not).  See the section on
script programming.

SET MODEM-DIALER @i<name> [ { CHANGES-SPEED, MATCHES SPEED } ]@\The type of
modem @index<Autodialer> dialer on the communication line; the @i<name>
identifies the modem type: DIRECT, HAYES, RACALVADIC, VENTEL, etc.  "Direct"
indicates either there is no dialout modem, or that if the line requires
carrier detection to open, then SET LINE will hang waiting for an incoming
call.  HAYES, VENTEL, and the others indicate that SET LINE will prepare for a
subsequent DIAL command for the given dialer.  UNKNOWN means a modem is
attached, but of an unknown or unsupported type.  The optional trailing field
tells whether the modem does speed matching; Kermit assumes it does not, and
therefore changes the line speed if the modem reports a connection speed
different from the speed at which it was dialed (for modems that support this
feature, principally Hayes).  Support for new dialers is added from time to
time, so type SET MODEM ? for a list of those supported in your copy of
Kermit.  Also see the description of the DIAL command.  @i<NOTE:> the SET
MODEM command must be given @i<before> the SET LINE command if you plan to use
the DIAL command.

SET NETWORK {TCP/IP, X.25}@\Select the type of network that is to be used for
SET HOST connections.  TCP/IP is presently available for UNIX systems that
support the Berkeley sockets library (such as BSD-based UNIXes, HP-UX, Xenix
with Excelan TCP/IP).  X.25 is available only for SUNs with the SunLink
product (see section on X.25 support).

SET PAD@\(See X.25 section)

SET PARITY {EVEN, ODD, MARK, SPACE, NONE}@\Specify character parity for use in
packets and terminal connection, normally NONE.  If other than NONE, C-Kermit
will seek to use the 8th-bit prefixing mechanism for transferring 8-bit data,
which can be used successfully only if the other Kermit agrees during the
automatic feature negotiation phase; if not, 8-bit data cannot be successfully
transferred.  In Berkeley-based Unix implementations, if you SET PARITY to
other than NONE, this will also enable Xon/Xoff flow control during file
transfer if FLOW is set to XON/XOFF; otherwise, flow control is not done
(because the communication line must be opened in "raw mode" for 8-bit data,
which precludes the use of Xon/Xoff flow control in Berkeley Unix).

SET PROMPT [@i<text>]@\The given text will be substituted for "@q(C-Kermit)>"
as this program's prompt.  If the text is omitted, the prompt will revert to
"@q(C-Kermit>)".  If the text is enclosed in { curly braces }, the braces are
stripped and any leading and trailing blanks are retained.  The text may
contain backslash codes.

SET RECEIVE @i<parameter> @i<value>@\(See SET SEND.)

SET RETRY @i<n>@\Specify the maximum number of times a particular packet
can be retransmitted (because of timeout or transmission errors) before Kermit
gives up and declares the file transfer a failure.

SET {SEND, RECEIVE} @i<parameter> @i<value>@\@begin(multiple)
These commands are used to modify the normal formats and procedures used by
the Kermit file transfer protocol.  Normally they are not necessary, but they
can be used to overcome unusual obstacles, or to improve Kermit's performance.

The SET RECEIVE command lets you tell the other Kermit how it should format
the packets it sends to you.  Give SET RECEIVE commands to the Kermit that is
going to receive files.  If you plan to transfer files in both directions,
give SET RECEIVE commands to both Kermits.

The SET SEND command rarely needs to be used.  It is for overriding what the
the other Kermit requests, and should be necessary only if you cannot use a
SET RECEIVE command to modify the parameter in question on the receiving
Kermit.
@end(multiple)
@begin(d4)
SET {RECEIVE, SEND} END-OF-PACKET @i(cc)@\Specifies the control character that
marks the end of a Kermit packet.  Normally 13 (carriage return), which most
Kermit implementations require.

SET {RECEIVE, SEND} PACKET-LENGTH @i(n)@\Specify the maximum packet length,
normally 90.  Shorter packet lengths can be useful on noisy lines, or with
systems or front ends or networks that have small buffers.  The shorter the
packet, the higher the overhead, but the lower the chance of a packet being
corrupted by noise, and the less time to retransmit corrupted packets.  If you
request a length greater than 94, "long packets" are used, which is a feature
that not all other Kermit programs support (most popular ones do).  C-Kermit
can send and receive packets up to about 2000 characters in length.  If you
use longer packets, you should also request a stronger error checking method
(see SET BLOCK-CHECK).  SET SEND PACKET-LENGTH overrides the value requested
by the other Kermit during protocol initiation unless the other Kermit
requests a shorter length.

SET {RECEIVE, SEND} PAD-CHARACTER @i(cc)@\SET RECEIVE PAD-CHARACTER allows
C-Kermit to request the other Kermit to use @i(cc) as a pad character.
Default @i(cc) is NUL, ASCII 0.  C-Kermit normally does not need to have
incoming packets preceded with pad characters.  SET SEND PAD-CHARACTER
designates a character to send before each packet.  Normally, none is sent.
Outbound padding is sometimes necessary for communicating with slow half
duplex systems that provide no other means of line turnaround control.  It can
also be used to send special characters to communications equipment that needs
to be put in "transparent" or "no echo" mode, when this can be accomplished in
by feeding it a certain control character.

SET {RECEIVE, SEND} PADDING @i(n)@\How many pad characters to request or send,
normally 0.

SET {RECEIVE, SEND} START-OF-PACKET @i(cc)@\The normal Kermit packet prefix is
Control-A (1); this command changes the prefix C-Kermit puts on outbound
packets.  The only reasons this should ever be changed would be: Some piece of
equipment somewhere between the two Kermit programs will not pass through a
Control-A; or, some piece of of equipment similarly placed is echoing its
input.  In the latter case, the recipient of such an echo can change the
packet prefix for outbound packets to be different from that of arriving
packets, so that the echoed packets will be ignored.  The opposite Kermit must
also be told to change the prefix for its inbound packets (use SET RECEIVE
START on one Kermit and SET SEND START on the other).

SET {RECEIVE, SEND} TIMEOUT @i(n)@\Normally, each Kermit partner sets its
packet timeout interval based on what the opposite Kermit requests.  SET
RECEIVE TIMEOUT allows you to override the normal procedure and specify a
timeout interval for C-Kermit to use when waiting for packets from the other
Kermit.  If you specify 0, then no timeouts will occur, and C-Kermit will wait
forever for expected packets to arrive (relying on the other Kermit to provide
the timeout function).  SET SEND TIMEOUT specifies the number of seconds to
wait for a packet before timing it out and retransmitting or requesting
retransmission.
@end(d4)

SET SERVER TIMEOUT @i<n>@\Specify the time interval @i<n> in
seconds for the C-Kermit server to send NAK packets while waiting for a
command packet.  These NAKs are intended to break deadlocks in case a client
Kermit that cannot time out sends a command packet which is lost.  However,
the server command-wait NAKs can interfere with originate/answer devices that
are to be used for answering.  For example, you can run a C-Kermit server on a
modem line that normally dials out, so that people can dial in to it and give
Kermit commands.  While waiting for the phone call to come, the server NAKs
might "wake up" the modem and put it into originate mode, preventing the
incoming call from being answered.

SET SESSION-LOG { BINARY, TEXT }@\Specify how the session log is to be
written.  TEXT is the default, meaning that lines are written using the
convention of the local system; for example, Unix session logs will have
carriage returns (and certain other extraneous characters like NUL) omitted.
BINARY means to record all characters in the session log.

SET SPEED @i<n>@\The transmission speed in bits per second
("baud rate") for the communication line specified in SET LINE (but not SET
HOST).  This command cannot be used to change the speed of your own console
terminal.  Some computers are set up in such a way that you must give this
command after a SET LINE command before you can use the line.  Type SET SPEED
? to see what speeds are available.  Use speeds greater than 9600 with
caution, since they are not necessarily supported by the communication devices
on your computer or the other computer, or the communication path between them.

SET TAKE { ECHO, ERROR } { ON, OFF }@\SET TAKE ECHO tells whether
commands from a TAKE file are displayed on the screen as they are executed
(normally they are not).  SET TAKE ERROR controls whether execution of a TAKE
command file should be terminated if an error occurs (normally it is).

SET TERMINAL @i<parameter> @i<value>@\Used for specifying terminal parameters.
Currently, BYTESIZE is the only parameter provided in all C-Kermit
implementations, and it can be set to 7 or 8.  It's 7 by default, which means
that the high-order (8th) bit is stripped from each incoming and outgoing
character.  Use 8 for 8-bit character sets like ISO Latin Alphabet 1.  For
OS/2, you may also SET TERMINAL TYPE VT100 or SET TERMINAL TYPE TEK4010 to
select the type of terminal to emulate.

SET TRANSFER CHARACTER-SET @i<name>@\Tells what character set should be used
for file data within Kermit packets during transfer of text files.  The
choices are:
@begin(d4)
TRANSPARENT@\Don't translate characters at all.

ASCII@\Means to use the 7-bit ASCII (American Standard Code for Information
Interchange) character set.  If the local file character set contains
characters that do not occur in ASCII (like accented letters), represent them
in ASCII the best way possible.

CYRILLIC@\Means to use the ISO 8859-5 Latin/Cyrillic Alphabet, which is
capable of representing Russian, Ukrainian, Bulgarian, Serbian, etc.

LATIN1@\Means to use ISO 8859 Latin Alphabet 1, which is capable of
representing most western European languages (English, German, Spanish, Dutch,
Italian, Norwegian, Danish, Swedish, Portuguese, etc).
@end(d4)

SET TRANSMIT @i<parameter> @i<value>@\Controls the behavior of the TRANSMIT
command, used for uploading files to computers that don't have Kermit
programs.  See TRANSMIT.  The parameters are:
@begin(d4)
EOF @i<string>@\String to send after sending the file, for example
SET TRANSMIT EOF \4 to send a Ctrl-D.

FILL @i<character>@\ASCII value of character to insert into blank lines.  Some
computers ignore blank lines, others might terminate the upload when they
receive a blank line.  Use this command to insert a character, such as space
(32) or X (88), in any blank line.

LINEFEED { ON, OFF }@\Transmit linefeed as well as carriage return at the end
of each line.  Normally, only CR is sent.

PROMPT @i<n>@\ASCII value of character to look for from host before
sending next line, normally LF (10).
@end(d4)

SET UNKNOWN-CHAR-SET { DISCARD, KEEP }@\Tells what to do if a file arrives
whose Attribute packet announces a transfer character set unknown to C-Kermit.

SET WILDCARD-EXPANSION { KERMIT, SHELL }@\(UNIX only) Tells who should expand
wildcard characters in SEND and similar commands: KERMIT (the default) or the
user's preferred Unix shell (such as sh, csh, or ksh).

@begin(multiple)
SET WINDOW @i<n>@\Select a window size.  This refers to Kermit's sliding window
packet transport protocol.  Normally, Kermit sends a packet, waits for the
reply, then sends the next packet, and so on.  This is called "stop and wait"
operation, corresponding to a window size of 1, and is supported by all Kermit
programs.  If you select a window size greater than 1, and if the other Kermit
supports sliding windows, then multiple packets (up to the window size) can be
sent before any replies are required.  This allows file transfer to operate
efficiently over connections that have long delays, like over public data
networks or through satellites.

With a sufficiently large window size, transmission can be continuous with no
pauses or delays.  The maximum window size is 31, but sizes greater than 5 or
10 are rarely necessary.

Sliding windows may be used in conjunction with long packets, but the maximum
length for packets decreases with increasing window size.

Kermit uses the "selective retransmission" technique, so that if packets are
damaged during sliding windows transfers, only the damaged packets are
retransmitted.
@end(multiple)

SET X.25@\(See X.25 section)
@end(d4)

@subheading(The SHOW Command)

Syntax: @q<SHOW> @i<category> 

The SHOW command with the default argument of "parameters" displays
the values of most of the SET parameters described above.  If you type
a category name after SHOW, then a more detailed report of parameters within
the named category are displayed, for example SHOW COMMUNICATIONS, SHOW
PROTOCOL.  Type SHOW ? to see a list of the available categories.

@section(Backslash Notation)
@label(-bkslash)

@q<\> (backslash) in any command means that what follows is not ordinary text,
but rather a code, variable, or function whose value is to be substituted into
the command at that point.  The character after the backslash identifies which
kind of quantity this is:
@begin(description,leftmargin +6,indent -2,spread 0)
@q<%>@\A user-defined simple (scalar) variable

@q<&>@\an array reference

@q<$>@\an environment variable

@q<v>@\(or @q<V>) a built-in variable

@q<f>@\(or @q<F>) a function

@q<d>@\(or @q<D>) a decimal (base 10) number

@q<o>@\(or @q<O>) an octal (base 8) number

@q<x>@\(or @q<X>) a hexadecimal (base 16) number

@q<\>@\the backslash character itself

@q<b>@\(or @q<B>) the BREAK signal (OUTPUT command only)

@i<a decimal digit>@\a 1-3 digit decimal number.

@i<anything else>@\The following character is taken literally.
@end(description)
Variables, arrays, functions, etc, are explained in the next section.
Numbers can be expressed in backslash notation in the following ways:
@begin(d4)
@q<\{...}>@\A grouped number, braces discarded, e.g. \{17}5 is not the same as
\175.

@q<\>@i<nnn>@\(1-3 decimal digits) replaced by binary number 0-255, e.g.
@q<\13> represents carriage return (ASCII 13).

@q<\d>@i<nnn> or @q<\D>@i<nnn> - Same as @q<\>@i<nnn>

@q<\o>@i<nnn> or @q<\O>@i<nnn> (1-3 octal digits) replaced by binary number
0-255.

@q<\x>@i<nn> or @q<\X>@i<nn> (2 hexadecimal digits) replaced by binary number
0-255.
@end(d4)
Numbers expressed in backslash notation are typically used to express
nonprintable ASCII characters within character strings, or in commands that
want you to enter the ASCII value of a character.  Examples:
@begin(example)
echo \7Wake up!\7            ; A message with beeps
echo \27[H\27[J              ; VT100 clear-screen sequence
set pad-character \o177      ; The ASCII character DEL
@end(example)

@section(Macros, Variables, and Script Programming)
@label(-macros)

C-Kermit's script programming language is based upon that of MS-DOS Kermit,
and it is in most ways upwards compatible with it, meaning that many MS-DOS
Kermit script programs (or TAKE files in general) will work in C-Kermit with
little or no modification.  C-Kermit also has a SCRIPT command that provides
a terse but cryptic shorthand for automating certain kinds of interactive
operations (see Section @ref<-scrcmd>).

@subsection(Variables)

A variable name is of the form @q<\%@i(i)>, where @i(i) is a single letter or
digit.  Letter-variables are different from digit-variables, which are used as
macro parameters.  The alphabetic case of a letter-variable doesn't matter:
@q<\%a> is the same variable as @q<\%A>.

All variables have character strings as values.  A variable is considered to
exist if its value is a string of at least one character in length, otherwise
it is "undefined" and does not exist.

A value is given to a variable using the DEFINE or ASSIGN command:
@begin(d4)
DEFINE @i<name> [ @i<text> ]@\The named variable (or macro, see below) is
created, with @i<text> as a value.  If a macro or variable of the given name
already exists, its definition is replaced with the new one.  The given text
is copied into the definition literally.  If it contains any variable names,
functions references, etc, these are simply copied, rather than evaluated.

ASSIGN @i<name> @i<text>@\The text is evaluated, and then the named variable
or macro's value is set to the evaluated text.  This differs from DEFINE,
which does not evaluate the text, but rather copies it literally.  The
distinction between ASSIGN and DEFINE doesn't matter unless the text contains
variable names.  With ASSIGN, the contents of the variable is copied, whereas
with DEFINE, the name of the variable is copied.
@end(d4)
To illustrate the difference between DEFINE and ASSIGN:
@begin(example)
def \%a Monday
def \%b Today is \%a
assign \%c Today is \%a
def \%a Tuesday
echo \%b
echo \%c
@end(example)
The definition of @q<\%b> is "@q<Today is \%a>", so that whenever the value
of @q<\%a> changes, so does the value of @q<\%b>.  The definition of @q<\%c>,
however, is fixed as "@q<Today is Monday>", because "@q<Monday>"
was the value of @q<\%a> at the time that @q<\%c> was assigned.

A variable can be used in any Kermit command simply by referring to its name:
@example(echo \%a)
and variables can be undefined by DEFINEing or ASSIGNing nothing to them,
for example:
@example(define \%a)

A special kind of variable is called an @i<array>.  This is simply a list,
in which each element has a number.  An array reference looks like
@q<\&a[>@i<i>@q<]>.  The @q<\&> means this is an array element rather than a
simple variable, the letter tells which array it is (a, b, c, ..., z), and
the brackets enclose an @i<index> which tells which member of the array is
being referred to: 1, 2, 3, etc.  The index can be a number, or it can be a
variable or function (even another array element) that has a numeric value.
Array indices must be (or evaluate to) zero or greater.

Arrays have to be declared before you can use them, so Kermit will know how big
the array is and can create storage for it.  The command is DECLARE, for
example:
@example(DECLARE \&A[100])
This tells Kermit to create an array called @q<\&a> with 100 elements.  Once
an array is declared, its elements can be used just like simple variables:
@example(DEFINE \&A[3] Tuesday)
An entire array can be destroyed like this:
@example(DECLARE \&A[0])
If you refer to an element of an array that is not declared, the reference is
replaced by the empty string.

The array @q<\&a[]> is predeclared.  It contains the command line that the
Kermit program was invoked with, one word per array element.  The number of
elements in the array is given in the built-in variable @q<\v(args)>
(described later).  Example:
@example<$ @ux[kermit -p e -b 3]>
Here @q<\&a[0]> is the Kermit program's file specification, like
@q</usr/local/bin/kermit>; @q<\&a[1]> is @q<-p>, @q<\&a[2]> is @q<e>, and so
on.

The simple variables @q<\%a..\%z> and the arrays @q<\&a[]..\&z[]> are all
@i<global>, which means they can be referenced from anywhere in your script
program, including from within a TAKE file or macro.

You can list the names and values of all existing global simple variables with
the SHOW GLOBALS command, and you can list the names and dimensions of all
declared arrays with SHOW ARRAYS.

@subsection(Macros)

A Kermit macro is a list of one or more Kermit commands that can be referred
to by a single name.  Like variables, macros are created by the DEFINE
(or ASSIGN) command:
@example(define ibm set parity mark, set duplex half, set handsh xon)
and unlike variables, macros do not have weird-looking names; macro names can
be ordinary words.

Once a macro is defined, you can execute all of its commands simply by typing
the macro's name:
@example(C-Kermit>@ux[ibm])

If you have defined a macro that has the same name as one of Kermit's built-in
commands, you will have to insert the word DO before the name in order to
execute the macro rather than the built-in command:
@example(C-Kermit>@ux[do ibm])
(you can also use the word DO to invoke any macro).
In these examples, "IBM" and "DO IBM" are the @i<macro invocations>.  If you
follow a macro invocation by one or more "words" (a word is a sequence of
characters delimited by spaces, or else at the end of a line), then each of
these words is assigned to a digit-variable that is accessible to the commands
within the macro definition.  These trailing "words" are called the @i<macro
parameters>.  The first parameter is assigned to @q<\%1>, the second to
@q<\%2>, and so on, up to a maximum of nine.  The variable @q<\%0> contains
the name of the macro:
@begin(example)
define demo echo \%0: \%1 \%2 \%3 \%4 \%5 \%6 \%7 \%8 \%9
demo this is a test of macro argument passing
@end(example)

Variables that do not have corresponding parameters are undefined (empty).
The number of arguments passed to the macro is available in the named variable
\v(argc)@foot(which, for compatibility with MS-DOS Kermit, may also be
referred to simply as ARGC, but only within IF conditions.)
Macro parameters are @i<local> to the macro they are passed to.  If macro A
invokes macro B, macro B gets its own set of parameters, which are separate
from macro A's, so that macro A still has its own parameters available after
macro B has completed.  The variables @q<\%0..\%9> may be used as global
variables at "top level", when no macros are active, by assigning values to
them in the normal way.  To demonstrate:
@begin(example)
define xx echo \%1, yy Sneezy, echo \%1
define yy echo \%1, zz Grumpy, echo \%1
define zz echo \%1
xx Sleepy
@end(example)
Try this, and you'll see how the value of @q<\%1> is saved and restored at each
level.

Macro parameter words may be grouped into single parameters
by enclosing them in braces.  Try the following example to see how this works:
@begin(example)
define msg echo \%0: \%1
msg this is another test of macro argument passing
msg {this is yet another test of macro argument passing}
@end(example)
You can have a macro list its arguments on your screen by including the
command SHOW ARGUMENTS within the macro definition.

You can list the names and definitions of all existing macros with the SHOW
MACROS command.  If you include a name, as in "SHOW MACROS FOO", it will list
the definition(s) of only those macros whose names start with the character(s)
you have specified.

If you define a macro named ON_EXIT, it will be executed automatically
when the Kermit program exits.

@subsection(Named Variables)

Built-in named variables are read-only, you cannot change them.  Their names
are of the form @q<\v(name)>, in which the v can be lower or uppercase, and the
parentheses are required around the variable name.  If you refer to a named
variable that does not exist, it will be evaluated as the empty (zero-length)
string.  C-Kermit's variables are:
@begin(d84)
@q<\v(argc)>@\number of arguments passed to currently active macro.

@q<\v(args)>@\number of arguments passed to the program on the command line.
The program argument vector is assigned to the array @q<\&a[]>.

@q<\v(count)>@\current value of COUNT (loop control via SET COUNT, IF COUNT).

@q<\v(date)>@\current date in @i<dd mmm yyyy> format (e.g. 8 Feb 1990 or 10 Nov
1990)

@q<\v(directory)>@\current device and/or directory.

@q<\v(filespec)>@\file specification from most recent SEND, MSEND, or GET
command.

@q<\v(home)>@\user's home (login) directory name.

@q<\v(host)>@@\computer hostname.

@q<\v(input)>@\current INPUT buffer contents.

@q<\v(line)>@\current communication device or network host.

@q<\v(ndate)>@\current date in numeric format, e.g. 19901225.

@q<\v(platform)>@\name specific machine or environment C-Kermit was built for.

@q<\v(return)>@\Value of most recent RETURN command.

@q<\v(speed)>@\Transmission speed of current communication device, if known.
(A spurious value of 38400 might be reported for pseudoterminals.)

@q<\v(success)>@\1 or 0 depending on success or failure of previous command.

@q<\v(system)>@\name of generic operating system C-Kermit was built for,
such as UNIX or VMS.

@q<\v(time)>@\current time in hh:mm:ss 24-hour clock format (e.g. 13:45:23).

@q<\v(version)>@\numeric version number of C-Kermit.

@end(d84)
You can use these variables in any Kermit command where their values would
make sense:
@example<echo It is \v(time) o'clock on \v(date)>
A @q<\v>-variable's name can be abbreviated, as long as the abbreviation is
enough to distinguish it from all the other built-in variable names:
@q<\v(dir)>, @q<\v(ver)>, etc.

You can get a listing of Kermit's built-in variables and their values with
the SHOW VARIABLES command.

@subsection(Built-in Functions)

Built-in functions are of the form @q<\f>@i<name>(@i<args>).  The F and the
name can be upper or lower case.  The @i<args> are a comma-separated list of
arguments.  The function reference is replaced by its value.  For example:
@begin(example)
define \%a ABC123XYZ
define \%b ...\Flower(\%a)...
@end(example)
results in a value of @q<...abc123xyz...> for @q<\%b>.

The names of built-in functions and variables can be abbreviated to their
minimum unique length, for example @q<\feval(1+1)>, @q<\v(dir)>, etc.
C-Kermit's functions include string-oriented functions that return a string:
@begin(d84)
@q<\Fliteral(>@i<arg>@q<)>@\Copies its argument literally, without any
evaluation.

@q<\Fcharacter(>@i<arg>@q<)>@\Returns the single character corresponding to
its argument, which must be numeric.  For example, @q<\fchar(65)> is 'A',
@q<\fchar(193)> is A-acute (in the Latin-1).  If you give a negative number or
a number larger than 255, only the low-order 8 bits are used.

@q<\Fsubstr(>@i<arg1>@q<,>@i<arg2>@q<,>@q<arg3>@q<)>@\Substring of the string
@i<arg1> starting at position @i<arg2>, of length @i<arg3>.  @i<arg2> and
@i<arg3> must be numbers or variables that have numeric values.  Example:
@example<echo \fsubst(hello there,7,5)>
extracts the word "there".  The following is equivalent:
@begin(example)
define \%a hello there
define \%b 7
define \%c 5
echo \fsubst(\%a,\%b,\%c)
@end(example)

@q<\Flower(>@i<arg>@q<)>@\Converts all uppercase letters in its argument to
lowercase, for example:
@begin(example)
define \%a FINE
echo This is a \flower(\%a Mess).
@end(example)
prints "This is a fine mess."

@q<\Fupper(>@i<arg>@q<)>@\Converts all lowercase letters in its argument to
uppercase.

@q<\Freverse(>@i<arg>@q<)>@\Reverses the order of the characters in its
argument, for example @q<\frev(mupeen)> is @q<neepum>.

@q<\Frepeat(>@i<arg1>@q<,>@i<arg2>@q<)>@\Repeats the first argument the number
of times given by the second argument, for example:
@example<echo +\frep(-+,10)>
produces @q<+-+-+-+-+-+-+-+-+-+-+>.

@q<\Flpad(>@i<text>@q<,>@i<n>@q<,>@i<c>@q<)>@\Left-pads the @i<text> out to
length @i<n> with character @i<c>.  If @i<c> is omitted, blank (space) is used.

@q<\Frpad(>@i<text>@q<,>@i<n>@q<,>@i<c>@q<)>@\Right-pads the @i<text> out to
length @i<n> with character @i<c>.  If @i<c> is omitted, blank (space) is used.

@q<\Fexecute(>@i<macroname> @i<macro-args>@q<)>@\Execute the named macro with
the given parameters (if any), return the macro's RETURN value if any (see
RETURN).

@q<\Fcontents(>@i<variable-name>@q<)>@\Returns the current definition
(contents) of a variable.  If the definition includes variable names or
function references, these are copied literally, without evaluation.

@q<\Fdefinition(>@i<macro-name>@q<)>@\Returns the literal definition of the
named macro.
@end(d84)

Here are the string functions that return a number:
@begin(d84)
@q<\Flength(>@i<arg>@q<)>@\Returns the length of the argument string.

@q<\Findex(>@i<arg1>@q<,>@i<arg2>@q<,>@i<arg3>@q<)>@\Returns the position of
the first occurrence string @i<arg1> in string @i<arg2>, starting at position
@i<arg3>.  If @i<arg3> is omitted, then starting at the beginning.
@end(d84)

File functions:
@begin(d84)
@q<\Ffiles(>@i<filespec>@q<)>@\Returns the number of files that match the
given file specification, for example @q<\ffiles(ck*.c)>.

@q<\Fnextfile()>@\Returns the next filename that matches the @q<\Ffiles>()
file specification.  Use this in a counted loop (see below) after executing 
@q<\Ffiles()>.
@end(d84)

Integer arithmetic functions:
@begin(d84)
@q<\Fmax(>@i<arg1>@q<,>@i<arg2>@q<)>@\Returns the maximum of its two numeric
arguments.

@q<\Fmin(>@i<arg1>@q<,>@i<arg2>@q<)>@\Returns the minimum of its two numeric
arguments.

@q<\Feval(>@i<expression>@q<)>@\Evaluates the given arithmetic expression.
The operands of the expression can be numeric strings or variables, or
functions that evaluate to numeric strings.  The precedence is the normal,
intuitive algebraic (or programming) precedence, and can be altered by the
use of parentheses, which have higher precedence than any other operator.
Spaces may be used to separate operators from operands, but they are not
required.
@end(d84)
Table @ref(-arith) shows the types of expressions accepted by @q<\feval()>.
@begin<table>
@bar()
@blankspace(1)
@case[device,postscript="@begin(example,size -1)",
else="@begin(example)"]
Operator  Fix   Precedence   Operation          Example

 (   )              1         Group             (\%a + 3) * (\%1-5)
   !      Post      2         Factorial         \%x! - (\%x-2)!

   ~      Pre       3         Logical NOT       ~\%n
   -      Pre       3         Negative          -\%n

   ^      In        4         Raise to power    2^\%p

   *      In        5         Multiply          \%c * 5
   /      In        5         Divide            \%c / 5
   %      In        5         Modulus           \%c % 5
   &      In        5         Logical AND       \%c & 5

   +      In        6         Add               \%t + \%u
   -      In        6         Subtract          27 - \%x
   |      In        6         Logical OR        \%z | 4
   #      In        6         Exclusive OR      \%z # 4
   @@      In        6         Greatest Common   \%z @@ 30
			      Divisor
@end(example)
@caption<\feval() Arithmetic Functions>
@tag<-arith>
@bar()
@end<table>

You can list the names of Kermit's built-in functions with the SHOW FUNCTIONS
command.

Two Kermit commands are also available to perform simple arithmetic on
variables:
@begin(d4)
INCREMENT @i<name> [@i<value>]@\Add @i<value> to the named variable.  If
@i<value> is omitted, add 1.  If the variable does not have a numeric value,
this command has no effect.  Examples: @q<inc \%a, incr \%b 10>.

DECREMENT @i<name> [@i<value>]@\Subtract @i<value> from the named variable.  If
@i<value> is omitted, subtract 1.  If the variable does not have a numeric
value, this command has no effect. 
@end(d4)

@subsection(Script Programming)

Kermit's script programming language lets you write procedures, or
@i<programs>, that can include any Kermit command.  Variables and functions
can be referenced at practically any point in any command.  Control structures
are provided for decision making, transfer of control, looping, scoping of
variables, and so forth.  A script program can be a TAKE file, a macro, or any
combination of the two.

The basic idea of a script program is to automate tasks that you would
normally do "by hand" when interacting with another computer: dialing the
modem, negotiating through network boxes and front ends, logging in, etc etc.
You can also write programs to manage local files, or to do anything that you
could do manually with Kermit.

To automate interaction with another computer, you need a replacement for the
CONNECT command.  This comes in two parts, an OUTPUT command that "types" what
you would type during CONNECT, and an INPUT command that reads the other
computer's responses, plus a couple related commands:
@begin(description,leftmargin +4,indent -4)
OUTPUT @i<text>@\Send the text to the other computer.  The text can be any
combination of plain ordinary characters, backslash codes, variables, and
functions.

INPUT @i<timeout> @i<text>@\Read responses from the other computer.  Wait up
to @i<timeout> seconds for the specified text to appear.  If the text appears
within the timeout interval, the command succeeds immediately.  Otherwise it
fails.  The @i<text> can contain any combination of ordinary characters,
backslash codes, variables, and functions.  INPUT can be interrupted with
Ctrl-C, in which case it fails.

REINPUT @i<timeout> @i<text>@\Searches previous responses from the computer
for the given text.  The timeout parameter is ignored.  The previous responses
are stored in the INPUT buffer, which is 256 characters long, and which may
also be accessed via the @q<\v(input)> variable.

ECHO [ @i<text> ]@\Display the text on the local screen, followed by a newline.
The text can contain any combination of backslash codes, variables, functions,
etc.

CLEAR@\Clear any as-yet-unread characters from the communication device's
input buffer.

PAUSE [ @i<n> ]@\Do nothing for the indicated number of seconds.  If a number
is not given, pause for 1 second.  If anything is typed on the keyboard during
the pause interval, "wake up".  PAUSE can be interrupted by typing Ctrl-C (or
any other character), in which case it fails.

WAIT [ @i<n> [ { CD, CTS, DSR } ] ]@\Wait up to @i<n> seconds for the
specified modem signals to appear on the currently selected communication
device.  If you don't include any modem signal names, WAIT is equivalent to
PAUSE.  If you include one or more signal names (separated by spaces), Kermit
will wait for @i<all> of the specified signals to appear.  If they don't
appear within the alloted time, or if the device does not have modem control,
then the command will fail.  You may interrupt the WAIT command by typing any
character at the keyboard, in which case the command will fail.  The command
will also fail if modem-signal support is not included in C-Kermit for your
particular operating system version.  The modem signals are: CD (carrier
detect), CTS (Clear To Send), and DSR (Data Set Ready).
@end(description)
Example:
@begin(example)
wait 10 cd dsr      ; Wait 5 seconds for CD and DSR.
if success goto ok  ; Test the result.
@end(example)
WAIT can be interrupted by typing Ctrl-C (or any other character), in which
case it fails.

The behavior of the INPUT command can be controlled by SET INPUT:
@begin(description,leftmargin +4,indent -4)
SET [ INPUT ] CASE {IGNORE, OBSERVE}@\Tells whether alphabetic case matters
when searching the remote computer's responses for the INPUT text.  This
setting also affects C-Kermit's other string comparison operations, including
IF EQUAL, IF LGT, etc (IF command described later).

SET INPUT ECHO { ON, OFF }@\Tells whether the characters read by the INPUT
command should be echoed on the screen.

SET INPUT TIMEOUT-ACTION { PROCEED, QUIT }@\Tells whether the script program
should continue or stop immediately if an INPUT command fails.
@end(description)

At this point Kermit needs a decision making mechanism to tell whether the
INPUT command succeeded or failed.  This is the IF command.  Note that IF can
be used after INPUT only if you SET INPUT TIMEOUT PROCEED.
@begin(description,leftmargin +4,indent -4)
IF [NOT] @i<condition> @i<command>@\If the @i<condition> is satisfied, execute
the following Kermit @i<command>.  If the word NOT is included, execute the
command if the condition is @i<not> satisfied.
Only one command may be given, and it must appear on the same line as the IF.
@end(description)
The IF command supports a wide variety of conditions.  These are:
@begin(d84)
IF SUCCESS@\The previous command succeeded.

IF FAILURE@\The previous command failed.

IF DEFINED @i<name>@\The named variable or macro is defined.

IF BACKGROUND@\Kermit is running in the background or with its standard
input and output redirected.

IF COUNT@\Subtract one from COUNT, execute the command if the result is
greater than zero (see SET COUNT).

IF EXIST @i<filename>@\The named file exists.

IF EQUAL @i<s1 s2>@\s1 and s2 (character strings or variables) are equal.

IF LLT @i<s1 s2>@\s1 is lexically (alphabetically) less than s2.  Use IF NOT
LGT for less-@|than-@|or-@|equal.

IF LGT @i<s1 s1>@\s1 is lexically (alphabetically) greater than s2.  Use IF NOT
LLT for greater-@|than-@|or-@|equal.

IF = @i<n1 n2>@\n1 and n2 (numbers or variables containing numbers) are equal.

IF < @i<n1 n2>@\n1 is arithmetically less than n2. Use IF NOT > for
less-@|than-@|or-@|equal.

IF > @i<n1 n2>@\n1 is arithmetically greater than n2\n.  Use IF NOT < for
greater-@|than-@|or-@|equal.
@end(d84)
String comparisons in IF EQUAL, IF LGT, and IF LLT treat alphabetic case
according to SET INPUT CASE {IGNORE, OBSERVE}.  You can also use @q<\fupper()>
and @q<\flower()> to force caseless comparisons if INPUT CASE is set to
OBSERVE.

Arithmetic comparisons work with numeric constants, variables and array
elements that evaluate to a numeric string, functions that return a numeric
value, and the special "MS-DOS Kermit compatibility" variables COUNT, VERSION,
and ARGC, which can only appear in this context.  Numeric strings are
converted to binary integers before comparison, and may be positive, zero, or
negative.  Floating point ("real") numbers are not supported.

The IF command may be followed on the next line by an ELSE command, which is
executed if the IF condition is not true, and which is not executed if the IF
condition is true.  Example:
@begin(example)
IF < \%x 10 ECHO It's less
ELSE echo It's not less
@end(example)

As in any programming language, it is desirable to be able to go to different
places in the program based on the decisions made by IF commands.  The command
for going-to is:
@begin(description,leftmargin +4,indent -4)
GOTO @i<label>@\Go to the command which follows the named label.
@end(description)
A label is a word beginning with a colon (:) on the left margin.  Example:
@begin(example)
IF < \%x 10 goto less
echo It's not less
goto fin
:less
ECHO It's less
:fin
@end(example)

Several other commands are especially useful in conditional contexts, i.e. as
objects of IF commands:
@begin(description,leftmargin +4,indent -4)
STOP@\Stop executing the current script program (TAKE file or macro) and
return immediately to C-Kermit prompt level (or, if Kermit was invoked with
command-line action arguments, exit C-Kermit altogether).

END@\Go "up" one command level.  Exit the currently executing macro or TAKE
file, and return to the invoking TAKE file or macro.  Or, if the current TAKE
file or macro was invoked from @q(C-Kermit>) prompt level, return to the
prompt.  Or, if Kermit was invoked with command-line action arguments, exit
C-Kermit.  You can use POP as a synonym for this command.

RETURN [@i<value>]@\For use within macros.  Just like END, except that a
return value may be set.  This is for use with the @q<\fexecute()> function,
which allows you to write user-defined functions.  For example:
@begin(example)
def sum if = \%1 1 return 1,-
  else return \feval(\%1 + \fexecute(sum \feval(\%1 - 1)))
@end(example)
This function, called SUM, returns the sum of all the numbers from 1 to
whatever number (1 or greater) it was called with, for example:
@example<echo \fexec(sum 5)>
prints the number 12.  Notice that this function calls itself; C-Kermit
functions are allowed to do this.
@end(description)

Although the object command of an IF or ELSE statement may only be a single
command, that command is allowed to be a macro invocation or a TAKE command.
This provides a kind of statement grouping that can be used to avoid a lot of
confusing GOTOs.  A more flexible kind of statement grouping is available in
the XIF ("extended IF") command:
@begin(description,leftmargin +4,indent -4)
XIF @i<condition> { @i<command-list> } [ ELSE {  @i<command-list> } ]@\
In this extended form, braces are required to enclose a comma-separated
list of one or more commands, and the ELSE clause is on the same line as the
XIF.  Example:
@case<device,postscript="@begin(example,size -1)",else="@begin(example)">
xif < \%x 10 {ech Less,def \%m 10} else {ec Not less,def \%m \%x}
@end(example)
Here the appropriate message is echoed, depending on the value of @q<\%x>,
and the minimum of @q<\%x> and 10 is assigned to the variable @q<\%m>.
Commands like this one can be broken onto multiple lines for clarity, but only
if you use dash (or backslash) for line continuation:
@begin(example)
xif < \%x 10 { -
    echo Less, -
    def \%m 10 -
} else { -
    echo Not less, -
    def \%m \%x -
}
@end(example)
@end(description)
WARNING: It is not possible to use macro argument variables (@q<\%1>, etc) 
within an XIF command.

@subheading(Other Ways of Assigning Values to Variables)

Sometimes it is desirable for a script program to interact with you as well
as with the remote computer.  For example, you should not store passwords on
disk, so you can't write script programs that contain them.  However, you can
write script programs that prompt you for your password.  This is done using
the ASK or ASKQ command:
@begin(description,leftmargin +4,indent -4)
ASK @i<name> @i<prompt>@\Print the prompt on the screen and wait for you to
type a line of text (terminated by carriage return), and assign this line of
text to the named variable (but without the carriage return), for example:
@begin(example)
ask \%p Password:
output \%p\13
@end(example)
The prompt may be enclosed in { curly braces } to retain leading and/or
trailing spaces.

ASKQ @i<name> @i<prompt>@\Just like ASK, but it "asks quietly".  The
characters you type do not echo.  Especially useful for passwords.
@end(description)

Now, with IF, branching, ASK, and so forth, we can add to our login script:
@case<device,postscript="@begin(example,size -1)",else="@begin(example)">
@tabclear()@tabdivide(2)
define error echo Error: \%1, end@\; Error-handling macro.
set input timeout proceed@\; Don't quit if INPUT fails.
set input case ignore@\; Alphabetic case doesn't matter.
set input echo off@\; Don't need to watch.
output \13@\; Send carriage return (ASCII 13).
input 5 login:@\; Wait 5 secs for "login:" prompt.
if fail error {No login prompt}@\; Give up if it doesn't come.
output myuserid\13@\; Send user ID followed by CR.
input 5 password:@\; Wait for password prompt.
if fail error {No password prompt}@\; Give up if it doesn't come.
ask \%p Password:@\; Prompt user for password
output \%p\13@\; Send it, followed by CR
input 30 $\32@\; Wait for system prompt "$ "
if fail error {No system prompt}@\; Give up if it doesn't come.
connect@\; Got it, connect.
@end(example)

@subheading(Reading and Writing Local Files)

It is also possible to assign data from local files to variables.  In fact,
C-Kermit includes an entire input and output system for local files and
commands:
@begin(description,leftmargin +4,indent -4)
OPEN @i<mode> @i<filename>@\
For use with READ and WRITE commands.  Open the local file in the specified
mode: READ, WRITE, or APPEND.  !READ and !WRITE mean to read from or write
to a system command rather than a file.  Examples:
@begin(example)
OPEN READ oofa.txt
OPEN !READ ls ck[uwc].[cwh]
@end(example)
The first example reads lines from the file @q<oofa.txt>.  The second reads
filenames from a Unix directory listing; this gives you a way to select files
using your Unix shell's filename-@|matching metacharacters, which are more
powerful than Kermit's built-in ones.

READ @i<name>@\The next line from the current OPEN READ or OPEN !READ file is 
assigned to the named variable, for example @q<READ \%A>.  If no more lines
remain in the file, the command fails.

WRITE @i<name> @i<text>@\
Writes the given text to the named log or file.  The text text may include
backslash codes, and is not terminated by a newline unless you include the
appropriate code.  The name parameter can be any of the following:
@begin(description,leftmargin +4,indent -4,spread 0)
DEBUG-LOG

FILE (the OPEN WRITE, OPEN !WRITE, or OPEN APPEND file).

PACKET-LOG

SCREEN (just like ECHO except that WRITE does not supply a line terminator)

SESSION-LOG

TRANSACTION-LOG
@end(description)

CLOSE @i<name>@\Closes the named file.  A READ or !READ file is closed
automatically when end-of-file (EOF) is encountered during a READ operation,
but it does no harm to close it again.  WRITE, !WRITE, and APPEND files must
be closed explicitly.  Examples: CLOSE READ, CLOSE WRITE.
@end(description)
A typical script program for reading and writing files might look like this:
@begin(example)
@tabclear@tabdivide(2)
set take error off@\; So EOF can be handled.
open read foo@\; Open input file "foo".
open write bar@\; Open output file "bar".
def \%c 0@\; Make a line counter.
:loop@\; Loop to read all lines.
read \%a@\; Read one line into \%a.
if fail goto done@\; Catch EOF this way.
increment \%c@\; Count the line.
write file \%c. \fupp(\%a)\10@\; Format and write it.
goto loop@\; Go back and get more.
:done
close read@\; Finished,
close write@\; close the files.
echo All done.@\; Print a message.
@end(example)

The previous example shows a loop, which is a common programming construct.
It is always desirable to avoid infinite loops.  The READ example does this
by testing for end of file (EOF) with IF FAILURE.

@subheading(Counted Loops)

Kermit also provides for "finite", or counted, loops, in several varieties:
@begin(description,leftmargin +4,indent -4)
SET COUNT / IF COUNT@\Here a special variable, COUNT, is set.  The IF COUNT
command decrements the count variable, and if the result is greater than
zero, executes the object command:
@begin(example)
set count 5
:loop
echo \v(count)
if count goto loop
else echo Zero!
@end(example)

FOR@q< >@i<variable>@q< >@i<iv>@q< >@i<fv>@q< >@i<step>@q< >@~
{@q< >@i<command>,@q< >@i<command>,@q< ... >}@\
The FOR loop is controlled by a loop @i<variable> which is assigned
an initial value (@i<iv>), gets tested against a final value (@i<fv>), and
gets incremented by a @i<step> value.  If the step value is positive, the
loop exits when the loop variable is greater than the final value.  If the
step is negative, the loop exits when the variable becomes less than the final
value.  Example (cute way to print the 9's times table):
@begin(example)
for \%i 0 9 1 { assign \%j \feval(9-\%i), echo \%i\%j }
@end(example)
FOR loops can be nested:
@begin(example)
for \%i 1 5 1 { for \%j 5 \%i -1 { echo \%i:\%j } }
@end(example)

WHILE@q< >@i<condition>@q< >{@q< >@i<command>,@q< >@i<command>,@q< ... >}@\
The commands are executed as long as the @i<condition> is true.  The
conditions are the same as for the IF command.  Example:
@begin(example)
while not exist foo.bar { sleep 1 }
@end(example)
This loop waits until file named @q<foo.bar> appears.
@end(description)
FOR and WHILE loops can be nested in any combination.  Both FOR and WHILE
loops may be exited or continued prematurely using the following commands:
@begin(description,leftmargin +4,indent -4)
BREAK@\Exit from the closest enclosing FOR or WHILE loop.

CONTINUE@\Begin the next iteration (if any) of the closest enclosing FOR or
WHILE loop immediately.
@end(description)

WARNING: It is not possible to use macro arguments (@q<\%1>, etc) in FOR or
WHILE commands.

Here's a script program example that has nothing to do with data
communication or file transfer, but which illustrates the control structures
of the script language, the use of arrays, statement grouping, file i/o, etc:
@case<device,postscript="@begin(example,size -1)",else="@begin(example)">
; Kermit script program to read a file of numbers into an array,
; sort the array numerically, and display the sorted result.
;
def \%d 100                   ; Allow up to 100 elements.
dcl &a[\%d]		      ; Declare a 100-element array.
set take error off            ; To handle EOF on READ.
open read numbers.dat         ; Open this file for reading.

; Read each line into a separate array element
;
echo Reading...
for \%n 1 \%d 1 { -
    read \&a[\%n], -
    if fail break -
}
decr \%n                      ; Subtract one for read that failed.
                              ; Check for too many lines.
xif > \%n \%d { -
    echo Too many lines in file, -
    stop -
}
echo Array initialized: \%n elements, sorting...

; Sort the array using the (slow) "bubble sort" algorithm.
;
assign \%m \feval(\%n-1)
for \%i 1 \%m 1 { -
    for \%j \%i \%n 1 { -
	xif > \&a[\%i] \&a[\%j] { -
	    assign \%t \&a[\%i], -
	    assign \&a[\%i] \&a[\%j], -
	    assign \&a[\%j] \%t -
	} -
    } -
}

; Display the sorted array.
;
echo sorted.
for \%i 1 \%n 1 { echo \flpad(\%i,3). \flpad(\&a[\%i],5) }
@end(example)

@section(The SCRIPT Command)
@label(-scrcmd)

The SCRIPT command allows connection and login sequences to be specified in
a single, cryptic line in the style of the Unix uucp @q<L.sys> file.

Syntax: @q(SCRIPT )@i(expect send )[@i(expect send)] . . .

"expect" has the syntax: @i(expect)[@i(-send-expect)[@i(-send-expect)[...]]]

The SCRIPT command carries on a "canned dialog" with a remote system, in
which data is sent according to the remote system's responses.  The typical use
is for logging in to a remote system automatically.

A login script is a sequence of the form:
@example(@i<expect send [expect send] . . .>)
where @i(expect) is a prompt or message to be issued by the remote site, and
@i(send) is the string (names, numbers, etc) to return, and expects are
separated from sends by spaces.  The send may also be the keyword EOT, to send
Control-D, or BREAK, to send a break signal.  Letters in sends may be prefixed
by `@q[~]' to send special characters, including:
@begin(description,leftmargin +8,indent -4,spread 0)
@q(~b)@\backspace

@q(~s)@\space

@q(~q)@\`@q[?]'(trapped by Kermit's command interpreter)

@q(~n)@\linefeed

@q(~r)@\carriage return

@q(~t)@\tab

@q(~')@\single quote

@q(~~)@\tilde

@q(~")@\double quote

@q(~x)@\XON (Control-Q)

@q(~c)@\don't append a carriage return

@q(~)@i(o[o[o]])@ @ octal representation of an ASCII character code

@q(~d)@\delay approx 1/3 second during send

@q(~w)@i([d[d]])@ @ wait specified interval during expect, then time out

@q(\\b)@\send a BREAK signal
@end(description)
As with some UUCP systems, sent strings are followed by @q(~r) unless they have
a @q(~c).

Only the last 7 characters in each expect are matched.  A null @i(expect),
e.g. @q(~0) or two adjacent dashes, causes a short delay before proceeding
to the next send sequence.  A null expect always succeeds.

As with UUCP, if the expect string does not arrive, the script attempt
fails.  If you expect that a sequence might not arrive, as with UUCP, 
conditional sequences may be expressed in the form:
@example(@i<-send-expect[-send-expect[...]]>)
where dashed sequences are followed as long as previous expects fail.
Timeouts for expects can be specified using @q(~w); @q(~w) with no
arguments waits 15 seconds.

@i(expect-send) transactions can be easily be debugged by logging
transactions.  This records all exchanges, both expected and actual.
The script execution will also be logged in the session log, if that is
activated.

Note that `@q[\]' characters in login scripts, as in any other C-Kermit
interactive commands, must be doubled up.  A line may be ended with a
single `@q[\]' for continuation.

Example one:

Using a modem, dial a UNIX host site.  Expect "login" (...gin), and if it
doesn't come, simply send a null string with a @q(~r).  (Some Unixes
require either an EOT or a BREAK instead of the null sequence, depending
on the particular site's "logger" program.)  After providing user id
and password, respond "x" to a question-mark prompt, expect the Bourne
shell "@q($)" prompt (and send return if it doesn't arrive).  Then cd to
directory kermit, and run the program called "wermit", entering the
interactive connect state after wermit is loaded.
@begin(example)
set modem ventel
set line /dev/tty77
set baud 1200
dial 9&5551212
script gin:--gin:--gin: smith ssword: mysecret ~q x $--$ \
 cd~skermit $ wermit
connect
@end(example)
Note that SET LINE is issued @i<after> SET MODEM, but @i<before>
SET BAUD or other line-@|related parameters.

Example two:

@index(TELENET)
Using a modem, dial the Telenet network.  This network expects three returns
with slight delays between them.  These are sent following null expects.  The
single return is here sent as a null string, with a return appended by default.
Four returns are sent to be safe before looking for the prompt.  Then the
Telenet id and password are entered.  Then Telenet is instructed to connect to
a host site (c 12345).  The host has a data switch that asks "which system";
the script responds "myhost" (if the "which system" prompt doesn't appear, the
Telenet connect command is reissued).  The script waits for an @qq"@@" prompt
from the host, then sends the user ID ("joe") and password ("secret"), looks
for another @qq<@@> prompt, runs Kermit, and in response to the Kermit's prompt
(which ends in @qq[>]), gives the commands "set parity even" and "server".
Files are then exchanged.  The commands are in a take file; note the
continuation of the 'script' command onto several lines using the `@q[\]'
terminator.
@begin(example)
set modem hayes
set line /dev/acu
set speed 1200
set parity mark
dial 9,5551212
script ~0 ~0 ~0 ~0 ~0 ~0 ~0 ~0 @@--@@--@@ id~s\
aa001122 = 002211 @@ c~s12345 ystem-c~s12345-ystem \
myhost @@ joe~ssecret @@ kermit > set~sparity~seven > server
send some.stuff
get some.otherstuff
bye
quit
@end(example)
Since these commands may be executed totally in the background, they
can also be scheduled.  A typical shell script, which might be scheduled
by cron, would be as follows (csh used for this example):

@begin(example)
#
# Keep trying to dial and log onto remote host and exchange
# files, wait 10 minutes before retrying if it fails.
# 
cd someplace
while ( 1 )
    kermit < ./tonight.cmd >> nightly.log &
    if ( ! $status ) break
    sleep 600
end
@end(example)
File @q(tonight.cmd) might have two takes in it, for example, one to take
a file with the set modem, set line, set baud, dial, and script, and
a second take of a file with send/get commands for the remote server.
The last lines of @q(tonight.cmd) should be BYE and QUIT.

@section(Command Line Operation)
@label(-cmdlin)

A subset of Kermit's commands is available using Unix-style command line
options, on operating systems that support passing of command-line options
to programs through the "argv, argc" mechanism.

The C-Kermit command line syntax conforms to the @ux(Proposed Syntax Standards
for Unix System Commands) put forth by Kathy Hemenway and Helene Armitage of
AT&T Bell Laboratories in @i(Unix/World), Vol.1, No.3, 1984.  The rules that
apply are:
@begin(itemize,spread 0)
Command names must be between 2 and 9 characters ("kermit" is 6).

Command names must include lower case letters and digits only.

An option name is a single character.

Options are delimited by '@q(-)'.

Options with no arguments may be grouped (bundled) behind one delimiter.

Option-arguments cannot be optional.

Arguments immediately follow options, separated by whitespace.

The order of options does not matter.

'@q(-)' preceded and followed by whitespace means standard input.
@end(itemize)
A group of bundled options may end with an option that has an argument.

The following notation is used in command descriptions:
@begin(d84)
@i(fn)@\A file specification, possibly containing the "wildcard"
characters `@q[*]' or `@q[?]' (`@q[*]' matches all character strings, `@q[?]'
matches any single character).

@i(fn1)@\A Unix file specification which may not contain `@q[*]' or `@q[?]'.

@i(rfn)@\A remote file specification in the remote system's own syntax, which
may denote a single file or a group of files.

@i(rfn1)@\A remote file specification which should denote only a single file.

@i(n)@\A decimal number between 0 and 94.

@i(c)@\A decimal number between 0 and 127 representing the value of an
ASCII character.

@i(cc)@\A decimal number between 0 and 31, or else exactly 127,
representing the value of an ASCII control character.

@q([ ])@\Any field in square braces is optional.

@q({x,y,z})@\Alternatives are listed in curly braces.
@end(d84)

C-Kermit command line options may specify any combination of actions and
settings.  If C-Kermit is invoked with a command line that specifies no
actions, then it will issue a prompt and begin interactive dialog.  Action
options specify either protocol transactions or terminal connection.

An implicit TAKE command is executed upon your C-Kermit initialization file
when C-Kermit starts up, upon either interactive or command-line invocation.
This file may contain C-Kermit interactive-mode commands, which are explained
later.

In addition, if the first command line argument is the name of an existing
file, C-Kermit will read that file and execute Kermit interactive-mode
commands from it, in addition to (and after) your initialization file (if any).
Example:
@example<$ @ux[kermit cmdfile -b 3 -p m]>
In UNIX, this feature allows you to invoke C-Kermit by "running" a C-Kermit
command file, if its first line is of the form:
@example<#!/dir/kermit>
That is, number sign followed by exclamation point, followed by the full file
specification of the Kermit program.  You must also give this file execute
permission:
@example<$ @ux[chmod +x cmdfile]>
Then you can run this file as if it were a program, and it will feed itself
to C-Kermit automatically:
@example[$ @ux<cmdfile>]
You can even include C-Kermit command line options:
@example[$ @ux<cmdfile -l /dev/ttyh8 -p e>]
If you want the shell prompt to return automatically at the end of this file,
include an EXIT command.  Otherwise you will receive the C-Kermit prompt when
the file is finished.

Here are C-Kermit's command-line options:
@begin<d84>
@q(=)@\Ignore all command-line options that follow (but make them available
to the user in the array @q<\&a[]>).

@q(-y )@i(fn)@\Read commands from the specified file instead of the standard
initialization file.  If you want to start Kermit with no initialization file
at all, use this option and specify the null file (@q</dev/null> or @q<NL:>).

@q(-s )@i(fn)@\Send the specified file or files.  If @i(fn) contains
wildcard (meta) characters, the Unix shell expands it into a list.  On
non-Unix systems, Kermit expands any wildcard characters.  @i(fn)
may also be a list of files, as in:
@example<kermit -s ckcmai.c ckuker.h mail.txt>
If @i(fn) is '@q[-]' then kermit sends from standard input, which may
come from a file:
@example(kermit -s - < foo.bar)
or a parallel process:
@example(ls -l | grep cmg | kermit -s -)
You cannot use this mechanism to send
terminal typein.  If you want to send a file whose actual name is @qq(-)
you can precede it with a path name, as in
@example(kermit -s ./-)

@q(-r)@\Receive a file or files.  Wait passively for files to arrive.

@q(-k)@\Receive (passively) a file or files, sending them to standard
output.  This option can be used in several ways:
@begin(description,leftmargin +4,indent -4)
@q(kermit -k)@\Displays the incoming files on your screen; to be used only
in "local mode" (see below).

@q(kermit -k > )@i(fn1)@\Sends the incoming file or files to the named file,
@i(fn1).  If more than one file arrives, all are concatenated together
into the single file @i(fn1).

@q(kermit -k | command)@\Pipes the incoming data (single or multiple
files) to the indicated command, as in
@example'kermit -k | sort > sorted.stuff'
@end(description)

@q(-a )@i(fn1)@\If you have specified a file transfer option, you may give
an alternate name for a single file with the @q(-a) ("as") option.  For
example,
@example'kermit -s foo -a bar'
sends the file @q(foo) telling the receiver that its name is @q(bar).
If more than one file arrives or is sent, only the first file is
affected by the @q(-a) option:
@example'kermit -ra baz'
stores the first incoming file under the name @q(baz).

@q(-x)@\Begin server operation.  May be used in either local or remote mode.
@end(d84)

Before proceeding, a few words about remote and local operation are
necessary.  C-Kermit is "local" if it is running on PC or workstation that
you are using directly, or if it is running on a multiuser system and
transferring files over an external communication line -- not your job's
controlling terminal or console.  C-Kermit is remote if it is running on a
multiuser system and transferring files over its own controlling terminal's
communication line (normally @q</dev/tty>), connected to your PC or
workstation.

If you are running C-Kermit on a PC, it is normally used in local mode, with
the "back port" designated for file transfer and terminal connection, and the
keyboard and screen available to control or interrupt the file transfer and to
display its status.  If you are running C-Kermit on a multiuser (timesharing)
system, it is in remote mode unless you explicitly point it at an external
line for file transfer or terminal connection.  The following command 
determines whether C-Kermit is in local or remote mode:

@begin(d84)
@q(-l )@i(dev)@\Line  -- Specify a terminal line to use for file
transfer and terminal connection, as in
@example'kermit -l /dev/ttyi5'
@end(d84)

When an external line is being used, you will also need some additional
options for successful communication with the remote system:

@begin(d84)
@q(-b )@i(n)@\Bits per second -- Specify the transmission speed in bits per
second ("baud rate") for the line given in the @q(-l) option, as in:
@example'kermit -l /dev/ttyi5 -b 9600'
This option should always be included with the @q(-l) option, since the
speed of an external line is not necessarily what you expect.

@q(-p )@i(x)@\Parity -- e,o,m,s,n (even, odd, mark, space, or none).  If parity
is other than none, then Kermit's 8th-bit prefixing mechanism will be used for
transferring 8-bit binary data, provided the opposite Kermit agrees.  The
default parity is none.

@q(-t)@\Specifies half duplex, line turnaround with XON as the handshake
character.

@q(-m)@i(name)@\Modem type -- hayes, penril, vadic, etc.  For a complete and
up-to-date list, run C-Kermit interactively and type "set modem ?".  Note:
name must be given in lowercase, but can be abbreviated, e.g. "hay" for
"hayes".
@end(d84)

If you wish to use a network connection rather than a terminal line for
communication, use the -j option rather -l:
@begin(d84)
@q(-j )@i(name)@\Host -- Specify a network host name.  This option is
currently supported for TCP/IP Telnet connections on Berkeley-based UNIX
implementations only.  The speed (-b) parameter does not apply to network
connections.
@end(d84)

The following commands may be used only with a C-Kermit which is in local
mode.

@begin(d84)
@q(-g )@i(rfn)@\Actively request a remote server to send the named file
or files; @i(rfn) is a file specification in the remote host's own syntax.  If
@i(fn) happens to contain any special shell characters, like space, '@q(*)',
'@q([)', '@q(~)', etc, these must be quoted, as in:
@example'kermit -g x\*.\?'
or:
@example'kermit -g "profile exec"'

@q(-f)@\Send a 'finish' command to a remote server.

@q(-c)@\Establish a terminal connection over the specified or default
communication line, before any protocol transaction takes place.
Get back to the local system by typing the escape character
(normally Control-Backslash) followed by the letter 'c'.

@q(-n)@\Like @q(-c), but @i(after) a protocol transaction takes place;
@q(-c) and @q(-n) may both be used in the same command.  The use of @q(-n)
and @q(-c) is illustrated below.
@end(d84)
If the other Kermit is on a remote system, the @q(-l) and @q(-b) options should
also be included with the @q(-r), @q(-k), or @q(-s) options.

Several other command-line options are provided:
@begin(d84)
@index(Binary Files)
@q(-i)@\Specifies that files should be sent or received exactly "as is" with no
conversions.  This option is necessary for transmitting binary files.  It may
also be used in Unix-to-Unix transfers (it must be given to @i<both> Unix
Kermit programs), where it will improve performance by circumventing the normal
text-file conversions, and will allow mixture of text and binary files in a
single file group.

@q(-w)@\Writeover -- An incoming file should write over any existing file of
the same name.  Changes the default behavior, which is to back up the existing
file before creating the new one.

@q(-e @i<n>)@\Extended packet length -- Specify that C-Kermit is allowed to
receive packets up to length @i<n>, where @i<n> may be between 10 and some
large number, like 1000 or 2000, depending on the system.  The default maximum
length for received packets is 90.  Packets longer than 94 will be used only
if the other Kermit supports, and agrees to use, the "long packet" protocol
extension, and if you request them.

@q(-v @i<n>)@\Window size -- Specify that C-Kermit is allowed to send
and receive files using a window size of @i<n>.  That is, up to @i<n> packets
may be sent before acknowledgements are required.  This speeds up transfers
in most situations, especially long distance network connections.  Default
window size is 1, maximum is 32.  Sizes greater than 1 work only if the other
Kermit supports this option.

@q(-q)@\Quiet -- Suppress screen update during file transfer, for instance
to allow a file transfer to proceed in the background.

@q(-z)@\Force foreground mode: even if Kermit thinks it is running in the
background, this will make it issue its normal prompts and messages.
Example:
@example(kermit -z | vt100)

@q(-d)@\Debug -- Record debugging information in the file @q(debug.log) in 
the current directory.  Use this option if you believe the program
is misbehaving, and show the resulting log to your local
Kermit maintainer.

@q(-h)@\Help -- Display a brief synopsis of the command line options.
@end(d84)
The command line may contain no more than one protocol action option.

Files are sent with their own names, except that lowercase letters are raised
to upper, pathnames are stripped off, certain special characters like (`@q[~]')
and (`@q[#]') are changed to `@q(X)', and if the file name begins with a
period, an `@q(X)' is inserted before it.  Incoming files are stored under
their own names except that uppercase letters are lowered, and, if @q(-w) was
specified, a "generation number" is appended to the name if it has the same
name as an existing file which would otherwise be overwritten.  If the @q(-a)
option is included, then the same rules apply to its argument.  The file
transfer display shows any transformations performed upon filenames.

During transmission, files are encoded as follows:
@begin(itemize)
Control characters are converted to prefixed printables.

Sequences of repeated characters are collapsed via repeat counts, if
the other Kermit is also capable of repeated-@|character compression.  This
feature is negotiated automatically.

If parity is being used on the communication line, data characters with 
the 8th (parity) bit on are specially prefixed, provided the other Kermit
is capable of 8th-bit prefixing; if not, 8-bit binary files cannot be
successfully transferred.  This feature is negotiated if you give the @q(-p)
option.

Conversion is done between Unix newlines and carriage-@|return-@|linefeed 
sequences unless the @q(-i) option was specified.
@end(itemize)

@subheading(Command Line Examples:)

@exx(kermit -l /dev/ttyi5 -b 1200 -cn -r)
This command connects you to the system on the other end of @q(ttyi5) at
1200 baud, where you presumably log in and run Kermit with a SEND
command.  After you escape back, C-Kermit waits for a file (or files) to
arrive.  When the file transfer is completed, you are reconnected to
the remote system so that you can logout.

@exx(kermit -l /dev/ttyi4 -b 1800 -cntp m -r -a foo)
This command is like the preceding one, except the remote system in this
case uses half duplex communication with mark parity.  The first file
that arrives is stored under the name @q(foo).

@exx(kermit -l /dev/ttyi6 -b 9600 -c | tek)
This example uses Kermit to connect your terminal to the system at the
other end of @q(ttyi6).  The C-Kermit terminal connection does not
provide any particular terminal emulation, so C-Kermit's standard i/o is
piped through a (hypothetical) program called tek, which performs (say)
Tektronix emulation.

@exx(kermit -l /dev/ttyi6 -b 9600 -nf)
This command would be used to shut down a remote server and then connect
to the remote system, in order to log out or to make further use of it.
The @q(-n) option is invoked @i(after) @q(-f) (@q[-c] would have been invoked
before).

@exx(kermit -l /dev/ttyi6 -b 9600 -qg foo.\* &)
This command causes C-Kermit to be invoked in the background, getting a group
of files from a remote server (note the quoting of the `@q[*]' character).  No
display occurs on the screen, and the keyboard is not sampled for
interruption commands.  This allows other work to be done while file
transfers proceed in the background.  UNIX only.

@exx(kermit -l /dev/ttyi6 -b 9600 -g foo.\* > foo.log < /dev/null &)
This command is like the previous one, except the file transfer display has
been redirected to the file @q(foo.log).  Standard input is also redirected, to
prevent C-Kermit from sampling it for interruption commands.

@exx(kermit -iwx)
This command starts up C-Kermit as a server.  Files are transmitted with no
newline/@|carriage-@|return-@|linefeed conversion; the @q(-i) option is
necessary for binary file transfer and recommended for Unix-@|to-@|Unix
transfers.  Incoming files that have the same names as existing files are given
new, unique names.

@exx(kermit -l /dev/ttyi6 -b 9600)
This command sets the communication line and speed.  Since no action is
specified, C-Kermit issues a prompt and enters an interactive dialog with
you.  Any settings given on the command line remain in force during the
dialog, unless explicitly changed.

@exx(kermit)
This command starts up Kermit interactively with all default settings.

The next example shows how Unix Kermit might be used to send an entire
directory tree from one Unix system to another, using the tar program as
Kermit's standard input and output.  On the orginating system, in this case the
remote, type (for instance):@label(-uxtar)

@exx(tar cf - /usr/fdc | kermit -is -)
This causes tar to send the directory @q(/usr/fdc) (and all its files and all
its subdirectories and all their files...) to standard output instead of to a
tape; kermit receives this as standard input and sends it as a binary file.
On the receiving system, in this case the local one, type (for instance):

@exx(kermit -il /dev/ttyi5 -b 9600 -k | tar xf -)
Kermit receives the tar archive, and sends it via standard output to its own
copy of tar, which extracts from it a replica of the original directory tree.

A final example shows how a Unix compression utility might be used to speed
up Kermit file transfers:
@begin(example)
compress file | kermit -is -     (@i(sender))
kermit -ik | uncompress          (@i(receiver))
@end(example)	

@section(UNIX Specifics)

@subsection(The Unix File System)

Consult your Unix manual for details about the file system under your version
of Unix.  In general, Unix files have lowercase names, possibly
containing one or more dots or other special characters.  Unix directories are
tree-@|structured.  Directory levels are separated by slash (@qq[/])
characters.  For example,
@example(/usr/foo/bar)
denotes the file @q(bar) in the directory @q(/usr/foo).  Alphabetic case is
significant in Unix file and directory names, i.e. @qq<a> is a different file
(or directory) from @qq<A>.  Wildcard or "meta" characters allow groups of
files to be specified.  @qq(*) matches any string; @qq(?) matches any single
character.

When C-Kermit is invoked with file arguments specified on the Unix command
line, the Unix shell (Bourne Shell, C-Shell, K-Shell, etc) expands the meta
characters itself, and in this case a wider variety is available.  For example,
@example(kermit -s ~/ck[uvm]*.{upd,bwr}]) is expanded by the Berkeley C-Shell
into a list of all the files in the user's home directory (@q[~/]) that start
with the characters "@q(ck)", followed by a single character @qq(u), @qq(v), or
@qq(m), followed by zero or more characters, followed by a dot, followed by one
of the strings @qq(upd) or @qq(bwr).  Internally, the C-Kermit program itself
expands only the @qq(*) and @qq(?) meta characters.

Unix files are linear (sequential) streams of 8-bit bytes.  Text files consist
of 7-bit ASCII or ISO-646 NRC characters, with the high-@|order bit off (0),
or in very recent versions of Unix, of 8-bit characters in an ASCII-based
international standard character set such as ISO 8859 Latin Alphabet 1.  Text
file lines are separated by the Unix newline character, which is linefeed (LF,
ASCII 10).  This distinguishes Unix text files from those on most other
ASCII-based stream file systems, in which lines are separated by a
carriage-@|return linefeed sequence (CRLF, ASCII 13, followed by linefeed,
ASCII 10).  Binary files are likely to contain data in the high bits of the
file bytes, and have no particular line or record structure.

@subsection<UUCP Lock Files>

Unix has no built-in way of obtaining exclusive access to an external
communication line.  When you issue the 'set line' command to Unix Kermit, Unix
would normally grant you access to the line even if some other process is
making use of it.  The method adopted by most Unix systems to handle this
situation is the "UUCP lock file".  UUCP, the Unix-@|to-@|Unix Copy program,
creates a file in its directory (usually @q(/usr/spool/uucp), but often
elsewhere) with a name like @q(LCK..)@i(name), where @i(name) is the
device name, for instance @q(LCK..tty07).

Unix Kermit uses UUCP lock files in order to avoid conflicts with UUCP,
tip, or other programs that follow this convention, including other users
running Kermit itself.  Whenever you attempt
to access an external line using the 'set line' command or `@q(-l)' on the
command line, Kermit looks
in the UUCP directory for a lock file corresponding to that device.  For
instance, if you 'set line /dev/ttyi6' then Kermit looks for the file
@example(/usr/spool/uucp/LCK..ttyi6)
If it finds this file, it gives you an error message and a directory
listing of the file so that you can see who is using it, e.g.
@begin(example)
-r--r--r--  1 fdc    8 Feb  7 13:02 /usr/spool/uucp/LCK..ttyi6
@end(example)
In this case, you would look up user fdc to find out how soon the line
will become free.

This convention requires that the uucp directory be publicly readable
and writable.  If it is not, the program will issue an appropriate warning
message.

If no lock file is found, Unix Kermit will attempt create one, thus preventing
anyone who subsequently tries to run Kermit, UUCP, cu, tip, or similar
programs on the same line from gaining access until you release the line.  If
Kermit could not create the lock file (for instance because the uucp directory
is write-@|protected), then you will receive an error message.

Even when the lock directory is writable and readable, the locking mechanism
depends upon all users using the same name for the same device.  If a device
has more than one path associated with it, then a lock can be circumvented by
using an alias.

When a lock-@|creating program abruptly terminates, e.g. because it crashes or
is killed via shell command, the lock file remains in the uucp directory,
spuriously indicating that the line is in use.  If the lock file is owned by
yourself, you may remove it.  Otherwise, you'll have to get the owner or the
system manager to remove it, or else wait for a system task to do so; uucp
supports a function (uuclean) which removes these files after a predetermined
age -- uucp sites tend to run this function periodically via crontab.

Locking is not needed, or used, if communications occur over the user's
login terminal line (normally @q[/dev/tty]).

@subsection(C-Kermit under Berkeley or System III/V Unix)

C-Kermit may be interrupted at command level or during file transfer by typing
Control-C.  The program will perform its normal exit function, restoring the
terminal and releasing any lock.  If a protocol transaction was in progress, an
error packet will be sent to the opposite Kermit so that it can terminate
cleanly.

C-Kermit may be invoked in the background ("@q(&)" on shell commmand line).
If a background process is "killed", the user will have to manually
remove any lock file and may need to restore the modem.  This is because 
the kill signal (@q<kill(@i[x],9)>) cannot be trapped by Kermit.

During execution of a system command ('directory', 'cd', or `@q(!)'), C-Kermit
can often be returned to command level by typing a single Control-C.  (With
System III/V, the usual interrupt function (often the DEL key) is replaced by
Control-C.) 

Under Berkeley Unix only: C-Kermit may also be interrupted by @q(^Z) to put the
process in the background.

Control-C, Control-Z, and Control-@q(\) lose their normal functions during
terminal connection and also during file transfer when the controlling tty
line is being used for packet i/o.

If you are running C-Kermit in "quiet mode" in the foreground, then
interrupting the program with a console interrupt like Control-C will not
restore the terminal to normal conversational operation.  This is because
the system call to enable console interrupt traps will cause the program to
block if it's running in the background, and the primary reason for quiet
mode is to allow the program to run in the background without blocking, so
that you can do other work in the foreground.

If C-Kermit is run in the background ("&" on shell commmand line), then
the interrupt signal (Control-C) (and System III/V quit signal) are
ignored.  This prevents an interrupt signal intended for a foreground
job (say a compilation) from being trapped by a background Kermit session.

@subsection(C-Kermit on the AT&T UNIX PC)

@index<UNIX PC>
For Unix PC owners here are a couple of hints.  The name of the phone line
devices are @q</dev/ph0> and @q</dev/ph1>. The RS232 serial port is
@q</dev/tty000>.

Dialing out with the internal modem:
@begin(example)
C-Kermit>@ux<set line /dev/ph0>
C-Kermit>@ux<set speed 1200>
C-Kermit>@ux<set modem att>
C-Kermit>@ux<dial (123) 555-1212>
@end(example)
Or use @q</dev/ph1> for the second phone line.	Control-C will terminate the
dialer.  The telephone line must be in the DATA state; C-Kermit will remind
you of this if it finds the line in VOICE state. 

To connecting via the RS232C serial port, first you must turn off the login
processor that is (or may be) associated with the port, then you can use the
port in the normal manner.
@begin(example)
$ @ux</usr/bin/getoff.sh tty000>
$ @ux<kermit>
C-Kermit>@ux<set line /dev/tty000>
C-Kermit>@ux<set speed 9600>
    @i[(start doing work...)]
    @i[(after exiting C-Kermit you may type:)]
$ @ux</usr/bin/geton.sh tty000>
@end<example>
You may omit the getoff/getoff lines if the line is not used for logging in.

@section(X.25 Support)

@index<X.25>
This section applies only to UNIX C-Kermit on SUN computers that are attached
to X.25 networks via the SunLink X.25 product.

To use an X.25 connection:
@begin<example>
C-Kermit>@ux[set network x.25]
C-Kermit>@ux[set host aaaaaaa]
C-Kermit>@ux[connect]
@end<example>
where aaaaaaa is the X.121 address of the host you wish to connect to.  An
X.121 address is a many-digit number consisting of a 4-digit DNIC (Data
Network Identification Code) followed by an NTN (Network Terminal Number) up
to 10 digits in length, or a 3-digit DCC (Data Country Code) followed by
a country-dependent NN (National Number) up to 11 digits in length.

The following connect-mode escapes apply to X.25 terminal connections:

@begin<d4>
Ctrl-\H@\Hangup - Close the X.25 network connection.

Ctrl-\I@\Interrupt - Send an X.25 interrupt packet.

Ctrl-\R@\Reset the X.25 virtual circuit.
@end<d4>

The following special commands can be used to control your X.25 connection:
@begin(d4)
HANGUP@\Close the X.25 network connection.

PAD CLEAR@\Clear the X.25 virtual circuit.

PAD INTERRUPT@\Send an X.25 Interrupt packet.

PAD RESET@\Reset the X.25 virtual circuit.

PAD STATUS@\X.25 status request.

SET PAD BREAK-ACTION @i<n>@\X.3 Parameter 7.  What PAD should do if it
receives a BREAK signal.  0 = nothing, 1 = send Interrupt packet, 2 = reset,
4 = send Indication Of Break PAD message, 8 = escape to PAD, 16 = discard
output.  Default = 21 (= 16 + 4 + 1).

SET PAD BREAK-CHARACTER @i<n>@\Default 0.

SET PAD LINE-DELETE @i<n>@\X.3 Parameter 17.  0-127 = ASCII value of character
to be used for erasing a line.  Default = 21 (Ctrl-U).

SET PAD CHARACTER-DELETE @i<n>@\X.3 Parameter 16.  0-127 = ASCII value of
character to be used for erasing a character.  Default = 8 (Ctrl-H =
Backspace).

SET PAD CR-PADDING @i<n>@\X.3 Parameter 9, Padding After Carriage Return (CR).
0-255.  Number of padding characters PAD should send to DTE after sending a
CR.  Default = 0.

SET PAD DISCARD-OUTPUT { 0, 1 }@\X.3 Parameter 8.  0 = normal data delivery,
1 = discard output.  Default = 0.

SET PAD LINE-DISPLAY @i<n>@\X.3 Parameter 18.  0-127 = ASCII value of
character to redisplay an edited line.  Default = 18 (Ctrl-R).

SET PAD ECHO { 0, 1 }@\X.3 Parameter 2.  0 = PAD will not echo, 1 = PAD will
echo.  Default = 1.

SET PAD EDITING { 0, 1 }@\X.3 Parameter 15.  0 = No editing, 1 = editing
allowed.  Default = 1.

SET PAD ESCAPE { 0, 1 }@\X.3 Parameter 1.  0 = Escape to PAD not possible,
1 = Ctrl-P escapes to PAD.

SET PAD FORWARD @i<n>@\X.3 Parameter 3, Data Forwarding Characters.  0 = none,
1 = any alphanumeric, 2 = carriage return, etc.  Default = 2.

SET PAD LF-PADDING @i<n>@\X.3 Parameter 14. 0-255 padding characters to be
sent by PAD after linefeed.  Default = 0.

SET PAD LF-INSERT @i<n>@\X.3 Parameter 13, Linefeed (LF) insertion after
carriage return (CR).  0 = no LF insertion, 1 = PAD inserts LF after each CR
sent to DTE, 2 = PAD inserts LF after each CR received from DTE, 4 = PAD
echoes LF as CRLF.  Default = 0.

SET PAD LINE-FOLD @i<n>@\X.3 Parameter 10, Line Folding.  0 = none, 1-255 =
number of graphic characters per line after which to insert folding characters.
Default = 0.

SET PAD PAD-FLOW-CONTROL { 0, 1 }@\X.3 Parameter 5.  0 = No flow control by
PAD, 1 = PAD may send Xon/Xoff flow control to user.  Default = 0.

SET PAD SERVICE-SIGNALS { 0, 1 }@\X.3 parameter 6, PAD Service and Command
Signals.  0 = PAD service signals are not sent to DTE, 1 = PAD service signals
sent.  Default = 1.

SET PAD TIMEOUT @i<n>@\X.3 Parameter 4, Data forwarding timeout, 0-255
(twentieths of a second).  Default = 0 (no data forwarding on timeout).

@begin(comment)
SET PAD TRANSMISSION-RATE @i<n>@\X.3 Parameter 11 (read-only).  0 = 110 bps,
2 = 300 bps, 3 = 1200 bps, 11 = 75/1200 bps, 12 = 2400 bps, 14 = 9600 bps, etc.
This command doesn't do anything.
@end(comment)

SET PAD USER-FLOW-CONTROL { 0, 1 }@\X.3 Parameter 12.  0 = no flow control by
user, 1 = user device may send Xon/Xoff flow control to PAD.  Default = 0.

SET X.25 CLOSED-USER-GROUP { OFF, ON @i<n> }@\OFF = no closed user group,
ON @i<n> specifies the user group number, 0 to 99.  OFF by default.

SET X.25 REVERSE-CHARGE { OFF, ON }@\OFF = caller pays, ON = callee pays.
Default is OFF.
@end(d4)

@section(C-Kermit under VAX/VMS)

C-Kermit can be built using VAX-11 C to run under VMS.  Most of the
descriptions in this manual hold true, but it should be noted that as of this
writing the VMS support is not thoroughly tested.

@i<( This section needs to be written! )>

