//	PenView.h      (by Mike Mahoney,  1/22/91)
	
#import <appkit/View.h>		//  All except View could be imported in the .m file.
#import <appkit/Application.h>
#import <appkit/NXCursor.h>
#import <appkit/Form.h>
#import <appkit/Slider.h>
#import <appkit/Window.h>
#import <dpsclient/wraps.h>

@interface PenView:View
{
	id sliderOutlet;            	//  pointer to the Slider object
	id formOutlet;            	//  pointer to the Form object
	
   	float penWidth;		//  contains the width of the pen
						//      (initialized in setSliderOutlet)
	id pencilCursor;		//  pointer to NXCursor object which looks like a pencil
	NXPoint hotSpot;		//  point on the pencilCursor image that's aligned  
}						//      with the mouse (initialized in initFrame)

//  OUTLET INITIALIZATION METHODS
//             	The system will actually initialize IB-set outlets for us but
//		      if we want to do any other initialization we can use these.
//		They are automatically called at launch time.

- setSliderOutlet:sender;         		//  reads initial Slider value set in IB
- setFormOutlet:sender;         		//  sets float value in Form to Slider value
 

//  TARGET/ACTION METHODS

- changePenWidth:sender;       		//  invoked when the "penWidth" Slider is moved
- clearView:sender;       			//  invoked when the "Clear" menu item is chosen


//   OVERRIDDEN VIEW METHODS             	   //  These were inserted.

- initFrame:(const NXRect *) frameRect;
- drawSelf:(NXRect *)rects :(int) rectCount;	   //   used only to clear PenView 
- mouseDown: (NXEvent *) ptr;			   //   to grab control when mouse pressed 
- resetCursorRects;						   //   resets cursor rectangle(automatically 
										   //      invoked, don't invoke directly)						
@end
