.TH XHOST 1 "Release 5" "X Version 11"
.SH NAME
xhost - server access control program for X
.SH SYNOPSIS
.B xhost
[[+-]name ...]
.SH DESCRIPTION
The \fIxhost\fP program 
is used to add and delete host names or user names to the list allowed
to make connections to the X server.  In the case of hosts, this provides
a rudimentary form of privacy control and security.  It is only sufficient
for a workstation (single user) environment, although it does limit the
worst abuses.  Environments which require more sophisticated measures should
implement the user-based mechanism, or use the hooks in the
protocol for passing other authentication data to the server.
.PP
Hostnames that are followed by two colons (::) are used in checking DECnet
connections; all other hostnames are used for TCP/IP connections.
.PP
User names contain an at-sign (@).  When Secure RPC is being used, the
network independent netname (e.g., "unix.\fIuid\fP@\fIdomainname\fP") can
be specified, or a local user can be specified with just the username
and a trailing at-sign (e.g., "joe@").
.SH OPTIONS
\fIXhost\fP accepts the following command line options described below.  For
security, the options that effect access control may only be run from the
"controlling host".  For workstations, this is the same machine as the
server.  For X terminals, it is the login host.
.TP 8
.BI "\[\+\]" "name"
The given \fIname\fP (the plus sign is optional)
is added to the list allowed to connect to the X server.
The name can be a host name or a user name.
.TP 8
.BI \- "name"
The given \fIname\fP is removed from the list of allowed
to connect to the server.  The name can be a host name or a user name.
Existing connections are not broken, but new
connection attempts will be denied.
Note that the current machine is allowed to be removed; however, further
connections (including attempts to add it back) will not be permitted.
Resetting the server (thereby breaking all connections) 
is the only way to allow local connections again.
.TP 8
.B \+
Access is granted to everyone, even if they aren't on the list
(i.e., access control is turned off).
.TP 8
.B \-
Access is restricted to only those on the list
(i.e., access control is turned on).
.TP 8
.I nothing
If no command line arguments are given,
a message indicating whether or not access control is currently enabled
is printed, followed by the list of those allowed to connect.
This is the only option that may be used from machines other than
the controlling host.
.SH DIAGNOSTICS
For each name added to the access control list,
a line of the form "\fIname\fP being added to access contro list"
is printed.
For each name removed from the access control list,
a line of the form "\fIname\fP being removed from access contro list"
is printed.
.SH FILES
/etc/X*.hosts
.SH "SEE ALSO"
X(1), Xserver(1), xdm(1)
.SH ENVIRONMENT
.TP 8
.B DISPLAY
to get the default host and display to use.
.SH BUGS
.PP
You can't specify a display on the command line because
.B \-display 
is a valid command line argument (indicating that you want
to remove the machine named 
.I ``display''
from the access list).
.PP
This is not really a bug, but
the X server stores network addresses, not host names.  If somehow you
change a host's network address while the server is still running,
\fIxhost\fP must be used to add the new address and/or remove the old address.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Bob Scheifler, MIT Laboratory for Computer Science,
.br
Jim Gettys, MIT Project Athena (DEC).
