/*
    streams - Definitions and macros for streams package 

    Copyright (C) 1994. Adam Fedor

    streams.h,v 1.3 1994/08/20 18:11:21 pfkeb Exp

    Right now this is just a simple package based on stdio meant to 
    provide compile compatability with NeXT's streams package.

 */
#ifndef _streams_h_
#define _streams_h_

#include <stdio.h>
#include <unistd.h>

#ifdef HAVE_LIBGCC
typedef struct {
    FILE *stream;
    char *buf;
    int	 size;
} NXStream
#else
#define NXStream        FILE
#endif

/* 
    Read/write modes -- Hopefully these are the same as the typedstream
    modes "OBJC_...".
*/
#define NX_READONLY     1
#define NX_WRITEONLY    2
#define NX_READWRITE    4

/* Seek modes */
#define NX_FROMSTART    SEEK_SET
#define NX_FROMCURRENT	SEEK_CUR
#define NX_FROMEND	SEEK_END

#define NXGetc          fgetc
/*!!! FIXME !!!  ungetc needs that character to push back */
#define NXUngetc(s)   	ungetc(' ', s)
#define NXPutc(s,c)     fputc(c, s)

#define NXFlush(s)	fflush(s)
#define NXSeek(s,o,m)	fseek(s,o,m)
#define NXTell          ftell

#define NXRead(s,b,n)   fread(b, 1, n, s)
#define NXWrite(s,b,n)  fwrite(b, 1, n, s)

#define NXPrintf        fprintf
#define NXVPrintf	vfprintf

#define NXScanf         fscanf

#define NXClose         fclose

/*
    We have to provide functions for these because of a descrepency in
    the type of the argument "mode"
*/
extern NXStream *NXOpenFile(int fd, int mode);
extern NXStream *NXOpenMemory(const char *addr, int size, int mode);
extern NXStream *NXMapFile(const char *name, int mode);
extern int NXSaveToFile(NXStream *s, const char *name);
extern void NXGetMemoryBuffer(NXStream *s, char **addr, int *len, int *maxlen);
extern void NXCloseMemory(NXStream *s, int option);

#define NX_FREEBUFFER           0       /* constants for NXCloseMemory */
#define NX_TRUNCATEBUFFER       1
#define NX_SAVEBUFFER           2

#define NXAtEOS		feof

#endif /* _streams_h */
