/* Compatibility functions or dummies
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * zone.c,v 1.1 1994/02/28 00:44:47 pfkeb Exp
 */

/*
	This is to mimic the zonemalloc, zonefree, and zonerealloc calls.
	The zone pointer is simply ignored.
 */

#include <stdlib.h>

void *NXCreateChildZone(void *parentZone, size_t startSize, 
                        size_t granularity, int canFree)
{
    return ((void *)0);
}

void NXMergeZone(void *zone)
{
    zone = ((void *)0);
    return;
}

void NXNameZone(void *zone, const char *name)
{
    zone = ((void *)0);
    return;
}

