/*  Archiving Category for CustomView
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz, Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCustomView.m,v 1.5 1994/06/11 03:53:31 pfkeb Exp

*/

#include "XmCustomView.h"
#include <stdio.h>
#include <stdlib.h>

/* declared in Translator.m */
extern BOOL 	fileOwnerAdded;
extern id	list_of_objects;

@implementation CustomView (XmArchiving)
- write:(TypedStream *)stream
{
	/* if realObject exists here, it means this custom object was
	 * for the File's Owner.
	 * So just write "FileOwner" for class name and we'll connect it
	 * properly when this Custom Object is read in
	 */
	if (realObject)
		strcpy(className,"FileOwner");

#ifdef DEBUG		
	printf("->(CustomView for %s)", className);
#endif
	[super write:stream];


	objc_write_type(stream,"*",className);
	return self;
}
- initFrame:(NXRect*)frameRect
{
	[super initFrame:frameRect];
	printf("CustomView : init\n");
	return self;
}

- awake
{
    [super awake];
#ifdef DEBUG		
    printf("CustomView for %s: awake", className);
#endif
    return self;
}

/* just trap nibInstantiate so it doesn't try to connect */
- nibInstantiate
{
    if ((realObject) && (!fileOwnerAdded)) {
	fileOwnerAdded = YES;
	[list_of_objects addObject:self];
#ifdef DEBUG		
	printf("Adding FileOwner CustomView\n");
#endif
    }
    return self;
}
- free
{
	printf("CustomView : free\n");
	return [super free];
}
@end

