/*  Archiving Category for IBControlConnector and IBOutletConnector
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmConnector.h,v 1.4 1994/06/11 03:53:18 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"

#define NXTypedStream TypedStream
#include "IBConnectors.h"

@interface IBConnector (XmArchiving)
- write:(TypedStream *)stream;
@end

@interface IBControlConnector (XmArchiving)
- write:(TypedStream *)stream;
- establishConnection;
- free;  /*Do not let NeXTStep free this connectors */
@end

@interface IBOutletConnector (XmArchiving)
- write:(TypedStream *)stream;
- establishConnection;
- free;  /*Do not let NeXTStep free this connectors */
@end
