/*  Archiving Category for Object
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

This file is part of the nib translator for 
an Objective-C class library for X/Motif

XmBox.m,v 1.8 1994/06/11 03:53:10 pfkeb Exp

*/


#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "objc/typedstream.h"
#include "archive-def.h"

#define NXTypedStream TypedStream
#include <appkit/Box.h>

@implementation Box (XmArchiving)


- write:(TypedStream *)stream
{
    NXSize tSize;
    int b, t, h, w;
    NXRect brect, trect;
    
    [super write:stream];
#ifdef DEBUG
    printf("\n->Box");
#endif

    [self getOffsets:&tSize];
    h = (int)tSize.height;
    w = (int)tSize.width;
    t = [self titlePosition];
    b = [self borderType];
    NXSetRect(&brect, borderRect.origin.x, borderRect.origin.y,
    			borderRect.size.width, borderRect.size.height);
    NXSetRect(&trect, titleRect.origin.x, titleRect.origin.y,
    			titleRect.size.width, titleRect.size.height);
    
    // convert coordinates:
    
    if (trect.origin.y == 0) {
    	trect.origin.y = bounds.size.height - trect.size.height;
    } else {
    	trect.origin.y = 0;
    }
    if (brect.origin.y == 0) {
    	brect.origin.y = bounds.size.height - brect.size.height;
    } else {
    	if (t == NX_ABOVETOP) {
		brect.origin.y = NX_MAXY(&trect);
//		brect.size.height -= NX_MAXY(&trect);
	} else if (t == NX_ATTOP) {
		brect.origin.y = NX_MAXY(&trect)/2;
//		brect.size.height -= NX_MAXY(&trect)/2;
	} else {
		brect.origin.y = 0;
	}
    }
    
// write out the title  -=- no, the cell stores the title.
// 			    so let it write out its own title.
//			    write each item only once!  slf
// write out the constant relating the border type.
// write out the cell in which the box's title is written.
// -------------------------------------------------------
// Actually, we need a textfield cell for our motif version, so we'll
// simply have to do that manually in an awake method... for now write
// out the title.  NeXT uses a simple CELL class, we need something a 
// little weightier, cuz our cell class by itself can't do drawing to the
// screen and doesn't have a specific widget associated with it.

    objc_write_type(stream, "*", [self title]);

    objc_write_type(stream, "i", &b);
    objc_write_type(stream, "i", &t);
    objc_write_type(stream, "i", &w);
    objc_write_type(stream, "i", &h);
    objc_write_rect(stream, &brect);
    objc_write_rect(stream, &trect);
//    objc_write_object(stream, cell);
 
    return self;
}
@end
