/*  Assumed definition of NeXT classes
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

IBConnectors.h,v 1.3 1994/06/11 03:52:58 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"
#include <apps/InterfaceBuilder.h>

/* This are interfaces for NeXT IB Objects */

@interface IBConnector:Object
{
  id    source;
  id    destination;
  id    label;
}
- free;
- write:(NXTypedStream *) s;
- read:(NXTypedStream *) s;

- source;
- destination;
- renewObject:old to:new;
- nibInstantiate;

@end

@interface IBControlConnector : IBConnector
{
}
- establishConnection;
@end

@interface IBOutletConnector : IBConnector
- establishConnection;
@end

