
#include "Controller.h"

#include <appkit/TextField.h>
#include <appkit/Matrix.h>
#include <appkit/NXBrowser.h>
#include <appkit/NXBrowserCell.h>

@implementation Controller

- appDidInit:sender
{
    [browser setDoubleAction:@selector(browserDoubleClicked:)];
    return self;
}

- browserClicked:sender
{
    [clickMsg setStringValue:"Single click"];
    [self updateForm];
    return self;
}

- browserDoubleClicked:sender
{
    [clickMsg setStringValue:"Double click"];
    [self updateForm];
    return self;
}
- testLoadThree:sender
{
    count = 3;
    [browser loadColumnZero];
    [self updateForm];
    return self;
}

- testLoadTwelve:sender
{
    count = 12;
    [browser loadColumnZero];
    [self updateForm];
    return self;
}

- testSelectCell:sender
{
    Matrix	*matrix;
    
    matrix = [browser matrixInColumn:0];
    [matrix selectCellAt:5 :0];
    [self updateForm];
    return self;
}

- testSetTitle:sender
{
    [browser setTitle:"New Title" ofColumn:0];
    return self;
}
- updateForm
{
    Matrix 	*matrix;
    int		row;
    
    matrix = [browser matrixInColumn:0];
    row = [matrix selectedRow];
    [resultsField setIntValue:row];
    return self;
}

/* Delegate method of NXBrowser */

- (int)browser:sender fillMatrix:matrix inColumn:(int)column
{
    id		aCell;
    char	string[64];
    int		i;
    
    for ( i = 0; i < count; i++ ) {
        sprintf( string, "cell %i", i);
	[matrix insertRowAt:i];
	aCell = [matrix cellAt:i :0];
	[aCell setStringValue:string];
	[aCell setLeaf:YES];
	[aCell setLoaded:YES];
    }
    return count;
}
@end
