/* GNU OpenStep dpsclient/event.h include file
 *
 * Copyright (C) 1993 Keith Mason. All Rights Reserved.
 *
 * Author: Keith Mason
 */

#ifndef _GNUSTEP_DPSCLIENT_EVENT_H_
#define _GNUSTEP_DPSCLIENT_EVENT_H_

/* Character Set Values */

#define NX_ASCIISET   1
#define NX_SYMBOLSET  2
#define NX_DINGBATSET 3


/* Event types */

#define NX_NULLEVENT     0

#define NX_LMOUSEDOWN    1
#define NX_LMOUSEUP      2
#define NX_LMOUSEDRAGGED 3

#define NX_MOUSEDOWN     NX_LMOUSEDOWN
#define NX_MOUSEUP       NX_LMOUSEUP
#define NX_MOUSEDRAGGED  NX_LMOUSEDRAGGED

#define NX_RMOUSEDOWN    4
#define NX_RMOUSEUP      5
#define NX_RMOUSEDRAGGED 6

#define NX_MOUSEMOVED    7
#define NX_MOUSEENTERED  8
#define NX_MOUSEEXITED   9
#define NX_KEYDOWN       10
#define NX_KEYUP         11
#define NX_FLAGSCHANGED  12

#define NX_KITDEFINED    13
#define NX_SYSDEFINED    14
#define NX_APPDEFINED    15

#define NX_TIMER         16
#define NX_CURSORUPDATE  17
#define NX_JOURNALEVENT  18

#define NX_FIRSTEVENT    NX_NULLEVENT
#define NX_LASTEVENT     NX_JOURNALEVENT
#define NX_ALLEVENTS     31


/* Event Type Masks */

/* I don't get what the difference between "event types" and "event type     */
/* masks" are.... They both refer to the type field of the NXEvent struct.   */
/* These aren't masks, until I find out how they're supposed to be           */
#define NX_NULLEVENTMASK     0
#define NX_LMOUSEDOWNMASK    1
#define NX_LMOUSEUPMASK      2
#define NX_LMOUSEDRAGGEDMASK 3
#define NX_MOUSEDOWNMASK     NX_LMOUSEDOWNMASK
#define NX_MOUSEUPMASK       NX_LMOUSEUPMASK
#define NX_MOUSEDRAGGEDMASK  NX_LMOUSEDRAGGEDMASK
#define NX_RMOUSEDOWNMASK    4
#define NX_RMOUSEUPMASK      5
#define NX_RMOUSEDRAGGEDMASK 6
#define NX_MOUSEMOVEDMASK    7
#define NX_MOUSEENTEREDMASK  8
#define NX_MOUSEEXITEDMASK   9
#define NX_KEYDOWNMASK       10
#define NX_KEYUPMASK         11
#define NX_FLAGSCHANGEDMASK  12
#define NX_KITDEFINEDMASK    13
#define NX_SYSDEFINEDMASK    14
#define NX_APPDEFINEDMASK    15
#define NX_TIMERMASK         16
#define NX_CURSORUPDATEMASK  17
#define NX_JOURNALEVENTMASK  18


/* Keyboard State Flags Masks */

#define NX_ALPHASHIFTMASK    (1<<0)
#define NX_SHIFTMASK         (1<<1)
#define NX_CONTROLMASK       (1<<2)
#define NX_ALTERNATEMASK     (1<<3)
#define NX_COMMANDMASK       (1<<4)
#define NX_NUMERICPADMASK    (1<<5)
#define NX_HELPMASK          (1<<6)

#define NX_NEXTCTRLKEYMASK   (1<<7)
#define NX_NEXTLSHIFTKEYMASK (1<<8)
#define NX_NEXTRSHIFTKEYMASK (1<<9)
#define NX_NEXTLCMDKEYMASK   (1<<10)
#define NX_NEXTRCMDKEYMASK   (1<<11)
#define NX_NEXTLALTKEYMASK   (1<<12)
#define NX_NEXTRALTKEYMASK   (1<<13)


/* Miscellaneous Event Flags Masks */

#define NX_STYLUSPROXIMITYMASK (1<<14)
#define NX_NONCOALSESCEDMASK   (1<<15)


/* NXCoord */

/* Note: temporarily, coordinates are integers */
/* typedef float NXCoord; */
typedef int NXCoord;


/* NXPoint */

typedef struct _NXPoint {
  NXCoord x;
  NXCoord y;
} NXPoint;


/* NXSize */

typedef struct _NXSize {
  NXCoord width;
  NXCoord height;
} NXSize;


/* NXEventData */

typedef union {
  struct {
    short eventNum;
    int click;
    unsigned char pressure;
  } mouse;
  struct {
    short repeat;
    unsigned short charSet;
    unsigned short charCode;
    unsigned short keyCode;
    short keyData;
  } key;
  struct {
    short eventNum;
    int trackingNum;
    int userData;
  } tracking;
  struct {
    short subtype;
    union {
      float F[2];
      long L[2];
      short S[4];
      char C[8];
    } misc;
  } compound;
} NXEventData;


/* NXEvent */

typedef struct _NXEvent {
  int type;
  NXPoint location;
  long time;
  int flags;
  unsigned int window;
  NXEventData data;
/*  DPSContext ctxt; // DPS Context not yet defined */
  void  *ctxt; 
} NXEvent, *NXEventPtr;

/*
 * Macros for compatiblility with original release.   Can be removed when
 * all use of them has been removed
 */
#endif  _GNUSTEP_DPSCLIENT_EVENT_H_
