/* Some preliminary ideas about what a String class might look like.
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* WARNING:  This implementation is incomplete and preliminary.  
   I'm just trying to get a 
   feel for how Strings will fit together with IndexedCollection. 
   cheng@iesd.auc.dk may be working on a String heirarchy.
   */

#include <coll/objc-gnu2next.h>
#include <coll/IndexedCollection.h>
#include <coll/ValueHolding.h>
#include <stdarg.h>

@interface String : IndexedCollection <ValueHolding>
{
  char *_contents_chars;
  unsigned _count;
}

// INITIALIZING;
- initFromString: (String*)aString range: (IndexRange)aRange;
- initFromString: (String*)aString length: (unsigned)aLength;
- initFromString: (String*)aString;
- initFromFormat: (String*)aFormatString, ...;
- initFromFormat: (String*)aFormatString withArgList: (va_list)arg;
- init;
- initFromCString: (char*)aCharPtr range: (IndexRange)aRange;
- initFromCString: (char*)aCharPtr length: (unsigned)aLength;
- initFromCString: (char*)aCharPtr;
- initFromCFormat: (char*)formatCharPtr, ...;
- initFromCFormat: (char*)formatCharPtr withArgList: (va_list)arg;

// COPYING (perhaps we should use "alloc" in the name;
- (char *) cStringCopy;
- (char *) cStringCopyRange: (IndexRange)aRange;
- (char *) cStringCopyLength: (unsigned)aLength;

- setCString: (char *)buffer range: (IndexRange)aRange;
- setCString: (char *)buffer length: (unsigned)aLength;
- setCString: (char *)buffer;

// REPLACING;
- replaceAllStrings: (String*)oldString with: (String*)newString;
- replaceFirstString: (String*)oldString with: (String*)newString;
- replaceFirstString: (String*)oldString 
    afterIndex: (unsigned)index 
    with: (String*)newString;

- setToAllCapitals;
- setToInitialCapitals;
- setToLowerCase;
- trimBlanks;

// TESTING;
- (BOOL) isEqual: anObject;
- (unsigned) hash;
- (int) compare: anObject;
- (int) compare: anObject ignoreCase: (BOOL)flag;
- (unsigned) count;
- copy;
- (IndexRange) stringRange;
- (unsigned) indexOfChar: (char)aChar ignoreCase: (BOOL)flag;
- (unsigned) indexOfChar: (char)aChar;
- (unsigned) indexOfLastChar: (char)aChar ignoreCase: (BOOL)flag;
- (unsigned) indexOfLastChar: (char)aChar;
- (unsigned) indexOfString: (String*)aString;
- (unsigned) indexOfString: (String*)aString ignoreCase: (BOOL)flag;
- (char) charAtIndex: (unsigned)anIndex;

/* Value Holding protocol

// GETTING VALUES;
- (int) intValue;
- (float) floatValue;
- (double) doubleValue;
- (const char *) cStringValue;
- (String *) stringValue;

// SETTING VALUES;
- setIntValue: (int)anInt;
- setFloatValue: (float)aFloat;
- setDoubleValue: (double)aDouble;
- setCStringValue: (const char *)aCString;
- setStringValue: (String*)aString;
*/

// FOR FILE AND PATH NAMES;
- (IndexRange) fileRange;
- (IndexRange) pathRange;
- (IndexRange) extensionRange;
- (IndexRange) fileWithOutExtentionRange;
- (BOOL) isAbsolute;
- (BOOL) isRelative;

@end

/* Eventually we'll want a heirarchy of String objects...

@interface ConstantString : SimpleReadOnlyString
@end
@interface MutableString : String
@end
@interface SimpleReadOnlyString : String
@end
@interface SimpleReadOnlyString : String
@end
@interface UniquedString : SimpleReadOnlyString
@end
@interface ReadWriteString : MutableString
@end

*/

/* Ideas for dealing eventually with 16-bit chars;

typedef short int Character;
// This could change to something bigger later, when we may have a 
// 16-bit character set.

- initFromCharacters: (Character*)buffer length: (unsigned)aLength;
- initFromCharacters: (Character*)buffer range: (IndexRange)aRange;
- initFromCharacters: (Character*)buffer;
- (Character) characterAtIndex: (unsigned)anIndex;

*/

