/* Category ToolKit of Application class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X-Windows
 *
 * WARNING: All WidgetSets that use this ToolKit category must use the
 * same definition of XWContext in dpsclient/xwfriends.h.  FIXME.
 *
 * xtApplication.m,v 1.8 1994/07/28 19:40:22 fedor Exp
 */

#include "Application.h"
#include "Window.h"
#include "stdmacros.h"
#include <dpsclient/xwfriends.h>
#include <appkit/xttools.h>
#include <coll/List.h>
#ifdef	sgi
#include <malloc.h>	/* although you might need to edit malloc.h */
#endif	/* sgi */

void 
appMainLoop( void *app_con )
{
    XtAppMainLoop((XtAppContext) app_con);
    return;
}

void *
createApplicationContext( void )
{
    XtToolkitInitialize();
    return XtCreateApplicationContext();
}

void
destroyApplicationContext( void *app_con) 
{
    XtDestroyApplicationContext((XtAppContext)app_con);
    return;
}
void *
openDisplay( void *app_con, char *appName, int ac, char **av)
{

   void *display = XtOpenDisplay((XtAppContext)app_con, 0,
			    NULL, appName,
			    NULL, 0,
			     &ac, av);
   if ( !display) {
      XtWarning("cannot open display");
      exit(1);
   }
   return display;
}

@implementation Application(ToolKit)

- (int)_runModalFor:theWindow
{
    XEvent	event;
    Widget 	dlog = [theWindow _widget];
	
	_modalReturnCode = X_RUNNINGMODAL;
    while ((XtIsManaged(dlog)) && (_modalReturnCode == X_RUNNINGMODAL)) {
	XtAppNextEvent(app_con, &event);
	XtDispatchEvent(&event);
    }

    return _modalReturnCode;
}

/* Open the X-Windows display */
- _displayInitArgc:(int)ac argv:(char**)av
{
    int		screen;
    Visual	*visual;
    XWContext 	context;
    _X_display = openDisplay( app_con, appName, ac, av);
    if (!_X_display) {
        XtWarning("cannot open display");
	return nil;
    }
    context = (XWContext)[self context];
    context->display = _X_display;

    /* Get the visual information */
    /* FIXME: Need a better way to choose the best visual */
    screen = DefaultScreen(context->display);
    visual = DefaultVisual(context->display, screen);
    if (!XMatchVisualInfo(context->display,
			  screen,
			  DefaultDepth(context->display, screen),
			  visual->class,
			  &context->vinfo)) {
	fprintf(stderr, "Application: Problem getting visual information");
	return self;
    }
    /* Create/Use the standard colormap */
    xtDefaultColormap(context);

    return self;
}

/* Return a valid context for this application.  Allocates the context if
   necessary, but does not fill any of the data in.  This should be done
   by other Application methods or by any object that needs the info
*/
- (DPSContext)_displayContext
{
    XWContext context;

    if (!_context) {

    	NX_MALLOC(context, XWContext_t, 1);
    	memset(context, 0, sizeof(XWContext_t));
	_context = (DPSContext)context;

	// Create a stack for the gstates
	context->gstack = (void *)[[List alloc] init];
	context->gstate = NULL;
    }

    return _context;
}

@end

