/* Widget set category implementation of Window class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmWindow.m,v 1.14 1994/08/18 02:00:45 kamerer Exp
 */

#include "Window.h"

/* Required for implementation: */
#include "Motif.h"
#include "Application.h"
#include "Menu.h"

#ifdef	RESIZE_DEBUG
#include <Xm/Xm.h>	/* Position, Dimension type declarations */
#endif	/* RESIZE_DEBUG */
#include <Xm/MainW.h>
#include <Xm/DialogS.h>

#ifdef X11R5
#include <X11/Xmu/Editres.h>
#endif

#ifdef MOTIF12			/* MOTIF 1.2 */
#include <Xm/Protocols.h>
#else				/* MOTIF 1.1 */
#include <Xm/VendorE.h>		/* for XmIsMotifWMRunning() */
#include <X11/Protocols.h>	/* for mwm DELETE WINDOW protocol */
#endif

#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdlib.h>             /* for free() */
#include "Scroller.h"
#include <stdio.h>
#include <objc2/typedstream2.h>
#include <coll/List.h>

char *WindowInstanceName( void )
{
    return "Window";
}

static void
_window_will_resize_callback(Widget w, XtPointer client_data,
                          XmAnyCallbackStruct *cb)
{
    XConfigureEvent *config_event = (XConfigureEvent *) cb;
    Window *windowid = (Window *) client_data;

    NXRect aRect;
    
    if (config_event->type != ConfigureNotify) return;
    
    aRect.size.height = config_event->height;
    aRect.size.width = config_event->width;
    aRect.origin.x = config_event->x;
    aRect.origin.y = config_event->y;
    
    [windowid _resizeWindow:&aRect];
    return;
}

static void
_window_will_close_callback(Widget w, XtPointer client_data,
			    XmAnyCallbackStruct *cb)
{
    Window *windowid = (Window *) client_data;

//   switch (cb->reason)
//   {
//   case XmCR_VALUE_CHANGED:
//	break;
//   default:
//   }

    if (nil == [windowid performClose:windowid])  return;
    
    /* else check to see if this is the last window -- if so exit()
     * since the application may be "lost" under X-windows otherwise
     */
    
    if (0 == [[NXApp windowList] count])  [NXApp terminate:windowid];
    
    return;
}

@implementation Window(WidgetSet)

/* private methods not declared in interface file. */

- _setTitle
{
    if ( _shell ) {
        XtVaSetValues(_shell,
		      XtNiconName, title,
		      XtNtitle, title,
		      NULL);
    }
    return self;
} 
    
- _initContent:(const NXRect *)contentRect
{
#ifdef	RESIZE_DEBUG
    Position x,y;
    Dimension w,h;
#endif	/* RESIZE_DEBUG */
    Atom WM_DELETE_WINDOW;
    
    _shell = XtAppCreateShell( title, "App",
                               applicationShellWidgetClass,
                               [NXApp _X_display], NULL, 0  ); 
#ifdef X11R5
#ifndef	sgi
  /* Register the Editres protocol: */
    XtAddEventHandler( _shell, (EventMask) 0, True,
                       _XEditResCheckMessages, NULL);
#endif	sgi
#endif

    XtVaSetValues(_shell, XmNallowShellResize, False, NULL);
    widgetid = XmCreateMainWindow(_shell, "window1", NULL, 0);
    XtManageChild(widgetid);
    XtVaSetValues(widgetid, XmNwidth,   NX_WIDTH(contentRect),
		            XmNheight, NX_HEIGHT(contentRect), NULL);

    if (!wFlags.visible)
	XtSetMappedWhenManaged((Widget)_shell, NO);

#ifdef	RESIZE_DEBUG
    XtVaGetValues(widgetid, XmNx, &x, NULL);
    XtVaGetValues(widgetid, XmNy, &y, NULL);
    XtVaGetValues(widgetid, XmNwidth, &w, NULL);
    XtVaGetValues(widgetid, XmNheight, &h, NULL);

    fprintf(stderr, "_initContent: widget size was (%d, %d), (%d, %d)\n",
          (int)x, (int)y, (int)w, (int)h);
#endif	/* RESIZE_DEBUG */

#ifndef	ALWAYS_MWM
    /* Might not require mwm at all                
    handle window close button -- currently requires Motif WM */
    if (True == XmIsMotifWMRunning(_shell))
#endif	/* ALWAYS_MWM */
    {
	/* first, disable mwm's default action for close buttons */
	XtVaSetValues(_shell, XmNdeleteResponse, XmDO_NOTHING, NULL);
	/* register WM_DELETE_WINDOW to call _window_will_close_callback */
	WM_DELETE_WINDOW = XmInternAtom([NXApp _X_display], "WM_DELETE_WINDOW",
					False);
	XmAddWMProtocolCallback(XtParent(widgetid), WM_DELETE_WINDOW,
	    (XtCallbackProc)_window_will_close_callback, (XtPointer)self);
    }
    
//    XtAddEventHandler(_shell, StructureNotifyMask, False,
//                  _window_will_resize_callback, (XtPointer)self);

    [self _setTitle];
    return self;
}

- _setWindowAreas
{
#ifdef	RESIZE_DEBUG
    Position x,y;
    Dimension w,h;
#endif	/* RESIZE_DEBUG */
    if (hasMenu) {
        if (!menu ) {
            menu = [NXApp mainMenu];
            [menu _managedBy:self];
	}
    } else {
        menu = nil;
    }
    [menu _managedBy:self];
    [contentView _managedBy:self];
	
    XmMainWindowSetAreas(widgetid,
			[menu _widget],	/* Menubar */
                         NULL,          /* Command window */
                         NULL,    	/* Horizontal Scroller*/
                         NULL,          /* Vertical   */
                         [contentView _widget]);       /* Contents */

#ifdef	RESIZE_DEBUG
    XtVaGetValues(widgetid, XmNx, &x, NULL);
    XtVaGetValues(widgetid, XmNy, &y, NULL);
    XtVaGetValues(widgetid, XmNwidth, &w, NULL);
    XtVaGetValues(widgetid, XmNheight, &h, NULL);

    fprintf(stderr, "_setWindowAreas: widget size was (%d, %d), (%d, %d)\n",
          (int)x, (int)y, (int)w, (int)h);

    fprintf(stderr,
          "_setWindowAreas: contentView size was (%d, %d), (%d, %d)\n",
          _contentViewFrameRect.origin.x, _contentViewFrameRect.origin.y,
          _contentViewFrameRect.size.width,
          _contentViewFrameRect.size.height);

    XtVaGetValues([contentView _widget], XmNx, &x, NULL);
    XtVaGetValues([contentView _widget], XmNy, &y, NULL);
    XtVaGetValues([contentView _widget], XmNwidth, &w, NULL);
    XtVaGetValues([contentView _widget], XmNheight, &h, NULL);

    fprintf(stderr, "_setWindowAreas: widget size was (%d, %d), (%d, %d)\n",
          (int)x, (int)y, (int)w, (int)h);
#endif	/* RESIZE_DEBUG */

    return self;
}

/* Public methods */

 /*- closeWindow
{
    if (_holder) {
        XtDestroyWidget([self topLevel]);
        printf("%d\n", [self topLevel]);
    }
}  */
 
- _realize
{
#ifdef	RESIZE_DEBUG
    Position x,y;
    Dimension w,h;
#endif	/* RESIZE_DEBUG */
    XWContext context;
    XSetWindowAttributes att;
    u_long	mask;

    if (XtIsRealized((Widget)_shell))
	return self;

    if ( !wFlags.visible) 
        return self;
    
    if (_shell) {
	XtRealizeWidget( (Widget)_shell);
    }

    // Change various window attributes
    context = (XWContext)[NXApp context];
    if (context->map && context->map->colormap) {
	XSetWindowColormap(context->display, 
			XtWindow((Widget)_shell), 
			context->map->colormap);
    }
    att.backing_store = Always;
    mask = CWBackingStore;
    XChangeWindowAttributes(context->display,
		XtWindow((Widget)_shell),
		mask,
		&att);

    hasRealized = YES;

#ifdef	RESIZE_DEBUG
    XtVaGetValues(widgetid, XmNx, &x, NULL);
    XtVaGetValues(widgetid, XmNy, &y, NULL);
    XtVaGetValues(widgetid, XmNwidth, &w, NULL);
    XtVaGetValues(widgetid, XmNheight, &h, NULL);

    fprintf(stderr, "_realize: widget size was (%d, %d), (%d, %d)\n",
          (int)x, (int)y, (int)w, (int)h);

    fprintf(stderr,
          "_realize: contentView size was (%d, %d), (%d, %d)\n",
          _contentViewFrameRect.origin.x, _contentViewFrameRect.origin.y,
          _contentViewFrameRect.size.width,
          _contentViewFrameRect.size.height);

    XtVaGetValues([contentView _widget], XmNx, &x, NULL);
    XtVaGetValues([contentView _widget], XmNy, &y, NULL);
    XtVaGetValues([contentView _widget], XmNwidth, &w, NULL);
    XtVaGetValues([contentView _widget], XmNheight, &h, NULL);

    fprintf(stderr, "_realize: widget size was (%d, %d), (%d, %d)\n",
          (int)x, (int)y, (int)w, (int)h);
#endif	/* RESIZE_DEBUG */
    return self;
}

- (BOOL) _hasRealized
{
    return hasRealized;
}

- _unrealize
{
    if ( wFlags.visible) 
	return self;

    if (_shell) {
	if (nil != contentView)  [contentView free];
	XtUnrealizeWidget( (Widget)_shell );
	_shell = 0;
    }
    hasRealized = NO;
    return self;
}

- _orderOut
{
    if (_shell)  XtUnmapWidget( (Widget)_shell);
    return self;
}

- _orderFront
{
    if (_shell)  XtMapWidget( (Widget)_shell);
    return self;
}

- (void *)_widget
{
    return widgetid;
}

- (void *)_shell
{
    return _shell;
}

@end

