/* WidgetSet category mplementation of View class for X/Motif
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang (SLAC)
 *	    Adam Fedor (U Colorado)
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmView.m,v 1.9 1994/07/19 01:09:40 fxmlk Exp
 */

 
#include "View.h"

/* Required for implementation: */
#include  <appkit/stdmacros.h>
#include  <coll/List.h>
#include <appkit/Motif.h>
#include "Application.h"
#include <Xm/BulletinB.h>  /* for xmScrolledWindowWidgetClass */
#define Window X11Window	/* To avoid problems with Objective C */
#include <X11/IntrinsicP.h>
#undef Window
#include <X11/StringDefs.h>	/* For non-Motif resource names */
#include <dpsclient/xwfriends.h>

GC _createGC(XWContext context, Widget widget);
GC _copyGC(XWContext context, Widget widget, GC source);

char *ViewInstanceName(void)
{
    return "View";
}

@implementation View(WidgetSet)

- _moveTo:(NXCoord)x :(NXCoord)y
{
    if ( widgetid ) {
        XtMoveWidget(widgetid, x, y );
    }
    return self;
}

- _sizeTo:(NXCoord)width :(NXCoord)height
{
    [self _setArg:XmNwidth  to:(void *)width];
    [self _setArg:XmNheight to:(void *)height];
    return self;
}

- makeNXEvent:(NXEvent *)nx fromXEvent:(XEvent *)event
/*
	converts various fields to an NXEvent-type struct, that 
	actually is not quite an NXEvent, but has many of the same
	fields to ease the transition from NeXT to X app.

 */
{
    nx->flags = 0;
    nx->type = event->type;
    nx->location.x = event->xbutton.x;
//    nx->location.y = bounds.size.height - event->xbutton.y;
    nx->location.y = event->xbutton.y;
    nx->time = (long)event->xbutton.time;
    if (event->xbutton.state & ShiftMask) {
    	nx->flags |= SHIFT_MASK;
    }
    if (event->xbutton.state & ControlMask) {
    	nx->flags |= CONTROL_MASK;
    }
    
    // these if statements can be extended to handle a few more keys...
    
//    nx->flags |= event->xbutton.state;
    return self;
}

- _init
{
  /* This method is invoked from from the -initFrame and -awake
   * methods.  Subclasses of View may override this method to 
   * add to their initialization.
   */

    classname = xmBulletinBoardWidgetClass;
	[self _setFrame:&frame];
    [self _addArg:XmNallowOverlap:(void *)True];
    [self _addArg:XmNnoResize:(void *)True];
    [self _addArg:XmNresizePolicy :(void *)XmRESIZE_NONE];
    [self _addArg:XmNmarginWidth :(void *)0];
    [self _addArg:XmNmarginHeight :(void *)0];

    return self;
}

- _getFrame
{
    [self _getArg:XmNx      into:&frame.origin.x];
    [self _getArg:XmNy      into:&frame.origin.y];
    [self _getArg:XmNwidth  into:&frame.size.width];
    [self _getArg:XmNheight into:&frame.size.height];
    return self;
}

- _managedBy:parent wid:(void*)widget
{    
    if (!classname)
       fprintf(stderr, "%s: classname unknown\n", [self name]);
    if (widgetid) {
        XtManageChild(widgetid);
    } else {
	widgetid = XtCreateManagedWidget(instancename, classname,
				         widget, [self _arglist], 
					 [self _numargs]);
	[self _addCallback];
    }
    [self _setnumargs:0];
    [self _manageChildren];
    return self;
}
 
- _unManage
{
    if ( widgetid ) {
	XtUnmanageChild(widgetid);
    }
    return self;
}
- _destroy
{
    if ( widgetid ) {
        XtDestroyWidget(widgetid);
    }
    widgetid = NULL;
    if (nil != subviews)  [subviews makeObjectsPerform:@selector(_destroy)];

    // Free our gstate
    if (vFlags.validGState) {
        XMotifContext context;
	XWgstate view = (XWgstate)_gstate;

        context = (XMotifContext)[NXApp context];
	XFreeGC(context->display, view->xgstate);
	NX_FREE(view);
    }
    return self;
}

/* Routines to handle gstates.  We need to create a gstate for every view
   in X-Windows, because every view draws under a different widget.
   However, a separate X11 Graphic Context (GC) is not created for
   every view unless one is specifically asked for via the allocGState
   method.  Otherwise, the X11 GC is just a pointer to the superview's
   GC.  This causes changes to the X11 GC to propogate up the chain,
   but it shouldn't cause too many problems since I think this is what
   happens in DPS anyway.
*/
/* Creates a gstate if the view doesn't already have one. A full copy of the
   gstate is made only if one was requested. Otherwise we just update the
   gstate to reflect the state of the view and our superviews.
*/
- (XWgstate)_createGState
{
    XMotifContext context;
    XWgstate	  view;
    NXRect	  cliprect;

    context = (XMotifContext)[NXApp context];

    NX_MALLOC(view, XWgstate_t, 1);
    view->scalex = 1.0;
    view->scaley = 1.0;
    view->rotation = 0;
    if (context->gstate)
    	memcpy(view, context->gstate, sizeof(XWgstate_t));
    view->widget = [self _widget];
    view->origin.x = 0;
    view->origin.y = 0;

    if ((!context->gstate || vFlags2.wantsGState) && !vFlags.validGState) {
	if (context->gstate && context->gstate->xgstate)
	    view->xgstate = _copyGC(context, view->widget, 
		context->gstate->xgstate);
	else
	    view->xgstate = _createGC(context, view->widget);
	if (view->xgstate) {
	    vFlags2.wantsGState = NO;
	    vFlags.validGState = YES;
	    // Save this gstate
    	    _gstate = (int)view;
    	}
    }

    /* Update the gstate . We do weird stuff with NXRect because the gstate
	cliprect is actually an XWRect.
    */
    cliprect = bounds;
    if (context->gstate) {
	NXRect oldclip;
	memcpy(&oldclip, &context->gstate->cliprect, sizeof(NXRect));
	NXIntersectionRect(&oldclip, &cliprect);
	view->scalex *= context->gstate->scalex;
	view->scaley *= context->gstate->scaley;
	view->rotation += context->gstate->rotation;
    }
    memcpy(&view->cliprect, &cliprect, sizeof(NXRect));
    return view;
}

- (BOOL)_displayLockFocus
{
    XMotifContext context;

    context = (XMotifContext)[NXApp context];

    // Push the current gstate
    if (context->gstate) {
	[(List *)context->gstack addObject:(id)context->gstate];
	// the current gstate should be our superview's gstate
	if (superview && context->gstate->widget != [superview _widget]) {
	    fprintf(stderr, "View: Focus already locked on different view.\n");
	    //return NO;
	}
    }
    
    // Install our own gstate if we have one, otherwise create a temporary one
    // Always create a gstate for a top-level view
    if (!_gstate) {
    	context->gstate = [self _createGState];
    } else
    	context->gstate = (XWgstate)_gstate;

    return YES;
}

- _displayUnlockFocus
{
    XMotifContext context;

    context = (XMotifContext)[NXApp context];
    if (!context->gstate) {
	fprintf(stderr, "View: attempt to unlock a nil view.\n");
	return nil;
    }
    if (context->gstate->widget != [self _widget]) {
	fprintf(stderr,
		"View: attempt to unlock a view that was not locked\n");
	//return nil;
    }
    
    // Free our temporary gstate
    if (!_gstate)
	NX_FREE(context->gstate);

    context->gstate = (XWgstate)[(List *)context->gstack removeLastObject];
    return self;
}

- _setSize:(NXSize *)newSize
{
    [self _setArg:XmNwidth  to:(void *)(int)newSize->width];
    [self _setArg:XmNheight to:(void *)(int)newSize->height];
    frame.size.width = newSize->width;
    frame.size.height = newSize->height;
    return self;
}

/* these last three methods set x resources, and should be methods only known
   to the category extension.  Box makes use of all of these methods in
   its content view.
 */
- _setResize:(void *)policy
{
    [self _setArg:XmNresizePolicy  to:(void *)policy];
    return self;
}

- _setOffsets:(NXSize *)offsets
{
    [self _setArg:XmNmarginWidth   to:(void *)offsets->width];
    [self _setArg:XmNmarginHeight  to:(void *)offsets->height];
    return self;
}

- _setBorderShadow:(void *)shadow andThickness:(void *)thickness
{
    [self _setArg:XmNshadowType      to:(void *)shadow];
    [self _setArg:XmNshadowThickness to:(void *)thickness];
    return self;
}

- _setFrame:(const NXRect *)aFrame
{
    [self _setArg:XmNx      to:(void *)(int)aFrame->origin.x];
    [self _setArg:XmNy      to:(void *)(int)aFrame->origin.y];
    [self _setArg:XmNwidth  to:(void *)(int)aFrame->size.width];
    [self _setArg:XmNheight to:(void *)(int)aFrame->size.height];
    return self;
}

@end


// Create a default graphics context.
GC
_createGC(XWContext context, Widget widget) 
{
    GC	      gc;
    XGCValues gcv;

    if (!widget) {
	fprintf(stderr, "View: Attempt to create a GC on an unrealized View\n");
	return NULL;
    }

    gcv.function = GXcopy;
    gcv.plane_mask = AllPlanes;
    gc = XCreateGC(context->display, XtWindow(widget),
    	GCFunction | GCPlaneMask , &gcv);
    return gc;
}

// Copy a graphic context
GC
_copyGC(XWContext context, Widget widget, GC source) 
{
    GC	      		dest;
    unsigned long	mask;

    mask = 0xffffffff; /* Copy everything (Hopefully) */
    dest = XCreateGC(context->display, XtWindow(widget), 0, NULL);
    XCopyGC(context->display, source, mask, dest); 
    return dest;
}

