/* WidgetSet category for TextFieldCell class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmTextFieldCell.m,v 1.5 1994/07/18 19:16:36 kamerer Exp
 */
 
#include "TextFieldCell.h"

#include "Motif.h"
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include "Text.h"

char *TextFieldCellInstanceName( void )
{
    return "TextFieldCell";
}

static void
theCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   TextFieldCell	*tfc = (TextFieldCell *) client_data;
   XmAnyCallbackStruct	*cb = (XmAnyCallbackStruct *) call_data;

   switch (cb->reason) {
   case XmCR_ACTIVATE:
	[tfc sendAction];
	break;
   default:
   }
   return;
}

@implementation TextFieldCell(WidgetSet)

/* Private methods not declared in interface */

- _alignSelf
{
    switch (alignment) {
    case NX_LEFTALIGNED :
	[self _setArg:XmNalignment to:(void *)XmALIGNMENT_BEGINNING];
	break;
    case NX_RIGHTALIGNED :
	[self _setArg:XmNalignment to:(void *)XmALIGNMENT_END];
	break;
    case NX_CENTERED :
	[self _setArg:XmNalignment to:(void *)XmALIGNMENT_CENTER];
	break;
    default:
	break;
    }
    return self;
}

/* Public Methods */

- _init
{
//    [super _init];
    classname = xmTextFieldWidgetClass;
    _isLabel = NO;
    return self;
}

- _initAsLabel
{
    instancename = TextFieldCellInstanceName();
    classname = xmLabelWidgetClass;
    _isLabel = YES;
    return self;
}

- _setAsLabel:(BOOL)aFlag
{
    _isLabel = aFlag;
    return self;
}

- (const char *)_stringValue
{
    char	*temp;
    
    if ( widgetid ) {
        if ( _isLabel ) {
	    temp = (char *)[super stringValue];
	} else {
	    XtVaGetValues(widgetid, XmNvalue, &temp, NULL);
	}
    } else {
	temp = contents;
    }
    return ((temp) ? (temp) : "");
}

- _setStringValue
{
    if ( contents ) {
        if (_isLabel) {
// Note the following gave left aligned widget even when alignment
// was centered
//	    xs = XmStringCreateSimple(contents);
//	    [self _setArg:XmNlabelString to:(void *)xs];
//	    [self _alignSelf];
//  So replaced it with this hack
	    if ( widgetid ) {
		XtUnmanageChild((Widget) widgetid);
		XtDestroyWidget((Widget) widgetid);
		widgetid = NULL;
		[self _managedBy:parentid];
	    }
	} else {
	    [self _setArg:XmNvalue to:contents];
	}
    }
    return self;
}

- _addCallback
{
    if ( _isLabel ) {
        return self;
    }
    XtAddCallback(widgetid, XmNactivateCallback, theCallback, self);
    return self;
}

- _managedBy:parent
{
    XmString xs;

    [self _setArg:XmNmarginWidth to:(void *)0];
    [self _setArg:XmNmarginHeight to:(void *)0];
    if ( _isLabel ) {
        xs = XmStringCreateSimple(contents);
	[self _addArg:XmNlabelString:(void *)xs];
	[self _alignSelf];
    } else {
	[self _addArg:XmNvalue :contents];
    }
    [super _managedBy:parent];

    return self;
}

- _selectText
{
	if (_isLabel)
		return self;
	XmTextFieldSetSelection(widgetid, 0, XmTextFieldGetLastPosition(widgetid),
							0);
	return self;
}

@end
