/* WidgetSet category implementation for MenuCell
 *
 * Copyright (C)  1994  The Board of Trustees of The Leland Stanford
 *                      Junior University.  All Rights Reserved.
 * 
 * Authors: Paul Kunz, Tom Pavel, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmMenuCell.m,v 1.2 1994/06/11 03:57:55 pfkeb Exp
 */


#include "MenuCell.h"

/* Required for implementation: */
#include "Motif.h"
#include "Menu.h"
#include <Xm/CascadeBG.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>

#include <stdlib.h>             /* for free() */
#include <stdio.h>

static void
theCallback(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
   MenuCell* mcid = (MenuCell*) client_data;
   XmPushButtonCallbackStruct* cb = (XmPushButtonCallbackStruct*) call_data;

   switch (cb->reason) {
   case XmCR_ACTIVATE:
        [mcid sendAction];
	break;
   case XmCR_ARM:
      [mcid setState:1];
      break;
   case XmCR_DISARM:
      [mcid setState:0];
      break;
   default:
   }
}

char *MenuCellInstanceName(void)
{
    return "MenuCell";
}

@implementation MenuCell(WidgetSet)

- _init
{
   classname = xmPushButtonWidgetClass;
   return self;
}

- _setSubmenu
{
    classname = xmCascadeButtonGadgetClass;
    return self;
}

- _addCallback
{
    XtAddCallback(widgetid, XmNactivateCallback, theCallback, self);
    return self;
}

- _managedBy:parent wid:(void*)widget
 /* 
	Pretty much the Button implementation of this method.
	Since that was originally what menuCell leveraged off of.
	Might want to change this if optimizations can be made.
 */
{
    parentid = parent;
    if ([self hasSubmenu]) {
	[subMenu _managedBy:self wid:widget];
	[self _setArg:XmNsubMenuId to:[subMenu _widget]];
	widgetid = XmCreateCascadeButtonGadget(widget, instancename,
					       arglist, numargs);
	XtManageChild(widgetid);
    } else {
        widgetid = XtCreateManagedWidget(instancename, classname,
                                         widget,
                                         arglist, numargs);
        [self _addCallback];
    }
    return self;
}

- _managedBy:parent
{
    if (![parent _widget]) {
    	fprintf(stderr, "MenuCell: parent widget not found\n");
		return 0;
	}

    return [self _managedBy:parent wid:[parent _widget]];
}

@end
