/* Implementation of TextField class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * TextField.m,v 1.36 1994/07/18 20:40:12 kamerer Exp
 */

 
#include "TextField.h"

#include "TextFieldCell.h"

#include "stdmacros.h"

@implementation TextField : Control

- initFrame:(const NXRect *)frameRect
{
    if ( !cell )
        cell = [[TextFieldCell alloc] init]; 
    [super initFrame:frameRect];
    instancename = "TextField";
    return self;
}

- _initAsLabel
{
    if (!cell) {
	cell = [[TextFieldCell alloc] _initAsLabel];
    } else {
        [(TextFieldCell *)cell _initAsLabel];
    }
    return self;
}

- setTextGray:(float)value
{
    if (nil != cell)  [(TextFieldCell *)cell setTextGray:value];

    return self;
}

- read:(TypedStream *)ts
{
    int		edit, select, bezel, border;
    BOOL	label;

    [super read:ts];

    objc_read_types(ts, "iiii", &edit, &select, &bezel, &border);
    label = (!(edit || select || bezel || border));
  /* Normally we don't message another object from -read:, 
   * but we know that cell has been read by us 
   */
    [(TextFieldCell *)cell _setAsLabel:label];
    return self;
}

// - write:(TypedStream *)ts;

- selectText:sender
{
	if (cell) {
		[cell _selectText];
	}
	return self;
}

@end
